/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.message;

import java.io.Serializable;
import org.apache.logging.log4j.message.Clearable;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory2;
import org.apache.logging.log4j.message.ReusableObjectMessage;
import org.apache.logging.log4j.message.ReusableParameterizedMessage;
import org.apache.logging.log4j.message.ReusableSimpleMessage;
import org.apache.logging.log4j.util.PerformanceSensitive;

@PerformanceSensitive(value={"allocation"})
public final class ReusableMessageFactory
implements MessageFactory2,
Serializable {
    public static final ReusableMessageFactory INSTANCE = new ReusableMessageFactory();
    private static final long serialVersionUID = 1L;
    private final transient ThreadLocal<ReusableParameterizedMessage> threadLocalParameterized = new ThreadLocal();
    private final transient ThreadLocal<ReusableSimpleMessage> threadLocalSimpleMessage = new ThreadLocal();
    private final transient ThreadLocal<ReusableObjectMessage> threadLocalObjectMessage = new ThreadLocal();

    private ReusableParameterizedMessage getParameterized() {
        ReusableParameterizedMessage result2 = this.threadLocalParameterized.get();
        if (result2 == null) {
            result2 = new ReusableParameterizedMessage();
            this.threadLocalParameterized.set(result2);
        }
        return result2.reserved ? new ReusableParameterizedMessage().reserve() : result2.reserve();
    }

    private ReusableSimpleMessage getSimple() {
        ReusableSimpleMessage result2 = this.threadLocalSimpleMessage.get();
        if (result2 == null) {
            result2 = new ReusableSimpleMessage();
            this.threadLocalSimpleMessage.set(result2);
        }
        return result2;
    }

    private ReusableObjectMessage getObject() {
        ReusableObjectMessage result2 = this.threadLocalObjectMessage.get();
        if (result2 == null) {
            result2 = new ReusableObjectMessage();
            this.threadLocalObjectMessage.set(result2);
        }
        return result2;
    }

    public static void release(Message message) {
        if (message instanceof Clearable) {
            ((Clearable)((Object)message)).clear();
        }
    }

    @Override
    public Message newMessage(CharSequence charSequence) {
        ReusableSimpleMessage result2 = this.getSimple();
        result2.set(charSequence);
        return result2;
    }

    @Override
    public Message newMessage(String message, Object ... params) {
        return this.getParameterized().set(message, params);
    }

    @Override
    public Message newMessage(String message, Object p0) {
        return this.getParameterized().set(message, p0);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1) {
        return this.getParameterized().set(message, p0, p1);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2) {
        return this.getParameterized().set(message, p0, p1, p2);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3) {
        return this.getParameterized().set(message, p0, p1, p2, p3);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4) {
        return this.getParameterized().set(message, p0, p1, p2, p3, p4);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5) {
        return this.getParameterized().set(message, p0, p1, p2, p3, p4, p5);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6) {
        return this.getParameterized().set(message, p0, p1, p2, p3, p4, p5, p6);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7) {
        return this.getParameterized().set(message, p0, p1, p2, p3, p4, p5, p6, p7);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8) {
        return this.getParameterized().set(message, p0, p1, p2, p3, p4, p5, p6, p7, p8);
    }

    @Override
    public Message newMessage(String message, Object p0, Object p1, Object p2, Object p3, Object p4, Object p5, Object p6, Object p7, Object p8, Object p9) {
        return this.getParameterized().set(message, p0, p1, p2, p3, p4, p5, p6, p7, p8, p9);
    }

    @Override
    public Message newMessage(String message) {
        ReusableSimpleMessage result2 = this.getSimple();
        result2.set(message);
        return result2;
    }

    @Override
    public Message newMessage(Object message) {
        ReusableObjectMessage result2 = this.getObject();
        result2.set(message);
        return result2;
    }

    private Object writeReplace() {
        return new SerializationProxy();
    }

    private static class SerializationProxy
    implements Serializable {
        private static final long serialVersionUID = 1L;

        private SerializationProxy() {
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

