/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.builder;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Properties;
import net.sourceforge.texlipse.PathUtils;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.builder.BuilderRegistry;
import net.sourceforge.texlipse.builder.OutputScanner;

public class ExternalProgram {
    private String[] command = null;
    private File dir = null;
    private Process process = null;
    private String consoleOutput = null;

    public void setup(String[] command, File dir, String console) {
        this.command = command;
        this.dir = dir;
        this.process = null;
        this.consoleOutput = console;
    }

    public void stop() {
        if (this.process != null) {
            this.process.destroy();
        }
    }

    protected String readOutput(InputStream is) {
        StringWriter store = new StringWriter();
        try {
            InputStreamReader isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                store.write(String.valueOf(line) + '\n');
                if (this.consoleOutput == null) continue;
                BuilderRegistry.printToConsole(String.valueOf(this.consoleOutput) + "> " + line);
            }
        }
        catch (IOException iOException) {}
        store.flush();
        return store.getBuffer().toString();
    }

    public String run(String[] queryMessage) throws Exception {
        return this.run(true, queryMessage);
    }

    public String run() throws Exception {
        return this.run(true, null);
    }

    protected String run(boolean wait, String[] queryMessage) throws IOException {
        Properties envProp;
        Runtime rt;
        String output = null;
        String errorOutput = null;
        if (this.command != null && this.dir != null) {
            StringBuffer commandSB = new StringBuffer();
            int i = 0;
            while (i < this.command.length) {
                commandSB.append(this.command[i]);
                commandSB.append(" ");
                ++i;
            }
            BuilderRegistry.printToConsole("running: " + commandSB.toString());
            rt = Runtime.getRuntime();
            envProp = PathUtils.getEnv();
            int index = this.command[0].lastIndexOf(File.separatorChar);
            if (index > 0) {
                String commandPath = this.command[0].substring(0, index);
                String key = PathUtils.findPathKey(envProp);
                envProp.setProperty(key, String.valueOf(envProp.getProperty(key)) + File.pathSeparatorChar + commandPath);
            }
        } else {
            throw new IllegalStateException();
        }
        String[] env = PathUtils.mergeEnvFromPrefs(envProp, "buildEnvSet");
        this.process = rt.exec(this.command, env, this.dir);
        final StringBuffer thErrorOutput = new StringBuffer();
        final StringBuffer thOutput = new StringBuffer();
        final OutputScanner scanner = new OutputScanner(this.process.getInputStream(), this.process.getOutputStream(), queryMessage, this.consoleOutput);
        final OutputScanner errorScanner = new OutputScanner(this.process.getErrorStream(), this.process.getOutputStream(), queryMessage, this.consoleOutput);
        final Thread errorThread = new Thread(){

            public void run() {
                if (errorScanner.scanOutput()) {
                    thErrorOutput.append(errorScanner.getText());
                }
            }
        };
        Thread outputThread = new Thread(){

            public void run() {
                if (scanner.scanOutput()) {
                    thOutput.append(scanner.getText());
                } else {
                    ExternalProgram.this.process.destroy();
                    try {
                        errorThread.join();
                    }
                    catch (InterruptedException e) {
                        TexlipsePlugin.log("Output scanner interrupted", e);
                    }
                    thOutput.setLength(0);
                    thErrorOutput.setLength(0);
                }
            }
        };
        outputThread.start();
        errorThread.start();
        try {
            errorThread.join();
            outputThread.join();
        }
        catch (InterruptedException e) {
            TexlipsePlugin.log("Output scanner interrupted", e);
        }
        output = thOutput.toString();
        errorOutput = thErrorOutput.toString();
        if (wait) {
            try {
                this.process.waitFor();
            }
            catch (InterruptedException e) {
                TexlipsePlugin.log("Process interrupted", e);
            }
        }
        this.process = null;
        if (errorOutput.length() > 0) {
            output = String.valueOf(output) + "\n" + errorOutput;
        }
        return output;
    }
}

