/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.texlipse.properties;

import java.io.File;
import net.sourceforge.texlipse.TexlipsePlugin;
import net.sourceforge.texlipse.builder.BuilderRegistry;
import net.sourceforge.texlipse.builder.ProgramRunner;
import net.sourceforge.texlipse.properties.BuilderConfigDialog;
import net.sourceforge.texlipse.properties.TexlipseHelpIds;
import net.sourceforge.texlipse.properties.TexlipsePreferencePage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class BuilderSettingsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private List builderList;
    private Button consoleOutputCheckBox;
    private Button auxParserCheckBox;
    private Text texDirField;
    protected File lastPath;
    private Button editButton;

    public BuilderSettingsPreferencePage() {
        this.setPreferenceStore(TexlipsePlugin.getDefault().getPreferenceStore());
        this.lastPath = new File(this.resolveTexDir());
    }

    private String resolveTexDir() {
        ProgramRunner runner = BuilderRegistry.getRunner(0);
        if (runner == null) {
            return File.separator;
        }
        String dir = runner.getProgramPath();
        if (dir == null || dir.length() == 0) {
            return File.separator;
        }
        int index = dir.lastIndexOf(File.separatorChar);
        if (index < 0) {
            return dir;
        }
        return dir.substring(0, index);
    }

    protected Control createContents(Composite parent) {
        Composite contents = new Composite(parent, 0);
        GridLayout gl = new GridLayout();
        gl.numColumns = 2;
        contents.setLayout((Layout)gl);
        this.addBuilderList(contents);
        TexlipsePreferencePage.addSpacer(2, false, contents);
        this.addTexInstallDir(contents);
        TexlipsePreferencePage.addSpacer(2, false, contents);
        this.addConsoleCheckBox(contents);
        this.addAuxParserCheckBox(contents);
        return contents;
    }

    private void addTexInstallDir(Composite contents) {
        Composite parent = new Composite(contents, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        parent.setLayout((Layout)layout);
        GridData pgd = new GridData(768);
        pgd.horizontalSpan = 2;
        parent.setLayoutData((Object)pgd);
        TexlipsePreferencePage.addLabelField(3, TexlipsePlugin.getResourceString("preferenceBuilderTexDirDescription"), parent);
        Label label = new Label(parent, 16384);
        label.setText(TexlipsePlugin.getResourceString("preferenceBuilderTexDirLabel"));
        label.setLayoutData((Object)new GridData());
        this.texDirField = new Text(parent, 2052);
        this.texDirField.setLayoutData((Object)new GridData(768));
        this.texDirField.setText("");
        WorkbenchHelp.setHelp((Control)this.texDirField, (String)TexlipseHelpIds.BUILDER_TEX_DIR);
        Button button = new Button(parent, 8);
        button.setText(JFaceResources.getString((String)"openBrowse"));
        button.setLayoutData((Object)new GridData());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String dir;
                DirectoryDialog dialog = new DirectoryDialog(BuilderSettingsPreferencePage.this.getShell());
                if (BuilderSettingsPreferencePage.this.lastPath != null && BuilderSettingsPreferencePage.this.lastPath.exists()) {
                    dialog.setFilterPath(BuilderSettingsPreferencePage.this.lastPath.getAbsolutePath());
                }
                if ((dir = dialog.open()) != null) {
                    BuilderSettingsPreferencePage.this.lastPath = new File(dir.trim());
                    if (BuilderSettingsPreferencePage.this.lastPath.exists()) {
                        BuilderSettingsPreferencePage.this.texDirField.setText(BuilderSettingsPreferencePage.this.lastPath.getAbsolutePath());
                    } else {
                        BuilderSettingsPreferencePage.this.lastPath = null;
                    }
                }
            }
        });
    }

    private void addBuilderList(Composite contents) {
        Composite leftPart = new Composite(contents, 0);
        leftPart.setLayout((Layout)new GridLayout());
        leftPart.setLayoutData((Object)new GridData(1808));
        Label label = new Label(leftPart, 16384);
        label.setText(TexlipsePlugin.getResourceString("preferenceBuilderListLabel"));
        label.setLayoutData((Object)new GridData());
        this.builderList = new List(leftPart, 2820);
        this.builderList.setItems(this.getBuilderItems());
        this.builderList.setLayoutData((Object)new GridData(1808));
        this.builderList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = BuilderSettingsPreferencePage.this.builderList.getSelectionIndex();
                BuilderSettingsPreferencePage.this.editButton.setEnabled(index >= 0);
            }
        });
        WorkbenchHelp.setHelp((Control)this.builderList, (String)TexlipseHelpIds.BUILDER_LIST);
        Composite rightPart = new Composite(contents, 0);
        rightPart.setLayout((Layout)new GridLayout());
        rightPart.setLayoutData((Object)new GridData(1808));
        Label empty = new Label(rightPart, 16384);
        empty.setLayoutData((Object)new GridData());
        this.editButton = new Button(rightPart, 8);
        this.editButton.setEnabled(false);
        this.editButton.setText(TexlipsePlugin.getResourceString("openEdit"));
        this.editButton.setLayoutData((Object)new GridData(32));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                int index = BuilderSettingsPreferencePage.this.builderList.getSelectionIndex();
                if (index >= 0) {
                    BuilderSettingsPreferencePage.this.openEditorDialog(index);
                }
            }
        });
        Label filler = new Label(rightPart, 16384);
        filler.setLayoutData((Object)new GridData(1040));
    }

    private void addConsoleCheckBox(Composite contents) {
        Composite checkField = new Composite(contents, 0);
        GridData checkData = new GridData(768);
        checkData.horizontalSpan = 2;
        checkField.setLayoutData((Object)checkData);
        GridLayout checkLay = new GridLayout();
        checkLay.numColumns = 2;
        checkField.setLayout((Layout)checkLay);
        this.consoleOutputCheckBox = new Button(checkField, 32);
        this.consoleOutputCheckBox.setLayoutData((Object)new GridData());
        this.consoleOutputCheckBox.setText(TexlipsePlugin.getResourceString("preferenceBuilderConsoleOutput"));
        this.consoleOutputCheckBox.setSelection(this.getPreferenceStore().getBoolean("builderConsole"));
    }

    private void addAuxParserCheckBox(Composite contents) {
        Composite checkField = new Composite(contents, 0);
        GridData checkData = new GridData(768);
        checkData.horizontalSpan = 2;
        checkField.setLayoutData((Object)checkData);
        GridLayout checkLay = new GridLayout();
        checkLay.numColumns = 2;
        checkField.setLayout((Layout)checkLay);
        this.auxParserCheckBox = new Button(checkField, 32);
        this.auxParserCheckBox.setLayoutData((Object)new GridData());
        this.auxParserCheckBox.setText(TexlipsePlugin.getResourceString("preferenceBuilderAuxParser"));
        this.auxParserCheckBox.setSelection(this.getPreferenceStore().getBoolean("builderParseAuxFiles"));
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        this.getPreferenceStore().setValue("builderConsole", this.consoleOutputCheckBox.getSelection());
        this.getPreferenceStore().setValue("builderParseAuxFiles", this.auxParserCheckBox.getSelection());
        this.changeTexDistribution();
        this.texDirField.setText("");
        this.builderList.setItems(this.getBuilderItems());
        return ok;
    }

    public void performDefaults() {
        super.performDefaults();
        this.consoleOutputCheckBox.setSelection(this.getPreferenceStore().getDefaultBoolean("builderConsole"));
        this.auxParserCheckBox.setSelection(this.getPreferenceStore().getDefaultBoolean("builderParseAuxFiles"));
    }

    private void changeTexDistribution() {
        File dir;
        String texDir = this.texDirField.getText();
        if (texDir != null && texDir.length() > 0 && (dir = new File(texDir)) != null && dir.exists() && dir.isDirectory()) {
            int size = BuilderRegistry.getNumberOfRunners();
            int i = 0;
            while (i < size) {
                ProgramRunner prog = BuilderRegistry.getRunner(i);
                File file = new File(dir, prog.getProgramName());
                if (file != null && file.exists() && file.isFile()) {
                    prog.setProgramPath(file.getAbsolutePath());
                }
                ++i;
            }
        }
    }

    private String[] getBuilderItems() {
        int number = BuilderRegistry.getNumberOfRunners();
        String[] array = new String[number];
        int i = 0;
        while (i < number) {
            array[i] = this.getRunnerLabel(i);
            ++i;
        }
        return array;
    }

    private String getRunnerLabel(int i) {
        ProgramRunner runner = BuilderRegistry.getRunner(i);
        return String.valueOf(runner.getDescription()) + "        (" + runner.getProgramPath() + ')';
    }

    private void openEditorDialog(int index) {
        BuilderConfigDialog dialog = new BuilderConfigDialog(this.getShell(), BuilderRegistry.getRunner(index));
        int code = dialog.open();
        if (code == 0) {
            this.builderList.setItem(index, this.getRunnerLabel(index));
        }
    }

    public void init(IWorkbench workbench) {
    }
}

