#include <stdlib.h>

extern unsigned long _sys_heap_begin;
extern unsigned long _sys_heap_end;

void *sbrk (int incr)
{
    static int inited = 0;
    static int _brk_left;
    static int _brk_val;
    void *retv;

    if (!inited) {
	_brk_val = _sys_heap_begin;
	_brk_left = _sys_heap_end - _sys_heap_begin;
	inited = 1;
    }

    if ((incr > _brk_left) || (_brk_val + incr > _sys_heap_end))
	return ((void *)-1);

    retv = (void *) _brk_val;
    _brk_val += incr;
    _brk_left -= incr;

    return retv;
}
