/*
 * All filters can use the routines below. Just make sure that
 * read_graphics() is defined as a macro for a function with
 * the following prototype:
 *    int read_graphics(LPSTR filename,LPHANDLE hmf,int *nx,int *ny)
 *
 * Written by Hippocrates Sendoukas, Los Angeles, September 1993
 */
/*  <- GetFilterInfo */
#ifdef __TURBOC__
#pragma argsused
#endif
WORD FAR PASCAL
GetFilterInfo(WORD version,LPSTR iniinfo,LPHANDLE hmem,LPHANDLE ftypes)
{
  return 2;
}

/*  -> GetFilterInfo */
/*  <- GetFilterPref */

#ifdef __TURBOC__
#pragma argsused
#endif
void FAR PASCAL
GetFilterPref(HANDLE hinst,HWND hwnd,HANDLE hmem,WORD flags)
{
}

/*  -> GetFilterPref */
/*  <- ImportGR */

#ifdef __TURBOC__
#pragma argsused
#endif
WORD FAR PASCAL
ImportGR(HDC hdc,LPFILESPEC fs,LPPICTINFO pi,HANDLE hmem)
{
  HANDLE	hmf;
  int		nx,ny,retcode;
  DWORD		mode;
  char		buf[32];

  GetPrivateProfileString(FILTNAME,"mode","",buf,sizeof(buf),"filters.ini");
  AnsiLower(buf);
  mode = (!lstrcmp(buf,"xor")) ? SRCINVERT :
         (!lstrcmp(buf,"and")) ? SRCAND :
         (!lstrcmp(buf,"or"))  ? SRCPAINT : SRCCOPY;

  memset(pi,0,sizeof(PICTINFO));
  hmf = 0;
  retcode = read_graphic(fs->fullname,&hmf,&nx,&ny,mode);
  if (retcode!=IE_OK) return (WORD) retcode;
  pi->hmf = hmf;
  pi->bbox.left = pi->bbox.top = 0;
  pi->bbox.right = nx;
  pi->bbox.bottom = ny;
  if (hdc)
    pi->inch = GetDeviceCaps(hdc,LOGPIXELSX);
  else
    {
      hdc = GetDC(0);
      pi->inch = GetDeviceCaps(hdc,LOGPIXELSX);
      ReleaseDC(0,hdc);
    }
  return IE_OK;
}

/*  -> ImportGR */
#if defined(_WIN32) || defined(__WIN32__)
/*  <- DllEntryPoint */

BOOL WINAPI _CRT_INIT(HINSTANCE,DWORD,LPVOID);

#ifdef __TURBOC__
#pragma argsused
#endif
BOOL WINAPI
DllEntryPoint(HINSTANCE hinst,DWORD reason,LPVOID p)
{
#ifdef __MSC
  if (reason==DLL_PROCESS_ATTACH || reason==DLL_THREAD_ATTACH)
    if(!_CRT_INIT(hinst,reason,p)) return(FALSE);
  if (reason==DLL_PROCESS_DETACH || reason==DLL_THREAD_DETACH)
    if (!_CRT_INIT(hinst,reason,p)) return(FALSE);
#endif
  return(TRUE);
}

/*  -> DllEntryPoint */
#else
/*  <- LibMain */

#pragma argsused
int FAR PASCAL
LibMain(HANDLE hinst,WORD dataseg,WORD heapsize,LPSTR cmdline)
{
  if (heapsize>0) UnlockData(0);
  return 1;
}

/*  -> LibMain */
#endif
