---
myst:
  html_meta:
    keywords: LaTeX, fichier, fontes mathématiques, police mathématique, 
              composition des mathématiques, Unicode, OpenType, TrueType
---

# Quelles sont les fontes OpenType utilisables pour les mathématiques ?

La norme [ISO/CEI 10646](wpfr:ISO/CEI_10646), qui est plus connue sous le nom d'[Unicode](wpfr:Unicode),
a été adopté très rapidement par les designers de fontes TrueType (TTF) et OpenType (OTF). 
Les potentialités de ces fontes et de cette norme permettent d’espérer, pour la première fois,
une méthode uniforme pour la composition dans toutes les langues.

Les utilisateurs de TeX ont adopté ces polices avec enthousiasme depuis un certain temps,
en utilisant [XeTeX](/1_generalites/glossaire/xetex) et [LuaTeX](/1_generalites/glossaire/luatex).

Alors que les utilisateurs de TeX étudiaient l'utilisation de ces formats de polices, 
l'ISO étendait Unicode pour fournir un support aux mathématiques. 
Parallèlement à ces travaux, Microsoft et (séparément) un consortium de sociétés d'édition 
développaient des polices mathématiques OpenType (Microsoft a contribué au développement des concepts, 
dans le cadre du processus ISO). La police de caractères mathématiques OpenType de Microsoft, 
*[Cambria Math](wpfr:Cambria_(police_d'écriture)>)* 
([article en anglais plus détaillé](wp:Cambria_(typeface)#Cambria_Math)) 
est disponible à l'achat depuis un certain temps.

La première police mathématique OpenType libre à apparaître a été *[Asana Math](wp:Asana-Math)*. 
Le consortium des éditeurs a ensuite produit une version provisoire de leur police, 
*[STIX](wp:STIX_Fonts_project)*, qui a été redéveloppée par un groupe d'utilisateurs de TeX 
pour fournir un ensemble plus largement utilisable, *[XITS](wp:XITS_font_project)*.

D'autres polices apparaissent, notamment *TeX Gyre Termes Math* 
(basée sur des polices proches de *Times*) et *Tex Gyre Pagella Math* 
(basée sur des polices proches de *Palatino*), ainsi que 
*[LM Math](https://www.gust.org.pl/projects/e-foundry/latin-modern)* 
qui étend la version OpenType de la famille de polices *[Latin Modern](wpfr:Computer_Modern)*.

L'utilisation d'une police mathématique Unicode est assez compliquée, 
mais l'extension LaTeX <ctanpkg:unicode-math> (supporté par l'extension <ctanpkg:fontspec>) 
fait le gros du travail de base.

:::{sources}
- [Unicode Maths using OpenType fonts](faquk:FAQ-otf-maths),
- [TUGboat Vol. 27 (2006), n°2 : The New Font Project : TEX Gyre](https://www.tug.org/TUGboat/tb27-2/tb87hagen-gyre.pdf),
- [TUGboat Vol. 39 (2018), n°3 : TEX Gyre text fonts revisited](https://tug.org/TUGboat/tb39-3/tb123jackowski-gyre.pdf).
:::