%%
%% This is file `grant.cls',
%% generated with the docstrip utility.
%%
%% The original source files were:
%%
%% grant.dtx  (with options: `grant')
%% 
%% This is a generated file.
%% 
%% Copyright (C) 2016-2019 Jonathan Karr <karr@mssm.edu>
%% 
%% This file may be distributed and/or modified under the conditions of
%% the MIT License. The latest version of this license is in:
%% 
%%     https://github.com/KarrLab/latex-grant/blob/master/LICENSE
%% 


%% \CharacterTable
%%  {Upper-case    \A\B\C\D\E\F\G\H\I\J\K\L\M\N\O\P\Q\R\S\T\U\V\W\X\Y\Z
%%   Lower-case    \a\b\c\d\e\f\g\h\i\j\k\l\m\n\o\p\q\r\s\t\u\v\w\x\y\z
%%   Digits        \0\1\2\3\4\5\6\7\8\9
%%   Exclamation   \!     Double quote  \"     Hash (number) \#
%%   Dollar        \$     Percent       \%     Ampersand     \&
%%   Acute accent  \'     Left paren    \(     Right paren   \)
%%   Asterisk      \*     Plus          \+     Comma         \,
%%   Minus         \-     Point         \.     Solidus       \/
%%   Colon         \:     Semicolon     \;     Less than     \<
%%   Equals        \=     Greater than  \>     Question mark \?
%%   Commercial at \@     Left bracket  \[     Backslash     \\
%%   Right bracket \]     Circumflex    \^     Underscore    \_
%%   Grave accent  \`     Left brace    \{     Vertical bar  \|
%%   Right brace   \}     Tilde         \~}




\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{grant}[2019/02/26 grant class]

%%%%%%%%%%%%%%%%%%%%%%
%% options
%%%%%%%%%%%%%%%%%%%%%%

\usepackage{etoolbox}

\newcommand{\fntsiz}{11pt}
\DeclareOption{10pt}{\renewcommand{\fntsiz}{10pt}}
\DeclareOption{11pt}{\renewcommand{\fntsiz}{11pt}}
\DeclareOption{12pt}{\renewcommand{\fntsiz}{12pt}}

\newbool{isdraft}
\boolfalse{isdraft}
\DeclareOption{isdraft}
    {\booltrue{isdraft}}
\DeclareOption{isnotdraft}
    {\boolfalse{isdraft}}

\newbool{iswhitepaper}
\boolfalse{iswhitepaper}
\DeclareOption{iswhitepaper}
    {\booltrue{iswhitepaper}}
\DeclareOption{isnotwhitepaper}
    {\boolfalse{iswhitepaper}}

\newbool{issectioncompact}
\boolfalse{issectioncompact}
\DeclareOption{issectioncompact}
    {\booltrue{issectioncompact}}
\DeclareOption{isnotsectioncompact}
    {\boolfalse{issectioncompact}}

\newbool{isbibcompact}
\boolfalse{isbibcompact}
\DeclareOption{isbibcompact}
    {\booltrue{isbibcompact}}
\DeclareOption{isnotbibcompact}
    {\boolfalse{isbibcompact}}

\ExecuteOptions{isdraft, isnotdraft, iswhitepaper, isnotwhitepaper, issectioncompact, isnotsectioncompact, isbibcompact, isnotbibcompact}
\ProcessOptions

%%%%%%%%%%%%%%%%%%%%%%
%% load book class
%%%%%%%%%%%%%%%%%%%%%%
\LoadClass[\fntsiz,oneside]{book}

%%%%%%%%%%%%%%%%%%%%%%
%% formatting
%%%%%%%%%%%%%%%%%%%%%%

\usepackage[english]{babel}
\usepackage[utf8]{inputenc}
\usepackage[T1]{fontenc}
\usepackage{uarial}
\renewcommand{\familydefault}{\sfdefault}

\usepackage[normalem]{ulem}
\usepackage{soul}
\soulregister\cite7

\usepackage{xcolor}
\usepackage{framed}
\definecolor{hlcolor}{rgb}{1, 1, 0}
\sethlcolor{hlcolor}
\colorlet{shadecolor}{hlcolor}
\setlength{\fboxsep}{0.05ex}
\setlength{\OuterFrameSep}{-\fboxsep}

\usepackage{setspace}
\singlespacing

\usepackage[paperwidth=8.5in, paperheight=11in, margin=1in, footskip=20pt]{geometry}

\setlength{\parindent}{0in}
\setlength{\parskip}{5pt}

\setcounter{secnumdepth}{5}
\usepackage[compact,explicit]{titlesec}

\titleclass{\part}{top}

\titleformat{\part}[block]{\centering\LARGE\bfseries}{}{0pt}{\LARGE\MakeUppercase{#1}}[]
\titleformat{\chapter}[block]{\large\bfseries}{}{0pt}{\large\MakeUppercase{#1}}[]
\titleformat{\section}[block]{\bfseries}{\uline{\thesection.~}}{0ex}{\uline{#1}}[]
\titleformat{\subsection}[runin]{\bfseries}{\thesubsection.~}{0ex}{#1}[]
\titleformat{\subsubsection}[runin]{}{\uline{\thesubsubsection.~}}{0ex}{\uline{#1}}[.]
\titleformat{\paragraph}[runin]{\itshape}{\theparagraph.~}{0ex}{#1}[.]
\titleformat{\subparagraph}[runin]{}{}{0ex}{\uline{#1}}[:]

\titlespacing*{\part}{0pt}{-3.5ex}{*-1}
\titlespacing*{\chapter}{0pt}{-3.5ex}{*-0.5}
\titlespacing*{\section}{0pt}{*0.0}{*-1}
\titlespacing*{\subsection}{0pt}{*0.0}{*0.5}
\titlespacing*{\subsubsection}{0pt}{*0.0}{*0.5}
\titlespacing*{\paragraph}{0pt}{*0}{*0.5}
\titlespacing*{\subparagraph}{0pt}{*0}{*0.5}

\renewcommand*\thesection{\arabic{section}}
\renewcommand*\thesubsection{\Alph{subsection}}
\renewcommand*\thesubsubsection{\roman{subsubsection}}
\renewcommand*\theparagraph{\arabic{paragraph}}

\makeatletter
\newcommand{\chapternotitle}[1]{%
  \begingroup
  \let\@makechapterhead\@gobble % make \@makechapterhead do nothing
  \chapter{#1}
  \endgroup
}
\makeatother

\newcommand{\partnonum}[2][part]{%
\phantomsection%
\addcontentsline{toc}{#1}{#2}%
\part*{#2}%
}

\newcommand{\chapternonum}[2][chapter]{%
\phantomsection%
\addcontentsline{toc}{#1}{#2}%
\chapter*{#2}%
}

\newcommand{\sectionnonum}[2][section]{%
\phantomsection%
\addcontentsline{toc}{#1}{#2}%
\section*{#2}%
}
\newcommand{\subsectionnonum}[2][subsection]{%
\phantomsection%
\addcontentsline{toc}{#1}{#2}%
\subsection*{#2}%
}
\newcommand{\subsubsectionnonum}[2][subsubsection]{%
\phantomsection%
\addcontentsline{toc}{#1}{#2}%
\subsubsection*{#2}%
}

\ifbool{iswhitepaper}{
    \titleformat{\section}[runin]{\bfseries}{\uline{\thesection.~}}{0ex}{\uline{#1}}[:]
}{
    \usepackage[auto]{chappg}
}

\ifbool{issectioncompact}{
    \titleformat{\section}[runin]{\bfseries}{\uline{\thesection.~}}{0ex}{\uline{#1}}[.]
    \titlespacing*{\section}{0pt}{*0.0}{*0.5}
}{}


\usepackage{fancyhdr}
\pagestyle{fancy}
\assignpagestyle{\chapter}{fancy}
\renewcommand{\chaptermark}[1]{\markboth{#1}{}}
\renewcommand{\headrulewidth}{0pt}
\renewcommand{\footrulewidth}{0pt}
\fancyhf{}
\ifbool{isdraft}{
    \lfoot{\small\leftmark}
    \rfoot{\small\thepage}
}{}

\ifbool{iswhitepaper}{
    \lfoot{}
    \rfoot{}
    \cfoot{\small\thepage}
}{}

\usepackage{paralist}
\usepackage{enumitem}
\setlist[itemize]{topsep=0pt, partopsep=0ex, parsep=0ex, itemsep=0ex, leftmargin=1em}
\setlist[enumerate]{topsep=0pt, partopsep=0ex, parsep=0ex, itemsep=0ex, leftmargin=1.3em}

\usepackage{hyphenat}

\usepackage[backend=bibtex8,style=nature,citestyle=numeric-comp,sorting=none,maxbibnames=30,minbibnames=30,autocite=superscript,firstinits=true,terseinits=true]{biblatex}
\let\cite=\autocite
\renewbibmacro*{name:last-first}[4]{%
  \ifuseprefix
    {%
      \usebibmacro{name:delim}{#3#1}%
       \usebibmacro{name:hook}{#3#1}%
       \ifblank{#3}{}
         {%
           \ifcapital
             {\mkbibnameprefix{\MakeCapital{#3}}\isdot}
         {\mkbibnameprefix{#3}\isdot}%
           \ifpunctmark{'}{}{\addhighpenspace}%
         }%
       \mkbibnamelast{#1}\isdot
       \ifblank{#2}
         {}{\addlowpenspace\mkbibnamefirst{#2}}%
       \ifblank{#4}{}{\addlowpenspace\mkbibnameaffix{#4}\isdot}%
    }
    {%
      \usebibmacro{name:delim}{#1}%
      \usebibmacro{name:hook}{#1}%
      \mkbibnamelast{#1}\isdot
      \ifblank{#2#3}{}{\addcomma}%
      \ifblank{#2}{}{\addlowpenspace\mkbibnamefirst{#2}\isdot}%
      \ifblank{#3}{}{\addlowpenspace\mkbibnameprefix{#3}\isdot}%
      \ifblank{#4}{}{\addlowpenspace\mkbibnameaffix{#4}\isdot}%
    }%
}
\setlength{\bibitemsep}{0pt}
\setlength{\biblabelsep}{5pt}

\ifbool{isbibcompact}{
    \defbibenvironment{bibliography}
        {\inparaenum[ (1)]}
        {\endinparaenum}
        {\item}

    \renewcommand{\bibfont}{\footnotesize}

    \ExecuteBibliographyOptions{maxbibnames=1,minbibnames=1}

    \DeclareFieldFormat[article]{title}{}
    \DeclareFieldFormat[article]{pages}{}
    \DeclareFieldFormat[article]{volume}{}
    \DeclareFieldFormat[article]{number}{}

    \DeclareFieldFormat[inproceedings]{title}{}
    \DeclareFieldFormat[inproceedings]{pages}{}
    \DeclareFieldFormat[inproceedings]{volume}{}
    \DeclareFieldFormat[inproceedings]{number}{}

    \DeclareFieldFormat[online]{url}{}
    \DeclareFieldFormat[online]{urldate}{}

    \renewbibmacro*{issue+date}{%
      \iffieldundef{year}
        {}
        {%
          \iffieldundef{issue}
            {\printtext[]{\usebibmacro{date}}}
            {%
              \printtext[parens]{%
                \printfield{issue}%
                \setunit*{\addspace}%
                \usebibmacro{date}%
              }%
            }%
        }%
      \newunit
    }

    \renewbibmacro*{name:last-first}[4]{%
      \ifuseprefix
        {%
          \usebibmacro{name:delim}{#3#1}%
           \usebibmacro{name:hook}{#3#1}%
           \ifblank{#3}{}
             {%
               \ifcapital
                 {\mkbibnameprefix{\MakeCapital{#3}}\isdot}
                 {\mkbibnameprefix{#3}\isdot}%
               \ifpunctmark{'}{}{\addhighpenspace}%
             }%
           \mkbibnamelast{#1}\isdot
           \ifblank{#2}
             {}{%
             %\addlowpenspace\mkbibnamefirst{#2}
             }%
           \ifblank{#4}{}{\addlowpenspace\mkbibnameaffix{#4}\isdot}%
        }
        {%
          \usebibmacro{name:delim}{#1}%
          \usebibmacro{name:hook}{#1}%
          \mkbibnamelast{#1}\isdot
          \ifblank{#2#3}{}{\addcomma}%
          %\ifblank{#2}{}{\addlowpenspace\mkbibnamefirst{#2}\isdot}%
          \ifblank{#3}{}{\addlowpenspace\mkbibnameprefix{#3}\isdot}%
          \ifblank{#4}{}{\addlowpenspace\mkbibnameaffix{#4}\isdot}%
        }%
    }
}{}

\usepackage{graphicx}
\DeclareGraphicsExtensions{%
    .pdf,.PDF,%
    .png,.PNG,%
    .jpg,.jpeg}

\usepackage[font=footnotesize,labelfont=bf,singlelinecheck=false,labelsep=period, skip=2pt]{caption}

\ifbool{isdraft}{
    \usepackage[breaklinks=true, bookmarksdepth=3]{hyperref}
}{
    \usepackage[breaklinks=true, bookmarksdepth=0, bookmarks=false]{hyperref}
    \let\oldcite\cite
    \renewcommand{\cite}[1]{%
      \begin{NoHyper}\oldcite{#1}\end{NoHyper}%
    }
}

\usepackage{tabularx}
\usepackage{longtable}
\usepackage{ltxtable}

\renewcommand{\figurename}{Fig.}
\renewcommand{\tablename}{Tab.}
\addto\captionsenglish{\renewcommand{\figurename}{Fig.}}
\addto\captionsenglish{\renewcommand{\tablename}{Tab.}}
\renewcommand*\thefigure{\arabic{figure}}
\renewcommand*\thetable{\arabic{table}}

\usepackage{placeins}

\usepackage{pdfpages}

\usepackage{lineno}

\setlength{\textfloatsep}{5.0pt plus 0.5pt minus 1pt}

\usepackage{tabularx}
\usepackage{booktabs}
\usepackage{wrapfig}

\usepackage{amsmath}
\usepackage{csquotes}

\usepackage[author={}, color=yellow]{pdfcomment}

\newcommand{\dontcite}[1]{}

\usepackage{multicol}

%%%%%%%%%%%%%%%%%%%%
%% Cover page
%%%%%%%%%%%%%%%%%%%%
\newcommand{\FundingAgency}{}
\newcommand{\FundingId}{}
\newcommand{\FundingTitle}{}
\newcommand{\FundingUrl}{}
\newcommand{\FundingDeadline}{}

\newcommand{\ProposalTitle}{}
\newcommand{\ProposalDurationInYears}{}
\newcommand{\ProposalCostInMillions}{}

\newcommand{\PiName}{}
\newcommand{\PiTitle}{}
\newcommand{\PiDepartment}{}
\newcommand{\PiInstitution}{}
\newcommand{\PiAddress}{}
\newcommand{\PiUrl}{}
\newcommand{\PiEmail}{}
\newcommand{\PiPhone}{}
\newcommand{\PiFax}{}

\newcommand{\OtherKeyPersonnel}{}

\newcommand{\LeadOrganizationName}{}
\newcommand{\LeadOrganizationAddress}{}
\newcommand{\LeadOrganizationDUNS}{}
\newcommand{\LeadOrganizationTIN}{}
\newcommand{\LeadOrganizationCAGE}{}

\newcommand{\AdminName}{}
\newcommand{\AdminTitle}{}
\newcommand{\AdminAddress}{}
\newcommand{\AdminInstitution}{}
\newcommand{\AdminPhone}{}
\newcommand{\AdminFax}{}
\newcommand{\AdminEmail}{}

\newcommand{\PoName}{}
\newcommand{\PoAddress}{}
\newcommand{\PoEmail}{}
\newcommand{\PoPhone}{}

\newcommand{\FundingIdTitle}{\FundingId\ifdefempty{\FundingTitle}{}{: \FundingTitle}}

\newcommand{\makecoverpage}{
    {\LARGE\bfseries

    \ProposalTitle

    }
    \vskip1ex
    \uline{Funding opportunity}
    \\\FundingAgency
    \\\FundingIdTitle (\href{\FundingUrl}{\FundingId})
    \\\FundingDeadline

    \uline{Applicant}
    \\\PiName
    \\\PiTitle
    \\\PiDepartment
    \\\PiInstitution
    \\\PiAddress
    \\\href{http://\PiUrl}{\PiUrl}
    \\\href{mailto:\PiEmail}{\PiEmail}
    \\\PiPhone

    \uline{Program officer}
    \\\PoName
    \\\PoAddress
    \\\href{mailto:\PoEmail}{\PoEmail}
    \\\PoPhone
}

\newcommand{\AbstractName}{Abstract}
\newcommand{\AbstractOtherPersonnelName}{Other key personnel and primary subcontractors}
\providetoggle{AbstractIsCentered}
\providetoggle{AbstractShowAdminPOC}
\providetoggle{AbstractShowLeadOrg}
\providetoggle{AbstractShowOtherPersonnel}
\providetoggle{AbstractShowDuration}
\providetoggle{AbstractShowCost}
\settoggle{AbstractIsCentered}{false}
\settoggle{AbstractShowAdminPOC}{true}
\settoggle{AbstractShowLeadOrg}{true}
\settoggle{AbstractShowOtherPersonnel}{true}
\settoggle{AbstractShowDuration}{true}
\settoggle{AbstractShowCost}{true}

\newcommand{\makeabstractcoverpage}{
    {\setlength{\parskip}{12pt}

    \iftoggle{AbstractIsCentered}{
    \centering
    }{}

    \begin{center}\textbf{
    \LARGE{\MakeUppercase{\AbstractName}}\\[18pt]
    \LARGE{\FundingId}\\
    \large{\FundingTitle}\\[18pt]
    \LARGE{\ProposalTitle}
    }\end{center}
    \vskip-8pt

    \textbf{Technical point of contact: \PiName}\\
    \PiTitle\\
    \PiDepartment\\
    \PiInstitution\\
    \PiAddress\\
    Tel: \PiPhone, Fax: \PiFax, Email: \href{mailto:\PiEmail}{\PiEmail}, Web: \href{http://www.\PiUrl}{\PiUrl}

    \iftoggle{AbstractShowAdminPOC}{
    \textbf{Administrative point of contact: \AdminName}\\
    \AdminTitle\\
    \AdminAddress\\
    \AdminInstitution\\
    Tel: \AdminPhone, Fax: \AdminFax, Email: \href{mailto:\AdminEmail}{\AdminEmail}
    }{}

    \iftoggle{AbstractShowLeadOrg}{
    \textbf{Lead organization: \LeadOrganizationName}\\
    \LeadOrganizationAddress\\
    DUNS number: \LeadOrganizationDUNS\\
    Taxpayer identification number: \LeadOrganizationTIN\\
    CAGE code: \LeadOrganizationCAGE
    }{}

    \iftoggle{AbstractShowOtherPersonnel}{
    \textbf{\AbstractOtherPersonnelName}\\
    \OtherKeyPersonnel
    }{}

    \iftoggle{AbstractShowDuration}{\textbf{Duration: {\ProposalDurationInYears} years}}{}

    \iftoggle{AbstractShowCost}{\textbf{Estimated cost: \${\ProposalCostInMillions} million in total costs}}{}

    }
    \clearpage
}









\endinput
%%
%% End of file `grant.cls'.
