/* HomeTimeline.c generated by valac 0.34.6, the Vala compiler
 * generated from HomeTimeline.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <rest/oauth-proxy.h>
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "CbTweet.h"
#include <glib/gi18n-lib.h>


#define TYPE_SCROLL_WIDGET (scroll_widget_get_type ())
#define SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCROLL_WIDGET, ScrollWidget))
#define SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCROLL_WIDGET, ScrollWidgetClass))
#define IS_SCROLL_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCROLL_WIDGET))
#define IS_SCROLL_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCROLL_WIDGET))
#define SCROLL_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCROLL_WIDGET, ScrollWidgetClass))

typedef struct _ScrollWidget ScrollWidget;
typedef struct _ScrollWidgetClass ScrollWidgetClass;
typedef struct _ScrollWidgetPrivate ScrollWidgetPrivate;

#define TYPE_IPAGE (ipage_get_type ())
#define IPAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IPAGE, IPage))
#define IS_IPAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IPAGE))
#define IPAGE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IPAGE, IPageIface))

typedef struct _IPage IPage;
typedef struct _IPageIface IPageIface;

#define TYPE_BUNDLE (bundle_get_type ())
#define BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUNDLE, Bundle))
#define BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUNDLE, BundleClass))
#define IS_BUNDLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUNDLE))
#define IS_BUNDLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUNDLE))
#define BUNDLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUNDLE, BundleClass))

typedef struct _Bundle Bundle;
typedef struct _BundleClass BundleClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DEFAULT_TIMELINE (default_timeline_get_type ())
#define DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimeline))
#define DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))
#define IS_DEFAULT_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEFAULT_TIMELINE))
#define IS_DEFAULT_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEFAULT_TIMELINE))
#define DEFAULT_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEFAULT_TIMELINE, DefaultTimelineClass))

typedef struct _DefaultTimeline DefaultTimeline;
typedef struct _DefaultTimelineClass DefaultTimelineClass;
typedef struct _DefaultTimelinePrivate DefaultTimelinePrivate;

#define TYPE_TWEET_LIST_BOX (tweet_list_box_get_type ())
#define TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_BOX, TweetListBox))
#define TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_BOX, TweetListBoxClass))
#define IS_TWEET_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_BOX))
#define IS_TWEET_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_BOX))
#define TWEET_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_BOX, TweetListBoxClass))

typedef struct _TweetListBox TweetListBox;
typedef struct _TweetListBoxClass TweetListBoxClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define TYPE_BADGE_RADIO_BUTTON (badge_radio_button_get_type ())
#define BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButton))
#define BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))
#define IS_BADGE_RADIO_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BADGE_RADIO_BUTTON))
#define IS_BADGE_RADIO_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BADGE_RADIO_BUTTON))
#define BADGE_RADIO_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BADGE_RADIO_BUTTON, BadgeRadioButtonClass))

typedef struct _BadgeRadioButton BadgeRadioButton;
typedef struct _BadgeRadioButtonClass BadgeRadioButtonClass;

#define TYPE_IMESSAGE_RECEIVER (imessage_receiver_get_type ())
#define IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiver))
#define IS_IMESSAGE_RECEIVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMESSAGE_RECEIVER))
#define IMESSAGE_RECEIVER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_IMESSAGE_RECEIVER, IMessageReceiverIface))

typedef struct _IMessageReceiver IMessageReceiver;
typedef struct _IMessageReceiverIface IMessageReceiverIface;

#define TYPE_STREAM_MESSAGE_TYPE (stream_message_type_get_type ())

#define TYPE_HOME_TIMELINE (home_timeline_get_type ())
#define HOME_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HOME_TIMELINE, HomeTimeline))
#define HOME_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HOME_TIMELINE, HomeTimelineClass))
#define IS_HOME_TIMELINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HOME_TIMELINE))
#define IS_HOME_TIMELINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HOME_TIMELINE))
#define HOME_TIMELINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HOME_TIMELINE, HomeTimelineClass))

typedef struct _HomeTimeline HomeTimeline;
typedef struct _HomeTimelineClass HomeTimelineClass;
typedef struct _HomeTimelinePrivate HomeTimelinePrivate;
typedef struct _TweetListBoxPrivate TweetListBoxPrivate;

#define TYPE_DELTA_UPDATER (delta_updater_get_type ())
#define DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELTA_UPDATER, DeltaUpdater))
#define DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELTA_UPDATER, DeltaUpdaterClass))
#define IS_DELTA_UPDATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELTA_UPDATER))
#define IS_DELTA_UPDATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELTA_UPDATER))
#define DELTA_UPDATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELTA_UPDATER, DeltaUpdaterClass))

typedef struct _DeltaUpdater DeltaUpdater;
typedef struct _DeltaUpdaterClass DeltaUpdaterClass;

#define TYPE_TWEET_MODEL (tweet_model_get_type ())
#define TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_MODEL, TweetModel))
#define TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_MODEL, TweetModelClass))
#define IS_TWEET_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_MODEL))
#define IS_TWEET_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_MODEL))
#define TWEET_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_MODEL, TweetModelClass))

typedef struct _TweetModel TweetModel;
typedef struct _TweetModelClass TweetModelClass;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ScrollWidget {
	GtkScrolledWindow parent_instance;
	ScrollWidgetPrivate * priv;
};

struct _ScrollWidgetClass {
	GtkScrolledWindowClass parent_class;
};

struct _IPageIface {
	GTypeInterface parent_iface;
	void (*on_join) (IPage* self, gint page_id, Bundle* args);
	void (*on_leave) (IPage* self);
	void (*create_radio_button) (IPage* self, GtkRadioButton* group);
	GtkRadioButton* (*get_radio_button) (IPage* self);
	gchar* (*get_title) (IPage* self);
	gboolean (*handles_double_open) (IPage* self);
	void (*double_open) (IPage* self);
	gint (*get_id) (IPage* self);
	void (*set_id) (IPage* self, gint value);
	void (*set_window) (IPage* self, MainWindow* value);
};

struct _DefaultTimeline {
	ScrollWidget parent_instance;
	DefaultTimelinePrivate * priv;
	gboolean initialized;
	MainWindow* main_window;
	TweetListBox* tweet_list;
	Account* account;
	BadgeRadioButton* radio_button;
	guint tweet_remove_timeout;
	gboolean loading;
	GtkWidget* last_focus_widget;
};

struct _DefaultTimelineClass {
	ScrollWidgetClass parent_class;
	void (*on_join) (DefaultTimeline* self, gint page_id, Bundle* args);
	void (*on_leave) (DefaultTimeline* self);
	gchar* (*get_title) (DefaultTimeline* self);
	void (*create_radio_button) (DefaultTimeline* self, GtkRadioButton* group);
	const gchar* (*get_function) (DefaultTimeline* self);
};

typedef enum  {
	STREAM_MESSAGE_TYPE_UNSUPPORTED,
	STREAM_MESSAGE_TYPE_DELETE,
	STREAM_MESSAGE_TYPE_SCRUB_GEO,
	STREAM_MESSAGE_TYPE_LIMIT,
	STREAM_MESSAGE_TYPE_DISCONNECT,
	STREAM_MESSAGE_TYPE_FRIENDS,
	STREAM_MESSAGE_TYPE_EVENT,
	STREAM_MESSAGE_TYPE_WARNING,
	STREAM_MESSAGE_TYPE_DIRECT_MESSAGE,
	STREAM_MESSAGE_TYPE_TWEET,
	STREAM_MESSAGE_TYPE_EVENT_LIST_CREATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_DESTROYED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UPDATED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_UNSUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_SUBSCRIBED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_ADDED,
	STREAM_MESSAGE_TYPE_EVENT_LIST_MEMBER_REMOVED,
	STREAM_MESSAGE_TYPE_EVENT_FAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE,
	STREAM_MESSAGE_TYPE_EVENT_FOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_UNFOLLOW,
	STREAM_MESSAGE_TYPE_EVENT_BLOCK,
	STREAM_MESSAGE_TYPE_EVENT_UNBLOCK,
	STREAM_MESSAGE_TYPE_EVENT_MUTE,
	STREAM_MESSAGE_TYPE_EVENT_UNMUTE,
	STREAM_MESSAGE_TYPE_EVENT_USER_UPDATE,
	STREAM_MESSAGE_TYPE_EVENT_QUOTED_TWEET
} StreamMessageType;

struct _IMessageReceiverIface {
	GTypeInterface parent_iface;
	void (*stream_message_received) (IMessageReceiver* self, StreamMessageType type, JsonNode* root_node);
};

struct _HomeTimeline {
	DefaultTimeline parent_instance;
	HomeTimelinePrivate * priv;
};

struct _HomeTimelineClass {
	DefaultTimelineClass parent_class;
};

struct _TweetListBox {
	GtkListBox parent_instance;
	TweetListBoxPrivate * priv;
	DeltaUpdater* delta_updater;
	Account* account;
	TweetModel* model;
};

struct _TweetListBoxClass {
	GtkListBoxClass parent_class;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	OAuthProxy* proxy;
	UserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};


static gpointer home_timeline_parent_class = NULL;
static IMessageReceiverIface* home_timeline_imessage_receiver_parent_iface = NULL;

GType scroll_widget_get_type (void) G_GNUC_CONST;
GType bundle_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType ipage_get_type (void) G_GNUC_CONST;
GType default_timeline_get_type (void) G_GNUC_CONST;
GType tweet_list_box_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType badge_radio_button_get_type (void) G_GNUC_CONST;
GType stream_message_type_get_type (void) G_GNUC_CONST;
GType imessage_receiver_get_type (void) G_GNUC_CONST;
GType home_timeline_get_type (void) G_GNUC_CONST;
enum  {
	HOME_TIMELINE_DUMMY_PROPERTY,
	HOME_TIMELINE_FUNCTION
};
HomeTimeline* home_timeline_new (gint id, Account* account);
HomeTimeline* home_timeline_construct (GType object_type, gint id, Account* account);
DefaultTimeline* default_timeline_construct (GType object_type, gint id);
GType delta_updater_get_type (void) G_GNUC_CONST;
GType tweet_model_get_type (void) G_GNUC_CONST;
static void home_timeline_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root);
static void home_timeline_add_tweet (HomeTimeline* self, JsonNode* obj);
void default_timeline_delete_tweet (DefaultTimeline* self, gint64 tweet_id);
GType sql_database_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
void default_timeline_toggle_favorite (DefaultTimeline* self, gint64 id, gboolean mode);
void home_timeline_hide_tweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason);
void home_timeline_show_tweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason);
CbTweetState default_timeline_get_rt_flags (DefaultTimeline* self, CbTweet* t);
gboolean account_is_blocked (Account* self, gint64 user_id);
gboolean account_is_muted (Account* self, gint64 user_id);
gboolean account_filter_matches (Account* self, CbTweet* t);
gboolean settings_auto_scroll_on_new_tweets (void);
gboolean scroll_widget_get_scrolled_up (ScrollWidget* self);
gint main_window_get_cur_page_id (MainWindow* self);
gint ipage_get_id (IPage* self);
GtkWidget* tweet_list_box_get_first_visible_row (TweetListBox* self);
void tweet_model_add (TweetModel* self, CbTweet* tweet);
void scroll_widget_balance_next_upper_change (ScrollWidget* self, gint mode);
#define TOP 1
gboolean default_timeline_scroll_up (DefaultTimeline* self, CbTweet* t);
gint default_timeline_get_unread_count (DefaultTimeline* self);
void default_timeline_set_unread_count (DefaultTimeline* self, gint value);
gint settings_get_tweet_stack_count (void);
gchar* notification_manager_send (NotificationManager* self, const gchar* summary, const gchar* body, const gchar* id_suffix);
void tweet_model_toggle_flag_on_tweet (TweetModel* self, gint64 user_id, CbTweetState reason, gboolean active);
void home_timeline_hide_retweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason);
void tweet_model_toggle_flag_on_retweet (TweetModel* self, gint64 user_id, CbTweetState reason, gboolean active);
void home_timeline_show_retweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason);
static gchar* home_timeline_real_get_title (DefaultTimeline* base);
const gchar* account_get_screen_name (Account* self);
static void home_timeline_real_create_radio_button (DefaultTimeline* base, GtkRadioButton* group);
BadgeRadioButton* badge_radio_button_new (GtkRadioButton* group, const gchar* icon_name, const gchar* text);
BadgeRadioButton* badge_radio_button_construct (GType object_type, GtkRadioButton* group, const gchar* icon_name, const gchar* text);
const gchar* default_timeline_get_function (DefaultTimeline* self);
static void _vala_home_timeline_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


HomeTimeline* home_timeline_construct (GType object_type, gint id, Account* account) {
	HomeTimeline * self = NULL;
	gint _tmp0_ = 0;
	Account* _tmp1_ = NULL;
	TweetListBox* _tmp2_ = NULL;
	Account* _tmp3_ = NULL;
	g_return_val_if_fail (IS_ACCOUNT (account), NULL);
	_tmp0_ = id;
	self = (HomeTimeline*) default_timeline_construct (object_type, _tmp0_);
	_tmp1_ = account;
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account = _tmp1_;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
	_tmp3_ = account;
	_tmp2_->account = _tmp3_;
	return self;
}


HomeTimeline* home_timeline_new (gint id, Account* account) {
	return home_timeline_construct (TYPE_HOME_TIMELINE, id, account);
}


static void home_timeline_real_stream_message_received (IMessageReceiver* base, StreamMessageType type, JsonNode* root) {
	HomeTimeline * self;
	StreamMessageType _tmp0_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HOME_TIMELINE, HomeTimeline);
	g_return_if_fail (root != NULL);
	_tmp0_ = type;
	if (_tmp0_ == STREAM_MESSAGE_TYPE_TWEET) {
		JsonNode* _tmp1_ = NULL;
		_tmp1_ = root;
		home_timeline_add_tweet (self, _tmp1_);
	} else {
		StreamMessageType _tmp2_ = 0;
		_tmp2_ = type;
		if (_tmp2_ == STREAM_MESSAGE_TYPE_DELETE) {
			gint64 id = 0LL;
			JsonNode* _tmp3_ = NULL;
			JsonObject* _tmp4_ = NULL;
			JsonObject* _tmp5_ = NULL;
			JsonObject* _tmp6_ = NULL;
			gint64 _tmp7_ = 0LL;
			gint64 _tmp8_ = 0LL;
			_tmp3_ = root;
			_tmp4_ = json_node_get_object (_tmp3_);
			_tmp5_ = json_object_get_object_member (_tmp4_, "delete");
			_tmp6_ = json_object_get_object_member (_tmp5_, "status");
			_tmp7_ = json_object_get_int_member (_tmp6_, "id");
			id = _tmp7_;
			_tmp8_ = id;
			default_timeline_delete_tweet (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp8_);
		} else {
			StreamMessageType _tmp9_ = 0;
			_tmp9_ = type;
			if (_tmp9_ == STREAM_MESSAGE_TYPE_EVENT_FAVORITE) {
				gint64 id = 0LL;
				JsonNode* _tmp10_ = NULL;
				JsonObject* _tmp11_ = NULL;
				JsonObject* _tmp12_ = NULL;
				gint64 _tmp13_ = 0LL;
				gint64 source_id = 0LL;
				JsonNode* _tmp14_ = NULL;
				JsonObject* _tmp15_ = NULL;
				JsonObject* _tmp16_ = NULL;
				gint64 _tmp17_ = 0LL;
				gint64 _tmp18_ = 0LL;
				Account* _tmp19_ = NULL;
				gint64 _tmp20_ = 0LL;
				_tmp10_ = root;
				_tmp11_ = json_node_get_object (_tmp10_);
				_tmp12_ = json_object_get_object_member (_tmp11_, "target_object");
				_tmp13_ = json_object_get_int_member (_tmp12_, "id");
				id = _tmp13_;
				_tmp14_ = root;
				_tmp15_ = json_node_get_object (_tmp14_);
				_tmp16_ = json_object_get_object_member (_tmp15_, "source");
				_tmp17_ = json_object_get_int_member (_tmp16_, "id");
				source_id = _tmp17_;
				_tmp18_ = source_id;
				_tmp19_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
				_tmp20_ = _tmp19_->id;
				if (_tmp18_ == _tmp20_) {
					gint64 _tmp21_ = 0LL;
					_tmp21_ = id;
					default_timeline_toggle_favorite (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp21_, TRUE);
				}
			} else {
				StreamMessageType _tmp22_ = 0;
				_tmp22_ = type;
				if (_tmp22_ == STREAM_MESSAGE_TYPE_EVENT_UNFAVORITE) {
					gint64 id = 0LL;
					JsonNode* _tmp23_ = NULL;
					JsonObject* _tmp24_ = NULL;
					JsonObject* _tmp25_ = NULL;
					gint64 _tmp26_ = 0LL;
					gint64 source_id = 0LL;
					JsonNode* _tmp27_ = NULL;
					JsonObject* _tmp28_ = NULL;
					JsonObject* _tmp29_ = NULL;
					gint64 _tmp30_ = 0LL;
					gint64 _tmp31_ = 0LL;
					Account* _tmp32_ = NULL;
					gint64 _tmp33_ = 0LL;
					_tmp23_ = root;
					_tmp24_ = json_node_get_object (_tmp23_);
					_tmp25_ = json_object_get_object_member (_tmp24_, "target_object");
					_tmp26_ = json_object_get_int_member (_tmp25_, "id");
					id = _tmp26_;
					_tmp27_ = root;
					_tmp28_ = json_node_get_object (_tmp27_);
					_tmp29_ = json_object_get_object_member (_tmp28_, "source");
					_tmp30_ = json_object_get_int_member (_tmp29_, "id");
					source_id = _tmp30_;
					_tmp31_ = source_id;
					_tmp32_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
					_tmp33_ = _tmp32_->id;
					if (_tmp31_ == _tmp33_) {
						gint64 _tmp34_ = 0LL;
						_tmp34_ = id;
						default_timeline_toggle_favorite (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp34_, FALSE);
					}
				} else {
					StreamMessageType _tmp35_ = 0;
					_tmp35_ = type;
					if (_tmp35_ == STREAM_MESSAGE_TYPE_EVENT_BLOCK) {
						gint64 user_id = 0LL;
						JsonNode* _tmp36_ = NULL;
						JsonObject* _tmp37_ = NULL;
						JsonObject* _tmp38_ = NULL;
						gint64 _tmp39_ = 0LL;
						gint64 _tmp40_ = 0LL;
						_tmp36_ = root;
						_tmp37_ = json_node_get_object (_tmp36_);
						_tmp38_ = json_object_get_object_member (_tmp37_, "target");
						_tmp39_ = json_object_get_int_member (_tmp38_, "id");
						user_id = _tmp39_;
						_tmp40_ = user_id;
						home_timeline_hide_tweets_from (self, _tmp40_, CB_TWEET_STATE_HIDDEN_AUTHOR_BLOCKED);
					} else {
						StreamMessageType _tmp41_ = 0;
						_tmp41_ = type;
						if (_tmp41_ == STREAM_MESSAGE_TYPE_EVENT_UNBLOCK) {
							gint64 user_id = 0LL;
							JsonNode* _tmp42_ = NULL;
							JsonObject* _tmp43_ = NULL;
							JsonObject* _tmp44_ = NULL;
							gint64 _tmp45_ = 0LL;
							gint64 _tmp46_ = 0LL;
							_tmp42_ = root;
							_tmp43_ = json_node_get_object (_tmp42_);
							_tmp44_ = json_object_get_object_member (_tmp43_, "target");
							_tmp45_ = json_object_get_int_member (_tmp44_, "id");
							user_id = _tmp45_;
							_tmp46_ = user_id;
							home_timeline_show_tweets_from (self, _tmp46_, CB_TWEET_STATE_HIDDEN_AUTHOR_BLOCKED);
						} else {
							StreamMessageType _tmp47_ = 0;
							_tmp47_ = type;
							if (_tmp47_ == STREAM_MESSAGE_TYPE_EVENT_MUTE) {
								gint64 user_id = 0LL;
								JsonNode* _tmp48_ = NULL;
								JsonObject* _tmp49_ = NULL;
								JsonObject* _tmp50_ = NULL;
								gint64 _tmp51_ = 0LL;
								gint64 _tmp52_ = 0LL;
								_tmp48_ = root;
								_tmp49_ = json_node_get_object (_tmp48_);
								_tmp50_ = json_object_get_object_member (_tmp49_, "target");
								_tmp51_ = json_object_get_int_member (_tmp50_, "id");
								user_id = _tmp51_;
								_tmp52_ = user_id;
								home_timeline_hide_tweets_from (self, _tmp52_, CB_TWEET_STATE_HIDDEN_AUTHOR_MUTED);
							} else {
								StreamMessageType _tmp53_ = 0;
								_tmp53_ = type;
								if (_tmp53_ == STREAM_MESSAGE_TYPE_EVENT_UNMUTE) {
									gint64 user_id = 0LL;
									JsonNode* _tmp54_ = NULL;
									JsonObject* _tmp55_ = NULL;
									JsonObject* _tmp56_ = NULL;
									gint64 _tmp57_ = 0LL;
									gint64 _tmp58_ = 0LL;
									_tmp54_ = root;
									_tmp55_ = json_node_get_object (_tmp54_);
									_tmp56_ = json_object_get_object_member (_tmp55_, "target");
									_tmp57_ = json_object_get_int_member (_tmp56_, "id");
									user_id = _tmp57_;
									_tmp58_ = user_id;
									home_timeline_show_tweets_from (self, _tmp58_, CB_TWEET_STATE_HIDDEN_AUTHOR_MUTED);
								}
							}
						}
					}
				}
			}
		}
	}
}


static void home_timeline_add_tweet (HomeTimeline* self, JsonNode* obj) {
	GDateTime* now = NULL;
	GDateTime* _tmp0_ = NULL;
	CbTweet* t = NULL;
	CbTweet* _tmp1_ = NULL;
	CbTweet* _tmp2_ = NULL;
	JsonNode* _tmp3_ = NULL;
	Account* _tmp4_ = NULL;
	gint64 _tmp5_ = 0LL;
	GDateTime* _tmp6_ = NULL;
	CbTweet* _tmp7_ = NULL;
	CbMiniTweet* _tmp8_ = NULL;
	Account* _tmp54_ = NULL;
	CbTweet* _tmp55_ = NULL;
	gboolean _tmp56_ = FALSE;
	gboolean auto_scroll = FALSE;
	gboolean _tmp58_ = FALSE;
	gboolean _tmp59_ = FALSE;
	gboolean _tmp60_ = FALSE;
	CbTweet* _tmp61_ = NULL;
	CbMiniTweet _tmp62_ = {0};
	CbUserIdentity _tmp63_ = {0};
	gint64 _tmp64_ = 0LL;
	Account* _tmp65_ = NULL;
	gint64 _tmp66_ = 0LL;
	CbTweet* _tmp86_ = NULL;
	gboolean _tmp87_ = FALSE;
	TweetListBox* _tmp88_ = NULL;
	GtkWidget* _tmp89_ = NULL;
	GtkWidget* _tmp90_ = NULL;
	gboolean _tmp91_ = FALSE;
	gboolean _tmp92_ = FALSE;
	gboolean _tmp93_ = FALSE;
	gboolean should_focus = FALSE;
	TweetListBox* _tmp96_ = NULL;
	TweetModel* _tmp97_ = NULL;
	CbTweet* _tmp98_ = NULL;
	CbTweet* _tmp99_ = NULL;
	gboolean _tmp100_ = FALSE;
	gboolean _tmp108_ = FALSE;
	CbTweet* _tmp112_ = NULL;
	gboolean _tmp113_ = FALSE;
	gint stack_size = 0;
	gint _tmp114_ = 0;
	gboolean _tmp115_ = FALSE;
	CbTweet* _tmp116_ = NULL;
	gint64 _tmp117_ = 0LL;
	Account* _tmp118_ = NULL;
	gint64 _tmp119_ = 0LL;
	gboolean _tmp121_ = FALSE;
	gint _tmp122_ = 0;
	g_return_if_fail (IS_HOME_TIMELINE (self));
	g_return_if_fail (obj != NULL);
	_tmp0_ = g_date_time_new_now_local ();
	now = _tmp0_;
	_tmp1_ = cb_tweet_new ();
	t = _tmp1_;
	_tmp2_ = t;
	_tmp3_ = obj;
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
	_tmp5_ = _tmp4_->id;
	_tmp6_ = now;
	cb_tweet_load_from_json (_tmp2_, _tmp3_, _tmp5_, _tmp6_);
	_tmp7_ = t;
	_tmp8_ = _tmp7_->retweeted_tweet;
	if (_tmp8_ != NULL) {
		CbTweet* _tmp9_ = NULL;
		CbTweet* _tmp10_ = NULL;
		CbTweetState _tmp11_ = 0;
		Account* _tmp12_ = NULL;
		CbTweet* _tmp13_ = NULL;
		CbMiniTweet _tmp14_ = {0};
		CbUserIdentity _tmp15_ = {0};
		gint64 _tmp16_ = 0LL;
		gboolean _tmp17_ = FALSE;
		Account* _tmp19_ = NULL;
		CbTweet* _tmp20_ = NULL;
		CbMiniTweet* _tmp21_ = NULL;
		CbUserIdentity _tmp22_ = {0};
		gint64 _tmp23_ = 0LL;
		gboolean _tmp24_ = FALSE;
		Account* _tmp26_ = NULL;
		CbTweet* _tmp27_ = NULL;
		CbMiniTweet _tmp28_ = {0};
		CbUserIdentity _tmp29_ = {0};
		gint64 _tmp30_ = 0LL;
		gboolean _tmp31_ = FALSE;
		Account* _tmp33_ = NULL;
		CbTweet* _tmp34_ = NULL;
		CbMiniTweet* _tmp35_ = NULL;
		CbUserIdentity _tmp36_ = {0};
		gint64 _tmp37_ = 0LL;
		gboolean _tmp38_ = FALSE;
		_tmp9_ = t;
		_tmp10_ = t;
		_tmp11_ = default_timeline_get_rt_flags (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp10_);
		cb_tweet_set_flag (_tmp9_, (guint) _tmp11_);
		_tmp12_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp13_ = t;
		_tmp14_ = _tmp13_->source_tweet;
		_tmp15_ = _tmp14_.author;
		_tmp16_ = _tmp15_.id;
		_tmp17_ = account_is_blocked (_tmp12_, _tmp16_);
		if (_tmp17_) {
			CbTweet* _tmp18_ = NULL;
			_tmp18_ = t;
			cb_tweet_set_flag (_tmp18_, (guint) CB_TWEET_STATE_HIDDEN_RETWEETER_BLOCKED);
		}
		_tmp19_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp20_ = t;
		_tmp21_ = _tmp20_->retweeted_tweet;
		_tmp22_ = (*_tmp21_).author;
		_tmp23_ = _tmp22_.id;
		_tmp24_ = account_is_blocked (_tmp19_, _tmp23_);
		if (_tmp24_) {
			CbTweet* _tmp25_ = NULL;
			_tmp25_ = t;
			cb_tweet_set_flag (_tmp25_, (guint) CB_TWEET_STATE_HIDDEN_AUTHOR_BLOCKED);
		}
		_tmp26_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp27_ = t;
		_tmp28_ = _tmp27_->source_tweet;
		_tmp29_ = _tmp28_.author;
		_tmp30_ = _tmp29_.id;
		_tmp31_ = account_is_muted (_tmp26_, _tmp30_);
		if (_tmp31_) {
			CbTweet* _tmp32_ = NULL;
			_tmp32_ = t;
			cb_tweet_set_flag (_tmp32_, (guint) CB_TWEET_STATE_HIDDEN_RETWEETER_MUTED);
		}
		_tmp33_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp34_ = t;
		_tmp35_ = _tmp34_->retweeted_tweet;
		_tmp36_ = (*_tmp35_).author;
		_tmp37_ = _tmp36_.id;
		_tmp38_ = account_is_muted (_tmp33_, _tmp37_);
		if (_tmp38_) {
			CbTweet* _tmp39_ = NULL;
			_tmp39_ = t;
			cb_tweet_set_flag (_tmp39_, (guint) CB_TWEET_STATE_HIDDEN_AUTHOR_MUTED);
		}
	} else {
		Account* _tmp40_ = NULL;
		CbTweet* _tmp41_ = NULL;
		CbMiniTweet _tmp42_ = {0};
		CbUserIdentity _tmp43_ = {0};
		gint64 _tmp44_ = 0LL;
		gboolean _tmp45_ = FALSE;
		Account* _tmp47_ = NULL;
		CbTweet* _tmp48_ = NULL;
		CbMiniTweet _tmp49_ = {0};
		CbUserIdentity _tmp50_ = {0};
		gint64 _tmp51_ = 0LL;
		gboolean _tmp52_ = FALSE;
		_tmp40_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp41_ = t;
		_tmp42_ = _tmp41_->source_tweet;
		_tmp43_ = _tmp42_.author;
		_tmp44_ = _tmp43_.id;
		_tmp45_ = account_is_blocked (_tmp40_, _tmp44_);
		if (_tmp45_) {
			CbTweet* _tmp46_ = NULL;
			_tmp46_ = t;
			cb_tweet_set_flag (_tmp46_, (guint) CB_TWEET_STATE_HIDDEN_AUTHOR_BLOCKED);
		}
		_tmp47_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp48_ = t;
		_tmp49_ = _tmp48_->source_tweet;
		_tmp50_ = _tmp49_.author;
		_tmp51_ = _tmp50_.id;
		_tmp52_ = account_is_muted (_tmp47_, _tmp51_);
		if (_tmp52_) {
			CbTweet* _tmp53_ = NULL;
			_tmp53_ = t;
			cb_tweet_set_flag (_tmp53_, (guint) CB_TWEET_STATE_HIDDEN_AUTHOR_MUTED);
		}
	}
	_tmp54_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
	_tmp55_ = t;
	_tmp56_ = account_filter_matches (_tmp54_, _tmp55_);
	if (_tmp56_) {
		CbTweet* _tmp57_ = NULL;
		_tmp57_ = t;
		cb_tweet_set_flag (_tmp57_, (guint) CB_TWEET_STATE_HIDDEN_FILTERED);
	}
	_tmp58_ = settings_auto_scroll_on_new_tweets ();
	auto_scroll = _tmp58_;
	_tmp61_ = t;
	_tmp62_ = _tmp61_->source_tweet;
	_tmp63_ = _tmp62_.author;
	_tmp64_ = _tmp63_.id;
	_tmp65_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
	_tmp66_ = _tmp65_->id;
	if (_tmp64_ == _tmp66_) {
		_tmp60_ = TRUE;
	} else {
		gboolean _tmp67_ = FALSE;
		CbTweet* _tmp68_ = NULL;
		CbMiniTweet* _tmp69_ = NULL;
		_tmp68_ = t;
		_tmp69_ = _tmp68_->retweeted_tweet;
		if (_tmp69_ != NULL) {
			CbTweet* _tmp70_ = NULL;
			CbMiniTweet* _tmp71_ = NULL;
			CbUserIdentity _tmp72_ = {0};
			gint64 _tmp73_ = 0LL;
			Account* _tmp74_ = NULL;
			gint64 _tmp75_ = 0LL;
			_tmp70_ = t;
			_tmp71_ = _tmp70_->retweeted_tweet;
			_tmp72_ = (*_tmp71_).author;
			_tmp73_ = _tmp72_.id;
			_tmp74_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
			_tmp75_ = _tmp74_->id;
			_tmp67_ = _tmp73_ == _tmp75_;
		} else {
			_tmp67_ = FALSE;
		}
		_tmp60_ = _tmp67_;
	}
	if (_tmp60_) {
		_tmp59_ = TRUE;
	} else {
		gboolean _tmp76_ = FALSE;
		gboolean _tmp77_ = FALSE;
		gboolean _tmp78_ = FALSE;
		gboolean _tmp79_ = FALSE;
		_tmp78_ = scroll_widget_get_scrolled_up (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget));
		_tmp79_ = _tmp78_;
		if (_tmp79_) {
			MainWindow* _tmp80_ = NULL;
			gint _tmp81_ = 0;
			gint _tmp82_ = 0;
			gint _tmp83_ = 0;
			gint _tmp84_ = 0;
			_tmp80_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->main_window;
			_tmp81_ = main_window_get_cur_page_id (_tmp80_);
			_tmp82_ = _tmp81_;
			_tmp83_ = ipage_get_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_IPAGE, IPage));
			_tmp84_ = _tmp83_;
			_tmp77_ = _tmp82_ == _tmp84_;
		} else {
			_tmp77_ = FALSE;
		}
		if (_tmp77_) {
			gboolean _tmp85_ = FALSE;
			_tmp85_ = auto_scroll;
			_tmp76_ = _tmp85_;
		} else {
			_tmp76_ = FALSE;
		}
		_tmp59_ = _tmp76_;
	}
	_tmp86_ = t;
	cb_tweet_set_seen (_tmp86_, _tmp59_);
	_tmp88_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
	_tmp89_ = tweet_list_box_get_first_visible_row (_tmp88_);
	_tmp90_ = _tmp89_;
	g_object_get (_tmp90_, "is-focus", &_tmp91_, NULL);
	_tmp92_ = _tmp91_;
	_tmp93_ = _tmp92_;
	_g_object_unref0 (_tmp90_);
	if (_tmp93_) {
		gboolean _tmp94_ = FALSE;
		gboolean _tmp95_ = FALSE;
		_tmp94_ = scroll_widget_get_scrolled_up (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget));
		_tmp95_ = _tmp94_;
		_tmp87_ = _tmp95_;
	} else {
		_tmp87_ = FALSE;
	}
	should_focus = _tmp87_;
	_tmp96_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
	_tmp97_ = _tmp96_->model;
	_tmp98_ = t;
	tweet_model_add (_tmp97_, _tmp98_);
	_tmp99_ = t;
	_tmp100_ = cb_tweet_is_hidden (_tmp99_);
	if (!_tmp100_) {
		gboolean _tmp101_ = FALSE;
		CbTweet* _tmp103_ = NULL;
		gboolean _tmp104_ = FALSE;
		scroll_widget_balance_next_upper_change (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SCROLL_WIDGET, ScrollWidget), TOP);
		_tmp101_ = auto_scroll;
		if (_tmp101_) {
			CbTweet* _tmp102_ = NULL;
			_tmp102_ = t;
			default_timeline_scroll_up (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp102_);
		}
		_tmp103_ = t;
		_tmp104_ = cb_tweet_get_seen (_tmp103_);
		if (!_tmp104_) {
			gint _tmp105_ = 0;
			gint _tmp106_ = 0;
			_tmp105_ = default_timeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline));
			_tmp106_ = _tmp105_;
			default_timeline_set_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline), _tmp106_ + 1);
		}
	} else {
		CbTweet* _tmp107_ = NULL;
		_tmp107_ = t;
		cb_tweet_set_seen (_tmp107_, TRUE);
	}
	_tmp108_ = should_focus;
	if (_tmp108_) {
		TweetListBox* _tmp109_ = NULL;
		GtkWidget* _tmp110_ = NULL;
		GtkWidget* _tmp111_ = NULL;
		_tmp109_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
		_tmp110_ = tweet_list_box_get_first_visible_row (_tmp109_);
		_tmp111_ = _tmp110_;
		gtk_widget_grab_focus (_tmp111_);
		_g_object_unref0 (_tmp111_);
	}
	_tmp112_ = t;
	_tmp113_ = cb_tweet_is_hidden (_tmp112_);
	if (_tmp113_) {
		_g_object_unref0 (t);
		_g_date_time_unref0 (now);
		return;
	}
	_tmp114_ = settings_get_tweet_stack_count ();
	stack_size = _tmp114_;
	_tmp116_ = t;
	_tmp117_ = cb_tweet_get_user_id (_tmp116_);
	_tmp118_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
	_tmp119_ = _tmp118_->id;
	if (_tmp117_ == _tmp119_) {
		_tmp115_ = TRUE;
	} else {
		gboolean _tmp120_ = FALSE;
		_tmp120_ = auto_scroll;
		_tmp115_ = _tmp120_;
	}
	if (_tmp115_) {
		_g_object_unref0 (t);
		_g_date_time_unref0 (now);
		return;
	}
	_tmp122_ = stack_size;
	if (_tmp122_ == 1) {
		gboolean _tmp123_ = FALSE;
		_tmp123_ = auto_scroll;
		_tmp121_ = !_tmp123_;
	} else {
		_tmp121_ = FALSE;
	}
	if (_tmp121_) {
		gchar* summary = NULL;
		gchar* _tmp124_ = NULL;
		CbTweet* _tmp125_ = NULL;
		CbMiniTweet* _tmp126_ = NULL;
		gchar* id_suffix = NULL;
		CbTweet* _tmp143_ = NULL;
		gint64 _tmp144_ = 0LL;
		gchar* _tmp145_ = NULL;
		gchar* _tmp146_ = NULL;
		gchar* _tmp147_ = NULL;
		gchar* _tmp148_ = NULL;
		CbTweet* _tmp149_ = NULL;
		Account* _tmp150_ = NULL;
		NotificationManager* _tmp151_ = NULL;
		const gchar* _tmp152_ = NULL;
		CbTweet* _tmp153_ = NULL;
		gchar* _tmp154_ = NULL;
		gchar* _tmp155_ = NULL;
		const gchar* _tmp156_ = NULL;
		gchar* _tmp157_ = NULL;
		_tmp124_ = g_strdup ("");
		summary = _tmp124_;
		_tmp125_ = t;
		_tmp126_ = _tmp125_->retweeted_tweet;
		if (_tmp126_ != NULL) {
			const gchar* _tmp127_ = NULL;
			CbTweet* _tmp128_ = NULL;
			CbMiniTweet _tmp129_ = {0};
			CbUserIdentity _tmp130_ = {0};
			const gchar* _tmp131_ = NULL;
			CbTweet* _tmp132_ = NULL;
			CbMiniTweet* _tmp133_ = NULL;
			CbUserIdentity _tmp134_ = {0};
			const gchar* _tmp135_ = NULL;
			gchar* _tmp136_ = NULL;
			_tmp127_ = _ ("%s retweeted %s");
			_tmp128_ = t;
			_tmp129_ = _tmp128_->source_tweet;
			_tmp130_ = _tmp129_.author;
			_tmp131_ = _tmp130_.user_name;
			_tmp132_ = t;
			_tmp133_ = _tmp132_->retweeted_tweet;
			_tmp134_ = (*_tmp133_).author;
			_tmp135_ = _tmp134_.user_name;
			_tmp136_ = g_strdup_printf (_tmp127_, _tmp131_, _tmp135_);
			_g_free0 (summary);
			summary = _tmp136_;
		} else {
			const gchar* _tmp137_ = NULL;
			CbTweet* _tmp138_ = NULL;
			CbMiniTweet _tmp139_ = {0};
			CbUserIdentity _tmp140_ = {0};
			const gchar* _tmp141_ = NULL;
			gchar* _tmp142_ = NULL;
			_tmp137_ = _ ("%s tweeted");
			_tmp138_ = t;
			_tmp139_ = _tmp138_->source_tweet;
			_tmp140_ = _tmp139_.author;
			_tmp141_ = _tmp140_.user_name;
			_tmp142_ = g_strdup_printf (_tmp137_, _tmp141_);
			_g_free0 (summary);
			summary = _tmp142_;
		}
		_tmp143_ = t;
		_tmp144_ = _tmp143_->id;
		_tmp145_ = g_strdup_printf ("%" G_GINT64_FORMAT, _tmp144_);
		_tmp146_ = _tmp145_;
		_tmp147_ = g_strdup_printf ("tweet-%s", _tmp146_);
		_tmp148_ = _tmp147_;
		_g_free0 (_tmp146_);
		id_suffix = _tmp148_;
		_tmp149_ = t;
		_tmp150_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
		_tmp151_ = _tmp150_->notifications;
		_tmp152_ = summary;
		_tmp153_ = t;
		_tmp154_ = cb_tweet_get_real_text (_tmp153_);
		_tmp155_ = _tmp154_;
		_tmp156_ = id_suffix;
		_tmp157_ = notification_manager_send (_tmp151_, _tmp152_, _tmp155_, _tmp156_);
		_g_free0 (_tmp149_->notification_id);
		_tmp149_->notification_id = _tmp157_;
		_g_free0 (_tmp155_);
		_g_free0 (id_suffix);
		_g_free0 (summary);
	} else {
		gboolean _tmp158_ = FALSE;
		gboolean _tmp159_ = FALSE;
		gint _tmp160_ = 0;
		_tmp160_ = stack_size;
		if (_tmp160_ != 0) {
			gint _tmp161_ = 0;
			gint _tmp162_ = 0;
			gint _tmp163_ = 0;
			_tmp161_ = default_timeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline));
			_tmp162_ = _tmp161_;
			_tmp163_ = stack_size;
			_tmp159_ = (_tmp162_ % _tmp163_) == 0;
		} else {
			_tmp159_ = FALSE;
		}
		if (_tmp159_) {
			gint _tmp164_ = 0;
			gint _tmp165_ = 0;
			_tmp164_ = default_timeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline));
			_tmp165_ = _tmp164_;
			_tmp158_ = _tmp165_ > 0;
		} else {
			_tmp158_ = FALSE;
		}
		if (_tmp158_) {
			gchar* summary = NULL;
			gint _tmp166_ = 0;
			gint _tmp167_ = 0;
			const gchar* _tmp168_ = NULL;
			gint _tmp169_ = 0;
			gint _tmp170_ = 0;
			gchar* _tmp171_ = NULL;
			Account* _tmp172_ = NULL;
			NotificationManager* _tmp173_ = NULL;
			const gchar* _tmp174_ = NULL;
			gchar* _tmp175_ = NULL;
			gchar* _tmp176_ = NULL;
			_tmp166_ = default_timeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline));
			_tmp167_ = _tmp166_;
			_tmp168_ = ngettext ("%d new Tweet!", "%d new Tweets!", (gulong) _tmp167_);
			_tmp169_ = default_timeline_get_unread_count (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline));
			_tmp170_ = _tmp169_;
			_tmp171_ = g_strdup_printf (_tmp168_, _tmp170_);
			summary = _tmp171_;
			_tmp172_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
			_tmp173_ = _tmp172_->notifications;
			_tmp174_ = summary;
			_tmp175_ = notification_manager_send (_tmp173_, _tmp174_, "", NULL);
			_tmp176_ = _tmp175_;
			_g_free0 (_tmp176_);
			_g_free0 (summary);
		}
	}
	_g_object_unref0 (t);
	_g_date_time_unref0 (now);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void home_timeline_hide_tweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason) {
	TweetModel* tm = NULL;
	TweetListBox* _tmp0_ = NULL;
	TweetModel* _tmp1_ = NULL;
	TweetModel* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	CbTweetState _tmp4_ = 0;
	g_return_if_fail (IS_HOME_TIMELINE (self));
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
	_tmp1_ = _tmp0_->model;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TWEET_MODEL, TweetModel));
	tm = _tmp2_;
	_tmp3_ = user_id;
	_tmp4_ = reason;
	tweet_model_toggle_flag_on_tweet (tm, _tmp3_, _tmp4_, TRUE);
	_g_object_unref0 (tm);
}


void home_timeline_show_tweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason) {
	TweetModel* tm = NULL;
	TweetListBox* _tmp0_ = NULL;
	TweetModel* _tmp1_ = NULL;
	TweetModel* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	CbTweetState _tmp4_ = 0;
	g_return_if_fail (IS_HOME_TIMELINE (self));
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
	_tmp1_ = _tmp0_->model;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TWEET_MODEL, TweetModel));
	tm = _tmp2_;
	_tmp3_ = user_id;
	_tmp4_ = reason;
	tweet_model_toggle_flag_on_tweet (tm, _tmp3_, _tmp4_, FALSE);
	_g_object_unref0 (tm);
}


void home_timeline_hide_retweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason) {
	TweetModel* tm = NULL;
	TweetListBox* _tmp0_ = NULL;
	TweetModel* _tmp1_ = NULL;
	TweetModel* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	CbTweetState _tmp4_ = 0;
	g_return_if_fail (IS_HOME_TIMELINE (self));
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
	_tmp1_ = _tmp0_->model;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TWEET_MODEL, TweetModel));
	tm = _tmp2_;
	_tmp3_ = user_id;
	_tmp4_ = reason;
	tweet_model_toggle_flag_on_retweet (tm, _tmp3_, _tmp4_, TRUE);
	_g_object_unref0 (tm);
}


void home_timeline_show_retweets_from (HomeTimeline* self, gint64 user_id, CbTweetState reason) {
	TweetModel* tm = NULL;
	TweetListBox* _tmp0_ = NULL;
	TweetModel* _tmp1_ = NULL;
	TweetModel* _tmp2_ = NULL;
	gint64 _tmp3_ = 0LL;
	CbTweetState _tmp4_ = 0;
	g_return_if_fail (IS_HOME_TIMELINE (self));
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->tweet_list;
	_tmp1_ = _tmp0_->model;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_TWEET_MODEL, TweetModel));
	tm = _tmp2_;
	_tmp3_ = user_id;
	_tmp4_ = reason;
	tweet_model_toggle_flag_on_retweet (tm, _tmp3_, _tmp4_, FALSE);
	_g_object_unref0 (tm);
}


static gchar* home_timeline_real_get_title (DefaultTimeline* base) {
	HomeTimeline * self;
	gchar* result = NULL;
	Account* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HOME_TIMELINE, HomeTimeline);
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->account;
	_tmp1_ = account_get_screen_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat ("@", _tmp2_, NULL);
	result = _tmp3_;
	return result;
}


static void home_timeline_real_create_radio_button (DefaultTimeline* base, GtkRadioButton* group) {
	HomeTimeline * self;
	GtkRadioButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	BadgeRadioButton* _tmp2_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HOME_TIMELINE, HomeTimeline);
	g_return_if_fail ((group == NULL) || GTK_IS_RADIO_BUTTON (group));
	_tmp0_ = group;
	_tmp1_ = _ ("Home");
	_tmp2_ = badge_radio_button_new (_tmp0_, "user-home-symbolic", _tmp1_);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->radio_button);
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)->radio_button = _tmp2_;
}


static const gchar* home_timeline_real_get_function (DefaultTimeline* base) {
	const gchar* result;
	HomeTimeline* self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_HOME_TIMELINE, HomeTimeline);
	result = "1.1/statuses/home_timeline.json";
	return result;
}


static void home_timeline_class_init (HomeTimelineClass * klass) {
	home_timeline_parent_class = g_type_class_peek_parent (klass);
	((DefaultTimelineClass *) klass)->get_title = (gchar* (*)(DefaultTimeline*)) home_timeline_real_get_title;
	((DefaultTimelineClass *) klass)->create_radio_button = (void (*)(DefaultTimeline*, GtkRadioButton*)) home_timeline_real_create_radio_button;
	DEFAULT_TIMELINE_CLASS (klass)->get_function = home_timeline_real_get_function;
	G_OBJECT_CLASS (klass)->get_property = _vala_home_timeline_get_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), HOME_TIMELINE_FUNCTION, g_param_spec_string ("function", "function", "function", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void home_timeline_imessage_receiver_interface_init (IMessageReceiverIface * iface) {
	home_timeline_imessage_receiver_parent_iface = g_type_interface_peek_parent (iface);
	iface->stream_message_received = (void (*)(IMessageReceiver*, StreamMessageType, JsonNode*)) home_timeline_real_stream_message_received;
}


static void home_timeline_instance_init (HomeTimeline * self) {
}


GType home_timeline_get_type (void) {
	static volatile gsize home_timeline_type_id__volatile = 0;
	if (g_once_init_enter (&home_timeline_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (HomeTimelineClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) home_timeline_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HomeTimeline), 0, (GInstanceInitFunc) home_timeline_instance_init, NULL };
		static const GInterfaceInfo imessage_receiver_info = { (GInterfaceInitFunc) home_timeline_imessage_receiver_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType home_timeline_type_id;
		home_timeline_type_id = g_type_register_static (TYPE_DEFAULT_TIMELINE, "HomeTimeline", &g_define_type_info, 0);
		g_type_add_interface_static (home_timeline_type_id, TYPE_IMESSAGE_RECEIVER, &imessage_receiver_info);
		g_once_init_leave (&home_timeline_type_id__volatile, home_timeline_type_id);
	}
	return home_timeline_type_id__volatile;
}


static void _vala_home_timeline_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	HomeTimeline * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_HOME_TIMELINE, HomeTimeline);
	switch (property_id) {
		case HOME_TIMELINE_FUNCTION:
		g_value_set_string (value, default_timeline_get_function (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DEFAULT_TIMELINE, DefaultTimeline)));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



