/* SurfaceProgress.c generated by valac 0.34.6, the Vala compiler
 * generated from SurfaceProgress.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>


#define TYPE_SURFACE_PROGRESS (surface_progress_get_type ())
#define SURFACE_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SURFACE_PROGRESS, SurfaceProgress))
#define SURFACE_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SURFACE_PROGRESS, SurfaceProgressClass))
#define IS_SURFACE_PROGRESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SURFACE_PROGRESS))
#define IS_SURFACE_PROGRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SURFACE_PROGRESS))
#define SURFACE_PROGRESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SURFACE_PROGRESS, SurfaceProgressClass))

typedef struct _SurfaceProgress SurfaceProgress;
typedef struct _SurfaceProgressClass SurfaceProgressClass;
typedef struct _SurfaceProgressPrivate SurfaceProgressPrivate;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

struct _SurfaceProgress {
	GtkWidget parent_instance;
	SurfaceProgressPrivate * priv;
};

struct _SurfaceProgressClass {
	GtkWidgetClass parent_class;
};

struct _SurfaceProgressPrivate {
	cairo_surface_t* _surface;
	gdouble _progress;
};


static gpointer surface_progress_parent_class = NULL;

GType surface_progress_get_type (void) G_GNUC_CONST;
#define SURFACE_PROGRESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SURFACE_PROGRESS, SurfaceProgressPrivate))
enum  {
	SURFACE_PROGRESS_DUMMY_PROPERTY,
	SURFACE_PROGRESS_SURFACE,
	SURFACE_PROGRESS_PROGRESS
};
static gboolean surface_progress_real_draw (GtkWidget* base, cairo_t* ct);
cairo_surface_t* surface_progress_get_surface (SurfaceProgress* self);
static void surface_progress_real_get_preferred_width (GtkWidget* base, gint* min, gint* nat);
static void surface_progress_real_get_preferred_height (GtkWidget* base, gint* min, gint* nat);
SurfaceProgress* surface_progress_new (void);
SurfaceProgress* surface_progress_construct (GType object_type);
void surface_progress_set_surface (SurfaceProgress* self, cairo_surface_t* value);
gdouble surface_progress_get_progress (SurfaceProgress* self);
void surface_progress_set_progress (SurfaceProgress* self, gdouble value);
static GObject * surface_progress_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void surface_progress_finalize (GObject* obj);
static void _vala_surface_progress_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_surface_progress_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gboolean surface_progress_real_draw (GtkWidget* base, cairo_t* ct) {
	SurfaceProgress * self;
	gboolean result = FALSE;
	cairo_surface_t* _tmp0_ = NULL;
	cairo_surface_t* _tmp1_ = NULL;
	gint width = 0;
	gint _tmp2_ = 0;
	gint height = 0;
	gint _tmp3_ = 0;
	cairo_surface_t* tmp_surface = NULL;
	cairo_t* _tmp4_ = NULL;
	cairo_surface_t* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	cairo_surface_t* _tmp8_ = NULL;
	cairo_t* ctx = NULL;
	cairo_surface_t* _tmp9_ = NULL;
	cairo_t* _tmp10_ = NULL;
	cairo_t* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	cairo_t* _tmp14_ = NULL;
	cairo_surface_t* _tmp15_ = NULL;
	cairo_t* _tmp16_ = NULL;
	cairo_t* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	cairo_t* _tmp20_ = NULL;
	cairo_surface_t* _tmp21_ = NULL;
	cairo_t* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	gint arc_size = 0;
	gint _tmp28_ = 0;
	gdouble cx = 0.0;
	gint _tmp29_ = 0;
	gdouble cy = 0.0;
	gint _tmp30_ = 0;
	gdouble radius = 0.0;
	gint _tmp31_ = 0;
	cairo_t* _tmp32_ = NULL;
	cairo_t* _tmp33_ = NULL;
	cairo_t* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	cairo_t* _tmp37_ = NULL;
	gdouble _tmp38_ = 0.0;
	gdouble _tmp39_ = 0.0;
	gdouble _tmp40_ = 0.0;
	cairo_t* _tmp41_ = NULL;
	gdouble _tmp42_ = 0.0;
	gdouble _tmp43_ = 0.0;
	gdouble _tmp44_ = 0.0;
	gdouble _tmp45_ = 0.0;
	cairo_t* _tmp46_ = NULL;
	gdouble _tmp47_ = 0.0;
	gdouble _tmp48_ = 0.0;
	cairo_t* _tmp49_ = NULL;
	cairo_t* _tmp50_ = NULL;
	gint _tmp51_ = 0;
	gint _tmp52_ = 0;
	cairo_t* _tmp53_ = NULL;
	cairo_surface_t* _tmp54_ = NULL;
	cairo_t* _tmp55_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SURFACE_PROGRESS, SurfaceProgress);
	g_return_val_if_fail (ct != NULL, FALSE);
	_tmp0_ = surface_progress_get_surface (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = GDK_EVENT_PROPAGATE;
		return result;
	}
	_tmp2_ = gtk_widget_get_allocated_width (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	width = _tmp2_;
	_tmp3_ = gtk_widget_get_allocated_height (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	height = _tmp3_;
	_tmp4_ = ct;
	_tmp5_ = cairo_get_target (_tmp4_);
	_tmp6_ = width;
	_tmp7_ = height;
	_tmp8_ = cairo_surface_create_similar (_tmp5_, CAIRO_CONTENT_COLOR_ALPHA, _tmp6_, _tmp7_);
	tmp_surface = _tmp8_;
	_tmp9_ = tmp_surface;
	_tmp10_ = cairo_create (_tmp9_);
	ctx = _tmp10_;
	_tmp11_ = ct;
	_tmp12_ = width;
	_tmp13_ = height;
	cairo_rectangle (_tmp11_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp12_, (gdouble) _tmp13_);
	_tmp14_ = ct;
	_tmp15_ = self->priv->_surface;
	cairo_set_source_surface (_tmp14_, _tmp15_, (gdouble) 0, (gdouble) 0);
	_tmp16_ = ct;
	cairo_paint_with_alpha (_tmp16_, 0.5);
	_tmp17_ = ctx;
	_tmp18_ = width;
	_tmp19_ = height;
	cairo_rectangle (_tmp17_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp18_, (gdouble) _tmp19_);
	_tmp20_ = ctx;
	_tmp21_ = self->priv->_surface;
	cairo_set_source_surface (_tmp20_, _tmp21_, (gdouble) 0, (gdouble) 0);
	_tmp22_ = ctx;
	cairo_fill (_tmp22_);
	_tmp24_ = width;
	_tmp25_ = height;
	if (_tmp24_ > _tmp25_) {
		gint _tmp26_ = 0;
		_tmp26_ = width;
		_tmp23_ = _tmp26_;
	} else {
		gint _tmp27_ = 0;
		_tmp27_ = height;
		_tmp23_ = _tmp27_;
	}
	arc_size = _tmp23_;
	_tmp28_ = arc_size;
	arc_size = _tmp28_ * 2;
	_tmp29_ = width;
	cx = _tmp29_ / 2.0;
	_tmp30_ = height;
	cy = _tmp30_ / 2.0;
	_tmp31_ = arc_size;
	radius = (_tmp31_ / 2.0) - 0.5;
	_tmp32_ = ctx;
	cairo_set_operator (_tmp32_, CAIRO_OPERATOR_DEST_IN);
	_tmp33_ = ctx;
	cairo_set_source_rgba (_tmp33_, 1.0, 0.0, 0.0, 1.0);
	_tmp34_ = ctx;
	_tmp35_ = width;
	_tmp36_ = height;
	cairo_move_to (_tmp34_, _tmp35_ / 2.0, _tmp36_ / 2.0);
	_tmp37_ = ctx;
	_tmp38_ = cx;
	_tmp39_ = cy;
	_tmp40_ = radius;
	cairo_arc (_tmp37_, _tmp38_, _tmp39_, _tmp40_, (gdouble) 0, (gdouble) 0);
	_tmp41_ = ctx;
	_tmp42_ = cx;
	_tmp43_ = cy;
	_tmp44_ = radius;
	_tmp45_ = self->priv->_progress;
	cairo_arc (_tmp41_, _tmp42_, _tmp43_, _tmp44_, (gdouble) 0, (2 * G_PI) * _tmp45_);
	_tmp46_ = ctx;
	_tmp47_ = cx;
	_tmp48_ = cy;
	cairo_move_to (_tmp46_, _tmp47_, _tmp48_);
	_tmp49_ = ctx;
	cairo_fill (_tmp49_);
	_tmp50_ = ct;
	_tmp51_ = width;
	_tmp52_ = height;
	cairo_rectangle (_tmp50_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp51_, (gdouble) _tmp52_);
	_tmp53_ = ct;
	_tmp54_ = tmp_surface;
	cairo_set_source_surface (_tmp53_, _tmp54_, (gdouble) 0, (gdouble) 0);
	_tmp55_ = ct;
	cairo_fill (_tmp55_);
	result = GDK_EVENT_PROPAGATE;
	_cairo_destroy0 (ctx);
	_cairo_surface_destroy0 (tmp_surface);
	return result;
}


static void surface_progress_real_get_preferred_width (GtkWidget* base, gint* min, gint* nat) {
	SurfaceProgress * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	cairo_surface_t* _tmp0_ = NULL;
	cairo_surface_t* _tmp1_ = NULL;
	cairo_surface_t* _tmp2_ = NULL;
	cairo_surface_t* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SURFACE_PROGRESS, SurfaceProgress);
	_tmp0_ = surface_progress_get_surface (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		_vala_min = 0;
		_vala_nat = 0;
		if (min) {
			*min = _vala_min;
		}
		if (nat) {
			*nat = _vala_nat;
		}
		return;
	}
	_tmp2_ = surface_progress_get_surface (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = cairo_image_surface_get_width (_tmp3_);
	_vala_nat = _tmp4_;
	_tmp5_ = _vala_nat;
	_vala_min = _tmp5_;
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}


static void surface_progress_real_get_preferred_height (GtkWidget* base, gint* min, gint* nat) {
	SurfaceProgress * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	cairo_surface_t* _tmp0_ = NULL;
	cairo_surface_t* _tmp1_ = NULL;
	cairo_surface_t* _tmp2_ = NULL;
	cairo_surface_t* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_SURFACE_PROGRESS, SurfaceProgress);
	_tmp0_ = surface_progress_get_surface (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		_vala_min = 0;
		_vala_nat = 0;
		if (min) {
			*min = _vala_min;
		}
		if (nat) {
			*nat = _vala_nat;
		}
		return;
	}
	_tmp2_ = surface_progress_get_surface (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = cairo_image_surface_get_height (_tmp3_);
	_vala_nat = _tmp4_;
	_tmp5_ = _vala_nat;
	_vala_min = _tmp5_;
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}


SurfaceProgress* surface_progress_construct (GType object_type) {
	SurfaceProgress * self = NULL;
	self = (SurfaceProgress*) gtk_widget_new (object_type, NULL);
	return self;
}


SurfaceProgress* surface_progress_new (void) {
	return surface_progress_construct (TYPE_SURFACE_PROGRESS);
}


cairo_surface_t* surface_progress_get_surface (SurfaceProgress* self) {
	cairo_surface_t* result;
	cairo_surface_t* _tmp0_ = NULL;
	g_return_val_if_fail (IS_SURFACE_PROGRESS (self), NULL);
	_tmp0_ = self->priv->_surface;
	result = _tmp0_;
	return result;
}


static gpointer _cairo_surface_reference0 (gpointer self) {
	return self ? cairo_surface_reference (self) : NULL;
}


void surface_progress_set_surface (SurfaceProgress* self, cairo_surface_t* value) {
	cairo_surface_t* _tmp0_ = NULL;
	cairo_surface_t* _tmp1_ = NULL;
	g_return_if_fail (IS_SURFACE_PROGRESS (self));
	_tmp0_ = value;
	_tmp1_ = _cairo_surface_reference0 (_tmp0_);
	_cairo_surface_destroy0 (self->priv->_surface);
	self->priv->_surface = _tmp1_;
	gtk_widget_queue_resize (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	g_object_notify ((GObject *) self, "surface");
}


gdouble surface_progress_get_progress (SurfaceProgress* self) {
	gdouble result;
	gdouble _tmp0_ = 0.0;
	g_return_val_if_fail (IS_SURFACE_PROGRESS (self), 0.0);
	_tmp0_ = self->priv->_progress;
	result = _tmp0_;
	return result;
}


void surface_progress_set_progress (SurfaceProgress* self, gdouble value) {
	gdouble _tmp0_ = 0.0;
	g_return_if_fail (IS_SURFACE_PROGRESS (self));
	_tmp0_ = value;
	if (_tmp0_ > 1.0) {
		self->priv->_progress = 1.0;
	} else {
		gdouble _tmp1_ = 0.0;
		_tmp1_ = value;
		if (_tmp1_ < 0.0) {
			self->priv->_progress = 0.0;
		} else {
			gdouble _tmp2_ = 0.0;
			_tmp2_ = value;
			self->priv->_progress = _tmp2_;
		}
	}
	gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	g_object_notify ((GObject *) self, "progress");
}


static GObject * surface_progress_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	SurfaceProgress * self;
	parent_class = G_OBJECT_CLASS (surface_progress_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SURFACE_PROGRESS, SurfaceProgress);
	gtk_widget_set_has_window (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget), FALSE);
	return obj;
}


static void surface_progress_class_init (SurfaceProgressClass * klass) {
	surface_progress_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SurfaceProgressPrivate));
	((GtkWidgetClass *) klass)->draw = (gboolean (*)(GtkWidget*, cairo_t*)) surface_progress_real_draw;
	((GtkWidgetClass *) klass)->get_preferred_width = (void (*)(GtkWidget*, gint*, gint*)) surface_progress_real_get_preferred_width;
	((GtkWidgetClass *) klass)->get_preferred_height = (void (*)(GtkWidget*, gint*, gint*)) surface_progress_real_get_preferred_height;
	G_OBJECT_CLASS (klass)->get_property = _vala_surface_progress_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_surface_progress_set_property;
	G_OBJECT_CLASS (klass)->constructor = surface_progress_constructor;
	G_OBJECT_CLASS (klass)->finalize = surface_progress_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SURFACE_PROGRESS_SURFACE, g_param_spec_pointer ("surface", "surface", "surface", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SURFACE_PROGRESS_PROGRESS, g_param_spec_double ("progress", "progress", "progress", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void surface_progress_instance_init (SurfaceProgress * self) {
	self->priv = SURFACE_PROGRESS_GET_PRIVATE (self);
	self->priv->_surface = NULL;
	self->priv->_progress = 0.0;
}


static void surface_progress_finalize (GObject* obj) {
	SurfaceProgress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SURFACE_PROGRESS, SurfaceProgress);
	_cairo_surface_destroy0 (self->priv->_surface);
	G_OBJECT_CLASS (surface_progress_parent_class)->finalize (obj);
}


GType surface_progress_get_type (void) {
	static volatile gsize surface_progress_type_id__volatile = 0;
	if (g_once_init_enter (&surface_progress_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SurfaceProgressClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) surface_progress_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SurfaceProgress), 0, (GInstanceInitFunc) surface_progress_instance_init, NULL };
		GType surface_progress_type_id;
		surface_progress_type_id = g_type_register_static (gtk_widget_get_type (), "SurfaceProgress", &g_define_type_info, 0);
		g_once_init_leave (&surface_progress_type_id__volatile, surface_progress_type_id);
	}
	return surface_progress_type_id__volatile;
}


static void _vala_surface_progress_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SurfaceProgress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SURFACE_PROGRESS, SurfaceProgress);
	switch (property_id) {
		case SURFACE_PROGRESS_SURFACE:
		g_value_set_pointer (value, surface_progress_get_surface (self));
		break;
		case SURFACE_PROGRESS_PROGRESS:
		g_value_set_double (value, surface_progress_get_progress (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_surface_progress_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SurfaceProgress * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SURFACE_PROGRESS, SurfaceProgress);
	switch (property_id) {
		case SURFACE_PROGRESS_SURFACE:
		surface_progress_set_surface (self, g_value_get_pointer (value));
		break;
		case SURFACE_PROGRESS_PROGRESS:
		surface_progress_set_progress (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



