/* ComposeTweetWindow.c generated by valac 0.34.6, the Vala compiler
 * generated from ComposeTweetWindow.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "CbTweet.h"
#include <gio/gio.h>
#include <cairo.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <rest/oauth-proxy.h>
#include "CbUserCounter.h"
#include "CbFilter.h"
#include <gdk-pixbuf/gdk-pixbuf.h>


#define TYPE_COMPOSE_TWEET_WINDOW (compose_tweet_window_get_type ())
#define COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow))
#define COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))
#define IS_COMPOSE_TWEET_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_TWEET_WINDOW))
#define IS_COMPOSE_TWEET_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_TWEET_WINDOW))
#define COMPOSE_TWEET_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowClass))

typedef struct _ComposeTweetWindow ComposeTweetWindow;
typedef struct _ComposeTweetWindowClass ComposeTweetWindowClass;
typedef struct _ComposeTweetWindowPrivate ComposeTweetWindowPrivate;

#define TYPE_AVATAR_WIDGET (avatar_widget_get_type ())
#define AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_WIDGET, AvatarWidget))
#define AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_WIDGET, AvatarWidgetClass))
#define IS_AVATAR_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_WIDGET))
#define IS_AVATAR_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_WIDGET))
#define AVATAR_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_WIDGET, AvatarWidgetClass))

typedef struct _AvatarWidget AvatarWidget;
typedef struct _AvatarWidgetClass AvatarWidgetClass;

#define TYPE_COMPLETION_TEXT_VIEW (completion_text_view_get_type ())
#define COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextView))
#define COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))
#define IS_COMPLETION_TEXT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_TEXT_VIEW))
#define IS_COMPLETION_TEXT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_TEXT_VIEW))
#define COMPLETION_TEXT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_TEXT_VIEW, CompletionTextViewClass))

typedef struct _CompletionTextView CompletionTextView;
typedef struct _CompletionTextViewClass CompletionTextViewClass;

#define TYPE_COMPOSE_IMAGE_MANAGER (compose_image_manager_get_type ())
#define COMPOSE_IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManager))
#define COMPOSE_IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManagerClass))
#define IS_COMPOSE_IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_IMAGE_MANAGER))
#define IS_COMPOSE_IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_IMAGE_MANAGER))
#define COMPOSE_IMAGE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_IMAGE_MANAGER, ComposeImageManagerClass))

typedef struct _ComposeImageManager ComposeImageManager;
typedef struct _ComposeImageManagerClass ComposeImageManagerClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;

#define COMPOSE_TWEET_WINDOW_TYPE_MODE (compose_tweet_window_mode_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_TWEET_LIST_ENTRY (tweet_list_entry_get_type ())
#define TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntry))
#define TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))
#define IS_TWEET_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TWEET_LIST_ENTRY))
#define IS_TWEET_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TWEET_LIST_ENTRY))
#define TWEET_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TWEET_LIST_ENTRY, TweetListEntryClass))

typedef struct _TweetListEntry TweetListEntry;
typedef struct _TweetListEntryClass TweetListEntryClass;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_USER_STREAM (user_stream_get_type ())
#define USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_STREAM, UserStream))
#define USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_STREAM, UserStreamClass))
#define IS_USER_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_STREAM))
#define IS_USER_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_STREAM))
#define USER_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_STREAM, UserStreamClass))

typedef struct _UserStream UserStream;
typedef struct _UserStreamClass UserStreamClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;

#define SQL_TYPE_SELECT_STATEMENT (sql_select_statement_get_type ())
#define SQL_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement))
#define SQL_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))
#define SQL_IS_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_SELECT_STATEMENT))
#define SQL_IS_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_SELECT_STATEMENT))
#define SQL_SELECT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))

typedef struct _SqlSelectStatement SqlSelectStatement;
typedef struct _SqlSelectStatementClass SqlSelectStatementClass;

#define TYPE_COMPOSE_JOB (compose_job_get_type ())
#define COMPOSE_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPOSE_JOB, ComposeJob))
#define COMPOSE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPOSE_JOB, ComposeJobClass))
#define IS_COMPOSE_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPOSE_JOB))
#define IS_COMPOSE_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPOSE_JOB))
#define COMPOSE_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPOSE_JOB, ComposeJobClass))

typedef struct _ComposeJob ComposeJob;
typedef struct _ComposeJobClass ComposeJobClass;
typedef struct _Block68Data Block68Data;
typedef struct _ComposeJobPrivate ComposeJobPrivate;

#define SQL_TYPE_UPDATE_STATEMENT (sql_update_statement_get_type ())
#define SQL_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatement))
#define SQL_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))
#define SQL_IS_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_IS_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_UPDATE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))

typedef struct _SqlUpdateStatement SqlUpdateStatement;
typedef struct _SqlUpdateStatementClass SqlUpdateStatementClass;
typedef struct _Block69Data Block69Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ComposeTweetWindow {
	GtkApplicationWindow parent_instance;
	ComposeTweetWindowPrivate * priv;
};

struct _ComposeTweetWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	COMPOSE_TWEET_WINDOW_MODE_NORMAL,
	COMPOSE_TWEET_WINDOW_MODE_REPLY,
	COMPOSE_TWEET_WINDOW_MODE_QUOTE
} ComposeTweetWindowMode;

struct _ComposeTweetWindowPrivate {
	AvatarWidget* avatar_image;
	GtkGrid* content_grid;
	CompletionTextView* tweet_text;
	GtkLabel* length_label;
	GtkButton* send_button;
	GtkSpinner* title_spinner;
	GtkLabel* title_label;
	GtkStack* title_stack;
	ComposeImageManager* compose_image_manager;
	GtkButton* add_image_button;
	GtkStack* stack;
	GtkGrid* image_error_grid;
	GtkLabel* image_error_label;
	GtkButton* cancel_button;
	Account* account;
	CbTweet* reply_to;
	ComposeTweetWindowMode mode;
	GCancellable* cancellable;
	GtkListBox* reply_list;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	OAuthProxy* proxy;
	UserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _Block68Data {
	int _ref_count_;
	ComposeTweetWindow* self;
	ComposeJob* job;
};

struct _ComposeJob {
	GObject parent_instance;
	ComposeJobPrivate * priv;
	gchar* text;
	CbTweet* quoted_tweet;
	gint64* reply_id;
};

struct _ComposeJobClass {
	GObjectClass parent_class;
};

struct _Block69Data {
	int _ref_count_;
	ComposeTweetWindow* self;
	GtkFileChooserDialog* filechooser;
};


static gpointer compose_tweet_window_parent_class = NULL;

GType compose_tweet_window_get_type (void) G_GNUC_CONST;
GType avatar_widget_get_type (void) G_GNUC_CONST;
GType completion_text_view_get_type (void) G_GNUC_CONST;
GType compose_image_manager_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
GType compose_tweet_window_mode_get_type (void) G_GNUC_CONST;
#define COMPOSE_TWEET_WINDOW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindowPrivate))
enum  {
	COMPOSE_TWEET_WINDOW_DUMMY_PROPERTY
};
#define COMPOSE_TWEET_WINDOW_DEFAULT_WIDTH 450
GType main_window_get_type (void) G_GNUC_CONST;
ComposeTweetWindow* compose_tweet_window_new (MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
ComposeTweetWindow* compose_tweet_window_construct (GType object_type, MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode);
void completion_text_view_set_account (CompletionTextView* self, Account* account);
cairo_surface_t* account_get_avatar (Account* self);
void avatar_widget_set_surface (AvatarWidget* self, cairo_surface_t* value);
static void __lambda43_ (ComposeTweetWindow* self);
static void ___lambda43__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void compose_tweet_window_recalc_tweet_length (ComposeTweetWindow* self);
static void _compose_tweet_window_recalc_tweet_length_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
GType tweet_list_entry_get_type (void) G_GNUC_CONST;
TweetListEntry* tweet_list_entry_new (CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height);
TweetListEntry* tweet_list_entry_construct (GType object_type, CbTweet* tweet, MainWindow* main_window, Account* account, gboolean restrict_height);
void tweet_list_entry_set_read_only (TweetListEntry* self, gboolean value);
const gchar* account_get_screen_name (Account* self);
static gboolean compose_tweet_window_escape_pressed_cb (ComposeTweetWindow* self);
static gboolean _compose_tweet_window_escape_pressed_cb_gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self);
static gboolean __lambda44_ (ComposeTweetWindow* self);
static void compose_tweet_window_start_send_tweet (ComposeTweetWindow* self);
static gboolean ___lambda44__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self);
static void __lambda53_ (ComposeTweetWindow* self);
gint compose_image_manager_get_n_images (ComposeImageManager* self);
#define TWITTER_max_media_per_upload 4
static void ___lambda53__compose_image_manager_image_removed (ComposeImageManager* _sender, gpointer self);
GType sql_database_get_type (void) G_GNUC_CONST;
GType user_stream_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
GType sql_select_statement_get_type (void) G_GNUC_CONST;
SqlSelectStatement* sql_database_select (SqlDatabase* self, const gchar* table_name);
SqlSelectStatement* sql_select_statement_cols (SqlSelectStatement* self, const gchar* first, ...);
gchar* sql_select_statement_once_string (SqlSelectStatement* self);
gint tweet_utils_calc_tweet_length (const gchar* text, gint media_count);
GType compose_job_get_type (void) G_GNUC_CONST;
static Block68Data* block68_data_ref (Block68Data* _data68_);
static void block68_data_unref (void * _userdata_);
ComposeJob* compose_job_new (Account* account);
ComposeJob* compose_job_construct (GType object_type, Account* account);
static gint64* _int64_dup (gint64* self);
gchar** compose_image_manager_get_image_paths (ComposeImageManager* self, int* result_length1);
void compose_job_add_image (ComposeJob* self, const gchar* path);
static void __lambda50_ (ComposeTweetWindow* self, const gchar* path);
void compose_image_manager_start_progress (ComposeImageManager* self, const gchar* image_path);
static void ___lambda50__compose_job_image_upload_started (ComposeJob* _sender, const gchar* path, gpointer self);
static void __lambda51_ (ComposeTweetWindow* self, const gchar* path, const gchar* error_msg);
void compose_image_manager_end_progress (ComposeImageManager* self, const gchar* image_path, const gchar* error_message);
static void ___lambda51__compose_job_image_upload_finished (ComposeJob* _sender, const gchar* path, const gchar* error_message, gpointer self);
void compose_job_start (ComposeJob* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean compose_job_start_finish (ComposeJob* self, GAsyncResult* _res_);
static void __lambda52_ (Block68Data* _data68_, GObject* obj, GAsyncResult* res);
GType sql_update_statement_get_type (void) G_GNUC_CONST;
SqlUpdateStatement* sql_database_update (SqlDatabase* self, const gchar* table_name);
SqlUpdateStatement* sql_update_statement_val (SqlUpdateStatement* self, const gchar* col_name, const gchar* col_value);
gint64 sql_update_statement_run (SqlUpdateStatement* self);
static void compose_tweet_window_save_last_tweet (ComposeTweetWindow* self);
static void ___lambda52__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _compose_tweet_window_start_send_tweet_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void compose_tweet_window_cancel_clicked (ComposeTweetWindow* self, GtkWidget* source);
static void _compose_tweet_window_cancel_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
void compose_tweet_window_set_text (ComposeTweetWindow* self, const gchar* text);
static void compose_tweet_window_add_image_clicked_cb (ComposeTweetWindow* self, GtkButton* source);
static Block69Data* block69_data_ref (Block69Data* _data69_);
static void block69_data_unref (void * _userdata_);
static void __lambda54_ (Block69Data* _data69_, gint id);
#define TWITTER_MAX_BYTES_PER_IMAGE ((1024 * 1024) * 3)
void compose_image_manager_load_image (ComposeImageManager* self, const gchar* path, GdkPixbuf* image);
static void ___lambda54__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void _compose_tweet_window_add_image_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void compose_tweet_window_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GType compose_tweet_window_mode_get_type (void) {
	static volatile gsize compose_tweet_window_mode_type_id__volatile = 0;
	if (g_once_init_enter (&compose_tweet_window_mode_type_id__volatile)) {
		static const GEnumValue values[] = {{COMPOSE_TWEET_WINDOW_MODE_NORMAL, "COMPOSE_TWEET_WINDOW_MODE_NORMAL", "normal"}, {COMPOSE_TWEET_WINDOW_MODE_REPLY, "COMPOSE_TWEET_WINDOW_MODE_REPLY", "reply"}, {COMPOSE_TWEET_WINDOW_MODE_QUOTE, "COMPOSE_TWEET_WINDOW_MODE_QUOTE", "quote"}, {0, NULL, NULL}};
		GType compose_tweet_window_mode_type_id;
		compose_tweet_window_mode_type_id = g_enum_register_static ("ComposeTweetWindowMode", values);
		g_once_init_leave (&compose_tweet_window_mode_type_id__volatile, compose_tweet_window_mode_type_id);
	}
	return compose_tweet_window_mode_type_id__volatile;
}


static void __lambda43_ (ComposeTweetWindow* self) {
	AvatarWidget* _tmp0_ = NULL;
	Account* _tmp1_ = NULL;
	cairo_surface_t* _tmp2_ = NULL;
	cairo_surface_t* _tmp3_ = NULL;
	_tmp0_ = self->priv->avatar_image;
	_tmp1_ = self->priv->account;
	_tmp2_ = account_get_avatar (_tmp1_);
	_tmp3_ = _tmp2_;
	avatar_widget_set_surface (_tmp0_, _tmp3_);
}


static void ___lambda43__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda43_ ((ComposeTweetWindow*) self);
}


static void _compose_tweet_window_recalc_tweet_length_gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	compose_tweet_window_recalc_tweet_length ((ComposeTweetWindow*) self);
}


static gboolean _compose_tweet_window_escape_pressed_cb_gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self) {
	gboolean result;
	result = compose_tweet_window_escape_pressed_cb ((ComposeTweetWindow*) self);
	return result;
}


static gboolean __lambda44_ (ComposeTweetWindow* self) {
	gboolean result = FALSE;
	compose_tweet_window_start_send_tweet (self);
	result = TRUE;
	return result;
}


static gboolean ___lambda44__gtk_accel_group_activate (GtkAccelGroup* accel_group, GObject* acceleratable, guint keyval, GdkModifierType modifier, gpointer self) {
	gboolean result;
	result = __lambda44_ ((ComposeTweetWindow*) self);
	return result;
}


static void __lambda53_ (ComposeTweetWindow* self) {
	ComposeImageManager* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	ComposeImageManager* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	_tmp0_ = self->priv->compose_image_manager;
	_tmp1_ = compose_image_manager_get_n_images (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ < TWITTER_max_media_per_upload) {
		GtkButton* _tmp3_ = NULL;
		_tmp3_ = self->priv->add_image_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), TRUE);
	}
	_tmp4_ = self->priv->compose_image_manager;
	_tmp5_ = compose_image_manager_get_n_images (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == 0) {
		ComposeImageManager* _tmp7_ = NULL;
		_tmp7_ = self->priv->compose_image_manager;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
	}
}


static void ___lambda53__compose_image_manager_image_removed (ComposeImageManager* _sender, gpointer self) {
	__lambda53_ ((ComposeTweetWindow*) self);
}


ComposeTweetWindow* compose_tweet_window_construct (GType object_type, MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode) {
	ComposeTweetWindow * self = NULL;
	Account* _tmp0_ = NULL;
	CbTweet* _tmp1_ = NULL;
	ComposeTweetWindowMode _tmp2_ = 0;
	CompletionTextView* _tmp3_ = NULL;
	Account* _tmp4_ = NULL;
	GApplication* _tmp5_ = NULL;
	AvatarWidget* _tmp6_ = NULL;
	Account* _tmp7_ = NULL;
	cairo_surface_t* _tmp8_ = NULL;
	cairo_surface_t* _tmp9_ = NULL;
	Account* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	CompletionTextView* _tmp15_ = NULL;
	GtkTextBuffer* _tmp16_ = NULL;
	GtkTextBuffer* _tmp17_ = NULL;
	MainWindow* _tmp18_ = NULL;
	ComposeTweetWindowMode _tmp20_ = 0;
	ComposeTweetWindowMode _tmp35_ = 0;
	CompletionTextView* _tmp99_ = NULL;
	GtkAccelGroup* ag = NULL;
	GtkAccelGroup* _tmp100_ = NULL;
	GtkAccelGroup* _tmp101_ = NULL;
	GtkAccelGroup* _tmp102_ = NULL;
	ComposeImageManager* _tmp103_ = NULL;
	GtkAccelGroup* _tmp104_ = NULL;
	gchar* last_tweet = NULL;
	Account* _tmp105_ = NULL;
	SqlDatabase* _tmp106_ = NULL;
	SqlSelectStatement* _tmp107_ = NULL;
	SqlSelectStatement* _tmp108_ = NULL;
	SqlSelectStatement* _tmp109_ = NULL;
	SqlSelectStatement* _tmp110_ = NULL;
	gchar* _tmp111_ = NULL;
	gchar* _tmp112_ = NULL;
	gboolean _tmp113_ = FALSE;
	gboolean _tmp114_ = FALSE;
	const gchar* _tmp115_ = NULL;
	g_return_val_if_fail ((parent == NULL) || IS_MAIN_WINDOW (parent), NULL);
	g_return_val_if_fail (IS_ACCOUNT (acc), NULL);
	g_return_val_if_fail ((reply_to == NULL) || CB_IS_TWEET (reply_to), NULL);
	self = (ComposeTweetWindow*) g_object_new (object_type, NULL);
	gtk_application_window_set_show_menubar (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), FALSE);
	_tmp0_ = acc;
	self->priv->account = _tmp0_;
	_tmp1_ = reply_to;
	self->priv->reply_to = _tmp1_;
	_tmp2_ = mode;
	self->priv->mode = _tmp2_;
	_tmp3_ = self->priv->tweet_text;
	_tmp4_ = acc;
	completion_text_view_set_account (_tmp3_, _tmp4_);
	_tmp5_ = g_application_get_default ();
	gtk_window_set_application (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_application_get_type (), GtkApplication));
	_tmp6_ = self->priv->avatar_image;
	_tmp7_ = acc;
	_tmp8_ = account_get_avatar (_tmp7_);
	_tmp9_ = _tmp8_;
	avatar_widget_set_surface (_tmp6_, _tmp9_);
	_tmp10_ = acc;
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, G_TYPE_OBJECT, GObject), "notify::avatar", (GCallback) ___lambda43__g_object_notify, self, 0);
	_tmp11_ = self->priv->length_label;
	_tmp12_ = CB_TWEET_MAX_LENGTH;
	_tmp13_ = g_strdup_printf ("%i", _tmp12_);
	_tmp14_ = _tmp13_;
	gtk_label_set_label (_tmp11_, _tmp14_);
	_g_free0 (_tmp14_);
	_tmp15_ = self->priv->tweet_text;
	_tmp16_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_text_view_get_type (), GtkTextView));
	_tmp17_ = _tmp16_;
	g_signal_connect_object (_tmp17_, "changed", (GCallback) _compose_tweet_window_recalc_tweet_length_gtk_text_buffer_changed, self, 0);
	_tmp18_ = parent;
	if (_tmp18_ != NULL) {
		MainWindow* _tmp19_ = NULL;
		_tmp19_ = parent;
		gtk_window_set_transient_for (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_window_get_type (), GtkWindow));
		gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), TRUE);
	}
	_tmp20_ = mode;
	if (_tmp20_ != COMPOSE_TWEET_WINDOW_MODE_NORMAL) {
		GtkListBox* _tmp21_ = NULL;
		GtkListBox* _tmp22_ = NULL;
		TweetListEntry* reply_entry = NULL;
		CbTweet* _tmp23_ = NULL;
		MainWindow* _tmp24_ = NULL;
		Account* _tmp25_ = NULL;
		TweetListEntry* _tmp26_ = NULL;
		TweetListEntry* _tmp27_ = NULL;
		TweetListEntry* _tmp28_ = NULL;
		TweetListEntry* _tmp29_ = NULL;
		GtkListBox* _tmp30_ = NULL;
		TweetListEntry* _tmp31_ = NULL;
		GtkListBox* _tmp32_ = NULL;
		GtkGrid* _tmp33_ = NULL;
		GtkListBox* _tmp34_ = NULL;
		_tmp21_ = (GtkListBox*) gtk_list_box_new ();
		g_object_ref_sink (_tmp21_);
		_g_object_unref0 (self->priv->reply_list);
		self->priv->reply_list = _tmp21_;
		_tmp22_ = self->priv->reply_list;
		gtk_list_box_set_selection_mode (_tmp22_, GTK_SELECTION_NONE);
		_tmp23_ = reply_to;
		_tmp24_ = parent;
		_tmp25_ = acc;
		_tmp26_ = tweet_list_entry_new (_tmp23_, _tmp24_, _tmp25_, TRUE);
		g_object_ref_sink (_tmp26_);
		reply_entry = _tmp26_;
		_tmp27_ = reply_entry;
		gtk_list_box_row_set_activatable (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_list_box_row_get_type (), GtkListBoxRow), FALSE);
		_tmp28_ = reply_entry;
		tweet_list_entry_set_read_only (_tmp28_, TRUE);
		_tmp29_ = reply_entry;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_widget_get_type (), GtkWidget));
		_tmp30_ = self->priv->reply_list;
		_tmp31_ = reply_entry;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_widget_get_type (), GtkWidget));
		_tmp32_ = self->priv->reply_list;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, gtk_widget_get_type (), GtkWidget));
		_tmp33_ = self->priv->content_grid;
		_tmp34_ = self->priv->reply_list;
		gtk_grid_attach (_tmp33_, G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_widget_get_type (), GtkWidget), 0, 0, 2, 1);
		_g_object_unref0 (reply_entry);
	}
	_tmp35_ = mode;
	if (_tmp35_ == COMPOSE_TWEET_WINDOW_MODE_REPLY) {
		GString* mention_builder = NULL;
		GString* _tmp36_ = NULL;
		CbTweet* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		Account* _tmp39_ = NULL;
		const gchar* _tmp40_ = NULL;
		const gchar* _tmp41_ = NULL;
		CbTweet* _tmp46_ = NULL;
		CbMiniTweet* _tmp47_ = NULL;
		CbTweet* _tmp57_ = NULL;
		gint _tmp58_ = 0;
		gchar** _tmp59_ = NULL;
		GString* _tmp87_ = NULL;
		gssize _tmp88_ = 0L;
		CompletionTextView* _tmp90_ = NULL;
		GtkTextBuffer* _tmp91_ = NULL;
		GtkTextBuffer* _tmp92_ = NULL;
		GString* _tmp93_ = NULL;
		const gchar* _tmp94_ = NULL;
		_tmp36_ = g_string_new ("");
		mention_builder = _tmp36_;
		_tmp37_ = reply_to;
		_tmp38_ = cb_tweet_get_screen_name (_tmp37_);
		_tmp39_ = self->priv->account;
		_tmp40_ = account_get_screen_name (_tmp39_);
		_tmp41_ = _tmp40_;
		if (g_strcmp0 (_tmp38_, _tmp41_) != 0) {
			GString* _tmp42_ = NULL;
			GString* _tmp43_ = NULL;
			CbTweet* _tmp44_ = NULL;
			const gchar* _tmp45_ = NULL;
			_tmp42_ = mention_builder;
			_tmp43_ = g_string_append (_tmp42_, "@");
			_tmp44_ = reply_to;
			_tmp45_ = cb_tweet_get_screen_name (_tmp44_);
			g_string_append (_tmp43_, _tmp45_);
		}
		_tmp46_ = reply_to;
		_tmp47_ = _tmp46_->retweeted_tweet;
		if (_tmp47_ != NULL) {
			GString* _tmp48_ = NULL;
			gssize _tmp49_ = 0L;
			GString* _tmp51_ = NULL;
			GString* _tmp52_ = NULL;
			CbTweet* _tmp53_ = NULL;
			CbMiniTweet _tmp54_ = {0};
			CbUserIdentity _tmp55_ = {0};
			const gchar* _tmp56_ = NULL;
			_tmp48_ = mention_builder;
			_tmp49_ = _tmp48_->len;
			if (_tmp49_ > ((gssize) 0)) {
				GString* _tmp50_ = NULL;
				_tmp50_ = mention_builder;
				g_string_append (_tmp50_, " ");
			}
			_tmp51_ = mention_builder;
			_tmp52_ = g_string_append (_tmp51_, "@");
			_tmp53_ = reply_to;
			_tmp54_ = _tmp53_->source_tweet;
			_tmp55_ = _tmp54_.author;
			_tmp56_ = _tmp55_.screen_name;
			g_string_append (_tmp52_, _tmp56_);
		}
		_tmp57_ = reply_to;
		_tmp59_ = cb_tweet_get_mentions (_tmp57_, &_tmp58_);
		{
			gchar** s_collection = NULL;
			gint s_collection_length1 = 0;
			gint _s_collection_size_ = 0;
			gint s_it = 0;
			s_collection = _tmp59_;
			s_collection_length1 = _tmp58_;
			for (s_it = 0; s_it < _tmp58_; s_it = s_it + 1) {
				const gchar* s = NULL;
				s = s_collection[s_it];
				{
					gboolean _tmp60_ = FALSE;
					gboolean _tmp61_ = FALSE;
					const gchar* _tmp62_ = NULL;
					Account* _tmp63_ = NULL;
					const gchar* _tmp64_ = NULL;
					const gchar* _tmp65_ = NULL;
					gchar* _tmp66_ = NULL;
					gchar* _tmp67_ = NULL;
					gboolean _tmp68_ = FALSE;
					GString* _tmp82_ = NULL;
					gssize _tmp83_ = 0L;
					GString* _tmp85_ = NULL;
					const gchar* _tmp86_ = NULL;
					_tmp62_ = s;
					_tmp63_ = self->priv->account;
					_tmp64_ = account_get_screen_name (_tmp63_);
					_tmp65_ = _tmp64_;
					_tmp66_ = g_strconcat ("@", _tmp65_, NULL);
					_tmp67_ = _tmp66_;
					_tmp68_ = g_strcmp0 (_tmp62_, _tmp67_) == 0;
					_g_free0 (_tmp67_);
					if (_tmp68_) {
						_tmp61_ = TRUE;
					} else {
						const gchar* _tmp69_ = NULL;
						CbTweet* _tmp70_ = NULL;
						const gchar* _tmp71_ = NULL;
						gchar* _tmp72_ = NULL;
						gchar* _tmp73_ = NULL;
						_tmp69_ = s;
						_tmp70_ = reply_to;
						_tmp71_ = cb_tweet_get_screen_name (_tmp70_);
						_tmp72_ = g_strconcat ("@", _tmp71_, NULL);
						_tmp73_ = _tmp72_;
						_tmp61_ = g_strcmp0 (_tmp69_, _tmp73_) == 0;
						_g_free0 (_tmp73_);
					}
					if (_tmp61_) {
						_tmp60_ = TRUE;
					} else {
						gboolean _tmp74_ = FALSE;
						CbTweet* _tmp75_ = NULL;
						CbMiniTweet* _tmp76_ = NULL;
						_tmp75_ = reply_to;
						_tmp76_ = _tmp75_->retweeted_tweet;
						if (_tmp76_ != NULL) {
							CbTweet* _tmp77_ = NULL;
							CbMiniTweet _tmp78_ = {0};
							CbUserIdentity _tmp79_ = {0};
							const gchar* _tmp80_ = NULL;
							const gchar* _tmp81_ = NULL;
							_tmp77_ = reply_to;
							_tmp78_ = _tmp77_->source_tweet;
							_tmp79_ = _tmp78_.author;
							_tmp80_ = _tmp79_.screen_name;
							_tmp81_ = s;
							_tmp74_ = g_strcmp0 (_tmp80_, _tmp81_) != 0;
						} else {
							_tmp74_ = FALSE;
						}
						_tmp60_ = _tmp74_;
					}
					if (_tmp60_) {
						continue;
					}
					_tmp82_ = mention_builder;
					_tmp83_ = _tmp82_->len;
					if (_tmp83_ > ((gssize) 0)) {
						GString* _tmp84_ = NULL;
						_tmp84_ = mention_builder;
						g_string_append (_tmp84_, " ");
					}
					_tmp85_ = mention_builder;
					_tmp86_ = s;
					g_string_append (_tmp85_, _tmp86_);
				}
			}
			s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_tmp87_ = mention_builder;
		_tmp88_ = _tmp87_->len;
		if (_tmp88_ > ((gssize) 0)) {
			GString* _tmp89_ = NULL;
			_tmp89_ = mention_builder;
			g_string_append (_tmp89_, " ");
		}
		_tmp90_ = self->priv->tweet_text;
		_tmp91_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, gtk_text_view_get_type (), GtkTextView));
		_tmp92_ = _tmp91_;
		_tmp93_ = mention_builder;
		_tmp94_ = _tmp93_->str;
		g_object_set (_tmp92_, "text", _tmp94_, NULL);
		_g_string_free0 (mention_builder);
	} else {
		ComposeTweetWindowMode _tmp95_ = 0;
		_tmp95_ = mode;
		if (_tmp95_ == COMPOSE_TWEET_WINDOW_MODE_QUOTE) {
			CbTweet* _tmp96_ = NULL;
			GtkLabel* _tmp97_ = NULL;
			const gchar* _tmp98_ = NULL;
			_tmp96_ = reply_to;
			_vala_assert (_tmp96_ != NULL, "reply_to != null");
			_tmp97_ = self->priv->title_label;
			_tmp98_ = _ ("Quote tweet");
			gtk_label_set_label (_tmp97_, _tmp98_);
		}
	}
	_tmp99_ = self->priv->tweet_text;
	gtk_widget_grab_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, gtk_widget_get_type (), GtkWidget));
	_tmp100_ = gtk_accel_group_new ();
	ag = _tmp100_;
	_tmp101_ = ag;
	gtk_accel_group_connect (_tmp101_, (guint) GDK_KEY_Escape, 0, GTK_ACCEL_LOCKED, (GClosure*) ((_compose_tweet_window_escape_pressed_cb_gtk_accel_group_activate == NULL) ? NULL : g_cclosure_new ((GCallback) _compose_tweet_window_escape_pressed_cb_gtk_accel_group_activate, g_object_ref (self), (GClosureNotify) g_object_unref)));
	_tmp102_ = ag;
	gtk_accel_group_connect (_tmp102_, (guint) GDK_KEY_Return, GDK_CONTROL_MASK, GTK_ACCEL_LOCKED, (GClosure*) ((___lambda44__gtk_accel_group_activate == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda44__gtk_accel_group_activate, g_object_ref (self), (GClosureNotify) g_object_unref)));
	_tmp103_ = self->priv->compose_image_manager;
	g_signal_connect_object (_tmp103_, "image-removed", (GCallback) ___lambda53__compose_image_manager_image_removed, self, 0);
	_tmp104_ = ag;
	gtk_window_add_accel_group (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), _tmp104_);
	_tmp105_ = self->priv->account;
	_tmp106_ = _tmp105_->db;
	_tmp107_ = sql_database_select (_tmp106_, "info");
	_tmp108_ = _tmp107_;
	_tmp109_ = sql_select_statement_cols (_tmp108_, "last_tweet", NULL);
	_tmp110_ = _tmp109_;
	_tmp111_ = sql_select_statement_once_string (_tmp110_);
	_tmp112_ = _tmp111_;
	_g_object_unref0 (_tmp110_);
	_g_object_unref0 (_tmp108_);
	last_tweet = _tmp112_;
	_tmp115_ = last_tweet;
	if (_tmp115_ != NULL) {
		const gchar* _tmp116_ = NULL;
		gint _tmp117_ = 0;
		gint _tmp118_ = 0;
		_tmp116_ = last_tweet;
		_tmp117_ = strlen (_tmp116_);
		_tmp118_ = _tmp117_;
		_tmp114_ = _tmp118_ > 0;
	} else {
		_tmp114_ = FALSE;
	}
	if (_tmp114_) {
		CompletionTextView* _tmp119_ = NULL;
		GtkTextBuffer* _tmp120_ = NULL;
		gchar* _tmp121_ = NULL;
		gchar* _tmp122_ = NULL;
		gchar* _tmp123_ = NULL;
		gint _tmp124_ = 0;
		gint _tmp125_ = 0;
		_tmp119_ = self->priv->tweet_text;
		_tmp120_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp119_, gtk_text_view_get_type (), GtkTextView));
		g_object_get (_tmp120_, "text", &_tmp121_, NULL);
		_tmp122_ = _tmp121_;
		_tmp123_ = _tmp122_;
		_tmp124_ = strlen (_tmp123_);
		_tmp125_ = _tmp124_;
		_tmp113_ = _tmp125_ == 0;
		_g_free0 (_tmp123_);
	} else {
		_tmp113_ = FALSE;
	}
	if (_tmp113_) {
		CompletionTextView* _tmp126_ = NULL;
		GtkTextBuffer* _tmp127_ = NULL;
		const gchar* _tmp128_ = NULL;
		_tmp126_ = self->priv->tweet_text;
		_tmp127_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, gtk_text_view_get_type (), GtkTextView));
		_tmp128_ = last_tweet;
		g_object_set (_tmp127_, "text", _tmp128_, NULL);
	}
	gtk_window_set_default_size (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), COMPOSE_TWEET_WINDOW_DEFAULT_WIDTH, (gint) (COMPOSE_TWEET_WINDOW_DEFAULT_WIDTH / 2.5));
	_g_free0 (last_tweet);
	_g_object_unref0 (ag);
	return self;
}


ComposeTweetWindow* compose_tweet_window_new (MainWindow* parent, Account* acc, CbTweet* reply_to, ComposeTweetWindowMode mode) {
	return compose_tweet_window_construct (TYPE_COMPOSE_TWEET_WINDOW, parent, acc, reply_to, mode);
}


static void compose_tweet_window_recalc_tweet_length (ComposeTweetWindow* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	CompletionTextView* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	gchar* text = NULL;
	CompletionTextView* _tmp5_ = NULL;
	GtkTextBuffer* _tmp6_ = NULL;
	GtkTextBuffer* _tmp7_ = NULL;
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	gchar* _tmp10_ = NULL;
	gint length = 0;
	const gchar* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	GtkLabel* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gint _tmp19_ = 0;
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	_tmp0_ = self->priv->tweet_text;
	_tmp1_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_text_view_get_type (), GtkTextView));
	_tmp2_ = _tmp1_;
	gtk_text_buffer_get_bounds (_tmp2_, &_tmp3_, &_tmp4_);
	start = _tmp3_;
	end = _tmp4_;
	_tmp5_ = self->priv->tweet_text;
	_tmp6_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_text_view_get_type (), GtkTextView));
	_tmp7_ = _tmp6_;
	_tmp8_ = start;
	_tmp9_ = end;
	_tmp10_ = gtk_text_buffer_get_text (_tmp7_, &_tmp8_, &_tmp9_, TRUE);
	text = _tmp10_;
	_tmp11_ = text;
	_tmp12_ = tweet_utils_calc_tweet_length (_tmp11_, 0);
	length = _tmp12_;
	_tmp13_ = self->priv->length_label;
	_tmp14_ = CB_TWEET_MAX_LENGTH;
	_tmp15_ = length;
	_tmp16_ = g_strdup_printf ("%i", _tmp14_ - _tmp15_);
	_tmp17_ = _tmp16_;
	gtk_label_set_label (_tmp13_, _tmp17_);
	_g_free0 (_tmp17_);
	_tmp19_ = length;
	if (_tmp19_ > 0) {
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		_tmp20_ = length;
		_tmp21_ = CB_TWEET_MAX_LENGTH;
		_tmp18_ = _tmp20_ <= _tmp21_;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		GtkButton* _tmp22_ = NULL;
		_tmp22_ = self->priv->send_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget), TRUE);
	} else {
		GtkButton* _tmp23_ = NULL;
		_tmp23_ = self->priv->send_button;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget), FALSE);
	}
	_g_free0 (text);
}


static Block68Data* block68_data_ref (Block68Data* _data68_) {
	g_atomic_int_inc (&_data68_->_ref_count_);
	return _data68_;
}


static void block68_data_unref (void * _userdata_) {
	Block68Data* _data68_;
	_data68_ = (Block68Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data68_->_ref_count_)) {
		ComposeTweetWindow* self;
		self = _data68_->self;
		_g_object_unref0 (_data68_->job);
		_g_object_unref0 (self);
		g_slice_free (Block68Data, _data68_);
	}
}


static gint64* _int64_dup (gint64* self) {
	gint64* dup;
	dup = g_new0 (gint64, 1);
	memcpy (dup, self, sizeof (gint64));
	return dup;
}


static gpointer __int64_dup0 (gpointer self) {
	return self ? _int64_dup (self) : NULL;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda50_ (ComposeTweetWindow* self, const gchar* path) {
	ComposeImageManager* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->compose_image_manager;
	_tmp1_ = path;
	compose_image_manager_start_progress (_tmp0_, _tmp1_);
}


static void ___lambda50__compose_job_image_upload_started (ComposeJob* _sender, const gchar* path, gpointer self) {
	__lambda50_ ((ComposeTweetWindow*) self, path);
}


static void __lambda51_ (ComposeTweetWindow* self, const gchar* path, const gchar* error_msg) {
	ComposeImageManager* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (path != NULL);
	_tmp0_ = self->priv->compose_image_manager;
	_tmp1_ = path;
	_tmp2_ = error_msg;
	compose_image_manager_end_progress (_tmp0_, _tmp1_, _tmp2_);
}


static void ___lambda51__compose_job_image_upload_finished (ComposeJob* _sender, const gchar* path, const gchar* error_message, gpointer self) {
	__lambda51_ ((ComposeTweetWindow*) self, path, error_message);
}


static void __lambda52_ (Block68Data* _data68_, GObject* obj, GAsyncResult* res) {
	ComposeTweetWindow* self;
	gboolean success = FALSE;
	ComposeJob* _tmp0_ = NULL;
	GAsyncResult* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	self = _data68_->self;
	g_return_if_fail ((obj == NULL) || G_IS_OBJECT (obj));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	_tmp0_ = _data68_->job;
	_tmp1_ = res;
	_tmp2_ = compose_job_start_finish (_tmp0_, _tmp1_);
	success = _tmp2_;
	g_debug ("ComposeTweetWindow.vala:211: Tweet sent.");
	_tmp3_ = success;
	if (_tmp3_) {
		Account* _tmp4_ = NULL;
		SqlDatabase* _tmp5_ = NULL;
		SqlUpdateStatement* _tmp6_ = NULL;
		SqlUpdateStatement* _tmp7_ = NULL;
		SqlUpdateStatement* _tmp8_ = NULL;
		SqlUpdateStatement* _tmp9_ = NULL;
		_tmp4_ = self->priv->account;
		_tmp5_ = _tmp4_->db;
		_tmp6_ = sql_database_update (_tmp5_, "info");
		_tmp7_ = _tmp6_;
		_tmp8_ = sql_update_statement_val (_tmp7_, "last_tweet", "");
		_tmp9_ = _tmp8_;
		sql_update_statement_run (_tmp9_);
		_g_object_unref0 (_tmp9_);
		_g_object_unref0 (_tmp7_);
	} else {
		compose_tweet_window_save_last_tweet (self);
	}
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
}


static void ___lambda52__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda52_ (self, source_object, res);
	block68_data_unref (self);
}


static void compose_tweet_window_start_send_tweet (ComposeTweetWindow* self) {
	Block68Data* _data68_;
	GtkButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	Account* _tmp3_ = NULL;
	ComposeJob* _tmp4_ = NULL;
	GCancellable* _tmp5_ = NULL;
	ComposeTweetWindowMode _tmp6_ = 0;
	GtkStack* _tmp15_ = NULL;
	GtkSpinner* _tmp16_ = NULL;
	GtkSpinner* _tmp17_ = NULL;
	GtkButton* _tmp18_ = NULL;
	CompletionTextView* _tmp19_ = NULL;
	GtkGrid* _tmp20_ = NULL;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	CompletionTextView* _tmp21_ = NULL;
	GtkTextBuffer* _tmp22_ = NULL;
	GtkTextBuffer* _tmp23_ = NULL;
	GtkTextIter _tmp24_ = {0};
	CompletionTextView* _tmp25_ = NULL;
	GtkTextBuffer* _tmp26_ = NULL;
	GtkTextBuffer* _tmp27_ = NULL;
	GtkTextIter _tmp28_ = {0};
	ComposeJob* _tmp29_ = NULL;
	CompletionTextView* _tmp30_ = NULL;
	GtkTextBuffer* _tmp31_ = NULL;
	GtkTextBuffer* _tmp32_ = NULL;
	GtkTextIter _tmp33_ = {0};
	GtkTextIter _tmp34_ = {0};
	gchar* _tmp35_ = NULL;
	ComposeImageManager* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	gchar** _tmp38_ = NULL;
	ComposeJob* _tmp42_ = NULL;
	ComposeJob* _tmp43_ = NULL;
	ComposeJob* _tmp44_ = NULL;
	GCancellable* _tmp45_ = NULL;
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	_data68_ = g_slice_new0 (Block68Data);
	_data68_->_ref_count_ = 1;
	_data68_->self = g_object_ref (self);
	_tmp0_ = self->priv->send_button;
	_tmp1_ = gtk_widget_get_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		block68_data_unref (_data68_);
		_data68_ = NULL;
		return;
	}
	_tmp3_ = self->priv->account;
	_tmp4_ = compose_job_new (_tmp3_);
	_data68_->job = _tmp4_;
	_tmp5_ = g_cancellable_new ();
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp5_;
	_tmp6_ = self->priv->mode;
	if (_tmp6_ == COMPOSE_TWEET_WINDOW_MODE_REPLY) {
		ComposeJob* _tmp7_ = NULL;
		CbTweet* _tmp8_ = NULL;
		gint64 _tmp9_ = 0LL;
		gint64* _tmp10_ = NULL;
		_tmp7_ = _data68_->job;
		_tmp8_ = self->priv->reply_to;
		_tmp9_ = _tmp8_->id;
		_tmp10_ = __int64_dup0 (&_tmp9_);
		_g_free0 (_tmp7_->reply_id);
		_tmp7_->reply_id = _tmp10_;
	} else {
		ComposeTweetWindowMode _tmp11_ = 0;
		_tmp11_ = self->priv->mode;
		if (_tmp11_ == COMPOSE_TWEET_WINDOW_MODE_QUOTE) {
			ComposeJob* _tmp12_ = NULL;
			CbTweet* _tmp13_ = NULL;
			CbTweet* _tmp14_ = NULL;
			_tmp12_ = _data68_->job;
			_tmp13_ = self->priv->reply_to;
			_tmp14_ = _g_object_ref0 (_tmp13_);
			_g_object_unref0 (_tmp12_->quoted_tweet);
			_tmp12_->quoted_tweet = _tmp14_;
		}
	}
	_tmp15_ = self->priv->title_stack;
	_tmp16_ = self->priv->title_spinner;
	gtk_stack_set_visible_child (_tmp15_, G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget));
	_tmp17_ = self->priv->title_spinner;
	gtk_spinner_start (_tmp17_);
	_tmp18_ = self->priv->send_button;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp19_ = self->priv->tweet_text;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp20_ = self->priv->content_grid;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp21_ = self->priv->tweet_text;
	_tmp22_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_text_view_get_type (), GtkTextView));
	_tmp23_ = _tmp22_;
	gtk_text_buffer_get_start_iter (_tmp23_, &_tmp24_);
	start = _tmp24_;
	_tmp25_ = self->priv->tweet_text;
	_tmp26_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_text_view_get_type (), GtkTextView));
	_tmp27_ = _tmp26_;
	gtk_text_buffer_get_end_iter (_tmp27_, &_tmp28_);
	end = _tmp28_;
	_tmp29_ = _data68_->job;
	_tmp30_ = self->priv->tweet_text;
	_tmp31_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_text_view_get_type (), GtkTextView));
	_tmp32_ = _tmp31_;
	_tmp33_ = start;
	_tmp34_ = end;
	_tmp35_ = gtk_text_buffer_get_text (_tmp32_, &_tmp33_, &_tmp34_, TRUE);
	_g_free0 (_tmp29_->text);
	_tmp29_->text = _tmp35_;
	_tmp36_ = self->priv->compose_image_manager;
	_tmp38_ = compose_image_manager_get_image_paths (_tmp36_, &_tmp37_);
	{
		gchar** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
		path_collection = _tmp38_;
		path_collection_length1 = _tmp37_;
		for (path_it = 0; path_it < _tmp37_; path_it = path_it + 1) {
			gchar* _tmp39_ = NULL;
			gchar* path = NULL;
			_tmp39_ = g_strdup (path_collection[path_it]);
			path = _tmp39_;
			{
				ComposeJob* _tmp40_ = NULL;
				const gchar* _tmp41_ = NULL;
				_tmp40_ = _data68_->job;
				_tmp41_ = path;
				compose_job_add_image (_tmp40_, _tmp41_);
				_g_free0 (path);
			}
		}
		path_collection = (_vala_array_free (path_collection, path_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp42_ = _data68_->job;
	g_signal_connect_object (_tmp42_, "image-upload-started", (GCallback) ___lambda50__compose_job_image_upload_started, self, 0);
	_tmp43_ = _data68_->job;
	g_signal_connect_object (_tmp43_, "image-upload-finished", (GCallback) ___lambda51__compose_job_image_upload_finished, self, 0);
	_tmp44_ = _data68_->job;
	_tmp45_ = self->priv->cancellable;
	compose_job_start (_tmp44_, _tmp45_, ___lambda52__gasync_ready_callback, block68_data_ref (_data68_));
	block68_data_unref (_data68_);
	_data68_ = NULL;
}


static void _compose_tweet_window_start_send_tweet_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	compose_tweet_window_start_send_tweet ((ComposeTweetWindow*) self);
}


static void compose_tweet_window_save_last_tweet (ComposeTweetWindow* self) {
	CbTweet* _tmp0_ = NULL;
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	_tmp0_ = self->priv->reply_to;
	if (_tmp0_ == NULL) {
		gchar* text = NULL;
		CompletionTextView* _tmp1_ = NULL;
		GtkTextBuffer* _tmp2_ = NULL;
		GtkTextBuffer* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		Account* _tmp6_ = NULL;
		SqlDatabase* _tmp7_ = NULL;
		SqlUpdateStatement* _tmp8_ = NULL;
		SqlUpdateStatement* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		SqlUpdateStatement* _tmp11_ = NULL;
		SqlUpdateStatement* _tmp12_ = NULL;
		_tmp1_ = self->priv->tweet_text;
		_tmp2_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_text_view_get_type (), GtkTextView));
		_tmp3_ = _tmp2_;
		g_object_get (_tmp3_, "text", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		text = _tmp5_;
		_tmp6_ = self->priv->account;
		_tmp7_ = _tmp6_->db;
		_tmp8_ = sql_database_update (_tmp7_, "info");
		_tmp9_ = _tmp8_;
		_tmp10_ = text;
		_tmp11_ = sql_update_statement_val (_tmp9_, "last_tweet", _tmp10_);
		_tmp12_ = _tmp11_;
		sql_update_statement_run (_tmp12_);
		_g_object_unref0 (_tmp12_);
		_g_object_unref0 (_tmp9_);
		_g_free0 (text);
	}
}


static void compose_tweet_window_cancel_clicked (ComposeTweetWindow* self, GtkWidget* source) {
	GCancellable* _tmp0_ = NULL;
	GtkStack* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	GtkWidget* _tmp4_ = NULL;
	GtkGrid* _tmp5_ = NULL;
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	g_return_if_fail (GTK_IS_WIDGET (source));
	_tmp0_ = self->priv->cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_ = NULL;
		_tmp1_ = self->priv->cancellable;
		g_cancellable_cancel (_tmp1_);
	}
	_tmp2_ = self->priv->stack;
	_tmp3_ = gtk_stack_get_visible_child (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->image_error_grid;
	if (_tmp4_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget)) {
		GtkStack* _tmp6_ = NULL;
		GtkGrid* _tmp7_ = NULL;
		GtkButton* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		_tmp6_ = self->priv->stack;
		_tmp7_ = self->priv->content_grid;
		gtk_stack_set_visible_child (_tmp6_, G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
		_tmp8_ = self->priv->cancel_button;
		_tmp9_ = _ ("Cancel");
		gtk_button_set_label (_tmp8_, _tmp9_);
		compose_tweet_window_recalc_tweet_length (self);
	} else {
		compose_tweet_window_save_last_tweet (self);
		gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	}
}


static void _compose_tweet_window_cancel_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	compose_tweet_window_cancel_clicked ((ComposeTweetWindow*) self, _sender);
}


static gboolean compose_tweet_window_escape_pressed_cb (ComposeTweetWindow* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (IS_COMPOSE_TWEET_WINDOW (self), FALSE);
	compose_tweet_window_save_last_tweet (self);
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (self, gtk_widget_get_type (), GtkWidget));
	result = GDK_EVENT_STOP;
	return result;
}


void compose_tweet_window_set_text (ComposeTweetWindow* self, const gchar* text) {
	CompletionTextView* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextBuffer* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	g_return_if_fail (text != NULL);
	_tmp0_ = self->priv->tweet_text;
	_tmp1_ = gtk_text_view_get_buffer (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_text_view_get_type (), GtkTextView));
	_tmp2_ = _tmp1_;
	_tmp3_ = text;
	g_object_set (_tmp2_, "text", _tmp3_, NULL);
}


static Block69Data* block69_data_ref (Block69Data* _data69_) {
	g_atomic_int_inc (&_data69_->_ref_count_);
	return _data69_;
}


static void block69_data_unref (void * _userdata_) {
	Block69Data* _data69_;
	_data69_ = (Block69Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data69_->_ref_count_)) {
		ComposeTweetWindow* self;
		self = _data69_->self;
		_g_object_unref0 (_data69_->filechooser);
		_g_object_unref0 (self);
		g_slice_free (Block69Data, _data69_);
	}
}


static void __lambda54_ (Block69Data* _data69_, gint id) {
	ComposeTweetWindow* self;
	gint _tmp0_ = 0;
	GError * _inner_error_ = NULL;
	self = _data69_->self;
	_tmp0_ = id;
	if (_tmp0_ == ((gint) GTK_RESPONSE_ACCEPT)) {
		gchar* filename = NULL;
		gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		GFile* file = NULL;
		const gchar* _tmp3_ = NULL;
		GFile* _tmp4_ = NULL;
		GFileInfo* info = NULL;
		GFileInfo* _tmp12_ = NULL;
		gint64 _tmp13_ = 0LL;
		_tmp1_ = gtk_file_chooser_get_filename (G_TYPE_CHECK_INSTANCE_CAST (_data69_->filechooser, GTK_TYPE_FILE_CHOOSER, GtkFileChooser));
		filename = _tmp1_;
		_tmp2_ = filename;
		g_debug ("ComposeTweetWindow.vala:272: Loading %s", _tmp2_);
		_tmp3_ = filename;
		_tmp4_ = g_file_new_for_path (_tmp3_);
		file = _tmp4_;
		{
			GFileInfo* _tmp5_ = NULL;
			GFile* _tmp6_ = NULL;
			GFileInfo* _tmp7_ = NULL;
			GFileInfo* _tmp8_ = NULL;
			_tmp6_ = file;
			_tmp7_ = g_file_query_info (_tmp6_, G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_SIZE, 0, NULL, &_inner_error_);
			_tmp5_ = _tmp7_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch81_g_error;
			}
			_tmp8_ = _tmp5_;
			_tmp5_ = NULL;
			_g_object_unref0 (info);
			info = _tmp8_;
			_g_object_unref0 (_tmp5_);
		}
		goto __finally81;
		__catch81_g_error:
		{
			GError* e = NULL;
			GError* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp9_ = e;
			_tmp10_ = _tmp9_->message;
			_tmp11_ = filename;
			g_warning ("ComposeTweetWindow.vala:281: %s (%s)", _tmp10_, _tmp11_);
			_g_error_free0 (e);
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			_g_free0 (filename);
			return;
		}
		__finally81:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (info);
			_g_object_unref0 (file);
			_g_free0 (filename);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp12_ = info;
		_tmp13_ = g_file_info_get_size (_tmp12_);
		if (_tmp13_ > ((gint64) TWITTER_MAX_BYTES_PER_IMAGE)) {
			GtkStack* _tmp14_ = NULL;
			GtkGrid* _tmp15_ = NULL;
			GtkLabel* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			gchar* _tmp18_ = NULL;
			gchar* _tmp19_ = NULL;
			GtkButton* _tmp20_ = NULL;
			const gchar* _tmp21_ = NULL;
			GtkButton* _tmp22_ = NULL;
			_tmp14_ = self->priv->stack;
			_tmp15_ = self->priv->image_error_grid;
			gtk_stack_set_visible_child (_tmp14_, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget));
			_tmp16_ = self->priv->image_error_label;
			_tmp17_ = _ ("The selected image is too big. The maximum file size per image is %'d " \
"MB");
			_tmp18_ = g_strdup_printf (_tmp17_, (TWITTER_MAX_BYTES_PER_IMAGE / 1024) / 1024);
			_tmp19_ = _tmp18_;
			gtk_label_set_label (_tmp16_, _tmp19_);
			_g_free0 (_tmp19_);
			_tmp20_ = self->priv->cancel_button;
			_tmp21_ = _ ("Back");
			gtk_button_set_label (_tmp20_, _tmp21_);
			_tmp22_ = self->priv->send_button;
			gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget), FALSE);
		} else {
			ComposeImageManager* _tmp23_ = NULL;
			ComposeImageManager* _tmp24_ = NULL;
			const gchar* _tmp25_ = NULL;
			_tmp23_ = self->priv->compose_image_manager;
			gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_widget_get_type (), GtkWidget));
			_tmp24_ = self->priv->compose_image_manager;
			_tmp25_ = filename;
			compose_image_manager_load_image (_tmp24_, _tmp25_, NULL);
		}
		_g_object_unref0 (info);
		_g_object_unref0 (file);
		_g_free0 (filename);
	}
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_data69_->filechooser, gtk_widget_get_type (), GtkWidget));
}


static void ___lambda54__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	__lambda54_ (self, response_id);
}


static void compose_tweet_window_add_image_clicked_cb (ComposeTweetWindow* self, GtkButton* source) {
	Block69Data* _data69_;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GtkFileChooserDialog* _tmp3_ = NULL;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp4_ = NULL;
	g_return_if_fail (IS_COMPOSE_TWEET_WINDOW (self));
	g_return_if_fail (GTK_IS_BUTTON (source));
	_data69_ = g_slice_new0 (Block69Data);
	_data69_->_ref_count_ = 1;
	_data69_->self = g_object_ref (self);
	_tmp0_ = _ ("Select Image");
	_tmp1_ = _ ("Cancel");
	_tmp2_ = _ ("Open");
	_tmp3_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_window_get_type (), GtkWindow), GTK_FILE_CHOOSER_ACTION_OPEN, _tmp1_, GTK_RESPONSE_CANCEL, _tmp2_, GTK_RESPONSE_ACCEPT, NULL);
	g_object_ref_sink (_tmp3_);
	_data69_->filechooser = _tmp3_;
	gtk_file_chooser_set_select_multiple (G_TYPE_CHECK_INSTANCE_CAST (_data69_->filechooser, GTK_TYPE_FILE_CHOOSER, GtkFileChooser), FALSE);
	gtk_window_set_modal (G_TYPE_CHECK_INSTANCE_CAST (_data69_->filechooser, gtk_window_get_type (), GtkWindow), TRUE);
	g_signal_connect_data (G_TYPE_CHECK_INSTANCE_CAST (_data69_->filechooser, gtk_dialog_get_type (), GtkDialog), "response", (GCallback) ___lambda54__gtk_dialog_response, block69_data_ref (_data69_), (GClosureNotify) block69_data_unref, 0);
	_tmp4_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp4_);
	filter = _tmp4_;
	gtk_file_filter_add_mime_type (filter, "image/png");
	gtk_file_filter_add_mime_type (filter, "image/jpeg");
	gtk_file_filter_add_mime_type (filter, "image/gif");
	gtk_file_chooser_set_filter (G_TYPE_CHECK_INSTANCE_CAST (_data69_->filechooser, GTK_TYPE_FILE_CHOOSER, GtkFileChooser), filter);
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_data69_->filechooser, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (filter);
	block69_data_unref (_data69_);
	_data69_ = NULL;
}


static void _compose_tweet_window_add_image_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	compose_tweet_window_add_image_clicked_cb ((ComposeTweetWindow*) self, _sender);
}


static void compose_tweet_window_class_init (ComposeTweetWindowClass * klass) {
	gint ComposeTweetWindow_private_offset;
	compose_tweet_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ComposeTweetWindowPrivate));
	G_OBJECT_CLASS (klass)->finalize = compose_tweet_window_finalize;
	ComposeTweetWindow_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/compose-window.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "avatar_image", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, avatar_image));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "content_grid", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, content_grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "tweet_text", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, tweet_text));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "length_label", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, length_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "send_button", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, send_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_spinner", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, title_spinner));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_label", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, title_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "title_stack", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, title_stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "compose_image_manager", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, compose_image_manager));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "add_image_button", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, add_image_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image_error_grid", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, image_error_grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "image_error_label", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, image_error_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "cancel_button", FALSE, ComposeTweetWindow_private_offset + G_STRUCT_OFFSET (ComposeTweetWindowPrivate, cancel_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "start_send_tweet", G_CALLBACK(_compose_tweet_window_start_send_tweet_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "cancel_clicked", G_CALLBACK(_compose_tweet_window_cancel_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "add_image_clicked_cb", G_CALLBACK(_compose_tweet_window_add_image_clicked_cb_gtk_button_clicked));
}


static void compose_tweet_window_instance_init (ComposeTweetWindow * self) {
	self->priv = COMPOSE_TWEET_WINDOW_GET_PRIVATE (self);
	self->priv->reply_list = NULL;
	g_type_ensure (TYPE_AVATAR_WIDGET);
	g_type_ensure (TYPE_COMPLETION_TEXT_VIEW);
	g_type_ensure (TYPE_COMPOSE_IMAGE_MANAGER);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void compose_tweet_window_finalize (GObject* obj) {
	ComposeTweetWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPOSE_TWEET_WINDOW, ComposeTweetWindow);
	_g_object_unref0 (self->priv->avatar_image);
	_g_object_unref0 (self->priv->content_grid);
	_g_object_unref0 (self->priv->tweet_text);
	_g_object_unref0 (self->priv->length_label);
	_g_object_unref0 (self->priv->send_button);
	_g_object_unref0 (self->priv->title_spinner);
	_g_object_unref0 (self->priv->title_label);
	_g_object_unref0 (self->priv->title_stack);
	_g_object_unref0 (self->priv->compose_image_manager);
	_g_object_unref0 (self->priv->add_image_button);
	_g_object_unref0 (self->priv->stack);
	_g_object_unref0 (self->priv->image_error_grid);
	_g_object_unref0 (self->priv->image_error_label);
	_g_object_unref0 (self->priv->cancel_button);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->reply_list);
	G_OBJECT_CLASS (compose_tweet_window_parent_class)->finalize (obj);
}


GType compose_tweet_window_get_type (void) {
	static volatile gsize compose_tweet_window_type_id__volatile = 0;
	if (g_once_init_enter (&compose_tweet_window_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ComposeTweetWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) compose_tweet_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComposeTweetWindow), 0, (GInstanceInitFunc) compose_tweet_window_instance_init, NULL };
		GType compose_tweet_window_type_id;
		compose_tweet_window_type_id = g_type_register_static (gtk_application_window_get_type (), "ComposeTweetWindow", &g_define_type_info, 0);
		g_once_init_leave (&compose_tweet_window_type_id__volatile, compose_tweet_window_type_id);
	}
	return compose_tweet_window_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



