/* Backend.c generated by valac 0.30.2, the Vala compiler
 * generated from Backend.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    This file is part of Déjà Dup.
    For copyright information, see AUTHORS.

    Déjà Dup is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Déjà Dup is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Déjà Dup.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define DEJA_DUP_TYPE_BACKEND (deja_dup_backend_get_type ())
#define DEJA_DUP_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackend))
#define DEJA_DUP_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))
#define DEJA_DUP_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND))
#define DEJA_DUP_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND, DejaDupBackendClass))

typedef struct _DejaDupBackend DejaDupBackend;
typedef struct _DejaDupBackendClass DejaDupBackendClass;
typedef struct _DejaDupBackendPrivate DejaDupBackendPrivate;

#define DEJA_DUP_TOOL_JOB_TYPE_MODE (deja_dup_tool_job_mode_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _DejaDupBackendIsReadyData DejaDupBackendIsReadyData;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
typedef struct _DejaDupBackendGetEnvpData DejaDupBackendGetEnvpData;
typedef struct _DejaDupBackendGetSpaceData DejaDupBackendGetSpaceData;

#define DEJA_DUP_TYPE_FILTERED_SETTINGS (deja_dup_filtered_settings_get_type ())
#define DEJA_DUP_FILTERED_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettings))
#define DEJA_DUP_FILTERED_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettingsClass))
#define DEJA_DUP_IS_FILTERED_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS))
#define DEJA_DUP_IS_FILTERED_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_FILTERED_SETTINGS))
#define DEJA_DUP_FILTERED_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_FILTERED_SETTINGS, DejaDupFilteredSettingsClass))

typedef struct _DejaDupFilteredSettings DejaDupFilteredSettings;
typedef struct _DejaDupFilteredSettingsClass DejaDupFilteredSettingsClass;

#define DEJA_DUP_TYPE_BACKEND_S3 (deja_dup_backend_s3_get_type ())
#define DEJA_DUP_BACKEND_S3(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3))
#define DEJA_DUP_BACKEND_S3_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3Class))
#define DEJA_DUP_IS_BACKEND_S3(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_S3))
#define DEJA_DUP_IS_BACKEND_S3_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_S3))
#define DEJA_DUP_BACKEND_S3_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_S3, DejaDupBackendS3Class))

typedef struct _DejaDupBackendS3 DejaDupBackendS3;
typedef struct _DejaDupBackendS3Class DejaDupBackendS3Class;

#define DEJA_DUP_TYPE_BACKEND_GCS (deja_dup_backend_gcs_get_type ())
#define DEJA_DUP_BACKEND_GCS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_GCS, DejaDupBackendGCS))
#define DEJA_DUP_BACKEND_GCS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_GCS, DejaDupBackendGCSClass))
#define DEJA_DUP_IS_BACKEND_GCS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_GCS))
#define DEJA_DUP_IS_BACKEND_GCS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_GCS))
#define DEJA_DUP_BACKEND_GCS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_GCS, DejaDupBackendGCSClass))

typedef struct _DejaDupBackendGCS DejaDupBackendGCS;
typedef struct _DejaDupBackendGCSClass DejaDupBackendGCSClass;

#define DEJA_DUP_TYPE_BACKEND_GDRIVE (deja_dup_backend_gdrive_get_type ())
#define DEJA_DUP_BACKEND_GDRIVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_GDRIVE, DejaDupBackendGDrive))
#define DEJA_DUP_BACKEND_GDRIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_GDRIVE, DejaDupBackendGDriveClass))
#define DEJA_DUP_IS_BACKEND_GDRIVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_GDRIVE))
#define DEJA_DUP_IS_BACKEND_GDRIVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_GDRIVE))
#define DEJA_DUP_BACKEND_GDRIVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_GDRIVE, DejaDupBackendGDriveClass))

typedef struct _DejaDupBackendGDrive DejaDupBackendGDrive;
typedef struct _DejaDupBackendGDriveClass DejaDupBackendGDriveClass;

#define DEJA_DUP_TYPE_BACKEND_U1 (deja_dup_backend_u1_get_type ())
#define DEJA_DUP_BACKEND_U1(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_U1, DejaDupBackendU1))
#define DEJA_DUP_BACKEND_U1_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_U1, DejaDupBackendU1Class))
#define DEJA_DUP_IS_BACKEND_U1(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_U1))
#define DEJA_DUP_IS_BACKEND_U1_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_U1))
#define DEJA_DUP_BACKEND_U1_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_U1, DejaDupBackendU1Class))

typedef struct _DejaDupBackendU1 DejaDupBackendU1;
typedef struct _DejaDupBackendU1Class DejaDupBackendU1Class;

#define DEJA_DUP_TYPE_BACKEND_RACKSPACE (deja_dup_backend_rackspace_get_type ())
#define DEJA_DUP_BACKEND_RACKSPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_RACKSPACE, DejaDupBackendRackspace))
#define DEJA_DUP_BACKEND_RACKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_RACKSPACE, DejaDupBackendRackspaceClass))
#define DEJA_DUP_IS_BACKEND_RACKSPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_RACKSPACE))
#define DEJA_DUP_IS_BACKEND_RACKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_RACKSPACE))
#define DEJA_DUP_BACKEND_RACKSPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_RACKSPACE, DejaDupBackendRackspaceClass))

typedef struct _DejaDupBackendRackspace DejaDupBackendRackspace;
typedef struct _DejaDupBackendRackspaceClass DejaDupBackendRackspaceClass;

#define DEJA_DUP_TYPE_BACKEND_OPENSTACK (deja_dup_backend_openstack_get_type ())
#define DEJA_DUP_BACKEND_OPENSTACK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_OPENSTACK, DejaDupBackendOpenstack))
#define DEJA_DUP_BACKEND_OPENSTACK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_OPENSTACK, DejaDupBackendOpenstackClass))
#define DEJA_DUP_IS_BACKEND_OPENSTACK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_OPENSTACK))
#define DEJA_DUP_IS_BACKEND_OPENSTACK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_OPENSTACK))
#define DEJA_DUP_BACKEND_OPENSTACK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_OPENSTACK, DejaDupBackendOpenstackClass))

typedef struct _DejaDupBackendOpenstack DejaDupBackendOpenstack;
typedef struct _DejaDupBackendOpenstackClass DejaDupBackendOpenstackClass;

#define DEJA_DUP_TYPE_BACKEND_FILE (deja_dup_backend_file_get_type ())
#define DEJA_DUP_BACKEND_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_FILE, DejaDupBackendFile))
#define DEJA_DUP_BACKEND_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_FILE, DejaDupBackendFileClass))
#define DEJA_DUP_IS_BACKEND_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_FILE))
#define DEJA_DUP_IS_BACKEND_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_FILE))
#define DEJA_DUP_BACKEND_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_FILE, DejaDupBackendFileClass))

typedef struct _DejaDupBackendFile DejaDupBackendFile;
typedef struct _DejaDupBackendFileClass DejaDupBackendFileClass;

#define DEJA_DUP_TYPE_BACKEND_AUTO (deja_dup_backend_auto_get_type ())
#define DEJA_DUP_BACKEND_AUTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_BACKEND_AUTO, DejaDupBackendAuto))
#define DEJA_DUP_BACKEND_AUTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_BACKEND_AUTO, DejaDupBackendAutoClass))
#define DEJA_DUP_IS_BACKEND_AUTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_BACKEND_AUTO))
#define DEJA_DUP_IS_BACKEND_AUTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_BACKEND_AUTO))
#define DEJA_DUP_BACKEND_AUTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_BACKEND_AUTO, DejaDupBackendAutoClass))

typedef struct _DejaDupBackendAuto DejaDupBackendAuto;
typedef struct _DejaDupBackendAutoClass DejaDupBackendAutoClass;

typedef enum  {
	DEJA_DUP_TOOL_JOB_MODE_INVALID,
	DEJA_DUP_TOOL_JOB_MODE_BACKUP,
	DEJA_DUP_TOOL_JOB_MODE_RESTORE,
	DEJA_DUP_TOOL_JOB_MODE_STATUS,
	DEJA_DUP_TOOL_JOB_MODE_LIST,
	DEJA_DUP_TOOL_JOB_MODE_HISTORY
} DejaDupToolJobMode;

struct _DejaDupBackend {
	GObject parent_instance;
	DejaDupBackendPrivate * priv;
};

struct _DejaDupBackendClass {
	GObjectClass parent_class;
	gboolean (*is_native) (DejaDupBackend* self);
	GIcon* (*get_icon) (DejaDupBackend* self);
	gchar* (*get_location) (DejaDupBackend* self, gboolean* as_root);
	gchar* (*get_location_pretty) (DejaDupBackend* self);
	void (*is_ready) (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*is_ready_finish) (DejaDupBackend* self, GAsyncResult* _res_, gchar** when);
	void (*get_envp) (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*get_envp_finish) (DejaDupBackend* self, GAsyncResult* _res_, GError** error);
	void (*get_space) (DejaDupBackend* self, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_);
	guint64 (*get_space_finish) (DejaDupBackend* self, GAsyncResult* _res_);
	gboolean (*space_can_be_infinite) (DejaDupBackend* self);
	void (*add_argv) (DejaDupBackend* self, DejaDupToolJobMode mode, GList** argv);
	DejaDupBackend* (*clone) (DejaDupBackend* self);
};

struct _DejaDupBackendPrivate {
	GMountOperation* _mount_op;
};

struct _DejaDupBackendIsReadyData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackend* self;
	gchar* when;
	gboolean result;
};

struct _DejaDupBackendGetEnvpData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackend* self;
	GList* _tmp0_;
};

struct _DejaDupBackendGetSpaceData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	DejaDupBackend* self;
	gboolean free;
	guint64 result;
	guint64 _tmp0_;
};


static gpointer deja_dup_backend_parent_class = NULL;
extern guint64 deja_dup_backend_INFINITE_SPACE;
guint64 deja_dup_backend_INFINITE_SPACE = 0ULL;

GType deja_dup_backend_get_type (void) G_GNUC_CONST;
GType deja_dup_tool_job_mode_get_type (void) G_GNUC_CONST;
#define DEJA_DUP_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_BACKEND, DejaDupBackendPrivate))
enum  {
	DEJA_DUP_BACKEND_DUMMY_PROPERTY,
	DEJA_DUP_BACKEND_MOUNT_OP
};
gboolean deja_dup_backend_is_native (DejaDupBackend* self);
static gboolean deja_dup_backend_real_is_native (DejaDupBackend* self);
GIcon* deja_dup_backend_get_icon (DejaDupBackend* self);
static GIcon* deja_dup_backend_real_get_icon (DejaDupBackend* self);
gchar* deja_dup_backend_get_location (DejaDupBackend* self, gboolean* as_root);
static gchar* deja_dup_backend_real_get_location (DejaDupBackend* self, gboolean* as_root);
gchar* deja_dup_backend_get_location_pretty (DejaDupBackend* self);
static gchar* deja_dup_backend_real_get_location_pretty (DejaDupBackend* self);
static void deja_dup_backend_real_is_ready_data_free (gpointer _data);
static void deja_dup_backend_real_is_ready (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_backend_is_ready (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean deja_dup_backend_is_ready_finish (DejaDupBackend* self, GAsyncResult* _res_, gchar** when);
static gboolean deja_dup_backend_real_is_ready_co (DejaDupBackendIsReadyData* _data_);
static void deja_dup_backend_real_get_envp_data_free (gpointer _data);
static void deja_dup_backend_real_get_envp (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_backend_get_envp (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_backend_get_envp_finish (DejaDupBackend* self, GAsyncResult* _res_, GError** error);
static gboolean deja_dup_backend_real_get_envp_co (DejaDupBackendGetEnvpData* _data_);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void deja_dup_backend_real_get_space_data_free (gpointer _data);
static void deja_dup_backend_real_get_space (DejaDupBackend* self, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_);
void deja_dup_backend_get_space (DejaDupBackend* self, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_);
guint64 deja_dup_backend_get_space_finish (DejaDupBackend* self, GAsyncResult* _res_);
static gboolean deja_dup_backend_real_get_space_co (DejaDupBackendGetSpaceData* _data_);
gboolean deja_dup_backend_space_can_be_infinite (DejaDupBackend* self);
static gboolean deja_dup_backend_real_space_can_be_infinite (DejaDupBackend* self);
void deja_dup_backend_add_argv (DejaDupBackend* self, DejaDupToolJobMode mode, GList** argv);
static void deja_dup_backend_real_add_argv (DejaDupBackend* self, DejaDupToolJobMode mode, GList** argv);
DejaDupBackend* deja_dup_backend_clone (DejaDupBackend* self);
static DejaDupBackend* deja_dup_backend_real_clone (DejaDupBackend* self);
gchar* deja_dup_backend_get_default_type (void);
GType deja_dup_filtered_settings_get_type (void) G_GNUC_CONST;
DejaDupFilteredSettings* deja_dup_get_settings (const gchar* subdir);
#define DEJA_DUP_BACKEND_KEY "backend"
DejaDupBackend* deja_dup_backend_get_default (void);
DejaDupBackendS3* deja_dup_backend_s3_new (void);
DejaDupBackendS3* deja_dup_backend_s3_construct (GType object_type);
GType deja_dup_backend_s3_get_type (void) G_GNUC_CONST;
DejaDupBackendGCS* deja_dup_backend_gcs_new (void);
DejaDupBackendGCS* deja_dup_backend_gcs_construct (GType object_type);
GType deja_dup_backend_gcs_get_type (void) G_GNUC_CONST;
DejaDupBackendGDrive* deja_dup_backend_gdrive_new (void);
DejaDupBackendGDrive* deja_dup_backend_gdrive_construct (GType object_type);
GType deja_dup_backend_gdrive_get_type (void) G_GNUC_CONST;
DejaDupBackendU1* deja_dup_backend_u1_new (void);
DejaDupBackendU1* deja_dup_backend_u1_construct (GType object_type);
GType deja_dup_backend_u1_get_type (void) G_GNUC_CONST;
DejaDupBackendRackspace* deja_dup_backend_rackspace_new (void);
DejaDupBackendRackspace* deja_dup_backend_rackspace_construct (GType object_type);
GType deja_dup_backend_rackspace_get_type (void) G_GNUC_CONST;
DejaDupBackendOpenstack* deja_dup_backend_openstack_new (void);
DejaDupBackendOpenstack* deja_dup_backend_openstack_construct (GType object_type);
GType deja_dup_backend_openstack_get_type (void) G_GNUC_CONST;
DejaDupBackendFile* deja_dup_backend_file_new (void);
DejaDupBackendFile* deja_dup_backend_file_construct (GType object_type);
GType deja_dup_backend_file_get_type (void) G_GNUC_CONST;
DejaDupBackendAuto* deja_dup_backend_auto_new (void);
DejaDupBackendAuto* deja_dup_backend_auto_construct (GType object_type);
GType deja_dup_backend_auto_get_type (void) G_GNUC_CONST;
DejaDupBackend* deja_dup_backend_construct (GType object_type);
GMountOperation* deja_dup_backend_get_mount_op (DejaDupBackend* self);
void deja_dup_backend_set_mount_op (DejaDupBackend* self, GMountOperation* value);
static void g_cclosure_user_marshal_VOID__BOOLEAN_POINTER_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void deja_dup_backend_finalize (GObject* obj);
static void _vala_deja_dup_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_deja_dup_backend_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gboolean deja_dup_backend_real_is_native (DejaDupBackend* self) {
	g_critical ("Type `%s' does not implement abstract method `deja_dup_backend_is_native'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


gboolean deja_dup_backend_is_native (DejaDupBackend* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DEJA_DUP_BACKEND_GET_CLASS (self)->is_native (self);
}


static GIcon* deja_dup_backend_real_get_icon (DejaDupBackend* self) {
	GIcon* result = NULL;
	result = NULL;
	return result;
}


GIcon* deja_dup_backend_get_icon (DejaDupBackend* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return DEJA_DUP_BACKEND_GET_CLASS (self)->get_icon (self);
}


static gchar* deja_dup_backend_real_get_location (DejaDupBackend* self, gboolean* as_root) {
	g_critical ("Type `%s' does not implement abstract method `deja_dup_backend_get_location'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar* deja_dup_backend_get_location (DejaDupBackend* self, gboolean* as_root) {
	g_return_val_if_fail (self != NULL, NULL);
	return DEJA_DUP_BACKEND_GET_CLASS (self)->get_location (self, as_root);
}


static gchar* deja_dup_backend_real_get_location_pretty (DejaDupBackend* self) {
	g_critical ("Type `%s' does not implement abstract method `deja_dup_backend_get_location_pretty'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


gchar* deja_dup_backend_get_location_pretty (DejaDupBackend* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return DEJA_DUP_BACKEND_GET_CLASS (self)->get_location_pretty (self);
}


static void deja_dup_backend_real_is_ready_data_free (gpointer _data) {
	DejaDupBackendIsReadyData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendIsReadyData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void deja_dup_backend_real_is_ready (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendIsReadyData* _data_;
	DejaDupBackend* _tmp0_ = NULL;
	_data_ = g_slice_new0 (DejaDupBackendIsReadyData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_real_is_ready);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_real_is_ready_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_real_is_ready_co (_data_);
}


static gboolean deja_dup_backend_real_is_ready_finish (DejaDupBackend* self, GAsyncResult* _res_, gchar** when) {
	gboolean result;
	DejaDupBackendIsReadyData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	if (when) {
		*when = _data_->when;
	} else {
		_g_free0 (_data_->when);
	}
	_data_->when = NULL;
	result = _data_->result;
	return result;
}


static gboolean deja_dup_backend_real_is_ready_co (DejaDupBackendIsReadyData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_g_free0 (_data_->when);
	_data_->when = NULL;
	_data_->result = TRUE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void deja_dup_backend_is_ready (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DEJA_DUP_BACKEND_GET_CLASS (self)->is_ready (self, _callback_, _user_data_);
}


gboolean deja_dup_backend_is_ready_finish (DejaDupBackend* self, GAsyncResult* _res_, gchar** when) {
	return DEJA_DUP_BACKEND_GET_CLASS (self)->is_ready_finish (self, _res_, when);
}


static void deja_dup_backend_real_get_envp_data_free (gpointer _data) {
	DejaDupBackendGetEnvpData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendGetEnvpData, _data_);
}


static void deja_dup_backend_real_get_envp (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendGetEnvpData* _data_;
	DejaDupBackend* _tmp0_ = NULL;
	_data_ = g_slice_new0 (DejaDupBackendGetEnvpData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_real_get_envp);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_real_get_envp_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	deja_dup_backend_real_get_envp_co (_data_);
}


static void deja_dup_backend_real_get_envp_finish (DejaDupBackend* self, GAsyncResult* _res_, GError** error) {
	DejaDupBackendGetEnvpData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


static gboolean deja_dup_backend_real_get_envp_co (DejaDupBackendGetEnvpData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = NULL;
	g_signal_emit_by_name (_data_->self, "envp-ready", TRUE, _data_->_tmp0_, NULL);
	__g_list_free__g_free0_0 (_data_->_tmp0_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void deja_dup_backend_get_envp (DejaDupBackend* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DEJA_DUP_BACKEND_GET_CLASS (self)->get_envp (self, _callback_, _user_data_);
}


void deja_dup_backend_get_envp_finish (DejaDupBackend* self, GAsyncResult* _res_, GError** error) {
	DEJA_DUP_BACKEND_GET_CLASS (self)->get_envp_finish (self, _res_, error);
}


static void deja_dup_backend_real_get_space_data_free (gpointer _data) {
	DejaDupBackendGetSpaceData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (DejaDupBackendGetSpaceData, _data_);
}


static void deja_dup_backend_real_get_space (DejaDupBackend* self, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DejaDupBackendGetSpaceData* _data_;
	DejaDupBackend* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	_data_ = g_slice_new0 (DejaDupBackendGetSpaceData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, deja_dup_backend_real_get_space);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, deja_dup_backend_real_get_space_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = free;
	_data_->free = _tmp1_;
	deja_dup_backend_real_get_space_co (_data_);
}


static guint64 deja_dup_backend_real_get_space_finish (DejaDupBackend* self, GAsyncResult* _res_) {
	guint64 result;
	DejaDupBackendGetSpaceData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	return result;
}


static gboolean deja_dup_backend_real_get_space_co (DejaDupBackendGetSpaceData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = 0ULL;
	_data_->_tmp0_ = deja_dup_backend_INFINITE_SPACE;
	_data_->result = _data_->_tmp0_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void deja_dup_backend_get_space (DejaDupBackend* self, gboolean free, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	DEJA_DUP_BACKEND_GET_CLASS (self)->get_space (self, free, _callback_, _user_data_);
}


guint64 deja_dup_backend_get_space_finish (DejaDupBackend* self, GAsyncResult* _res_) {
	return DEJA_DUP_BACKEND_GET_CLASS (self)->get_space_finish (self, _res_);
}


static gboolean deja_dup_backend_real_space_can_be_infinite (DejaDupBackend* self) {
	gboolean result = FALSE;
	result = TRUE;
	return result;
}


gboolean deja_dup_backend_space_can_be_infinite (DejaDupBackend* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return DEJA_DUP_BACKEND_GET_CLASS (self)->space_can_be_infinite (self);
}


static void deja_dup_backend_real_add_argv (DejaDupBackend* self, DejaDupToolJobMode mode, GList** argv) {
}


void deja_dup_backend_add_argv (DejaDupBackend* self, DejaDupToolJobMode mode, GList** argv) {
	g_return_if_fail (self != NULL);
	DEJA_DUP_BACKEND_GET_CLASS (self)->add_argv (self, mode, argv);
}


static DejaDupBackend* deja_dup_backend_real_clone (DejaDupBackend* self) {
	g_critical ("Type `%s' does not implement abstract method `deja_dup_backend_clone'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


DejaDupBackend* deja_dup_backend_clone (DejaDupBackend* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return DEJA_DUP_BACKEND_GET_CLASS (self)->clone (self);
}


gchar* deja_dup_backend_get_default_type (void) {
	gchar* result = NULL;
	DejaDupFilteredSettings* settings = NULL;
	DejaDupFilteredSettings* _tmp0_ = NULL;
	gchar* backend = NULL;
	DejaDupFilteredSettings* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_ = NULL;
	_tmp0_ = deja_dup_get_settings (NULL);
	settings = _tmp0_;
	_tmp1_ = settings;
	_tmp2_ = g_settings_get_string ((GSettings*) _tmp1_, DEJA_DUP_BACKEND_KEY);
	backend = _tmp2_;
	_tmp10_ = backend;
	if (g_strcmp0 (_tmp10_, "auto") != 0) {
		const gchar* _tmp11_ = NULL;
		_tmp11_ = backend;
		_tmp9_ = g_strcmp0 (_tmp11_, "s3") != 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		const gchar* _tmp12_ = NULL;
		_tmp12_ = backend;
		_tmp8_ = g_strcmp0 (_tmp12_, "gcs") != 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		const gchar* _tmp13_ = NULL;
		_tmp13_ = backend;
		_tmp7_ = g_strcmp0 (_tmp13_, "gdrive") != 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		const gchar* _tmp14_ = NULL;
		_tmp14_ = backend;
		_tmp6_ = g_strcmp0 (_tmp14_, "rackspace") != 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		const gchar* _tmp15_ = NULL;
		_tmp15_ = backend;
		_tmp5_ = g_strcmp0 (_tmp15_, "openstack") != 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		const gchar* _tmp16_ = NULL;
		_tmp16_ = backend;
		_tmp4_ = g_strcmp0 (_tmp16_, "u1") != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		const gchar* _tmp17_ = NULL;
		_tmp17_ = backend;
		_tmp3_ = g_strcmp0 (_tmp17_, "file") != 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gchar* _tmp18_ = NULL;
		_tmp18_ = g_strdup ("auto");
		_g_free0 (backend);
		backend = _tmp18_;
	}
	result = backend;
	_g_object_unref0 (settings);
	return result;
}


DejaDupBackend* deja_dup_backend_get_default (void) {
	DejaDupBackend* result = NULL;
	gchar* backend_name = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = deja_dup_backend_get_default_type ();
	backend_name = _tmp0_;
	_tmp1_ = backend_name;
	if (g_strcmp0 (_tmp1_, "s3") == 0) {
		DejaDupBackendS3* _tmp2_ = NULL;
		_tmp2_ = deja_dup_backend_s3_new ();
		result = (DejaDupBackend*) _tmp2_;
		_g_free0 (backend_name);
		return result;
	} else {
		const gchar* _tmp3_ = NULL;
		_tmp3_ = backend_name;
		if (g_strcmp0 (_tmp3_, "gcs") == 0) {
			DejaDupBackendGCS* _tmp4_ = NULL;
			_tmp4_ = deja_dup_backend_gcs_new ();
			result = (DejaDupBackend*) _tmp4_;
			_g_free0 (backend_name);
			return result;
		} else {
			const gchar* _tmp5_ = NULL;
			_tmp5_ = backend_name;
			if (g_strcmp0 (_tmp5_, "gdrive") == 0) {
				DejaDupBackendGDrive* _tmp6_ = NULL;
				_tmp6_ = deja_dup_backend_gdrive_new ();
				result = (DejaDupBackend*) _tmp6_;
				_g_free0 (backend_name);
				return result;
			} else {
				const gchar* _tmp7_ = NULL;
				_tmp7_ = backend_name;
				if (g_strcmp0 (_tmp7_, "u1") == 0) {
					DejaDupBackendU1* _tmp8_ = NULL;
					_tmp8_ = deja_dup_backend_u1_new ();
					result = (DejaDupBackend*) _tmp8_;
					_g_free0 (backend_name);
					return result;
				} else {
					const gchar* _tmp9_ = NULL;
					_tmp9_ = backend_name;
					if (g_strcmp0 (_tmp9_, "rackspace") == 0) {
						DejaDupBackendRackspace* _tmp10_ = NULL;
						_tmp10_ = deja_dup_backend_rackspace_new ();
						result = (DejaDupBackend*) _tmp10_;
						_g_free0 (backend_name);
						return result;
					} else {
						const gchar* _tmp11_ = NULL;
						_tmp11_ = backend_name;
						if (g_strcmp0 (_tmp11_, "openstack") == 0) {
							DejaDupBackendOpenstack* _tmp12_ = NULL;
							_tmp12_ = deja_dup_backend_openstack_new ();
							result = (DejaDupBackend*) _tmp12_;
							_g_free0 (backend_name);
							return result;
						} else {
							const gchar* _tmp13_ = NULL;
							_tmp13_ = backend_name;
							if (g_strcmp0 (_tmp13_, "file") == 0) {
								DejaDupBackendFile* _tmp14_ = NULL;
								_tmp14_ = deja_dup_backend_file_new ();
								result = (DejaDupBackend*) _tmp14_;
								_g_free0 (backend_name);
								return result;
							} else {
								DejaDupBackendAuto* _tmp15_ = NULL;
								_tmp15_ = deja_dup_backend_auto_new ();
								result = (DejaDupBackend*) _tmp15_;
								_g_free0 (backend_name);
								return result;
							}
						}
					}
				}
			}
		}
	}
	_g_free0 (backend_name);
}


DejaDupBackend* deja_dup_backend_construct (GType object_type) {
	DejaDupBackend * self = NULL;
	self = (DejaDupBackend*) g_object_new (object_type, NULL);
	return self;
}


GMountOperation* deja_dup_backend_get_mount_op (DejaDupBackend* self) {
	GMountOperation* result;
	GMountOperation* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mount_op;
	result = _tmp0_;
	return result;
}


void deja_dup_backend_set_mount_op (DejaDupBackend* self, GMountOperation* value) {
	GMountOperation* _tmp0_ = NULL;
	GMountOperation* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_mount_op);
	self->priv->_mount_op = _tmp1_;
	g_object_notify ((GObject *) self, "mount-op");
}


static void g_cclosure_user_marshal_VOID__BOOLEAN_POINTER_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_POINTER_STRING) (gpointer data1, gboolean arg_1, gpointer arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_POINTER_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_POINTER_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_string (param_values + 3), data2);
}


static void g_cclosure_user_marshal_VOID__STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), data2);
}


static void deja_dup_backend_class_init (DejaDupBackendClass * klass) {
	deja_dup_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupBackendPrivate));
	((DejaDupBackendClass *) klass)->is_native = deja_dup_backend_real_is_native;
	((DejaDupBackendClass *) klass)->get_icon = deja_dup_backend_real_get_icon;
	((DejaDupBackendClass *) klass)->get_location = deja_dup_backend_real_get_location;
	((DejaDupBackendClass *) klass)->get_location_pretty = deja_dup_backend_real_get_location_pretty;
	((DejaDupBackendClass *) klass)->is_ready = deja_dup_backend_real_is_ready;
	((DejaDupBackendClass *) klass)->is_ready_finish = deja_dup_backend_real_is_ready_finish;
	((DejaDupBackendClass *) klass)->get_envp = deja_dup_backend_real_get_envp;
	((DejaDupBackendClass *) klass)->get_envp_finish = deja_dup_backend_real_get_envp_finish;
	((DejaDupBackendClass *) klass)->get_space = deja_dup_backend_real_get_space;
	((DejaDupBackendClass *) klass)->get_space_finish = deja_dup_backend_real_get_space_finish;
	((DejaDupBackendClass *) klass)->space_can_be_infinite = deja_dup_backend_real_space_can_be_infinite;
	((DejaDupBackendClass *) klass)->add_argv = deja_dup_backend_real_add_argv;
	((DejaDupBackendClass *) klass)->clone = deja_dup_backend_real_clone;
	G_OBJECT_CLASS (klass)->get_property = _vala_deja_dup_backend_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_deja_dup_backend_set_property;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_backend_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_BACKEND_MOUNT_OP, g_param_spec_object ("mount-op", "mount-op", "mount-op", g_mount_operation_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("envp_ready", DEJA_DUP_TYPE_BACKEND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_POINTER_STRING, G_TYPE_NONE, 3, G_TYPE_BOOLEAN, G_TYPE_POINTER, G_TYPE_STRING);
	g_signal_new ("pause_op", DEJA_DUP_TYPE_BACKEND, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_STRING);
	deja_dup_backend_INFINITE_SPACE = G_MAXUINT64;
}


static void deja_dup_backend_instance_init (DejaDupBackend * self) {
	self->priv = DEJA_DUP_BACKEND_GET_PRIVATE (self);
}


static void deja_dup_backend_finalize (GObject* obj) {
	DejaDupBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DEJA_DUP_TYPE_BACKEND, DejaDupBackend);
	_g_object_unref0 (self->priv->_mount_op);
	G_OBJECT_CLASS (deja_dup_backend_parent_class)->finalize (obj);
}


GType deja_dup_backend_get_type (void) {
	static volatile gsize deja_dup_backend_type_id__volatile = 0;
	if (g_once_init_enter (&deja_dup_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupBackend), 0, (GInstanceInitFunc) deja_dup_backend_instance_init, NULL };
		GType deja_dup_backend_type_id;
		deja_dup_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupBackend", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&deja_dup_backend_type_id__volatile, deja_dup_backend_type_id);
	}
	return deja_dup_backend_type_id__volatile;
}


static void _vala_deja_dup_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DEJA_DUP_TYPE_BACKEND, DejaDupBackend);
	switch (property_id) {
		case DEJA_DUP_BACKEND_MOUNT_OP:
		g_value_set_object (value, deja_dup_backend_get_mount_op (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_deja_dup_backend_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DEJA_DUP_TYPE_BACKEND, DejaDupBackend);
	switch (property_id) {
		case DEJA_DUP_BACKEND_MOUNT_OP:
		deja_dup_backend_set_mount_op (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



