/* math-converter.c generated by valac 0.34.4, the Vala compiler
 * generated from math-converter.vala, do not modify */

/*
 * Copyright (C) 2008-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "libcalculator.h"
#include <stdlib.h>
#include <string.h>


#define TYPE_MATH_CONVERTER (math_converter_get_type ())
#define MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MATH_CONVERTER, MathConverter))
#define MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MATH_CONVERTER, MathConverterClass))
#define IS_MATH_CONVERTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MATH_CONVERTER))
#define IS_MATH_CONVERTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MATH_CONVERTER))
#define MATH_CONVERTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MATH_CONVERTER, MathConverterClass))

typedef struct _MathConverter MathConverter;
typedef struct _MathConverterClass MathConverterClass;
typedef struct _MathConverterPrivate MathConverterPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

struct _MathConverter {
	GtkGrid parent_instance;
	MathConverterPrivate * priv;
};

struct _MathConverterClass {
	GtkGridClass parent_class;
};

struct _MathConverterPrivate {
	MathEquation* equation;
	gchar* category;
	GtkCellRendererText* from_renderer;
	GtkComboBox* from_combo;
	GtkComboBox* to_combo;
	GtkLabel* result_label;
};


static gpointer math_converter_parent_class = NULL;

GType math_converter_get_type (void) G_GNUC_CONST;
#define MATH_CONVERTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MATH_CONVERTER, MathConverterPrivate))
enum  {
	MATH_CONVERTER_DUMMY_PROPERTY
};
MathConverter* math_converter_new (MathEquation* equation);
MathConverter* math_converter_construct (GType object_type, MathEquation* equation);
void math_converter_set_equation (MathConverter* self, MathEquation* equation);
static void __lambda10_ (MathConverter* self, GParamSpec* pspec);
static void math_converter_update_result_label (MathConverter* self);
static void ___lambda10__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void math_converter_set_category (MathConverter* self, const gchar* category);
static void math_converter_update_from_model (MathConverter* self);
gchar* math_converter_get_category (MathConverter* self);
void math_converter_set_conversion (MathConverter* self, const gchar* unit_a, const gchar* unit_b);
static gboolean math_converter_set_active_unit (MathConverter* self, GtkComboBox* combo, GtkTreeIter* iter, Unit* unit);
void math_converter_get_conversion (MathConverter* self, Unit** from_unit, Unit** to_unit);
static Number* math_converter_convert_equation (MathConverter* self, Number* x);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static gboolean math_converter_iter_is_unit (MathConverter* self, GtkTreeModel* model, GtkTreeIter* iter, Unit* unit);
static void math_converter_from_combobox_changed_cb (MathConverter* self);
static void _math_converter_from_combobox_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void math_converter_to_combobox_changed_cb (MathConverter* self);
static void _math_converter_to_combobox_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void math_converter_from_cell_data_func (MathConverter* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter);
static void math_converter_swap_button_clicked_cb (MathConverter* self);
static void _math_converter_swap_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
static GObject * math_converter_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _math_converter_from_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self);
static void _math_converter___lambda11_ (MathConverter* self);
static void __math_converter___lambda11__currency_manager_updated (CurrencyManager* _sender, gpointer self);
static void math_converter_finalize (GObject* obj);


MathConverter* math_converter_construct (GType object_type, MathEquation* equation) {
	MathConverter * self = NULL;
	MathEquation* _tmp0_ = NULL;
	g_return_val_if_fail (equation != NULL, NULL);
	self = (MathConverter*) g_object_new (object_type, NULL);
	_tmp0_ = equation;
	math_converter_set_equation (self, _tmp0_);
	return self;
}


MathConverter* math_converter_new (MathEquation* equation) {
	return math_converter_construct (TYPE_MATH_CONVERTER, equation);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda10_ (MathConverter* self, GParamSpec* pspec) {
	g_return_if_fail (pspec != NULL);
	math_converter_update_result_label (self);
}


static void ___lambda10__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda10_ ((MathConverter*) self, pspec);
}


void math_converter_set_equation (MathConverter* self, MathEquation* equation) {
	MathEquation* _tmp0_ = NULL;
	MathEquation* _tmp1_ = NULL;
	MathEquation* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (equation != NULL);
	_tmp0_ = equation;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->equation);
	self->priv->equation = _tmp1_;
	_tmp2_ = equation;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::display", (GCallback) ___lambda10__g_object_notify, self, 0);
}


void math_converter_set_category (MathConverter* self, const gchar* category) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->category;
	_tmp1_ = category;
	if (g_strcmp0 (_tmp0_, _tmp1_) == 0) {
		return;
	}
	_tmp2_ = category;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->category);
	self->priv->category = _tmp3_;
	math_converter_update_from_model (self);
}


gchar* math_converter_get_category (MathConverter* self) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->category;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}


void math_converter_set_conversion (MathConverter* self, const gchar* unit_a, const gchar* unit_b) {
	Unit* ua = NULL;
	UnitManager* _tmp0_ = NULL;
	UnitManager* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	Unit* _tmp3_ = NULL;
	Unit* _tmp4_ = NULL;
	Unit* ub = NULL;
	UnitManager* _tmp5_ = NULL;
	UnitManager* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	Unit* _tmp8_ = NULL;
	Unit* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	Unit* _tmp11_ = NULL;
	GtkComboBox* _tmp26_ = NULL;
	Unit* _tmp27_ = NULL;
	GtkComboBox* _tmp28_ = NULL;
	Unit* _tmp29_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (unit_a != NULL);
	g_return_if_fail (unit_b != NULL);
	_tmp0_ = unit_manager_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = unit_a;
	_tmp3_ = unit_manager_get_unit_by_name (_tmp1_, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp1_);
	ua = _tmp4_;
	_tmp5_ = unit_manager_get_default ();
	_tmp6_ = _tmp5_;
	_tmp7_ = unit_b;
	_tmp8_ = unit_manager_get_unit_by_name (_tmp6_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp6_);
	ub = _tmp9_;
	_tmp11_ = ua;
	if (_tmp11_ == NULL) {
		_tmp10_ = TRUE;
	} else {
		Unit* _tmp12_ = NULL;
		_tmp12_ = ub;
		_tmp10_ = _tmp12_ == NULL;
	}
	if (_tmp10_) {
		GtkTreeModel* model = NULL;
		GtkComboBox* _tmp13_ = NULL;
		GtkTreeModel* _tmp14_ = NULL;
		GtkTreeModel* _tmp15_ = NULL;
		GtkTreeIter iter = {0};
		GtkTreeModel* _tmp16_ = NULL;
		GtkTreeIter _tmp17_ = {0};
		gboolean _tmp18_ = FALSE;
		_tmp13_ = self->priv->from_combo;
		_tmp14_ = gtk_combo_box_get_model (_tmp13_);
		_tmp15_ = _g_object_ref0 (_tmp14_);
		model = _tmp15_;
		_tmp16_ = model;
		_tmp18_ = gtk_tree_model_get_iter_first (_tmp16_, &_tmp17_);
		iter = _tmp17_;
		if (_tmp18_) {
			GtkTreeIter child_iter = {0};
			GtkComboBox* _tmp24_ = NULL;
			GtkTreeIter _tmp25_ = {0};
			while (TRUE) {
				GtkTreeModel* _tmp19_ = NULL;
				GtkTreeIter _tmp20_ = {0};
				GtkTreeIter _tmp21_ = {0};
				gboolean _tmp22_ = FALSE;
				GtkTreeIter _tmp23_ = {0};
				_tmp19_ = model;
				_tmp20_ = iter;
				_tmp22_ = gtk_tree_model_iter_children (_tmp19_, &_tmp21_, &_tmp20_);
				child_iter = _tmp21_;
				if (!_tmp22_) {
					break;
				}
				_tmp23_ = child_iter;
				iter = _tmp23_;
			}
			_tmp24_ = self->priv->from_combo;
			_tmp25_ = iter;
			gtk_combo_box_set_active_iter (_tmp24_, &_tmp25_);
		}
		_g_object_unref0 (model);
		_g_object_unref0 (ub);
		_g_object_unref0 (ua);
		return;
	}
	_tmp26_ = self->priv->from_combo;
	_tmp27_ = ua;
	math_converter_set_active_unit (self, _tmp26_, NULL, _tmp27_);
	_tmp28_ = self->priv->to_combo;
	_tmp29_ = ub;
	math_converter_set_active_unit (self, _tmp28_, NULL, _tmp29_);
	_g_object_unref0 (ub);
	_g_object_unref0 (ua);
}


void math_converter_get_conversion (MathConverter* self, Unit** from_unit, Unit** to_unit) {
	Unit* _vala_from_unit = NULL;
	Unit* _vala_to_unit = NULL;
	GtkTreeIter from_iter = {0};
	GtkTreeIter to_iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	GtkComboBox* _tmp2_ = NULL;
	GtkTreeIter _tmp3_ = {0};
	GtkComboBox* _tmp4_ = NULL;
	GtkTreeModel* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	GtkComboBox* _tmp7_ = NULL;
	GtkTreeModel* _tmp8_ = NULL;
	GtkTreeIter _tmp9_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->from_combo;
	gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	from_iter = _tmp1_;
	_tmp2_ = self->priv->to_combo;
	gtk_combo_box_get_active_iter (_tmp2_, &_tmp3_);
	to_iter = _tmp3_;
	_tmp4_ = self->priv->from_combo;
	_tmp5_ = gtk_combo_box_get_model (_tmp4_);
	_tmp6_ = from_iter;
	gtk_tree_model_get (_tmp5_, &_tmp6_, 2, &_vala_from_unit, -1, -1);
	_tmp7_ = self->priv->to_combo;
	_tmp8_ = gtk_combo_box_get_model (_tmp7_);
	_tmp9_ = to_iter;
	gtk_tree_model_get (_tmp8_, &_tmp9_, 2, &_vala_to_unit, -1, -1);
	if (from_unit) {
		*from_unit = _vala_from_unit;
	} else {
		_g_object_unref0 (_vala_from_unit);
	}
	if (to_unit) {
		*to_unit = _vala_to_unit;
	} else {
		_g_object_unref0 (_vala_to_unit);
	}
}


static void math_converter_update_result_label (MathConverter* self) {
	Number* x = NULL;
	MathEquation* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Number* z = NULL;
	Number* _tmp4_ = NULL;
	Number* _tmp5_ = NULL;
	GtkLabel* _tmp6_ = NULL;
	Number* _tmp7_ = NULL;
	Number* _tmp8_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = math_equation_get_number (_tmp0_);
	_tmp2_ = _tmp1_;
	x = _tmp2_;
	_tmp3_ = x;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (x);
		return;
	}
	_tmp4_ = x;
	_tmp5_ = math_converter_convert_equation (self, _tmp4_);
	z = _tmp5_;
	_tmp6_ = self->priv->result_label;
	_tmp7_ = z;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, _tmp7_ != NULL);
	_tmp8_ = z;
	if (_tmp8_ != NULL) {
		Unit* source_unit = NULL;
		Unit* target_unit = NULL;
		Unit* _tmp9_ = NULL;
		Unit* _tmp10_ = NULL;
		gchar* source_text = NULL;
		Unit* _tmp11_ = NULL;
		Number* _tmp12_ = NULL;
		gchar* _tmp13_ = NULL;
		gchar* target_text = NULL;
		Unit* _tmp14_ = NULL;
		Number* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		GtkLabel* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		gchar* _tmp20_ = NULL;
		gchar* _tmp21_ = NULL;
		math_converter_get_conversion (self, &_tmp9_, &_tmp10_);
		_g_object_unref0 (source_unit);
		source_unit = _tmp9_;
		_g_object_unref0 (target_unit);
		target_unit = _tmp10_;
		_tmp11_ = source_unit;
		_tmp12_ = x;
		_tmp13_ = unit_format (_tmp11_, _tmp12_);
		source_text = _tmp13_;
		_tmp14_ = target_unit;
		_tmp15_ = z;
		_tmp16_ = unit_format (_tmp14_, _tmp15_);
		target_text = _tmp16_;
		_tmp17_ = self->priv->result_label;
		_tmp18_ = source_text;
		_tmp19_ = target_text;
		_tmp20_ = g_strdup_printf ("%s = %s", _tmp18_, _tmp19_);
		_tmp21_ = _tmp20_;
		gtk_label_set_text (_tmp17_, _tmp21_);
		_g_free0 (_tmp21_);
		_g_free0 (target_text);
		_g_free0 (source_text);
		_g_object_unref0 (target_unit);
		_g_object_unref0 (source_unit);
	}
	_g_object_unref0 (z);
	_g_object_unref0 (x);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static void math_converter_update_from_model (MathConverter* self) {
	GtkTreeStore* from_model = NULL;
	GtkTreeStore* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkComboBox* _tmp49_ = NULL;
	GtkTreeStore* _tmp50_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_tree_store_new (3, G_TYPE_STRING, TYPE_UNIT_CATEGORY, TYPE_UNIT);
	from_model = _tmp0_;
	_tmp1_ = self->priv->category;
	if (_tmp1_ == NULL) {
		GList* categories = NULL;
		UnitManager* _tmp2_ = NULL;
		UnitManager* _tmp3_ = NULL;
		GList* _tmp4_ = NULL;
		GList* _tmp5_ = NULL;
		GList* _tmp6_ = NULL;
		_tmp2_ = unit_manager_get_default ();
		_tmp3_ = _tmp2_;
		_tmp4_ = unit_manager_get_categories (_tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		categories = _tmp5_;
		_tmp6_ = categories;
		{
			GList* category_collection = NULL;
			GList* category_it = NULL;
			category_collection = _tmp6_;
			for (category_it = category_collection; category_it != NULL; category_it = category_it->next) {
				UnitCategory* _tmp7_ = NULL;
				UnitCategory* category = NULL;
				_tmp7_ = _g_object_ref0 ((UnitCategory*) category_it->data);
				category = _tmp7_;
				{
					GtkTreeIter parent = {0};
					GtkTreeStore* _tmp8_ = NULL;
					GtkTreeIter _tmp9_ = {0};
					GtkTreeStore* _tmp10_ = NULL;
					GtkTreeIter _tmp11_ = {0};
					UnitCategory* _tmp12_ = NULL;
					gchar* _tmp13_ = NULL;
					gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					UnitCategory* _tmp16_ = NULL;
					UnitCategory* _tmp17_ = NULL;
					GList* _tmp18_ = NULL;
					_tmp8_ = from_model;
					gtk_tree_store_append (_tmp8_, &_tmp9_, NULL);
					parent = _tmp9_;
					_tmp10_ = from_model;
					_tmp11_ = parent;
					_tmp12_ = category;
					_tmp13_ = unit_category_get_display_name (_tmp12_);
					_tmp14_ = _tmp13_;
					_tmp15_ = _tmp14_;
					_tmp16_ = category;
					gtk_tree_store_set (_tmp10_, &_tmp11_, 0, _tmp15_, 1, _tmp16_, -1, -1);
					_g_free0 (_tmp15_);
					_tmp17_ = category;
					_tmp18_ = unit_category_get_units (_tmp17_);
					{
						GList* unit_collection = NULL;
						GList* unit_it = NULL;
						unit_collection = _tmp18_;
						for (unit_it = unit_collection; unit_it != NULL; unit_it = unit_it->next) {
							Unit* _tmp19_ = NULL;
							Unit* unit = NULL;
							_tmp19_ = _g_object_ref0 ((Unit*) unit_it->data);
							unit = _tmp19_;
							{
								GtkTreeIter iter = {0};
								GtkTreeStore* _tmp20_ = NULL;
								GtkTreeIter _tmp21_ = {0};
								GtkTreeIter _tmp22_ = {0};
								GtkTreeStore* _tmp23_ = NULL;
								GtkTreeIter _tmp24_ = {0};
								Unit* _tmp25_ = NULL;
								gchar* _tmp26_ = NULL;
								gchar* _tmp27_ = NULL;
								gchar* _tmp28_ = NULL;
								UnitCategory* _tmp29_ = NULL;
								Unit* _tmp30_ = NULL;
								_tmp20_ = from_model;
								_tmp21_ = parent;
								gtk_tree_store_append (_tmp20_, &_tmp22_, &_tmp21_);
								iter = _tmp22_;
								_tmp23_ = from_model;
								_tmp24_ = iter;
								_tmp25_ = unit;
								_tmp26_ = unit_get_display_name (_tmp25_);
								_tmp27_ = _tmp26_;
								_tmp28_ = _tmp27_;
								_tmp29_ = category;
								_tmp30_ = unit;
								gtk_tree_store_set (_tmp23_, &_tmp24_, 0, _tmp28_, 1, _tmp29_, 2, _tmp30_, -1, -1);
								_g_free0 (_tmp28_);
								_g_object_unref0 (unit);
							}
						}
					}
					_g_object_unref0 (category);
				}
			}
		}
		__g_list_free__g_object_unref0_0 (categories);
	} else {
		UnitCategory* c = NULL;
		UnitManager* _tmp31_ = NULL;
		UnitManager* _tmp32_ = NULL;
		const gchar* _tmp33_ = NULL;
		UnitCategory* _tmp34_ = NULL;
		UnitCategory* _tmp35_ = NULL;
		UnitCategory* _tmp36_ = NULL;
		GList* _tmp37_ = NULL;
		_tmp31_ = unit_manager_get_default ();
		_tmp32_ = _tmp31_;
		_tmp33_ = self->priv->category;
		_tmp34_ = unit_manager_get_category (_tmp32_, _tmp33_);
		_tmp35_ = _tmp34_;
		_g_object_unref0 (_tmp32_);
		c = _tmp35_;
		_tmp36_ = c;
		_tmp37_ = unit_category_get_units (_tmp36_);
		{
			GList* unit_collection = NULL;
			GList* unit_it = NULL;
			unit_collection = _tmp37_;
			for (unit_it = unit_collection; unit_it != NULL; unit_it = unit_it->next) {
				Unit* _tmp38_ = NULL;
				Unit* unit = NULL;
				_tmp38_ = _g_object_ref0 ((Unit*) unit_it->data);
				unit = _tmp38_;
				{
					GtkTreeIter iter = {0};
					GtkTreeStore* _tmp39_ = NULL;
					GtkTreeIter _tmp40_ = {0};
					GtkTreeStore* _tmp41_ = NULL;
					GtkTreeIter _tmp42_ = {0};
					Unit* _tmp43_ = NULL;
					gchar* _tmp44_ = NULL;
					gchar* _tmp45_ = NULL;
					gchar* _tmp46_ = NULL;
					UnitCategory* _tmp47_ = NULL;
					Unit* _tmp48_ = NULL;
					_tmp39_ = from_model;
					gtk_tree_store_append (_tmp39_, &_tmp40_, NULL);
					iter = _tmp40_;
					_tmp41_ = from_model;
					_tmp42_ = iter;
					_tmp43_ = unit;
					_tmp44_ = unit_get_display_name (_tmp43_);
					_tmp45_ = _tmp44_;
					_tmp46_ = _tmp45_;
					_tmp47_ = c;
					_tmp48_ = unit;
					gtk_tree_store_set (_tmp41_, &_tmp42_, 0, _tmp46_, 1, _tmp47_, 2, _tmp48_, -1, -1);
					_g_free0 (_tmp46_);
					_g_object_unref0 (unit);
				}
			}
		}
		_g_object_unref0 (c);
	}
	_tmp49_ = self->priv->from_combo;
	_tmp50_ = from_model;
	gtk_combo_box_set_model (_tmp49_, (GtkTreeModel*) _tmp50_);
	_g_object_unref0 (from_model);
}


static gboolean math_converter_iter_is_unit (MathConverter* self, GtkTreeModel* model, GtkTreeIter* iter, Unit* unit) {
	gboolean result = FALSE;
	Unit* u = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	Unit* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	g_return_val_if_fail (unit != NULL, FALSE);
	_tmp0_ = model;
	_tmp1_ = *iter;
	gtk_tree_model_get (_tmp0_, &_tmp1_, 2, &u, -1, -1);
	_tmp2_ = unit;
	result = u == _tmp2_;
	_g_object_unref0 (u);
	return result;
}


static gboolean math_converter_set_active_unit (MathConverter* self, GtkComboBox* combo, GtkTreeIter* iter, Unit* unit) {
	gboolean result = FALSE;
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GtkTreeIter* _tmp4_ = NULL;
	GtkTreeIter child_iter = {0};
	GtkTreeModel* _tmp12_ = NULL;
	GtkTreeIter* _tmp13_ = NULL;
	GtkTreeIter _tmp14_ = {0};
	gboolean _tmp15_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (combo != NULL, FALSE);
	g_return_val_if_fail (unit != NULL, FALSE);
	_tmp0_ = combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	_tmp4_ = iter;
	if (_tmp4_ != NULL) {
		GtkTreeModel* _tmp5_ = NULL;
		GtkTreeIter* _tmp6_ = NULL;
		Unit* _tmp7_ = NULL;
		GtkTreeIter _tmp8_ = {0};
		gboolean _tmp9_ = FALSE;
		_tmp5_ = model;
		_tmp6_ = iter;
		_tmp7_ = unit;
		_tmp8_ = *_tmp6_;
		_tmp9_ = math_converter_iter_is_unit (self, _tmp5_, &_tmp8_, _tmp7_);
		_tmp3_ = _tmp9_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		GtkComboBox* _tmp10_ = NULL;
		GtkTreeIter* _tmp11_ = NULL;
		_tmp10_ = combo;
		_tmp11_ = iter;
		gtk_combo_box_set_active_iter (_tmp10_, _tmp11_);
		result = TRUE;
		_g_object_unref0 (model);
		return result;
	}
	_tmp12_ = model;
	_tmp13_ = iter;
	_tmp15_ = gtk_tree_model_iter_children (_tmp12_, &_tmp14_, _tmp13_);
	child_iter = _tmp14_;
	if (!_tmp15_) {
		result = FALSE;
		_g_object_unref0 (model);
		return result;
	}
	{
		gboolean _tmp16_ = FALSE;
		_tmp16_ = TRUE;
		while (TRUE) {
			GtkComboBox* _tmp19_ = NULL;
			GtkTreeIter _tmp20_ = {0};
			Unit* _tmp21_ = NULL;
			gboolean _tmp22_ = FALSE;
			if (!_tmp16_) {
				GtkTreeModel* _tmp17_ = NULL;
				gboolean _tmp18_ = FALSE;
				_tmp17_ = model;
				_tmp18_ = gtk_tree_model_iter_next (_tmp17_, &child_iter);
				if (!_tmp18_) {
					break;
				}
			}
			_tmp16_ = FALSE;
			_tmp19_ = combo;
			_tmp20_ = child_iter;
			_tmp21_ = unit;
			_tmp22_ = math_converter_set_active_unit (self, _tmp19_, &_tmp20_, _tmp21_);
			if (_tmp22_) {
				result = TRUE;
				_g_object_unref0 (model);
				return result;
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (model);
	return result;
}


static void math_converter_from_combobox_changed_cb (MathConverter* self) {
	UnitCategory* category = NULL;
	UnitCategory* to_category = NULL;
	Unit* unit = NULL;
	GtkTreeIter iter = {0};
	GtkTreeIter to_iter = {0};
	GtkTreeModel* model = NULL;
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeModel* _tmp2_ = NULL;
	GtkListStore* to_model = NULL;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkListStore* _tmp5_ = NULL;
	GtkComboBox* _tmp6_ = NULL;
	GtkTreeIter _tmp7_ = {0};
	gboolean _tmp8_ = FALSE;
	GtkTreeModel* _tmp9_ = NULL;
	GtkTreeIter _tmp10_ = {0};
	GtkComboBox* _tmp11_ = NULL;
	GtkTreeIter _tmp12_ = {0};
	gboolean _tmp13_ = FALSE;
	UnitCategory* _tmp16_ = NULL;
	UnitCategory* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	category = NULL;
	to_category = NULL;
	_tmp0_ = self->priv->from_combo;
	_tmp1_ = gtk_combo_box_get_model (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	model = _tmp2_;
	_tmp3_ = self->priv->to_combo;
	_tmp4_ = gtk_combo_box_get_model (_tmp3_);
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_list_store_get_type ()) ? ((GtkListStore*) _tmp4_) : NULL);
	to_model = _tmp5_;
	_tmp6_ = self->priv->from_combo;
	_tmp8_ = gtk_combo_box_get_active_iter (_tmp6_, &_tmp7_);
	iter = _tmp7_;
	if (!_tmp8_) {
		_g_object_unref0 (to_model);
		_g_object_unref0 (model);
		_g_object_unref0 (unit);
		_g_object_unref0 (to_category);
		_g_object_unref0 (category);
		return;
	}
	_tmp9_ = model;
	_tmp10_ = iter;
	gtk_tree_model_get (_tmp9_, &_tmp10_, 1, &category, 2, &unit, -1, -1);
	_tmp11_ = self->priv->to_combo;
	_tmp13_ = gtk_combo_box_get_active_iter (_tmp11_, &_tmp12_);
	to_iter = _tmp12_;
	if (_tmp13_) {
		GtkListStore* _tmp14_ = NULL;
		GtkTreeIter _tmp15_ = {0};
		_tmp14_ = to_model;
		_tmp15_ = to_iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp14_, &_tmp15_, 1, &to_category, -1);
	}
	_tmp16_ = category;
	_tmp17_ = to_category;
	if (_tmp16_ != _tmp17_) {
		GtkListStore* _tmp18_ = NULL;
		UnitCategory* _tmp19_ = NULL;
		GList* _tmp20_ = NULL;
		GtkComboBox* _tmp32_ = NULL;
		GtkListStore* _tmp33_ = NULL;
		GtkComboBox* _tmp34_ = NULL;
		_tmp18_ = gtk_list_store_new (3, G_TYPE_STRING, TYPE_UNIT_CATEGORY, TYPE_UNIT, -1);
		_g_object_unref0 (to_model);
		to_model = _tmp18_;
		_tmp19_ = category;
		_tmp20_ = unit_category_get_units (_tmp19_);
		{
			GList* u_collection = NULL;
			GList* u_it = NULL;
			u_collection = _tmp20_;
			for (u_it = u_collection; u_it != NULL; u_it = u_it->next) {
				Unit* _tmp21_ = NULL;
				Unit* u = NULL;
				_tmp21_ = _g_object_ref0 ((Unit*) u_it->data);
				u = _tmp21_;
				{
					GtkListStore* _tmp22_ = NULL;
					GtkTreeIter _tmp23_ = {0};
					GtkListStore* _tmp24_ = NULL;
					GtkTreeIter _tmp25_ = {0};
					Unit* _tmp26_ = NULL;
					gchar* _tmp27_ = NULL;
					gchar* _tmp28_ = NULL;
					gchar* _tmp29_ = NULL;
					UnitCategory* _tmp30_ = NULL;
					Unit* _tmp31_ = NULL;
					_tmp22_ = to_model;
					gtk_list_store_append (_tmp22_, &_tmp23_);
					iter = _tmp23_;
					_tmp24_ = to_model;
					_tmp25_ = iter;
					_tmp26_ = u;
					_tmp27_ = unit_get_display_name (_tmp26_);
					_tmp28_ = _tmp27_;
					_tmp29_ = _tmp28_;
					_tmp30_ = category;
					_tmp31_ = u;
					gtk_list_store_set (_tmp24_, &_tmp25_, 0, _tmp29_, 1, _tmp30_, 2, _tmp31_, -1, -1);
					_g_free0 (_tmp29_);
					_g_object_unref0 (u);
				}
			}
		}
		_tmp32_ = self->priv->to_combo;
		_tmp33_ = to_model;
		gtk_combo_box_set_model (_tmp32_, (GtkTreeModel*) _tmp33_);
		_tmp34_ = self->priv->to_combo;
		gtk_combo_box_set_active (_tmp34_, 0);
	}
	_g_object_unref0 (to_model);
	_g_object_unref0 (model);
	_g_object_unref0 (unit);
	_g_object_unref0 (to_category);
	_g_object_unref0 (category);
}


static void _math_converter_from_combobox_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	math_converter_from_combobox_changed_cb ((MathConverter*) self);
}


static void math_converter_to_combobox_changed_cb (MathConverter* self) {
	g_return_if_fail (self != NULL);
	math_converter_update_result_label (self);
	g_signal_emit_by_name (self, "changed");
}


static void _math_converter_to_combobox_changed_cb_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	math_converter_to_combobox_changed_cb ((MathConverter*) self);
}


static void math_converter_from_cell_data_func (MathConverter* self, GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter) {
	GtkCellRenderer* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_ = NULL;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (tree_model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = cell;
	_tmp1_ = tree_model;
	_tmp2_ = *iter;
	_tmp3_ = gtk_tree_model_iter_has_child (_tmp1_, &_tmp2_);
	g_object_set ((GObject*) _tmp0_, "sensitive", !_tmp3_, NULL);
}


static void math_converter_swap_button_clicked_cb (MathConverter* self) {
	Number* x = NULL;
	MathEquation* _tmp0_ = NULL;
	Number* _tmp1_ = NULL;
	Number* _tmp2_ = NULL;
	Number* _tmp3_ = NULL;
	Unit* from_unit = NULL;
	Unit* to_unit = NULL;
	Unit* _tmp9_ = NULL;
	Unit* _tmp10_ = NULL;
	GtkComboBox* _tmp11_ = NULL;
	GtkComboBox* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->equation;
	_tmp1_ = math_equation_get_number (_tmp0_);
	_tmp2_ = _tmp1_;
	x = _tmp2_;
	_tmp3_ = x;
	if (_tmp3_ != NULL) {
		Number* z = NULL;
		Number* _tmp4_ = NULL;
		Number* _tmp5_ = NULL;
		Number* _tmp6_ = NULL;
		_tmp4_ = x;
		_tmp5_ = math_converter_convert_equation (self, _tmp4_);
		z = _tmp5_;
		_tmp6_ = z;
		if (_tmp6_ != NULL) {
			MathEquation* _tmp7_ = NULL;
			Number* _tmp8_ = NULL;
			_tmp7_ = self->priv->equation;
			_tmp8_ = z;
			math_equation_set_number (_tmp7_, _tmp8_, (guint) 0);
		}
		_g_object_unref0 (z);
	}
	math_converter_get_conversion (self, &_tmp9_, &_tmp10_);
	_g_object_unref0 (from_unit);
	from_unit = _tmp9_;
	_g_object_unref0 (to_unit);
	to_unit = _tmp10_;
	_tmp11_ = self->priv->from_combo;
	math_converter_set_active_unit (self, _tmp11_, NULL, to_unit);
	_tmp12_ = self->priv->to_combo;
	math_converter_set_active_unit (self, _tmp12_, NULL, from_unit);
	math_converter_update_result_label (self);
	_g_object_unref0 (to_unit);
	_g_object_unref0 (from_unit);
	_g_object_unref0 (x);
}


static void _math_converter_swap_button_clicked_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	math_converter_swap_button_clicked_cb ((MathConverter*) self);
}


static Number* math_converter_convert_equation (MathConverter* self, Number* x) {
	Number* result = NULL;
	GtkTreeIter from_iter = {0};
	GtkTreeIter to_iter = {0};
	GtkComboBox* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkComboBox* _tmp3_ = NULL;
	GtkTreeIter _tmp4_ = {0};
	gboolean _tmp5_ = FALSE;
	UnitCategory* category = NULL;
	Unit* source_unit = NULL;
	Unit* target_unit = NULL;
	GtkComboBox* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	GtkTreeModel* _tmp8_ = NULL;
	GtkTreeIter _tmp9_ = {0};
	GtkComboBox* _tmp10_ = NULL;
	GtkTreeModel* _tmp11_ = NULL;
	GtkTreeModel* _tmp12_ = NULL;
	GtkTreeIter _tmp13_ = {0};
	UnitCategory* _tmp14_ = NULL;
	Number* _tmp15_ = NULL;
	Unit* _tmp16_ = NULL;
	Unit* _tmp17_ = NULL;
	Number* _tmp18_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (x != NULL, NULL);
	_tmp0_ = self->priv->from_combo;
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
	from_iter = _tmp1_;
	if (!_tmp2_) {
		result = NULL;
		return result;
	}
	_tmp3_ = self->priv->to_combo;
	_tmp5_ = gtk_combo_box_get_active_iter (_tmp3_, &_tmp4_);
	to_iter = _tmp4_;
	if (!_tmp5_) {
		result = NULL;
		return result;
	}
	_tmp6_ = self->priv->from_combo;
	_tmp7_ = gtk_combo_box_get_model (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = from_iter;
	gtk_tree_model_get (_tmp8_, &_tmp9_, 1, &category, 2, &source_unit, -1, -1);
	_tmp10_ = self->priv->to_combo;
	_tmp11_ = gtk_combo_box_get_model (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = to_iter;
	gtk_tree_model_get (_tmp12_, &_tmp13_, 2, &target_unit, -1, -1);
	_tmp14_ = category;
	_tmp15_ = x;
	_tmp16_ = source_unit;
	_tmp17_ = target_unit;
	_tmp18_ = unit_category_convert (_tmp14_, _tmp15_, _tmp16_, _tmp17_);
	result = _tmp18_;
	_g_object_unref0 (target_unit);
	_g_object_unref0 (source_unit);
	_g_object_unref0 (category);
	return result;
}


static void _math_converter_from_cell_data_func_gtk_cell_layout_data_func (GtkCellLayout* cell_layout, GtkCellRenderer* cell, GtkTreeModel* tree_model, GtkTreeIter* iter, gpointer self) {
	math_converter_from_cell_data_func ((MathConverter*) self, cell_layout, cell, tree_model, iter);
}


static void _math_converter___lambda11_ (MathConverter* self) {
	math_converter_update_result_label (self);
}


static void __math_converter___lambda11__currency_manager_updated (CurrencyManager* _sender, gpointer self) {
	_math_converter___lambda11_ ((MathConverter*) self);
}


static GObject * math_converter_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	MathConverter * self;
	GtkComboBox* _tmp0_ = NULL;
	GtkCellRendererText* _tmp1_ = NULL;
	CurrencyManager* _tmp2_ = NULL;
	CurrencyManager* _tmp3_ = NULL;
	parent_class = G_OBJECT_CLASS (math_converter_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_CONVERTER, MathConverter);
	_tmp0_ = self->priv->from_combo;
	_tmp1_ = self->priv->from_renderer;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp0_, (GtkCellRenderer*) _tmp1_, _math_converter_from_cell_data_func_gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp2_ = currency_manager_get_default ();
	_tmp3_ = _tmp2_;
	g_signal_connect_object (_tmp3_, "updated", (GCallback) __math_converter___lambda11__currency_manager_updated, self, 0);
	_g_object_unref0 (_tmp3_);
	math_converter_update_from_model (self);
	return obj;
}


static void math_converter_class_init (MathConverterClass * klass) {
	gint MathConverter_private_offset;
	math_converter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MathConverterPrivate));
	G_OBJECT_CLASS (klass)->constructor = math_converter_constructor;
	G_OBJECT_CLASS (klass)->finalize = math_converter_finalize;
	MathConverter_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/calculator/math-converter.ui");
	g_signal_new ("changed", TYPE_MATH_CONVERTER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "from_renderer", FALSE, MathConverter_private_offset + G_STRUCT_OFFSET (MathConverterPrivate, from_renderer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "from_combo", FALSE, MathConverter_private_offset + G_STRUCT_OFFSET (MathConverterPrivate, from_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "to_combo", FALSE, MathConverter_private_offset + G_STRUCT_OFFSET (MathConverterPrivate, to_combo));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "result_label", FALSE, MathConverter_private_offset + G_STRUCT_OFFSET (MathConverterPrivate, result_label));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "from_combobox_changed_cb", G_CALLBACK(_math_converter_from_combobox_changed_cb_gtk_combo_box_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "to_combobox_changed_cb", G_CALLBACK(_math_converter_to_combobox_changed_cb_gtk_combo_box_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "swap_button_clicked_cb", G_CALLBACK(_math_converter_swap_button_clicked_cb_gtk_button_clicked));
}


static void math_converter_instance_init (MathConverter * self) {
	self->priv = MATH_CONVERTER_GET_PRIVATE (self);
	self->priv->equation = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void math_converter_finalize (GObject* obj) {
	MathConverter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MATH_CONVERTER, MathConverter);
	_g_object_unref0 (self->priv->equation);
	_g_free0 (self->priv->category);
	_g_object_unref0 (self->priv->from_renderer);
	_g_object_unref0 (self->priv->from_combo);
	_g_object_unref0 (self->priv->to_combo);
	_g_object_unref0 (self->priv->result_label);
	G_OBJECT_CLASS (math_converter_parent_class)->finalize (obj);
}


GType math_converter_get_type (void) {
	static volatile gsize math_converter_type_id__volatile = 0;
	if (g_once_init_enter (&math_converter_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MathConverterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) math_converter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MathConverter), 0, (GInstanceInitFunc) math_converter_instance_init, NULL };
		GType math_converter_type_id;
		math_converter_type_id = g_type_register_static (gtk_grid_get_type (), "MathConverter", &g_define_type_info, 0);
		g_once_init_leave (&math_converter_type_id__volatile, math_converter_type_id);
	}
	return math_converter_type_id__volatile;
}



