; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=amdgcn -mcpu=fiji < %s | FileCheck -check-prefixes=GCN %s

define amdgpu_kernel void @float4_extelt(ptr addrspace(1) %out, i32 %sel) {
; GCN-LABEL: float4_extelt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s6, s[4:5], 0x2c
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_cmp_eq_u32 s6, 1
; GCN-NEXT:    s_cselect_b64 s[2:3], -1, 0
; GCN-NEXT:    s_cmp_lg_u32 s6, 2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1.0, s[2:3]
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_lg_u32 s6, 3
; GCN-NEXT:    v_cndmask_b32_e32 v0, 2.0, v0, vcc
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    v_cndmask_b32_e32 v2, 4.0, v0, vcc
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    flat_store_dword v[0:1], v2
; GCN-NEXT:    s_endpgm
entry:
  %ext = extractelement <4 x float> <float 0.0, float 1.0, float 2.0, float 4.0>, i32 %sel
  store float %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @int4_extelt(ptr addrspace(1) %out, i32 %sel) {
; GCN-LABEL: int4_extelt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s6, s[4:5], 0x2c
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_cmp_eq_u32 s6, 1
; GCN-NEXT:    s_cselect_b64 s[2:3], -1, 0
; GCN-NEXT:    s_cmp_lg_u32 s6, 2
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[2:3]
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_lg_u32 s6, 3
; GCN-NEXT:    v_cndmask_b32_e32 v0, 2, v0, vcc
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    v_cndmask_b32_e32 v2, 4, v0, vcc
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    flat_store_dword v[0:1], v2
; GCN-NEXT:    s_endpgm
entry:
  %ext = extractelement <4 x i32> <i32 0, i32 1, i32 2, i32 4>, i32 %sel
  store i32 %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @double4_extelt(ptr addrspace(1) %out, i32 %sel) {
; GCN-LABEL: double4_extelt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    s_mov_b32 s3, 0x3ff028f5
; GCN-NEXT:    s_mov_b32 s4, 0xc28f5c29
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_cmp_eq_u32 s2, 1
; GCN-NEXT:    s_cselect_b32 s3, s3, 0x3f847ae1
; GCN-NEXT:    s_cselect_b32 s4, s4, 0x47ae147b
; GCN-NEXT:    s_cmp_eq_u32 s2, 2
; GCN-NEXT:    s_cselect_b32 s4, 0xe147ae14, s4
; GCN-NEXT:    s_cselect_b32 s3, 0x4000147a, s3
; GCN-NEXT:    s_cmp_eq_u32 s2, 3
; GCN-NEXT:    s_cselect_b32 s2, 0x40100a3d, s3
; GCN-NEXT:    s_cselect_b32 s3, 0x70a3d70a, s4
; GCN-NEXT:    v_mov_b32_e32 v3, s1
; GCN-NEXT:    v_mov_b32_e32 v0, s3
; GCN-NEXT:    v_mov_b32_e32 v1, s2
; GCN-NEXT:    v_mov_b32_e32 v2, s0
; GCN-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GCN-NEXT:    s_endpgm
entry:
  %ext = extractelement <4 x double> <double 0.01, double 1.01, double 2.01, double 4.01>, i32 %sel
  store double %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @double5_extelt(ptr addrspace(1) %out, i32 %sel) {
; GCN-LABEL: double5_extelt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s6, s[4:5], 0x2c
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    s_mov_b32 s2, 0x3ff028f5
; GCN-NEXT:    s_mov_b32 s3, 0xc28f5c29
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_cmp_eq_u32 s6, 1
; GCN-NEXT:    s_cselect_b32 s2, s2, 0x3f847ae1
; GCN-NEXT:    s_cselect_b32 s3, s3, 0x47ae147b
; GCN-NEXT:    s_cmp_eq_u32 s6, 2
; GCN-NEXT:    s_cselect_b32 s8, 0xe147ae14, s3
; GCN-NEXT:    s_cselect_b32 s7, 0x4000147a, s2
; GCN-NEXT:    s_cmp_eq_u32 s6, 3
; GCN-NEXT:    s_cselect_b64 s[2:3], -1, 0
; GCN-NEXT:    s_and_b64 s[4:5], s[2:3], exec
; GCN-NEXT:    s_cselect_b32 s9, 0x40100a3d, s7
; GCN-NEXT:    s_cmp_eq_u32 s6, 4
; GCN-NEXT:    s_cselect_b64 s[4:5], -1, 0
; GCN-NEXT:    s_and_b64 s[6:7], s[4:5], exec
; GCN-NEXT:    s_cselect_b32 s6, 0x40140a3d, s9
; GCN-NEXT:    s_or_b64 s[2:3], s[4:5], s[2:3]
; GCN-NEXT:    s_and_b64 s[2:3], s[2:3], exec
; GCN-NEXT:    s_cselect_b32 s2, 0x70a3d70a, s8
; GCN-NEXT:    v_mov_b32_e32 v3, s1
; GCN-NEXT:    v_mov_b32_e32 v0, s2
; GCN-NEXT:    v_mov_b32_e32 v1, s6
; GCN-NEXT:    v_mov_b32_e32 v2, s0
; GCN-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GCN-NEXT:    s_endpgm
entry:
  %ext = extractelement <5 x double> <double 0.01, double 1.01, double 2.01, double 4.01, double 5.01>, i32 %sel
  store double %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @half4_extelt(ptr addrspace(1) %out, i32 %sel) {
; GCN-LABEL: half4_extelt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s6, s[4:5], 0x2c
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    s_mov_b32 s2, 0x40003c00
; GCN-NEXT:    s_mov_b32 s3, 0x44004200
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b32 s4, s6, 4
; GCN-NEXT:    s_lshr_b64 s[2:3], s[2:3], s4
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    flat_store_short v[0:1], v2
; GCN-NEXT:    s_endpgm
entry:
  %ext = extractelement <4 x half> <half 1.0, half 2.0, half 3.0, half 4.0>, i32 %sel
  store half %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @float2_extelt(ptr addrspace(1) %out, i32 %sel) {
; GCN-LABEL: float2_extelt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_cmp_eq_u32 s2, 1
; GCN-NEXT:    s_cselect_b64 s[2:3], -1, 0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_cndmask_b32_e64 v2, 0, 1.0, s[2:3]
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    flat_store_dword v[0:1], v2
; GCN-NEXT:    s_endpgm
entry:
  %ext = extractelement <2 x float> <float 0.0, float 1.0>, i32 %sel
  store float %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @double2_extelt(ptr addrspace(1) %out, i32 %sel) {
; GCN-LABEL: double2_extelt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    s_mov_b32 s3, 0x3ff028f5
; GCN-NEXT:    s_mov_b32 s4, 0xc28f5c29
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_cmp_eq_u32 s2, 1
; GCN-NEXT:    s_cselect_b32 s2, s3, 0x3f847ae1
; GCN-NEXT:    s_cselect_b32 s3, s4, 0x47ae147b
; GCN-NEXT:    v_mov_b32_e32 v3, s1
; GCN-NEXT:    v_mov_b32_e32 v0, s3
; GCN-NEXT:    v_mov_b32_e32 v1, s2
; GCN-NEXT:    v_mov_b32_e32 v2, s0
; GCN-NEXT:    flat_store_dwordx2 v[2:3], v[0:1]
; GCN-NEXT:    s_endpgm
entry:
  %ext = extractelement <2 x double> <double 0.01, double 1.01>, i32 %sel
  store double %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @half8_extelt(ptr addrspace(1) %out, i32 %sel) {
; GCN-LABEL: half8_extelt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v0, 0x3c00
; GCN-NEXT:    v_mov_b32_e32 v1, 0x4000
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_cmp_eq_u32 s2, 1
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 2
; GCN-NEXT:    v_cndmask_b32_e32 v0, v0, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v1, 0x4200
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 3
; GCN-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GCN-NEXT:    v_mov_b32_e32 v1, 0x4400
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 4
; GCN-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GCN-NEXT:    v_mov_b32_e32 v1, 0x4500
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 5
; GCN-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GCN-NEXT:    v_mov_b32_e32 v1, 0x4600
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 6
; GCN-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GCN-NEXT:    v_mov_b32_e32 v1, 0x4700
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 7
; GCN-NEXT:    v_cndmask_b32_e32 v0, v1, v0, vcc
; GCN-NEXT:    v_mov_b32_e32 v1, 0x4800
; GCN-NEXT:    s_cselect_b64 vcc, -1, 0
; GCN-NEXT:    v_cndmask_b32_e32 v2, v1, v0, vcc
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    flat_store_short v[0:1], v2
; GCN-NEXT:    s_endpgm
entry:
  %ext = extractelement <8 x half> <half 1.0, half 2.0, half 3.0, half 4.0, half 5.0, half 6.0, half 7.0, half 8.0>, i32 %sel
  store half %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @short8_extelt(ptr addrspace(1) %out, i32 %sel) {
; GCN-LABEL: short8_extelt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_cmp_eq_u32 s2, 1
; GCN-NEXT:    s_cselect_b32 s3, 2, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 2
; GCN-NEXT:    s_cselect_b32 s3, s3, 3
; GCN-NEXT:    s_cmp_lg_u32 s2, 3
; GCN-NEXT:    s_cselect_b32 s3, s3, 4
; GCN-NEXT:    s_cmp_lg_u32 s2, 4
; GCN-NEXT:    s_cselect_b32 s3, s3, 5
; GCN-NEXT:    s_cmp_lg_u32 s2, 5
; GCN-NEXT:    s_cselect_b32 s3, s3, 6
; GCN-NEXT:    s_cmp_lg_u32 s2, 6
; GCN-NEXT:    s_cselect_b32 s3, s3, 7
; GCN-NEXT:    s_cmp_lg_u32 s2, 7
; GCN-NEXT:    s_cselect_b32 s2, s3, 8
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    flat_store_short v[0:1], v2
; GCN-NEXT:    s_endpgm
entry:
  %ext = extractelement <8 x i16> <i16 1, i16 2, i16 3, i16 4, i16 5, i16 6, i16 7, i16 8>, i32 %sel
  store i16 %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @float8_extelt(ptr addrspace(1) %out, i32 %sel) {
; GCN-LABEL: float8_extelt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GCN-NEXT:    v_mov_b32_e32 v0, 1.0
; GCN-NEXT:    v_mov_b32_e32 v1, 2.0
; GCN-NEXT:    v_mov_b32_e32 v2, 0x40400000
; GCN-NEXT:    v_mov_b32_e32 v3, 4.0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 m0, s2
; GCN-NEXT:    v_mov_b32_e32 v4, 0x40a00000
; GCN-NEXT:    v_mov_b32_e32 v5, 0x40c00000
; GCN-NEXT:    v_mov_b32_e32 v6, 0x40e00000
; GCN-NEXT:    v_mov_b32_e32 v7, 0x41000000
; GCN-NEXT:    v_movrels_b32_e32 v2, v0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    flat_store_dword v[0:1], v2
; GCN-NEXT:    s_endpgm
entry:
  %ext = extractelement <8 x float> <float 1.0, float 2.0, float 3.0, float 4.0, float 5.0, float 6.0, float 7.0, float 8.0>, i32 %sel
  store float %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @double8_extelt(ptr addrspace(1) %out, i32 %sel) {
; GCN-LABEL: double8_extelt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dwordx2 s[16:17], s[4:5], 0x24
; GCN-NEXT:    s_load_dword s18, s[4:5], 0x2c
; GCN-NEXT:    s_mov_b32 s0, 0
; GCN-NEXT:    s_mov_b32 s15, 0x40200000
; GCN-NEXT:    s_mov_b32 s13, 0x401c0000
; GCN-NEXT:    s_mov_b32 s11, 0x40180000
; GCN-NEXT:    s_mov_b32 s9, 0x40140000
; GCN-NEXT:    s_mov_b32 s7, 0x40100000
; GCN-NEXT:    s_mov_b32 s5, 0x40080000
; GCN-NEXT:    s_mov_b32 s3, 2.0
; GCN-NEXT:    s_mov_b32 s1, 0x3ff00000
; GCN-NEXT:    s_mov_b32 s2, s0
; GCN-NEXT:    s_mov_b32 s4, s0
; GCN-NEXT:    s_mov_b32 s6, s0
; GCN-NEXT:    s_mov_b32 s8, s0
; GCN-NEXT:    s_mov_b32 s10, s0
; GCN-NEXT:    s_mov_b32 s12, s0
; GCN-NEXT:    s_mov_b32 s14, s0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b32 s18, s18, 1
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    v_mov_b32_e32 v15, s15
; GCN-NEXT:    s_mov_b32 m0, s18
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    v_mov_b32_e32 v3, s3
; GCN-NEXT:    v_mov_b32_e32 v4, s4
; GCN-NEXT:    v_mov_b32_e32 v5, s5
; GCN-NEXT:    v_mov_b32_e32 v6, s6
; GCN-NEXT:    v_mov_b32_e32 v7, s7
; GCN-NEXT:    v_mov_b32_e32 v8, s8
; GCN-NEXT:    v_mov_b32_e32 v9, s9
; GCN-NEXT:    v_mov_b32_e32 v10, s10
; GCN-NEXT:    v_mov_b32_e32 v11, s11
; GCN-NEXT:    v_mov_b32_e32 v12, s12
; GCN-NEXT:    v_mov_b32_e32 v13, s13
; GCN-NEXT:    v_mov_b32_e32 v14, s14
; GCN-NEXT:    v_movrels_b32_e32 v16, v1
; GCN-NEXT:    v_movrels_b32_e32 v15, v0
; GCN-NEXT:    v_mov_b32_e32 v0, s16
; GCN-NEXT:    v_mov_b32_e32 v1, s17
; GCN-NEXT:    flat_store_dwordx2 v[0:1], v[15:16]
; GCN-NEXT:    s_endpgm
entry:
  %ext = extractelement <8 x double> <double 1.0, double 2.0, double 3.0, double 4.0, double 5.0, double 6.0, double 7.0, double 8.0>, i32 %sel
  store double %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @double7_extelt(ptr addrspace(1) %out, i32 %sel) {
; GCN-LABEL: double7_extelt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dwordx2 s[14:15], s[4:5], 0x24
; GCN-NEXT:    s_load_dword s16, s[4:5], 0x2c
; GCN-NEXT:    s_mov_b32 s0, 0
; GCN-NEXT:    s_mov_b32 s13, 0x401c0000
; GCN-NEXT:    s_mov_b32 s11, 0x40180000
; GCN-NEXT:    s_mov_b32 s9, 0x40140000
; GCN-NEXT:    s_mov_b32 s7, 0x40100000
; GCN-NEXT:    s_mov_b32 s5, 0x40080000
; GCN-NEXT:    s_mov_b32 s3, 2.0
; GCN-NEXT:    s_mov_b32 s1, 0x3ff00000
; GCN-NEXT:    s_mov_b32 s2, s0
; GCN-NEXT:    s_mov_b32 s4, s0
; GCN-NEXT:    s_mov_b32 s6, s0
; GCN-NEXT:    s_mov_b32 s8, s0
; GCN-NEXT:    s_mov_b32 s10, s0
; GCN-NEXT:    s_mov_b32 s12, s0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b32 s16, s16, 1
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    v_mov_b32_e32 v15, s15
; GCN-NEXT:    s_mov_b32 m0, s16
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    v_mov_b32_e32 v3, s3
; GCN-NEXT:    v_mov_b32_e32 v4, s4
; GCN-NEXT:    v_mov_b32_e32 v5, s5
; GCN-NEXT:    v_mov_b32_e32 v6, s6
; GCN-NEXT:    v_mov_b32_e32 v7, s7
; GCN-NEXT:    v_mov_b32_e32 v8, s8
; GCN-NEXT:    v_mov_b32_e32 v9, s9
; GCN-NEXT:    v_mov_b32_e32 v10, s10
; GCN-NEXT:    v_mov_b32_e32 v11, s11
; GCN-NEXT:    v_mov_b32_e32 v12, s12
; GCN-NEXT:    v_mov_b32_e32 v13, s13
; GCN-NEXT:    v_mov_b32_e32 v14, s14
; GCN-NEXT:    v_movrels_b32_e32 v16, v1
; GCN-NEXT:    v_movrels_b32_e32 v15, v0
; GCN-NEXT:    v_mov_b32_e32 v0, s14
; GCN-NEXT:    v_mov_b32_e32 v1, s15
; GCN-NEXT:    flat_store_dwordx2 v[0:1], v[15:16]
; GCN-NEXT:    s_endpgm
entry:
  %ext = extractelement <7 x double> <double 1.0, double 2.0, double 3.0, double 4.0, double 5.0, double 6.0, double 7.0>, i32 %sel
  store double %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @float16_extelt(ptr addrspace(1) %out, i32 %sel) {
; GCN-LABEL: float16_extelt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GCN-NEXT:    v_mov_b32_e32 v0, 1.0
; GCN-NEXT:    v_mov_b32_e32 v1, 2.0
; GCN-NEXT:    v_mov_b32_e32 v2, 0x40400000
; GCN-NEXT:    v_mov_b32_e32 v3, 4.0
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 m0, s2
; GCN-NEXT:    v_mov_b32_e32 v4, 0x40a00000
; GCN-NEXT:    v_mov_b32_e32 v5, 0x40c00000
; GCN-NEXT:    v_mov_b32_e32 v6, 0x40e00000
; GCN-NEXT:    v_mov_b32_e32 v7, 0x41000000
; GCN-NEXT:    v_mov_b32_e32 v8, 0x41100000
; GCN-NEXT:    v_mov_b32_e32 v9, 0x41200000
; GCN-NEXT:    v_mov_b32_e32 v10, 0x41300000
; GCN-NEXT:    v_mov_b32_e32 v11, 0x41400000
; GCN-NEXT:    v_mov_b32_e32 v12, 0x41500000
; GCN-NEXT:    v_mov_b32_e32 v13, 0x41600000
; GCN-NEXT:    v_mov_b32_e32 v14, 0x41700000
; GCN-NEXT:    v_mov_b32_e32 v15, 0x41800000
; GCN-NEXT:    v_movrels_b32_e32 v2, v0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    flat_store_dword v[0:1], v2
; GCN-NEXT:    s_endpgm
entry:
  %ext = extractelement <16 x float> <float 1.0, float 2.0, float 3.0, float 4.0, float 5.0, float 6.0, float 7.0, float 8.0, float 9.0, float 10.0, float 11.0, float 12.0, float 13.0, float 14.0, float 15.0, float 16.0>, i32 %sel
  store float %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @double15_extelt(ptr addrspace(1) %out, i32 %sel) {
; GCN-LABEL: double15_extelt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    s_mov_b32 s36, 0
; GCN-NEXT:    s_mov_b32 s65, 0x402e0000
; GCN-NEXT:    s_mov_b32 s63, 0x402c0000
; GCN-NEXT:    s_mov_b32 s61, 0x402a0000
; GCN-NEXT:    s_mov_b32 s59, 0x40280000
; GCN-NEXT:    s_mov_b32 s57, 0x40260000
; GCN-NEXT:    s_mov_b32 s55, 0x40240000
; GCN-NEXT:    s_mov_b32 s53, 0x40220000
; GCN-NEXT:    s_mov_b32 s51, 0x40200000
; GCN-NEXT:    s_mov_b32 s49, 0x401c0000
; GCN-NEXT:    s_mov_b32 s47, 0x40180000
; GCN-NEXT:    s_mov_b32 s45, 0x40140000
; GCN-NEXT:    s_mov_b32 s43, 0x40100000
; GCN-NEXT:    s_mov_b32 s41, 0x40080000
; GCN-NEXT:    s_mov_b32 s39, 2.0
; GCN-NEXT:    s_mov_b32 s37, 0x3ff00000
; GCN-NEXT:    s_mov_b32 s38, s36
; GCN-NEXT:    s_mov_b32 s40, s36
; GCN-NEXT:    s_mov_b32 s42, s36
; GCN-NEXT:    s_mov_b32 s44, s36
; GCN-NEXT:    s_mov_b32 s46, s36
; GCN-NEXT:    s_mov_b32 s48, s36
; GCN-NEXT:    s_mov_b32 s50, s36
; GCN-NEXT:    s_mov_b32 s52, s36
; GCN-NEXT:    s_mov_b32 s54, s36
; GCN-NEXT:    s_mov_b32 s56, s36
; GCN-NEXT:    s_mov_b32 s58, s36
; GCN-NEXT:    s_mov_b32 s60, s36
; GCN-NEXT:    s_mov_b32 s62, s36
; GCN-NEXT:    s_mov_b32 s64, s36
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b32 s2, s2, 1
; GCN-NEXT:    v_mov_b32_e32 v0, s36
; GCN-NEXT:    v_mov_b32_e32 v1, s37
; GCN-NEXT:    v_mov_b32_e32 v31, s67
; GCN-NEXT:    s_mov_b32 m0, s2
; GCN-NEXT:    v_mov_b32_e32 v2, s38
; GCN-NEXT:    v_mov_b32_e32 v3, s39
; GCN-NEXT:    v_mov_b32_e32 v4, s40
; GCN-NEXT:    v_mov_b32_e32 v5, s41
; GCN-NEXT:    v_mov_b32_e32 v6, s42
; GCN-NEXT:    v_mov_b32_e32 v7, s43
; GCN-NEXT:    v_mov_b32_e32 v8, s44
; GCN-NEXT:    v_mov_b32_e32 v9, s45
; GCN-NEXT:    v_mov_b32_e32 v10, s46
; GCN-NEXT:    v_mov_b32_e32 v11, s47
; GCN-NEXT:    v_mov_b32_e32 v12, s48
; GCN-NEXT:    v_mov_b32_e32 v13, s49
; GCN-NEXT:    v_mov_b32_e32 v14, s50
; GCN-NEXT:    v_mov_b32_e32 v15, s51
; GCN-NEXT:    v_mov_b32_e32 v16, s52
; GCN-NEXT:    v_mov_b32_e32 v17, s53
; GCN-NEXT:    v_mov_b32_e32 v18, s54
; GCN-NEXT:    v_mov_b32_e32 v19, s55
; GCN-NEXT:    v_mov_b32_e32 v20, s56
; GCN-NEXT:    v_mov_b32_e32 v21, s57
; GCN-NEXT:    v_mov_b32_e32 v22, s58
; GCN-NEXT:    v_mov_b32_e32 v23, s59
; GCN-NEXT:    v_mov_b32_e32 v24, s60
; GCN-NEXT:    v_mov_b32_e32 v25, s61
; GCN-NEXT:    v_mov_b32_e32 v26, s62
; GCN-NEXT:    v_mov_b32_e32 v27, s63
; GCN-NEXT:    v_mov_b32_e32 v28, s64
; GCN-NEXT:    v_mov_b32_e32 v29, s65
; GCN-NEXT:    v_mov_b32_e32 v30, s66
; GCN-NEXT:    v_movrels_b32_e32 v32, v1
; GCN-NEXT:    v_movrels_b32_e32 v31, v0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    flat_store_dwordx2 v[0:1], v[31:32]
; GCN-NEXT:    s_endpgm
entry:
  %ext = extractelement <15 x double> <double 1.0, double 2.0, double 3.0, double 4.0, double 5.0, double 6.0, double 7.0, double 8.0, double 9.0, double 10.0, double 11.0, double 12.0, double 13.0, double 14.0, double 15.0>, i32 %sel
  store double %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @double16_extelt(ptr addrspace(1) %out, i32 %sel) {
; GCN-LABEL: double16_extelt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    s_mov_b32 s36, 0
; GCN-NEXT:    s_mov_b32 s67, 0x40300000
; GCN-NEXT:    s_mov_b32 s65, 0x402e0000
; GCN-NEXT:    s_mov_b32 s63, 0x402c0000
; GCN-NEXT:    s_mov_b32 s61, 0x402a0000
; GCN-NEXT:    s_mov_b32 s59, 0x40280000
; GCN-NEXT:    s_mov_b32 s57, 0x40260000
; GCN-NEXT:    s_mov_b32 s55, 0x40240000
; GCN-NEXT:    s_mov_b32 s53, 0x40220000
; GCN-NEXT:    s_mov_b32 s51, 0x40200000
; GCN-NEXT:    s_mov_b32 s49, 0x401c0000
; GCN-NEXT:    s_mov_b32 s47, 0x40180000
; GCN-NEXT:    s_mov_b32 s45, 0x40140000
; GCN-NEXT:    s_mov_b32 s43, 0x40100000
; GCN-NEXT:    s_mov_b32 s41, 0x40080000
; GCN-NEXT:    s_mov_b32 s39, 2.0
; GCN-NEXT:    s_mov_b32 s37, 0x3ff00000
; GCN-NEXT:    s_mov_b32 s38, s36
; GCN-NEXT:    s_mov_b32 s40, s36
; GCN-NEXT:    s_mov_b32 s42, s36
; GCN-NEXT:    s_mov_b32 s44, s36
; GCN-NEXT:    s_mov_b32 s46, s36
; GCN-NEXT:    s_mov_b32 s48, s36
; GCN-NEXT:    s_mov_b32 s50, s36
; GCN-NEXT:    s_mov_b32 s52, s36
; GCN-NEXT:    s_mov_b32 s54, s36
; GCN-NEXT:    s_mov_b32 s56, s36
; GCN-NEXT:    s_mov_b32 s58, s36
; GCN-NEXT:    s_mov_b32 s60, s36
; GCN-NEXT:    s_mov_b32 s62, s36
; GCN-NEXT:    s_mov_b32 s64, s36
; GCN-NEXT:    s_mov_b32 s66, s36
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b32 s2, s2, 1
; GCN-NEXT:    v_mov_b32_e32 v0, s36
; GCN-NEXT:    v_mov_b32_e32 v1, s37
; GCN-NEXT:    v_mov_b32_e32 v31, s67
; GCN-NEXT:    s_mov_b32 m0, s2
; GCN-NEXT:    v_mov_b32_e32 v2, s38
; GCN-NEXT:    v_mov_b32_e32 v3, s39
; GCN-NEXT:    v_mov_b32_e32 v4, s40
; GCN-NEXT:    v_mov_b32_e32 v5, s41
; GCN-NEXT:    v_mov_b32_e32 v6, s42
; GCN-NEXT:    v_mov_b32_e32 v7, s43
; GCN-NEXT:    v_mov_b32_e32 v8, s44
; GCN-NEXT:    v_mov_b32_e32 v9, s45
; GCN-NEXT:    v_mov_b32_e32 v10, s46
; GCN-NEXT:    v_mov_b32_e32 v11, s47
; GCN-NEXT:    v_mov_b32_e32 v12, s48
; GCN-NEXT:    v_mov_b32_e32 v13, s49
; GCN-NEXT:    v_mov_b32_e32 v14, s50
; GCN-NEXT:    v_mov_b32_e32 v15, s51
; GCN-NEXT:    v_mov_b32_e32 v16, s52
; GCN-NEXT:    v_mov_b32_e32 v17, s53
; GCN-NEXT:    v_mov_b32_e32 v18, s54
; GCN-NEXT:    v_mov_b32_e32 v19, s55
; GCN-NEXT:    v_mov_b32_e32 v20, s56
; GCN-NEXT:    v_mov_b32_e32 v21, s57
; GCN-NEXT:    v_mov_b32_e32 v22, s58
; GCN-NEXT:    v_mov_b32_e32 v23, s59
; GCN-NEXT:    v_mov_b32_e32 v24, s60
; GCN-NEXT:    v_mov_b32_e32 v25, s61
; GCN-NEXT:    v_mov_b32_e32 v26, s62
; GCN-NEXT:    v_mov_b32_e32 v27, s63
; GCN-NEXT:    v_mov_b32_e32 v28, s64
; GCN-NEXT:    v_mov_b32_e32 v29, s65
; GCN-NEXT:    v_mov_b32_e32 v30, s66
; GCN-NEXT:    v_movrels_b32_e32 v32, v1
; GCN-NEXT:    v_movrels_b32_e32 v31, v0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    flat_store_dwordx2 v[0:1], v[31:32]
; GCN-NEXT:    s_endpgm
entry:
  %ext = extractelement <16 x double> <double 1.0, double 2.0, double 3.0, double 4.0, double 5.0, double 6.0, double 7.0, double 8.0, double 9.0, double 10.0, double 11.0, double 12.0, double 13.0, double 14.0, double 15.0, double 16.0>, i32 %sel
  store double %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @float32_extelt(ptr addrspace(1) %out, i32 %sel) {
; GCN-LABEL: float32_extelt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    v_mov_b32_e32 v0, 1.0
; GCN-NEXT:    v_mov_b32_e32 v1, 2.0
; GCN-NEXT:    v_mov_b32_e32 v2, 0x40400000
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_mov_b32 m0, s2
; GCN-NEXT:    v_mov_b32_e32 v3, 4.0
; GCN-NEXT:    v_mov_b32_e32 v4, 0x40a00000
; GCN-NEXT:    v_mov_b32_e32 v5, 0x40c00000
; GCN-NEXT:    v_mov_b32_e32 v6, 0x40e00000
; GCN-NEXT:    v_mov_b32_e32 v7, 0x41000000
; GCN-NEXT:    v_mov_b32_e32 v8, 0x41100000
; GCN-NEXT:    v_mov_b32_e32 v9, 0x41200000
; GCN-NEXT:    v_mov_b32_e32 v10, 0x41300000
; GCN-NEXT:    v_mov_b32_e32 v11, 0x41400000
; GCN-NEXT:    v_mov_b32_e32 v12, 0x41500000
; GCN-NEXT:    v_mov_b32_e32 v13, 0x41600000
; GCN-NEXT:    v_mov_b32_e32 v14, 0x41700000
; GCN-NEXT:    v_mov_b32_e32 v15, 0x41800000
; GCN-NEXT:    v_mov_b32_e32 v16, 0x41880000
; GCN-NEXT:    v_mov_b32_e32 v17, 0x41900000
; GCN-NEXT:    v_mov_b32_e32 v18, 0x41980000
; GCN-NEXT:    v_mov_b32_e32 v19, 0x41a00000
; GCN-NEXT:    v_mov_b32_e32 v20, 0x41a80000
; GCN-NEXT:    v_mov_b32_e32 v21, 0x41b00000
; GCN-NEXT:    v_mov_b32_e32 v22, 0x41b80000
; GCN-NEXT:    v_mov_b32_e32 v23, 0x41c00000
; GCN-NEXT:    v_mov_b32_e32 v24, 0x41c80000
; GCN-NEXT:    v_mov_b32_e32 v25, 0x41d00000
; GCN-NEXT:    v_mov_b32_e32 v26, 0x41d80000
; GCN-NEXT:    v_mov_b32_e32 v27, 0x41e00000
; GCN-NEXT:    v_mov_b32_e32 v28, 0x41e80000
; GCN-NEXT:    v_mov_b32_e32 v29, 0x41f00000
; GCN-NEXT:    v_mov_b32_e32 v30, 0x41f80000
; GCN-NEXT:    v_mov_b32_e32 v31, 0x42000000
; GCN-NEXT:    v_movrels_b32_e32 v2, v0
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    flat_store_dword v[0:1], v2
; GCN-NEXT:    s_endpgm
entry:
  %ext = extractelement <32 x float> <float 1.0, float 2.0, float 3.0, float 4.0, float 5.0, float 6.0, float 7.0, float 8.0, float 9.0, float 10.0, float 11.0, float 12.0, float 13.0, float 14.0, float 15.0, float 16.0, float 17.0, float 18.0, float 19.0, float 20.0, float 21.0, float 22.0, float 23.0, float 24.0, float 25.0, float 26.0, float 27.0, float 28.0, float 29.0, float 30.0, float 31.0, float 32.0>, i32 %sel
  store float %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @byte8_extelt(ptr addrspace(1) %out, i32 %sel) {
; GCN-LABEL: byte8_extelt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s6, s[4:5], 0x2c
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    s_mov_b32 s2, 0x4030201
; GCN-NEXT:    s_mov_b32 s3, 0x8070605
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b32 s4, s6, 3
; GCN-NEXT:    s_lshr_b64 s[2:3], s[2:3], s4
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    flat_store_byte v[0:1], v2
; GCN-NEXT:    s_endpgm
entry:
  %ext = extractelement <8 x i8> <i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8>, i32 %sel
  store i8 %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @byte16_extelt(ptr addrspace(1) %out, i32 %sel) {
; GCN-LABEL: byte16_extelt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_cmp_eq_u32 s2, 1
; GCN-NEXT:    s_cselect_b32 s3, 2, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 2
; GCN-NEXT:    s_cselect_b32 s3, s3, 3
; GCN-NEXT:    s_cmp_lg_u32 s2, 3
; GCN-NEXT:    s_cselect_b32 s3, s3, 4
; GCN-NEXT:    s_cmp_lg_u32 s2, 4
; GCN-NEXT:    s_cselect_b32 s3, s3, 5
; GCN-NEXT:    s_cmp_lg_u32 s2, 5
; GCN-NEXT:    s_cselect_b32 s3, s3, 6
; GCN-NEXT:    s_cmp_lg_u32 s2, 6
; GCN-NEXT:    s_cselect_b32 s3, s3, 7
; GCN-NEXT:    s_cmp_lg_u32 s2, 7
; GCN-NEXT:    s_cselect_b32 s3, s3, 8
; GCN-NEXT:    s_cmp_lg_u32 s2, 8
; GCN-NEXT:    s_cselect_b32 s3, s3, 9
; GCN-NEXT:    s_cmp_lg_u32 s2, 9
; GCN-NEXT:    s_cselect_b32 s3, s3, 10
; GCN-NEXT:    s_cmp_lg_u32 s2, 10
; GCN-NEXT:    s_cselect_b32 s3, s3, 11
; GCN-NEXT:    s_cmp_lg_u32 s2, 11
; GCN-NEXT:    s_cselect_b32 s3, s3, 12
; GCN-NEXT:    s_cmp_lg_u32 s2, 12
; GCN-NEXT:    s_cselect_b32 s3, s3, 13
; GCN-NEXT:    s_cmp_lg_u32 s2, 13
; GCN-NEXT:    s_cselect_b32 s3, s3, 14
; GCN-NEXT:    s_cmp_lg_u32 s2, 14
; GCN-NEXT:    s_cselect_b32 s3, s3, 15
; GCN-NEXT:    s_cmp_lg_u32 s2, 15
; GCN-NEXT:    s_cselect_b32 s2, s3, 16
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    flat_store_byte v[0:1], v2
; GCN-NEXT:    s_endpgm
entry:
  %ext = extractelement <16 x i8> <i8 1, i8 2, i8 3, i8 4, i8 5, i8 6, i8 7, i8 8, i8 9, i8 10, i8 11, i8 12, i8 13, i8 14, i8 15, i8 16>, i32 %sel
  store i8 %ext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @bit4_extelt(ptr addrspace(1) %out, i32 %sel) {
; GCN-LABEL: bit4_extelt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_lshl_b32 s2, s2, 3
; GCN-NEXT:    s_lshr_b32 s2, 0x1000100, s2
; GCN-NEXT:    s_and_b32 s2, s2, 1
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    flat_store_dword v[0:1], v2
; GCN-NEXT:    s_endpgm
entry:
  %ext = extractelement <4 x i1> <i1 0, i1 1, i1 0, i1 1>, i32 %sel
  %zext = zext i1 %ext to i32
  store i32 %zext, ptr addrspace(1) %out
  ret void
}

define amdgpu_kernel void @bit128_extelt(ptr addrspace(1) %out, i32 %sel) {
; GCN-LABEL: bit128_extelt:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_load_dword s2, s[4:5], 0x2c
; GCN-NEXT:    s_load_dwordx2 s[0:1], s[4:5], 0x24
; GCN-NEXT:    s_waitcnt lgkmcnt(0)
; GCN-NEXT:    s_cmp_lg_u32 s2, 1
; GCN-NEXT:    s_cselect_b64 s[4:5], -1, 0
; GCN-NEXT:    v_cndmask_b32_e64 v0, 0, 1, s[4:5]
; GCN-NEXT:    s_cmp_lg_u32 s2, 2
; GCN-NEXT:    v_readfirstlane_b32 s3, v0
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 3
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 4
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 5
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 6
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 7
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 8
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 9
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 10
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 11
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 12
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 13
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 14
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 15
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 16
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 17
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 18
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 19
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 20
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 21
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 22
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 23
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 24
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 25
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 26
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 27
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 28
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 29
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 30
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 31
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 32
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 33
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 34
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 35
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 36
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 37
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 38
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 39
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 40
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 41
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 42
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 43
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 44
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 45
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 46
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 47
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 48
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 49
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 50
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 51
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 52
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 53
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 54
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 55
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 56
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 57
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 58
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 59
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 60
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 61
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 62
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmp_lg_u32 s2, 63
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmp_lg_u32 s2, 64
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x41
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x42
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x43
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x44
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x45
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x46
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x47
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x48
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x49
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x4a
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x4b
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x4c
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x4d
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x4e
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x4f
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x50
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x51
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x52
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x53
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x54
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x55
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x56
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x57
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x58
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x59
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x5a
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x5b
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x5c
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x5d
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x5e
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x5f
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x60
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x61
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x62
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x63
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x64
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x65
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x66
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x67
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x68
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x69
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x6a
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x6b
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x6c
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x6d
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x6e
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x6f
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x70
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x71
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x72
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x73
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x74
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x75
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x76
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x77
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x78
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x79
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x7a
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x7b
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x7c
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x7d
; GCN-NEXT:    s_cselect_b32 s3, s3, 0
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x7e
; GCN-NEXT:    s_cselect_b32 s3, s3, 1
; GCN-NEXT:    s_cmpk_lg_i32 s2, 0x7f
; GCN-NEXT:    s_cselect_b32 s2, s3, 0
; GCN-NEXT:    s_and_b32 s2, s2, 1
; GCN-NEXT:    v_mov_b32_e32 v0, s0
; GCN-NEXT:    v_mov_b32_e32 v1, s1
; GCN-NEXT:    v_mov_b32_e32 v2, s2
; GCN-NEXT:    flat_store_dword v[0:1], v2
; GCN-NEXT:    s_endpgm
entry:
  %ext = extractelement <128 x i1> <i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0, i1 1, i1 0>, i32 %sel
  %zext = zext i1 %ext to i32
  store i32 %zext, ptr addrspace(1) %out
  ret void
}

define float @float32_extelt_vec(i32 %sel) {
; GCN-LABEL: float32_extelt_vec:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GCN-NEXT:    v_cndmask_b32_e64 v1, 1.0, 2.0, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x40400000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 2, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 3, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, 4.0, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x40a00000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 4, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x40c00000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 5, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x40e00000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 6, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41000000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 7, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41100000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 8, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41200000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 9, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41300000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 10, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41400000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 11, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41500000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 12, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41600000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 13, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41700000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 14, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41800000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 15, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41880000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 16, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41900000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 17, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41980000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 18, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41a00000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 19, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41a80000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 20, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41b00000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 21, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41b80000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 22, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41c00000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 23, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41c80000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 24, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41d00000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 25, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41d80000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 26, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41e00000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 27, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41e80000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 28, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41f00000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 29, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x41f80000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 30, v0
; GCN-NEXT:    v_cndmask_b32_e32 v1, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GCN-NEXT:    v_cmp_ne_u32_e32 vcc, 31, v0
; GCN-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
entry:
  %ext = extractelement <32 x float> <float 1.0, float 2.0, float 3.0, float 4.0, float 5.0, float 6.0, float 7.0, float 8.0, float 9.0, float 10.0, float 11.0, float 12.0, float 13.0, float 14.0, float 15.0, float 16.0, float 17.0, float 18.0, float 19.0, float 20.0, float 21.0, float 22.0, float 23.0, float 24.0, float 25.0, float 26.0, float 27.0, float 28.0, float 29.0, float 30.0, float 31.0, float 32.0>, i32 %sel
  ret float %ext
}

define double @double16_extelt_vec(i32 %sel) {
; GCN-LABEL: double16_extelt_vec:
; GCN:       ; %bb.0: ; %entry
; GCN-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GCN-NEXT:    v_mov_b32_e32 v3, 0x3ff19999
; GCN-NEXT:    v_mov_b32_e32 v4, 0x4000cccc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 1, v0
; GCN-NEXT:    v_cmp_eq_u32_e64 s[4:5], 2, v0
; GCN-NEXT:    v_mov_b32_e32 v1, 0x9999999a
; GCN-NEXT:    v_mov_b32_e32 v2, 0xcccccccd
; GCN-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GCN-NEXT:    v_mov_b32_e32 v4, 0x4008cccc
; GCN-NEXT:    s_or_b64 vcc, s[4:5], vcc
; GCN-NEXT:    v_cndmask_b32_e64 v3, v3, v4, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e32 v2, v1, v2, vcc
; GCN-NEXT:    v_mov_b32_e32 v4, 0x40106666
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 3, v0
; GCN-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GCN-NEXT:    v_mov_b32_e32 v4, 0x40146666
; GCN-NEXT:    v_cmp_eq_u32_e64 s[4:5], 4, v0
; GCN-NEXT:    v_cndmask_b32_e64 v3, v3, v4, s[4:5]
; GCN-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GCN-NEXT:    v_mov_b32_e32 v4, 0x40186666
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 5, v0
; GCN-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GCN-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN-NEXT:    v_mov_b32_e32 v5, 0x401c6666
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 6, v0
; GCN-NEXT:    v_mov_b32_e32 v4, 0x66666666
; GCN-NEXT:    v_cndmask_b32_e32 v3, v3, v5, vcc
; GCN-NEXT:    s_or_b64 vcc, vcc, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; GCN-NEXT:    v_mov_b32_e32 v4, 0x40203333
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 7, v0
; GCN-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GCN-NEXT:    v_mov_b32_e32 v4, 0x40223333
; GCN-NEXT:    v_cmp_eq_u32_e64 s[4:5], 8, v0
; GCN-NEXT:    v_cndmask_b32_e64 v3, v3, v4, s[4:5]
; GCN-NEXT:    s_or_b64 s[4:5], s[4:5], vcc
; GCN-NEXT:    v_mov_b32_e32 v4, 0x40243333
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 9, v0
; GCN-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GCN-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN-NEXT:    v_mov_b32_e32 v4, 0x40263333
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 10, v0
; GCN-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GCN-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN-NEXT:    v_mov_b32_e32 v4, 0x40283333
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 11, v0
; GCN-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GCN-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN-NEXT:    v_mov_b32_e32 v4, 0x402a3333
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 12, v0
; GCN-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GCN-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN-NEXT:    v_mov_b32_e32 v4, 0x402c3333
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 13, v0
; GCN-NEXT:    v_cndmask_b32_e32 v3, v3, v4, vcc
; GCN-NEXT:    s_or_b64 s[4:5], vcc, s[4:5]
; GCN-NEXT:    v_mov_b32_e32 v5, 0x402e3333
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 14, v0
; GCN-NEXT:    v_mov_b32_e32 v4, 0x33333333
; GCN-NEXT:    v_cndmask_b32_e32 v3, v3, v5, vcc
; GCN-NEXT:    s_or_b64 vcc, vcc, s[4:5]
; GCN-NEXT:    v_cndmask_b32_e32 v2, v2, v4, vcc
; GCN-NEXT:    v_cmp_eq_u32_e32 vcc, 15, v0
; GCN-NEXT:    v_cndmask_b32_e32 v0, v2, v1, vcc
; GCN-NEXT:    v_mov_b32_e32 v1, 0x40301999
; GCN-NEXT:    v_cndmask_b32_e32 v1, v3, v1, vcc
; GCN-NEXT:    s_setpc_b64 s[30:31]
entry:
  %ext = extractelement <16 x double> <double 1.1, double 2.1, double 3.1, double 4.1, double 5.1, double 6.1, double 7.1, double 8.1, double 9.1, double 10.1, double 11.1, double 12.1, double 13.1, double 14.1, double 15.1, double 16.1>, i32 %sel
  ret double %ext
}
