; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=xtensa -verify-machineinstrs < %s \
; RUN:   | FileCheck -check-prefix=XTENSA %s

declare i32 @llvm.cttz.i32(i32, i1)
declare i32 @llvm.ctlz.i32(i32, i1)
declare i32 @llvm.ctpop.i32(i32)

define i32 @test_cttz_i32(i32 %a) nounwind {
; XTENSA-LABEL: test_cttz_i32:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    beqz a2, .LBB0_2
; XTENSA-NEXT:  # %bb.1: # %cond.false
; XTENSA-NEXT:    movi a8, -1
; XTENSA-NEXT:    xor a8, a2, a8
; XTENSA-NEXT:    addi a9, a2, -1
; XTENSA-NEXT:    and a8, a8, a9
; XTENSA-NEXT:    srli a9, a8, 1
; XTENSA-NEXT:    l32r a10, .LCPI0_0
; XTENSA-NEXT:    and a9, a9, a10
; XTENSA-NEXT:    sub a8, a8, a9
; XTENSA-NEXT:    l32r a9, .LCPI0_1
; XTENSA-NEXT:    and a10, a8, a9
; XTENSA-NEXT:    srli a8, a8, 2
; XTENSA-NEXT:    and a8, a8, a9
; XTENSA-NEXT:    add a8, a10, a8
; XTENSA-NEXT:    srli a9, a8, 4
; XTENSA-NEXT:    add a8, a8, a9
; XTENSA-NEXT:    l32r a9, .LCPI0_2
; XTENSA-NEXT:    and a8, a8, a9
; XTENSA-NEXT:    slli a9, a8, 8
; XTENSA-NEXT:    add a8, a8, a9
; XTENSA-NEXT:    slli a9, a8, 16
; XTENSA-NEXT:    add a8, a8, a9
; XTENSA-NEXT:    extui a2, a8, 24, 8
; XTENSA-NEXT:    ret
; XTENSA-NEXT:  .LBB0_2:
; XTENSA-NEXT:    movi a2, 32
; XTENSA-NEXT:    ret
  %tmp = call i32 @llvm.cttz.i32(i32 %a, i1 false)
  ret i32 %tmp
}

define i32 @test_cttz_i32_zero_undef(i32 %a) nounwind {
; XTENSA-LABEL: test_cttz_i32_zero_undef:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    movi a8, -1
; XTENSA-NEXT:    xor a8, a2, a8
; XTENSA-NEXT:    addi a9, a2, -1
; XTENSA-NEXT:    and a8, a8, a9
; XTENSA-NEXT:    srli a9, a8, 1
; XTENSA-NEXT:    l32r a10, .LCPI1_0
; XTENSA-NEXT:    and a9, a9, a10
; XTENSA-NEXT:    sub a8, a8, a9
; XTENSA-NEXT:    l32r a9, .LCPI1_1
; XTENSA-NEXT:    and a10, a8, a9
; XTENSA-NEXT:    srli a8, a8, 2
; XTENSA-NEXT:    and a8, a8, a9
; XTENSA-NEXT:    add a8, a10, a8
; XTENSA-NEXT:    srli a9, a8, 4
; XTENSA-NEXT:    add a8, a8, a9
; XTENSA-NEXT:    l32r a9, .LCPI1_2
; XTENSA-NEXT:    and a8, a8, a9
; XTENSA-NEXT:    slli a9, a8, 8
; XTENSA-NEXT:    add a8, a8, a9
; XTENSA-NEXT:    slli a9, a8, 16
; XTENSA-NEXT:    add a8, a8, a9
; XTENSA-NEXT:    extui a2, a8, 24, 8
; XTENSA-NEXT:    ret
  %tmp = call i32 @llvm.cttz.i32(i32 %a, i1 true)
  ret i32 %tmp
}

define i32 @test_ctlz_i32(i32 %a) nounwind {
; XTENSA-LABEL: test_ctlz_i32:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    beqz a2, .LBB2_2
; XTENSA-NEXT:  # %bb.1: # %cond.false
; XTENSA-NEXT:    srli a8, a2, 1
; XTENSA-NEXT:    or a8, a2, a8
; XTENSA-NEXT:    srli a9, a8, 2
; XTENSA-NEXT:    or a8, a8, a9
; XTENSA-NEXT:    srli a9, a8, 4
; XTENSA-NEXT:    or a8, a8, a9
; XTENSA-NEXT:    srli a9, a8, 8
; XTENSA-NEXT:    or a8, a8, a9
; XTENSA-NEXT:    extui a9, a8, 16, 16
; XTENSA-NEXT:    or a8, a8, a9
; XTENSA-NEXT:    movi a9, -1
; XTENSA-NEXT:    xor a8, a8, a9
; XTENSA-NEXT:    srli a9, a8, 1
; XTENSA-NEXT:    l32r a10, .LCPI2_0
; XTENSA-NEXT:    and a9, a9, a10
; XTENSA-NEXT:    sub a8, a8, a9
; XTENSA-NEXT:    l32r a9, .LCPI2_1
; XTENSA-NEXT:    and a10, a8, a9
; XTENSA-NEXT:    srli a8, a8, 2
; XTENSA-NEXT:    and a8, a8, a9
; XTENSA-NEXT:    add a8, a10, a8
; XTENSA-NEXT:    srli a9, a8, 4
; XTENSA-NEXT:    add a8, a8, a9
; XTENSA-NEXT:    l32r a9, .LCPI2_2
; XTENSA-NEXT:    and a8, a8, a9
; XTENSA-NEXT:    slli a9, a8, 8
; XTENSA-NEXT:    add a8, a8, a9
; XTENSA-NEXT:    slli a9, a8, 16
; XTENSA-NEXT:    add a8, a8, a9
; XTENSA-NEXT:    extui a2, a8, 24, 8
; XTENSA-NEXT:    ret
; XTENSA-NEXT:  .LBB2_2:
; XTENSA-NEXT:    movi a2, 32
; XTENSA-NEXT:    ret
  %tmp = call i32 @llvm.ctlz.i32(i32 %a, i1 false)
  ret i32 %tmp
}

define i32 @test_ctlz_i32_zero_undef(i32 %a) nounwind {
; XTENSA-LABEL: test_ctlz_i32_zero_undef:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    srli a8, a2, 1
; XTENSA-NEXT:    or a8, a2, a8
; XTENSA-NEXT:    srli a9, a8, 2
; XTENSA-NEXT:    or a8, a8, a9
; XTENSA-NEXT:    srli a9, a8, 4
; XTENSA-NEXT:    or a8, a8, a9
; XTENSA-NEXT:    srli a9, a8, 8
; XTENSA-NEXT:    or a8, a8, a9
; XTENSA-NEXT:    extui a9, a8, 16, 16
; XTENSA-NEXT:    or a8, a8, a9
; XTENSA-NEXT:    movi a9, -1
; XTENSA-NEXT:    xor a8, a8, a9
; XTENSA-NEXT:    srli a9, a8, 1
; XTENSA-NEXT:    l32r a10, .LCPI3_0
; XTENSA-NEXT:    and a9, a9, a10
; XTENSA-NEXT:    sub a8, a8, a9
; XTENSA-NEXT:    l32r a9, .LCPI3_1
; XTENSA-NEXT:    and a10, a8, a9
; XTENSA-NEXT:    srli a8, a8, 2
; XTENSA-NEXT:    and a8, a8, a9
; XTENSA-NEXT:    add a8, a10, a8
; XTENSA-NEXT:    srli a9, a8, 4
; XTENSA-NEXT:    add a8, a8, a9
; XTENSA-NEXT:    l32r a9, .LCPI3_2
; XTENSA-NEXT:    and a8, a8, a9
; XTENSA-NEXT:    slli a9, a8, 8
; XTENSA-NEXT:    add a8, a8, a9
; XTENSA-NEXT:    slli a9, a8, 16
; XTENSA-NEXT:    add a8, a8, a9
; XTENSA-NEXT:    extui a2, a8, 24, 8
; XTENSA-NEXT:    ret
  %tmp = call i32 @llvm.ctlz.i32(i32 %a, i1 true)
  ret i32 %tmp
}

define i32 @test_ctpop_i32(i32 %a) nounwind {
; XTENSA-LABEL: test_ctpop_i32:
; XTENSA:       # %bb.0:
; XTENSA-NEXT:    srli a8, a2, 1
; XTENSA-NEXT:    l32r a9, .LCPI4_0
; XTENSA-NEXT:    and a8, a8, a9
; XTENSA-NEXT:    sub a8, a2, a8
; XTENSA-NEXT:    l32r a9, .LCPI4_1
; XTENSA-NEXT:    and a10, a8, a9
; XTENSA-NEXT:    srli a8, a8, 2
; XTENSA-NEXT:    and a8, a8, a9
; XTENSA-NEXT:    add a8, a10, a8
; XTENSA-NEXT:    srli a9, a8, 4
; XTENSA-NEXT:    add a8, a8, a9
; XTENSA-NEXT:    l32r a9, .LCPI4_2
; XTENSA-NEXT:    and a8, a8, a9
; XTENSA-NEXT:    slli a9, a8, 8
; XTENSA-NEXT:    add a8, a8, a9
; XTENSA-NEXT:    slli a9, a8, 16
; XTENSA-NEXT:    add a8, a8, a9
; XTENSA-NEXT:    extui a2, a8, 24, 8
; XTENSA-NEXT:    ret
  %1 = call i32 @llvm.ctpop.i32(i32 %a)
  ret i32 %1
}
