# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=aarch64 -mcpu=neoverse-n2 -instruction-tables < %s | FileCheck %s

irg	x0, x1
irg	sp, x1
irg	x0, sp
irg	x0, x1, x2
irg	sp, x1, x2
addg	x0, x1, #0, #1
addg	sp, x2, #32, #3
addg	x0, sp, #64, #5
addg	x3, x4, #1008, #6
addg	x5, x6, #112, #15
subg	x0, x1, #0, #1
subg	sp, x2, #32, #3
subg	x0, sp, #64, #5
subg	x3, x4, #1008, #6
subg	x5, x6, #112, #15
gmi	x0, x1, x2
gmi	x3, sp, x4
gmi	xzr, x0, x30
gmi	x30, x0, xzr
subp	x0, x1, x2
subps	x0, x1, x2
subp	x0, sp, sp
subps	x0, sp, sp
subps	xzr, x0, x1
subps	xzr, sp, sp
stg	x0, [x1, #-4096]
stg	x1, [x2, #4080]
stg	x2, [sp, #16]
stg	x3, [x1]
stg	sp, [x1]
stzg	x0, [x1, #-4096]
stzg	x1, [x2, #4080]
stzg	x2, [sp, #16]
stzg	x3, [x1]
stzg	sp, [x1]
stg	x0, [x1, #-4096]!
stg	x1, [x2, #4080]!
stg	x2, [sp, #16]!
stg	sp, [sp, #16]!
stzg	x0, [x1, #-4096]!
stzg	x1, [x2, #4080]!
stzg	x2, [sp, #16]!
stzg	sp, [sp, #16]!
stg	x0, [x1], #-4096
stg	x1, [x2], #4080
stg	x2, [sp], #16
stg	sp, [sp], #16
stzg	x0, [x1], #-4096
stzg	x1, [x2], #4080
stzg	x2, [sp], #16
stzg	sp, [sp], #16
st2g	x0, [x1, #-4096]
st2g	x1, [x2, #4080]
st2g	x2, [sp, #16]
st2g	x3, [x1]
st2g	sp, [x1]
stz2g	x0, [x1, #-4096]
stz2g	x1, [x2, #4080]
stz2g	x2, [sp, #16]
stz2g	x3, [x1]
stz2g	sp, [x1]
st2g	x0, [x1, #-4096]!
st2g	x1, [x2, #4080]!
st2g	x2, [sp, #16]!
st2g	sp, [sp, #16]!
stz2g	x0, [x1, #-4096]!
stz2g	x1, [x2, #4080]!
stz2g	x2, [sp, #16]!
stz2g	sp, [sp, #16]!
st2g	x0, [x1], #-4096
st2g	x1, [x2], #4080
st2g	x2, [sp], #16
st2g	sp, [sp], #16
stz2g	x0, [x1], #-4096
stz2g	x1, [x2], #4080
stz2g	x2, [sp], #16
stz2g	sp, [sp], #16
stgp	x0, x1, [x2, #-1024]
stgp	x0, x1, [x2, #1008]
stgp	x0, x1, [sp, #16]
stgp	xzr, x1, [x2, #16]
stgp	x0, xzr, [x2, #16]
stgp	x0, xzr, [x2]
stgp	x0, x1, [x2, #-1024]!
stgp	x0, x1, [x2, #1008]!
stgp	x0, x1, [sp, #16]!
stgp	xzr, x1, [x2, #16]!
stgp	x0, xzr, [x2, #16]!
stgp	x0, x1, [x2], #-1024
stgp	x0, x1, [x2], #1008
stgp	x0, x1, [sp], #16
stgp	xzr, x1, [x2], #16
stgp	x0, xzr, [x2], #16
ldg	x0, [x1]
ldg	x2, [sp, #-4096]
ldg	x3, [x4, #4080]
ldgm	x0, [x1]
ldgm	x1, [sp]
ldgm	xzr, [x2]
stgm	x0, [x1]
stgm	x1, [sp]
stgm	xzr, [x2]
stzgm	x0, [x1]
stzgm	x1, [sp]
stzgm	xzr, [x2]

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      2     0.50                  U     irg	x0, x1
# CHECK-NEXT:  1      2     0.50                  U     irg	sp, x1
# CHECK-NEXT:  1      2     0.50                  U     irg	x0, sp
# CHECK-NEXT:  1      2     0.50                  U     irg	x0, x1, x2
# CHECK-NEXT:  1      2     0.50                  U     irg	sp, x1, x2
# CHECK-NEXT:  1      2     0.50                        addg	x0, x1, #0, #1
# CHECK-NEXT:  1      2     0.50                        addg	sp, x2, #32, #3
# CHECK-NEXT:  1      2     0.50                        addg	x0, sp, #64, #5
# CHECK-NEXT:  1      2     0.50                        addg	x3, x4, #1008, #6
# CHECK-NEXT:  1      2     0.50                        addg	x5, x6, #112, #15
# CHECK-NEXT:  1      2     0.50                  U     subg	x0, x1, #0, #1
# CHECK-NEXT:  1      2     0.50                  U     subg	sp, x2, #32, #3
# CHECK-NEXT:  1      2     0.50                  U     subg	x0, sp, #64, #5
# CHECK-NEXT:  1      2     0.50                  U     subg	x3, x4, #1008, #6
# CHECK-NEXT:  1      2     0.50                  U     subg	x5, x6, #112, #15
# CHECK-NEXT:  1      1     0.25                        gmi	x0, x1, x2
# CHECK-NEXT:  1      1     0.25                        gmi	x3, sp, x4
# CHECK-NEXT:  1      1     0.25                        gmi	xzr, x0, x30
# CHECK-NEXT:  1      1     0.25                        gmi	x30, x0, xzr
# CHECK-NEXT:  1      1     0.25                        subp	x0, x1, x2
# CHECK-NEXT:  1      1     0.25                  U     subps	x0, x1, x2
# CHECK-NEXT:  1      1     0.25                        subp	x0, sp, sp
# CHECK-NEXT:  1      1     0.25                  U     subps	x0, sp, sp
# CHECK-NEXT:  1      1     0.25                  U     subps	xzr, x0, x1
# CHECK-NEXT:  1      1     0.25                  U     subps	xzr, sp, sp
# CHECK-NEXT:  2      1     0.50           *            stg	x0, [x1, #-4096]
# CHECK-NEXT:  2      1     0.50           *            stg	x1, [x2, #4080]
# CHECK-NEXT:  2      1     0.50           *            stg	x2, [sp, #16]
# CHECK-NEXT:  2      1     0.50           *            stg	x3, [x1]
# CHECK-NEXT:  2      1     0.50           *            stg	sp, [x1]
# CHECK-NEXT:  2      1     0.50           *            stzg	x0, [x1, #-4096]
# CHECK-NEXT:  2      1     0.50           *            stzg	x1, [x2, #4080]
# CHECK-NEXT:  2      1     0.50           *            stzg	x2, [sp, #16]
# CHECK-NEXT:  2      1     0.50           *            stzg	x3, [x1]
# CHECK-NEXT:  2      1     0.50           *            stzg	sp, [x1]
# CHECK-NEXT:  3      1     0.50           *      U     stg	x0, [x1, #-4096]!
# CHECK-NEXT:  3      1     0.50           *      U     stg	x1, [x2, #4080]!
# CHECK-NEXT:  3      1     0.50           *      U     stg	x2, [sp, #16]!
# CHECK-NEXT:  3      1     0.50           *      U     stg	sp, [sp, #16]!
# CHECK-NEXT:  3      1     0.50           *      U     stzg	x0, [x1, #-4096]!
# CHECK-NEXT:  3      1     0.50           *      U     stzg	x1, [x2, #4080]!
# CHECK-NEXT:  3      1     0.50           *      U     stzg	x2, [sp, #16]!
# CHECK-NEXT:  3      1     0.50           *      U     stzg	sp, [sp, #16]!
# CHECK-NEXT:  3      1     0.50           *      U     stg	x0, [x1], #-4096
# CHECK-NEXT:  3      1     0.50           *      U     stg	x1, [x2], #4080
# CHECK-NEXT:  3      1     0.50           *      U     stg	x2, [sp], #16
# CHECK-NEXT:  3      1     0.50           *      U     stg	sp, [sp], #16
# CHECK-NEXT:  3      1     0.50           *      U     stzg	x0, [x1], #-4096
# CHECK-NEXT:  3      1     0.50           *      U     stzg	x1, [x2], #4080
# CHECK-NEXT:  3      1     0.50           *      U     stzg	x2, [sp], #16
# CHECK-NEXT:  3      1     0.50           *      U     stzg	sp, [sp], #16
# CHECK-NEXT:  2      1     0.50           *            st2g	x0, [x1, #-4096]
# CHECK-NEXT:  2      1     0.50           *            st2g	x1, [x2, #4080]
# CHECK-NEXT:  2      1     0.50           *            st2g	x2, [sp, #16]
# CHECK-NEXT:  2      1     0.50           *            st2g	x3, [x1]
# CHECK-NEXT:  2      1     0.50           *            st2g	sp, [x1]
# CHECK-NEXT:  2      1     0.50           *            stz2g	x0, [x1, #-4096]
# CHECK-NEXT:  2      1     0.50           *            stz2g	x1, [x2, #4080]
# CHECK-NEXT:  2      1     0.50           *            stz2g	x2, [sp, #16]
# CHECK-NEXT:  2      1     0.50           *            stz2g	x3, [x1]
# CHECK-NEXT:  2      1     0.50           *            stz2g	sp, [x1]
# CHECK-NEXT:  3      1     0.50           *      U     st2g	x0, [x1, #-4096]!
# CHECK-NEXT:  3      1     0.50           *      U     st2g	x1, [x2, #4080]!
# CHECK-NEXT:  3      1     0.50           *      U     st2g	x2, [sp, #16]!
# CHECK-NEXT:  3      1     0.50           *      U     st2g	sp, [sp, #16]!
# CHECK-NEXT:  3      1     0.50           *      U     stz2g	x0, [x1, #-4096]!
# CHECK-NEXT:  3      1     0.50           *      U     stz2g	x1, [x2, #4080]!
# CHECK-NEXT:  3      1     0.50           *      U     stz2g	x2, [sp, #16]!
# CHECK-NEXT:  3      1     0.50           *      U     stz2g	sp, [sp, #16]!
# CHECK-NEXT:  3      1     0.50           *      U     st2g	x0, [x1], #-4096
# CHECK-NEXT:  3      1     0.50           *      U     st2g	x1, [x2], #4080
# CHECK-NEXT:  3      1     0.50           *      U     st2g	x2, [sp], #16
# CHECK-NEXT:  3      1     0.50           *      U     st2g	sp, [sp], #16
# CHECK-NEXT:  3      1     0.50           *      U     stz2g	x0, [x1], #-4096
# CHECK-NEXT:  3      1     0.50           *      U     stz2g	x1, [x2], #4080
# CHECK-NEXT:  3      1     0.50           *      U     stz2g	x2, [sp], #16
# CHECK-NEXT:  3      1     0.50           *      U     stz2g	sp, [sp], #16
# CHECK-NEXT:  2      1     0.50           *            stgp	x0, x1, [x2, #-1024]
# CHECK-NEXT:  2      1     0.50           *            stgp	x0, x1, [x2, #1008]
# CHECK-NEXT:  2      1     0.50           *            stgp	x0, x1, [sp, #16]
# CHECK-NEXT:  2      1     0.50           *            stgp	xzr, x1, [x2, #16]
# CHECK-NEXT:  2      1     0.50           *            stgp	x0, xzr, [x2, #16]
# CHECK-NEXT:  2      1     0.50           *            stgp	x0, xzr, [x2]
# CHECK-NEXT:  3      1     0.50           *            stgp	x0, x1, [x2, #-1024]!
# CHECK-NEXT:  3      1     0.50           *            stgp	x0, x1, [x2, #1008]!
# CHECK-NEXT:  3      1     0.50           *            stgp	x0, x1, [sp, #16]!
# CHECK-NEXT:  3      1     0.50           *            stgp	xzr, x1, [x2, #16]!
# CHECK-NEXT:  3      1     0.50           *            stgp	x0, xzr, [x2, #16]!
# CHECK-NEXT:  3      1     0.50           *            stgp	x0, x1, [x2], #-1024
# CHECK-NEXT:  3      1     0.50           *            stgp	x0, x1, [x2], #1008
# CHECK-NEXT:  3      1     0.50           *            stgp	x0, x1, [sp], #16
# CHECK-NEXT:  3      1     0.50           *            stgp	xzr, x1, [x2], #16
# CHECK-NEXT:  3      1     0.50           *            stgp	x0, xzr, [x2], #16
# CHECK-NEXT:  1      4     0.33    *                   ldg	x0, [x1]
# CHECK-NEXT:  1      4     0.33    *                   ldg	x2, [sp, #-4096]
# CHECK-NEXT:  1      4     0.33    *                   ldg	x3, [x4, #4080]
# CHECK-NEXT:  1      4     0.33    *             U     ldgm	x0, [x1]
# CHECK-NEXT:  1      4     0.33    *             U     ldgm	x1, [sp]
# CHECK-NEXT:  1      4     0.33    *             U     ldgm	xzr, [x2]
# CHECK-NEXT:  2      1     0.50           *      U     stgm	x0, [x1]
# CHECK-NEXT:  2      1     0.50           *      U     stgm	x1, [sp]
# CHECK-NEXT:  2      1     0.50           *      U     stgm	xzr, [x2]
# CHECK-NEXT:  2      1     0.50           *      U     stzgm	x0, [x1]
# CHECK-NEXT:  2      1     0.50           *      U     stzgm	x1, [sp]
# CHECK-NEXT:  2      1     0.50           *      U     stzgm	xzr, [x2]

# CHECK:      Resources:
# CHECK-NEXT: [0.0] - N2UnitB
# CHECK-NEXT: [0.1] - N2UnitB
# CHECK-NEXT: [1.0] - N2UnitD
# CHECK-NEXT: [1.1] - N2UnitD
# CHECK-NEXT: [2]   - N2UnitL2
# CHECK-NEXT: [3.0] - N2UnitL01
# CHECK-NEXT: [3.1] - N2UnitL01
# CHECK-NEXT: [4]   - N2UnitM0
# CHECK-NEXT: [5]   - N2UnitM1
# CHECK-NEXT: [6.0] - N2UnitS
# CHECK-NEXT: [6.1] - N2UnitS
# CHECK-NEXT: [7]   - N2UnitV0
# CHECK-NEXT: [8]   - N2UnitV1

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4]    [5]    [6.0]  [6.1]  [7]    [8]
# CHECK-NEXT:  -      -     37.00  37.00  2.00   39.00  39.00  20.50  20.50  13.00  13.00   -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0.0]  [0.1]  [1.0]  [1.1]  [2]    [3.0]  [3.1]  [4]    [5]    [6.0]  [6.1]  [7]    [8]    Instructions:
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -      -     irg	x0, x1
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -      -     irg	sp, x1
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -      -     irg	x0, sp
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -      -     irg	x0, x1, x2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -      -     irg	sp, x1, x2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -      -     addg	x0, x1, #0, #1
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -      -     addg	sp, x2, #32, #3
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -      -     addg	x0, sp, #64, #5
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -      -     addg	x3, x4, #1008, #6
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -      -     addg	x5, x6, #112, #15
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -      -     subg	x0, x1, #0, #1
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -      -     subg	sp, x2, #32, #3
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -      -     subg	x0, sp, #64, #5
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -      -     subg	x3, x4, #1008, #6
# CHECK-NEXT:  -      -      -      -      -      -      -     0.50   0.50    -      -      -      -     subg	x5, x6, #112, #15
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -      -     gmi	x0, x1, x2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -      -     gmi	x3, sp, x4
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -      -     gmi	xzr, x0, x30
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -      -     gmi	x30, x0, xzr
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -      -     subp	x0, x1, x2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -      -     subps	x0, x1, x2
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -      -     subp	x0, sp, sp
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -      -     subps	x0, sp, sp
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -      -     subps	xzr, x0, x1
# CHECK-NEXT:  -      -      -      -      -      -      -     0.25   0.25   0.25   0.25    -      -     subps	xzr, sp, sp
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stg	x0, [x1, #-4096]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stg	x1, [x2, #4080]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stg	x2, [sp, #16]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stg	x3, [x1]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stg	sp, [x1]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stzg	x0, [x1, #-4096]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stzg	x1, [x2, #4080]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stzg	x2, [sp, #16]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stzg	x3, [x1]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stzg	sp, [x1]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stg	x0, [x1, #-4096]!
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stg	x1, [x2, #4080]!
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stg	x2, [sp, #16]!
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stg	sp, [sp, #16]!
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stzg	x0, [x1, #-4096]!
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stzg	x1, [x2, #4080]!
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stzg	x2, [sp, #16]!
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stzg	sp, [sp, #16]!
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stg	x0, [x1], #-4096
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stg	x1, [x2], #4080
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stg	x2, [sp], #16
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stg	sp, [sp], #16
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stzg	x0, [x1], #-4096
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stzg	x1, [x2], #4080
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stzg	x2, [sp], #16
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stzg	sp, [sp], #16
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     st2g	x0, [x1, #-4096]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     st2g	x1, [x2, #4080]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     st2g	x2, [sp, #16]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     st2g	x3, [x1]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     st2g	sp, [x1]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stz2g	x0, [x1, #-4096]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stz2g	x1, [x2, #4080]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stz2g	x2, [sp, #16]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stz2g	x3, [x1]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stz2g	sp, [x1]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     st2g	x0, [x1, #-4096]!
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     st2g	x1, [x2, #4080]!
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     st2g	x2, [sp, #16]!
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     st2g	sp, [sp, #16]!
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stz2g	x0, [x1, #-4096]!
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stz2g	x1, [x2, #4080]!
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stz2g	x2, [sp, #16]!
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stz2g	sp, [sp, #16]!
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     st2g	x0, [x1], #-4096
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     st2g	x1, [x2], #4080
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     st2g	x2, [sp], #16
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     st2g	sp, [sp], #16
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stz2g	x0, [x1], #-4096
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stz2g	x1, [x2], #4080
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stz2g	x2, [sp], #16
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stz2g	sp, [sp], #16
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stgp	x0, x1, [x2, #-1024]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stgp	x0, x1, [x2, #1008]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stgp	x0, x1, [sp, #16]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stgp	xzr, x1, [x2, #16]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stgp	x0, xzr, [x2, #16]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stgp	x0, xzr, [x2]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stgp	x0, x1, [x2, #-1024]!
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stgp	x0, x1, [x2, #1008]!
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stgp	x0, x1, [sp, #16]!
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stgp	xzr, x1, [x2, #16]!
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stgp	x0, xzr, [x2, #16]!
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stgp	x0, x1, [x2], #-1024
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stgp	x0, x1, [x2], #1008
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stgp	x0, x1, [sp], #16
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stgp	xzr, x1, [x2], #16
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50   0.25   0.25   0.25   0.25    -      -     stgp	x0, xzr, [x2], #16
# CHECK-NEXT:  -      -      -      -     0.33   0.33   0.33    -      -      -      -      -      -     ldg	x0, [x1]
# CHECK-NEXT:  -      -      -      -     0.33   0.33   0.33    -      -      -      -      -      -     ldg	x2, [sp, #-4096]
# CHECK-NEXT:  -      -      -      -     0.33   0.33   0.33    -      -      -      -      -      -     ldg	x3, [x4, #4080]
# CHECK-NEXT:  -      -      -      -     0.33   0.33   0.33    -      -      -      -      -      -     ldgm	x0, [x1]
# CHECK-NEXT:  -      -      -      -     0.33   0.33   0.33    -      -      -      -      -      -     ldgm	x1, [sp]
# CHECK-NEXT:  -      -      -      -     0.33   0.33   0.33    -      -      -      -      -      -     ldgm	xzr, [x2]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stgm	x0, [x1]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stgm	x1, [sp]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stgm	xzr, [x2]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stzgm	x0, [x1]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stzgm	x1, [sp]
# CHECK-NEXT:  -      -     0.50   0.50    -     0.50   0.50    -      -      -      -      -      -     stzgm	xzr, [x2]
