/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSHTMLSelectElement.h"

#include "ExceptionCode.h"
#include "HTMLCollection.h"
#include "HTMLFormElement.h"
#include "HTMLNames.h"
#include "HTMLOptionsCollection.h"
#include "HTMLSelectElement.h"
#include "JSDOMBinding.h"
#include "JSHTMLCollection.h"
#include "JSHTMLElement.h"
#include "JSHTMLFormElement.h"
#include "JSHTMLOptionsCollection.h"
#include "JSNode.h"
#include "JSNodeList.h"
#include "JSValidityState.h"
#include "KURL.h"
#include "NameNodeList.h"
#include "Node.h"
#include "NodeList.h"
#include "ValidityState.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLSelectElementTableValues[] =
{
    { "autofocus", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementAutofocus), (intptr_t)setJSHTMLSelectElementAutofocus, NoIntrinsic },
    { "disabled", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementDisabled), (intptr_t)setJSHTMLSelectElementDisabled, NoIntrinsic },
    { "form", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementForm), (intptr_t)0, NoIntrinsic },
    { "multiple", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementMultiple), (intptr_t)setJSHTMLSelectElementMultiple, NoIntrinsic },
    { "name", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementName), (intptr_t)setJSHTMLSelectElementName, NoIntrinsic },
    { "required", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementRequired), (intptr_t)setJSHTMLSelectElementRequired, NoIntrinsic },
    { "size", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementSize), (intptr_t)setJSHTMLSelectElementSize, NoIntrinsic },
    { "type", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementType), (intptr_t)0, NoIntrinsic },
    { "options", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementOptions), (intptr_t)0, NoIntrinsic },
    { "length", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementLength), (intptr_t)setJSHTMLSelectElementLength, NoIntrinsic },
    { "selectedOptions", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementSelectedOptions), (intptr_t)0, NoIntrinsic },
    { "selectedIndex", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementSelectedIndex), (intptr_t)setJSHTMLSelectElementSelectedIndex, NoIntrinsic },
    { "value", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementValue), (intptr_t)setJSHTMLSelectElementValue, NoIntrinsic },
    { "willValidate", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementWillValidate), (intptr_t)0, NoIntrinsic },
    { "validity", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementValidity), (intptr_t)0, NoIntrinsic },
    { "validationMessage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementValidationMessage), (intptr_t)0, NoIntrinsic },
    { "labels", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementLabels), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLSelectElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLSelectElementTable = { 67, 63, JSHTMLSelectElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLSelectElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLSelectElementConstructorTable = { 1, 0, JSHTMLSelectElementConstructorTableValues, 0 };
const ClassInfo JSHTMLSelectElementConstructor::s_info = { "HTMLSelectElementConstructor", &Base::s_info, &JSHTMLSelectElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLSelectElementConstructor) };

JSHTMLSelectElementConstructor::JSHTMLSelectElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLSelectElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLSelectElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLSelectElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLSelectElementConstructor, JSDOMWrapper>(exec, &JSHTMLSelectElementConstructorTable, jsCast<JSHTMLSelectElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLSelectElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLSelectElementConstructor, JSDOMWrapper>(exec, &JSHTMLSelectElementConstructorTable, jsCast<JSHTMLSelectElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLSelectElementPrototypeTableValues[] =
{
    { "item", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLSelectElementPrototypeFunctionItem), (intptr_t)1, NoIntrinsic },
    { "namedItem", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLSelectElementPrototypeFunctionNamedItem), (intptr_t)1, NoIntrinsic },
    { "add", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLSelectElementPrototypeFunctionAdd), (intptr_t)2, NoIntrinsic },
    { "remove", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLSelectElementPrototypeFunctionRemove), (intptr_t)0, NoIntrinsic },
    { "checkValidity", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLSelectElementPrototypeFunctionCheckValidity), (intptr_t)0, NoIntrinsic },
    { "setCustomValidity", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLSelectElementPrototypeFunctionSetCustomValidity), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLSelectElementPrototypeTable = { 16, 15, JSHTMLSelectElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLSelectElementPrototype::s_info = { "HTMLSelectElementPrototype", &Base::s_info, &JSHTMLSelectElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLSelectElementPrototype) };

JSObject* JSHTMLSelectElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLSelectElement>(exec, globalObject);
}

bool JSHTMLSelectElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLSelectElementPrototype* thisObject = jsCast<JSHTMLSelectElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLSelectElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLSelectElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLSelectElementPrototype* thisObject = jsCast<JSHTMLSelectElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSHTMLSelectElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLSelectElement::s_info = { "HTMLSelectElement", &Base::s_info, &JSHTMLSelectElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLSelectElement) };

JSHTMLSelectElement::JSHTMLSelectElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLSelectElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLSelectElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLSelectElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLSelectElementPrototype::create(exec->globalData(), globalObject, JSHTMLSelectElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLSelectElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLSelectElement* thisObject = jsCast<JSHTMLSelectElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = getStaticValueSlotEntryWithoutCaching<JSHTMLSelectElement>(exec, propertyName);
    if (entry) {
        slot.setCustom(thisObject, entry->propertyGetter());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<HTMLSelectElement*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, indexGetter);
        return true;
    }
    return getStaticValueSlot<JSHTMLSelectElement, Base>(exec, &JSHTMLSelectElementTable, thisObject, propertyName, slot);
}

bool JSHTMLSelectElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLSelectElement* thisObject = jsCast<JSHTMLSelectElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    const HashEntry* entry = JSHTMLSelectElementTable.entry(exec, propertyName);
    if (entry) {
        PropertySlot slot;
        slot.setCustom(thisObject, entry->propertyGetter());
        descriptor.setDescriptor(slot.getValue(exec, propertyName), entry->attributes());
        return true;
    }
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<HTMLSelectElement*>(thisObject->impl())->length()) {
        PropertySlot slot;
        slot.setCustomIndex(thisObject, index, indexGetter);
        descriptor.setDescriptor(slot.getValue(exec, propertyName), DontDelete);
        return true;
    }
    return getStaticValueDescriptor<JSHTMLSelectElement, Base>(exec, &JSHTMLSelectElementTable, thisObject, propertyName, descriptor);
}

bool JSHTMLSelectElement::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSHTMLSelectElement* thisObject = jsCast<JSHTMLSelectElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<HTMLSelectElement*>(thisObject->impl())->length()) {
        slot.setCustomIndex(thisObject, index, thisObject->indexGetter);
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsHTMLSelectElementAutofocus(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->hasAttribute(WebCore::HTMLNames::autofocusAttr));
    return result;
}


JSValue jsHTMLSelectElementDisabled(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->hasAttribute(WebCore::HTMLNames::disabledAttr));
    return result;
}


JSValue jsHTMLSelectElementForm(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->form()));
    return result;
}


JSValue jsHTMLSelectElementMultiple(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->multiple());
    return result;
}


JSValue jsHTMLSelectElementName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getAttribute(WebCore::HTMLNames::nameAttr));
    return result;
}


JSValue jsHTMLSelectElementRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->hasAttribute(WebCore::HTMLNames::requiredAttr));
    return result;
}


JSValue jsHTMLSelectElementSize(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->size());
    return result;
}


JSValue jsHTMLSelectElementType(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->type());
    return result;
}


JSValue jsHTMLSelectElementOptions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->options()));
    return result;
}


JSValue jsHTMLSelectElementLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsHTMLSelectElementSelectedOptions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->selectedOptions()));
    return result;
}


JSValue jsHTMLSelectElementSelectedIndex(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->selectedIndex());
    return result;
}


JSValue jsHTMLSelectElementValue(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->value());
    return result;
}


JSValue jsHTMLSelectElementWillValidate(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->willValidate());
    return result;
}


JSValue jsHTMLSelectElementValidity(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->validity()));
    return result;
}


JSValue jsHTMLSelectElementValidationMessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->validationMessage());
    return result;
}


JSValue jsHTMLSelectElementLabels(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->labels()));
    return result;
}


JSValue jsHTMLSelectElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLSelectElement* domObject = jsCast<JSHTMLSelectElement*>(asObject(slotBase));
    return JSHTMLSelectElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLSelectElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLSelectElement* thisObject = jsCast<JSHTMLSelectElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex) {
        thisObject->indexSetter(exec, index, value);
        return;
    }
    lookupPut<JSHTMLSelectElement, Base>(exec, propertyName, value, &JSHTMLSelectElementTable, thisObject, slot);
}

void JSHTMLSelectElement::putByIndex(JSCell* cell, ExecState* exec, unsigned index, JSValue value, bool shouldThrow)
{
    JSHTMLSelectElement* thisObject = jsCast<JSHTMLSelectElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index <= MAX_ARRAY_INDEX) {
        UNUSED_PARAM(shouldThrow);
        thisObject->indexSetter(exec, index, value);
        return;
    }
    Base::putByIndex(cell, exec, index, value, shouldThrow);
}

void setJSHTMLSelectElementAutofocus(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(thisObject);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::autofocusAttr, value.toBoolean(exec));
}


void setJSHTMLSelectElementDisabled(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(thisObject);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::disabledAttr, value.toBoolean(exec));
}


void setJSHTMLSelectElementMultiple(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(thisObject);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    impl->setMultiple(value.toBoolean(exec));
}


void setJSHTMLSelectElementName(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(thisObject);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::nameAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLSelectElementRequired(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(thisObject);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::requiredAttr, value.toBoolean(exec));
}


void setJSHTMLSelectElementSize(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(thisObject);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    impl->setSize(value.toInt32(exec));
}


void setJSHTMLSelectElementLength(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(thisObject);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setLength(value.toUInt32(exec), ec);
    setDOMException(exec, ec);
}


void setJSHTMLSelectElementSelectedIndex(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(thisObject);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    impl->setSelectedIndex(value.toInt32(exec));
}


void setJSHTMLSelectElementValue(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(thisObject);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    impl->setValue(valueToStringWithNullCheck(exec, value));
}


void JSHTMLSelectElement::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSHTMLSelectElement* thisObject = jsCast<JSHTMLSelectElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<HTMLSelectElement*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSHTMLSelectElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLSelectElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLSelectElementPrototypeFunctionItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLSelectElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLSelectElement::s_info);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    int index(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toUInt32(exec));
    if (index < 0) {
        setDOMException(exec, INDEX_SIZE_ERR);
        return JSValue::encode(jsUndefined());
    }
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->item(index)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLSelectElementPrototypeFunctionNamedItem(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLSelectElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLSelectElement::s_info);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    const String& name(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->namedItem(name)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLSelectElementPrototypeFunctionAdd(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLSelectElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLSelectElement::s_info);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    HTMLElement* element(toHTMLElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    HTMLElement* before(toHTMLElement(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->add(element, before, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLSelectElementPrototypeFunctionRemove(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLSelectElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLSelectElement::s_info);
    return JSValue::encode(castedThis->remove(exec));
}

EncodedJSValue JSC_HOST_CALL jsHTMLSelectElementPrototypeFunctionCheckValidity(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLSelectElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLSelectElement::s_info);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());

    JSC::JSValue result = jsBoolean(impl->checkValidity());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLSelectElementPrototypeFunctionSetCustomValidity(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLSelectElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLSelectElement* castedThis = jsCast<JSHTMLSelectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLSelectElement::s_info);
    HTMLSelectElement* impl = static_cast<HTMLSelectElement*>(castedThis->impl());
    if (exec->argumentCount() < 1)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    const String& error(valueToStringWithUndefinedOrNullCheck(exec, MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    impl->setCustomValidity(error);
    return JSValue::encode(jsUndefined());
}


JSValue JSHTMLSelectElement::indexGetter(ExecState* exec, JSValue slotBase, unsigned index)
{
    JSHTMLSelectElement* thisObj = jsCast<JSHTMLSelectElement*>(asObject(slotBase));
    ASSERT_GC_OBJECT_INHERITS(thisObj, &s_info);
    return toJS(exec, thisObj->globalObject(), static_cast<HTMLSelectElement*>(thisObj->impl())->item(index));
}


}
