/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(FILTERS) && ENABLE(SVG)

#include "JSSVGFEMergeNodeElement.h"

#include "JSSVGAnimatedString.h"
#include "SVGFEMergeNodeElement.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGFEMergeNodeElementTableValues[] =
{
    { "in1", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEMergeNodeElementIn1), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEMergeNodeElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEMergeNodeElementTable = { 4, 3, JSSVGFEMergeNodeElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGFEMergeNodeElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEMergeNodeElementConstructorTable = { 1, 0, JSSVGFEMergeNodeElementConstructorTableValues, 0 };
const ClassInfo JSSVGFEMergeNodeElementConstructor::s_info = { "SVGFEMergeNodeElementConstructor", &Base::s_info, &JSSVGFEMergeNodeElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGFEMergeNodeElementConstructor) };

JSSVGFEMergeNodeElementConstructor::JSSVGFEMergeNodeElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGFEMergeNodeElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGFEMergeNodeElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGFEMergeNodeElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEMergeNodeElementConstructor, JSDOMWrapper>(exec, &JSSVGFEMergeNodeElementConstructorTable, jsCast<JSSVGFEMergeNodeElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGFEMergeNodeElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFEMergeNodeElementConstructor, JSDOMWrapper>(exec, &JSSVGFEMergeNodeElementConstructorTable, jsCast<JSSVGFEMergeNodeElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFEMergeNodeElementPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGFEMergeNodeElementPrototypeTable = { 1, 0, JSSVGFEMergeNodeElementPrototypeTableValues, 0 };
const ClassInfo JSSVGFEMergeNodeElementPrototype::s_info = { "SVGFEMergeNodeElementPrototype", &Base::s_info, &JSSVGFEMergeNodeElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGFEMergeNodeElementPrototype) };

JSObject* JSSVGFEMergeNodeElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFEMergeNodeElement>(exec, globalObject);
}

const ClassInfo JSSVGFEMergeNodeElement::s_info = { "SVGFEMergeNodeElement", &Base::s_info, &JSSVGFEMergeNodeElementTable, 0 , CREATE_METHOD_TABLE(JSSVGFEMergeNodeElement) };

JSSVGFEMergeNodeElement::JSSVGFEMergeNodeElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFEMergeNodeElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGFEMergeNodeElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGFEMergeNodeElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGFEMergeNodeElementPrototype::create(exec->globalData(), globalObject, JSSVGFEMergeNodeElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGFEMergeNodeElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGFEMergeNodeElement* thisObject = jsCast<JSSVGFEMergeNodeElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGFEMergeNodeElement, Base>(exec, &JSSVGFEMergeNodeElementTable, thisObject, propertyName, slot);
}

bool JSSVGFEMergeNodeElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGFEMergeNodeElement* thisObject = jsCast<JSSVGFEMergeNodeElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGFEMergeNodeElement, Base>(exec, &JSSVGFEMergeNodeElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGFEMergeNodeElementIn1(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEMergeNodeElement* castedThis = jsCast<JSSVGFEMergeNodeElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEMergeNodeElement* impl = static_cast<SVGFEMergeNodeElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->in1Animated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGFEMergeNodeElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGFEMergeNodeElement* domObject = jsCast<JSSVGFEMergeNodeElement*>(asObject(slotBase));
    return JSSVGFEMergeNodeElement::getConstructor(exec, domObject->globalObject());
}

JSValue JSSVGFEMergeNodeElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFEMergeNodeElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(FILTERS) && ENABLE(SVG)
