/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGRectElement.h"

#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "ExceptionCode.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSDOMBinding.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGMatrix.h"
#include "SVGRect.h"
#include "SVGRectElement.h"
#include "SVGStringList.h"
#include "StylePropertySet.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSVGRectElementTableValues[] =
{
    { "x", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementX), (intptr_t)0, NoIntrinsic },
    { "y", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementY), (intptr_t)0, NoIntrinsic },
    { "width", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementWidth), (intptr_t)0, NoIntrinsic },
    { "height", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementHeight), (intptr_t)0, NoIntrinsic },
    { "rx", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementRx), (intptr_t)0, NoIntrinsic },
    { "ry", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementRy), (intptr_t)0, NoIntrinsic },
    { "requiredFeatures", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementRequiredFeatures), (intptr_t)0, NoIntrinsic },
    { "requiredExtensions", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementRequiredExtensions), (intptr_t)0, NoIntrinsic },
    { "systemLanguage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementSystemLanguage), (intptr_t)0, NoIntrinsic },
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementXmllang), (intptr_t)setJSSVGRectElementXmllang, NoIntrinsic },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementXmlspace), (intptr_t)setJSSVGRectElementXmlspace, NoIntrinsic },
    { "externalResourcesRequired", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementExternalResourcesRequired), (intptr_t)0, NoIntrinsic },
    { "className", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementClassName), (intptr_t)0, NoIntrinsic },
    { "style", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementStyle), (intptr_t)0, NoIntrinsic },
    { "transform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementTransform), (intptr_t)0, NoIntrinsic },
    { "nearestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementNearestViewportElement), (intptr_t)0, NoIntrinsic },
    { "farthestViewportElement", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementFarthestViewportElement), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGRectElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGRectElementTable = { 69, 63, JSSVGRectElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSSVGRectElementConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGRectElementConstructorTable = { 1, 0, JSSVGRectElementConstructorTableValues, 0 };
const ClassInfo JSSVGRectElementConstructor::s_info = { "SVGRectElementConstructor", &Base::s_info, &JSSVGRectElementConstructorTable, 0, CREATE_METHOD_TABLE(JSSVGRectElementConstructor) };

JSSVGRectElementConstructor::JSSVGRectElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSSVGRectElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSSVGRectElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSSVGRectElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGRectElementConstructor, JSDOMWrapper>(exec, &JSSVGRectElementConstructorTable, jsCast<JSSVGRectElementConstructor*>(cell), propertyName, slot);
}

bool JSSVGRectElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGRectElementConstructor, JSDOMWrapper>(exec, &JSSVGRectElementConstructorTable, jsCast<JSSVGRectElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGRectElementPrototypeTableValues[] =
{
    { "hasExtension", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGRectElementPrototypeFunctionHasExtension), (intptr_t)1, NoIntrinsic },
    { "getPresentationAttribute", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGRectElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1, NoIntrinsic },
    { "getBBox", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGRectElementPrototypeFunctionGetBBox), (intptr_t)0, NoIntrinsic },
    { "getCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGRectElementPrototypeFunctionGetCTM), (intptr_t)0, NoIntrinsic },
    { "getScreenCTM", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGRectElementPrototypeFunctionGetScreenCTM), (intptr_t)0, NoIntrinsic },
    { "getTransformToElement", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsSVGRectElementPrototypeFunctionGetTransformToElement), (intptr_t)1, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSVGRectElementPrototypeTable = { 17, 15, JSSVGRectElementPrototypeTableValues, 0 };
const ClassInfo JSSVGRectElementPrototype::s_info = { "SVGRectElementPrototype", &Base::s_info, &JSSVGRectElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSSVGRectElementPrototype) };

JSObject* JSSVGRectElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGRectElement>(exec, globalObject);
}

bool JSSVGRectElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGRectElementPrototype* thisObject = jsCast<JSSVGRectElementPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGRectElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSSVGRectElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGRectElementPrototype* thisObject = jsCast<JSSVGRectElementPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGRectElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSSVGRectElement::s_info = { "SVGRectElement", &Base::s_info, &JSSVGRectElementTable, 0 , CREATE_METHOD_TABLE(JSSVGRectElement) };

JSSVGRectElement::JSSVGRectElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGRectElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

void JSSVGRectElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSSVGRectElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSSVGRectElementPrototype::create(exec->globalData(), globalObject, JSSVGRectElementPrototype::createStructure(exec->globalData(), globalObject, JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGRectElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSVGRectElement* thisObject = jsCast<JSSVGRectElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSVGRectElement, Base>(exec, &JSSVGRectElementTable, thisObject, propertyName, slot);
}

bool JSSVGRectElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSVGRectElement* thisObject = jsCast<JSSVGRectElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSVGRectElement, Base>(exec, &JSSVGRectElementTable, thisObject, propertyName, descriptor);
}

JSValue jsSVGRectElementX(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementY(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementWidth(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementHeight(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementRx(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->rxAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementRy(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = impl->ryAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementRequiredFeatures(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredFeatures())));
    return result;
}


JSValue jsSVGRectElementRequiredExtensions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->requiredExtensions())));
    return result;
}


JSValue jsSVGRectElementSystemLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGStaticListPropertyTearOff<SVGStringList>::create(impl, impl->systemLanguage())));
    return result;
}


JSValue jsSVGRectElementXmllang(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmllang());
    return result;
}


JSValue jsSVGRectElementXmlspace(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->xmlspace());
    return result;
}


JSValue jsSVGRectElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = impl->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementClassName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = impl->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementStyle(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->style()));
    return result;
}


JSValue jsSVGRectElementTransform(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = impl->transformAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get());
    return result;
}


JSValue jsSVGRectElementNearestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->nearestViewportElement()));
    return result;
}


JSValue jsSVGRectElementFarthestViewportElement(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->farthestViewportElement()));
    return result;
}


JSValue jsSVGRectElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSVGRectElement* domObject = jsCast<JSSVGRectElement*>(asObject(slotBase));
    return JSSVGRectElement::getConstructor(exec, domObject->globalObject());
}

void JSSVGRectElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSVGRectElement* thisObject = jsCast<JSSVGRectElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSVGRectElement, Base>(exec, propertyName, value, &JSSVGRectElementTable, thisObject, slot);
}

void setJSSVGRectElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(thisObject);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    impl->setXmllang(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


void setJSSVGRectElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(thisObject);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    impl->setXmlspace(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


JSValue JSSVGRectElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGRectElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsSVGRectElementPrototypeFunctionHasExtension(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGRectElement::s_info))
        return throwVMTypeError(exec);
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGRectElement::s_info);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    const String& extension(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsBoolean(impl->hasExtension(extension));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGRectElementPrototypeFunctionGetPresentationAttribute(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGRectElement::s_info))
        return throwVMTypeError(exec);
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGRectElement::s_info);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    const String& name(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).isEmpty() ? String() : MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->getPresentationAttribute(name)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGRectElementPrototypeFunctionGetBBox(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGRectElement::s_info))
        return throwVMTypeError(exec);
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGRectElement::s_info);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<FloatRect>::create(impl->getBBox())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGRectElementPrototypeFunctionGetCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGRectElement::s_info))
        return throwVMTypeError(exec);
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGRectElement::s_info);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGRectElementPrototypeFunctionGetScreenCTM(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGRectElement::s_info))
        return throwVMTypeError(exec);
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGRectElement::s_info);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getScreenCTM())));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsSVGRectElementPrototypeFunctionGetTransformToElement(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSSVGRectElement::s_info))
        return throwVMTypeError(exec);
    JSSVGRectElement* castedThis = jsCast<JSSVGRectElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSSVGRectElement::s_info);
    SVGRectElement* impl = static_cast<SVGRectElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    SVGElement* element(toSVGElement(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined)));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(SVGPropertyTearOff<SVGMatrix>::create(impl->getTransformToElement(element, ec))));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}


}

#endif // ENABLE(SVG)
