/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSUint16Array.h"

#include "ExceptionCode.h"
#include "JSArrayBufferViewHelper.h"
#include "JSDOMBinding.h"
#include "JSUint16Array.h"
#include <runtime/Error.h>
#include <runtime/PropertyNameArray.h>
#include <wtf/GetPtr.h>
#include <wtf/Uint16Array.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSUint16ArrayTableValues[] =
{
    { "length", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUint16ArrayLength), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUint16ArrayConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSUint16ArrayTable = { 5, 3, JSUint16ArrayTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSUint16ArrayConstructorTableValues[] =
{
    { "BYTES_PER_ELEMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUint16ArrayBYTES_PER_ELEMENT), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSUint16ArrayConstructorTable = { 2, 1, JSUint16ArrayConstructorTableValues, 0 };
static const HashTable* getJSUint16ArrayConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSUint16ArrayConstructorTable);
}

const ClassInfo JSUint16ArrayConstructor::s_info = { "Uint16ArrayConstructor", &Base::s_info, 0, getJSUint16ArrayConstructorTable, CREATE_METHOD_TABLE(JSUint16ArrayConstructor) };

JSUint16ArrayConstructor::JSUint16ArrayConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSUint16ArrayConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSUint16ArrayPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->globalData(), exec->propertyNames().length, jsNumber(1), ReadOnly | DontDelete | DontEnum);
}

bool JSUint16ArrayConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSUint16ArrayConstructor, JSDOMWrapper>(exec, getJSUint16ArrayConstructorTable(exec), jsCast<JSUint16ArrayConstructor*>(cell), propertyName, slot);
}

bool JSUint16ArrayConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSUint16ArrayConstructor, JSDOMWrapper>(exec, getJSUint16ArrayConstructorTable(exec), jsCast<JSUint16ArrayConstructor*>(object), propertyName, descriptor);
}

EncodedJSValue JSC_HOST_CALL JSUint16ArrayConstructor::constructJSUint16Array(ExecState* exec)
{
    JSUint16ArrayConstructor* jsConstructor = jsCast<JSUint16ArrayConstructor*>(exec->callee());
    RefPtr<Uint16Array> array = constructArrayBufferView<Uint16Array, unsigned short>(exec);
    if (!array.get())
        // Exception has already been thrown.
        return JSValue::encode(JSValue());
    return JSValue::encode(asObject(toJS(exec, jsConstructor->globalObject(), array.get())));
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Uint16Array* object)
{
    return toJSArrayBufferView<JSUint16Array>(exec, globalObject, object);
}

void JSUint16Array::indexSetter(JSC::ExecState* exec, unsigned index, JSC::JSValue value)
{
    impl()->set(index, value.toNumber(exec));
}

ConstructType JSUint16ArrayConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSUint16Array;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSUint16ArrayPrototypeTableValues[] =
{
    { "BYTES_PER_ELEMENT", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsUint16ArrayBYTES_PER_ELEMENT), (intptr_t)0, NoIntrinsic },
    { "subarray", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsUint16ArrayPrototypeFunctionSubarray), (intptr_t)2, NoIntrinsic },
    { "set", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsUint16ArrayPrototypeFunctionSet), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSUint16ArrayPrototypeTable = { 8, 7, JSUint16ArrayPrototypeTableValues, 0 };
static const HashTable* getJSUint16ArrayPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSUint16ArrayPrototypeTable);
}

const ClassInfo JSUint16ArrayPrototype::s_info = { "Uint16ArrayPrototype", &Base::s_info, 0, getJSUint16ArrayPrototypeTable, CREATE_METHOD_TABLE(JSUint16ArrayPrototype) };

JSObject* JSUint16ArrayPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSUint16Array>(exec, globalObject);
}

bool JSUint16ArrayPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSUint16ArrayPrototype* thisObject = jsCast<JSUint16ArrayPrototype*>(cell);
    return getStaticPropertySlot<JSUint16ArrayPrototype, JSObject>(exec, getJSUint16ArrayPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSUint16ArrayPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSUint16ArrayPrototype* thisObject = jsCast<JSUint16ArrayPrototype*>(object);
    return getStaticPropertyDescriptor<JSUint16ArrayPrototype, JSObject>(exec, getJSUint16ArrayPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSUint16ArrayTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSUint16ArrayTable);
}

const ClassInfo JSUint16Array::s_info = { "Uint16Array", &Base::s_info, 0, getJSUint16ArrayTable , CREATE_METHOD_TABLE(JSUint16Array) };

JSUint16Array::JSUint16Array(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Uint16Array> impl)
    : JSArrayBufferView(structure, globalObject, impl)
{
}

void JSUint16Array::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    TypedArrayDescriptor descriptor(&JSUint16Array::s_info, OBJECT_OFFSETOF(JSUint16Array, m_storage), OBJECT_OFFSETOF(JSUint16Array, m_storageLength));
    globalData.registerTypedArrayDescriptor(impl(), descriptor);
    m_storage = impl()->data();
    m_storageLength = impl()->length();
    ASSERT(inherits(&s_info));
}

JSObject* JSUint16Array::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSUint16ArrayPrototype::create(exec->globalData(), globalObject, JSUint16ArrayPrototype::createStructure(exec->globalData(), globalObject, JSArrayBufferViewPrototype::self(exec, globalObject)));
}

bool JSUint16Array::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSUint16Array* thisObject = jsCast<JSUint16Array*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<Uint16Array*>(thisObject->impl())->length()) {
        slot.setValue(thisObject->getByIndex(exec, index));
        return true;
    }
    return getStaticValueSlot<JSUint16Array, Base>(exec, getJSUint16ArrayTable(exec), thisObject, propertyName, slot);
}

bool JSUint16Array::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSUint16Array* thisObject = jsCast<JSUint16Array*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex && index < static_cast<Uint16Array*>(thisObject->impl())->length()) {
        descriptor.setDescriptor(thisObject->getByIndex(exec, index), DontDelete);
        return true;
    }
    return getStaticValueDescriptor<JSUint16Array, Base>(exec, getJSUint16ArrayTable(exec), thisObject, propertyName, descriptor);
}

bool JSUint16Array::getOwnPropertySlotByIndex(JSCell* cell, ExecState* exec, unsigned index, PropertySlot& slot)
{
    JSUint16Array* thisObject = jsCast<JSUint16Array*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index < static_cast<Uint16Array*>(thisObject->impl())->length()) {
        slot.setValue(thisObject->getByIndex(exec, index));
        return true;
    }
    return Base::getOwnPropertySlotByIndex(thisObject, exec, index, slot);
}

JSValue jsUint16ArrayLength(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSUint16Array* castedThis = jsCast<JSUint16Array*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Uint16Array* impl = static_cast<Uint16Array*>(castedThis->impl());
    JSValue result = jsNumber(impl->length());
    return result;
}


JSValue jsUint16ArrayConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSUint16Array* domObject = jsCast<JSUint16Array*>(asObject(slotBase));
    return JSUint16Array::getConstructor(exec, domObject->globalObject());
}

void JSUint16Array::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSUint16Array* thisObject = jsCast<JSUint16Array*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    unsigned index = propertyName.asIndex();
    if (index != PropertyName::NotAnIndex) {
        thisObject->indexSetter(exec, index, value);
        return;
    }
    Base::put(thisObject, exec, propertyName, value, slot);
}

void JSUint16Array::putByIndex(JSCell* cell, ExecState* exec, unsigned index, JSValue value, bool shouldThrow)
{
    JSUint16Array* thisObject = jsCast<JSUint16Array*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    if (index <= MAX_ARRAY_INDEX) {
        UNUSED_PARAM(shouldThrow);
        thisObject->indexSetter(exec, index, value);
        return;
    }
    Base::putByIndex(cell, exec, index, value, shouldThrow);
}

void JSUint16Array::getOwnPropertyNames(JSObject* object, ExecState* exec, PropertyNameArray& propertyNames, EnumerationMode mode)
{
    JSUint16Array* thisObject = jsCast<JSUint16Array*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    for (unsigned i = 0; i < static_cast<Uint16Array*>(thisObject->impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getOwnPropertyNames(thisObject, exec, propertyNames, mode);
}

JSValue JSUint16Array::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSUint16ArrayConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsUint16ArrayPrototypeFunctionSubarray(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSUint16Array::s_info))
        return throwVMTypeError(exec);
    JSUint16Array* castedThis = jsCast<JSUint16Array*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSUint16Array::s_info);
    Uint16Array* impl = static_cast<Uint16Array*>(castedThis->impl());
    int start(MAYBE_MISSING_PARAMETER(exec, 0, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    size_t argsCount = exec->argumentCount();
    if (argsCount <= 1) {

        JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->subarray(start)));
        return JSValue::encode(result);
    }

    int end(MAYBE_MISSING_PARAMETER(exec, 1, DefaultIsUndefined).toInt32(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->subarray(start, end)));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsUint16ArrayPrototypeFunctionSet(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSUint16Array::s_info))
        return throwVMTypeError(exec);
    JSUint16Array* castedThis = jsCast<JSUint16Array*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSUint16Array::s_info);
    return JSValue::encode(setWebGLArrayHelper<Uint16Array, unsigned short>(exec, castedThis->impl()));
}

// Constant getters

JSValue jsUint16ArrayBYTES_PER_ELEMENT(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}


JSValue JSUint16Array::getByIndex(ExecState*, unsigned index)
{
    ASSERT_GC_OBJECT_INHERITS(this, &s_info);
    double result = static_cast<Uint16Array*>(impl())->item(index);
    if (isnan(result))
        return jsNaN();
    return JSValue(result);
}

Uint16Array* toUint16Array(JSC::JSValue value)
{
    return value.inherits(&JSUint16Array::s_info) ? jsCast<JSUint16Array*>(asObject(value))->impl() : 0;
}

}
