/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(BLOB) || ENABLE(FILE_SYSTEM)

#include "JSFileException.h"

#include "ExceptionCode.h"
#include "FileException.h"
#include "JSDOMBinding.h"
#include "KURL.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSFileExceptionTableValues[] =
{
    { "code", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionCode), (intptr_t)0, NoIntrinsic },
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionName), (intptr_t)0, NoIntrinsic },
    { "message", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionMessage), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSFileExceptionTable = { 10, 7, JSFileExceptionTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSFileExceptionConstructorTableValues[] =
{
    { "NOT_FOUND_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionNOT_FOUND_ERR), (intptr_t)0, NoIntrinsic },
    { "SECURITY_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionSECURITY_ERR), (intptr_t)0, NoIntrinsic },
    { "ABORT_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionABORT_ERR), (intptr_t)0, NoIntrinsic },
    { "NOT_READABLE_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionNOT_READABLE_ERR), (intptr_t)0, NoIntrinsic },
    { "ENCODING_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionENCODING_ERR), (intptr_t)0, NoIntrinsic },
    { "NO_MODIFICATION_ALLOWED_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionNO_MODIFICATION_ALLOWED_ERR), (intptr_t)0, NoIntrinsic },
    { "INVALID_STATE_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionINVALID_STATE_ERR), (intptr_t)0, NoIntrinsic },
    { "SYNTAX_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionSYNTAX_ERR), (intptr_t)0, NoIntrinsic },
    { "INVALID_MODIFICATION_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionINVALID_MODIFICATION_ERR), (intptr_t)0, NoIntrinsic },
    { "QUOTA_EXCEEDED_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionQUOTA_EXCEEDED_ERR), (intptr_t)0, NoIntrinsic },
    { "TYPE_MISMATCH_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionTYPE_MISMATCH_ERR), (intptr_t)0, NoIntrinsic },
    { "PATH_EXISTS_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionPATH_EXISTS_ERR), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSFileExceptionConstructorTable = { 34, 31, JSFileExceptionConstructorTableValues, 0 };
static const HashTable* getJSFileExceptionConstructorTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSFileExceptionConstructorTable);
}

const ClassInfo JSFileExceptionConstructor::s_info = { "FileExceptionConstructor", &Base::s_info, 0, getJSFileExceptionConstructorTable, CREATE_METHOD_TABLE(JSFileExceptionConstructor) };

JSFileExceptionConstructor::JSFileExceptionConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSFileExceptionConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSFileExceptionPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSFileExceptionConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSFileExceptionConstructor, JSDOMWrapper>(exec, getJSFileExceptionConstructorTable(exec), jsCast<JSFileExceptionConstructor*>(cell), propertyName, slot);
}

bool JSFileExceptionConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSFileExceptionConstructor, JSDOMWrapper>(exec, getJSFileExceptionConstructorTable(exec), jsCast<JSFileExceptionConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSFileExceptionPrototypeTableValues[] =
{
    { "NOT_FOUND_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionNOT_FOUND_ERR), (intptr_t)0, NoIntrinsic },
    { "SECURITY_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionSECURITY_ERR), (intptr_t)0, NoIntrinsic },
    { "ABORT_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionABORT_ERR), (intptr_t)0, NoIntrinsic },
    { "NOT_READABLE_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionNOT_READABLE_ERR), (intptr_t)0, NoIntrinsic },
    { "ENCODING_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionENCODING_ERR), (intptr_t)0, NoIntrinsic },
    { "NO_MODIFICATION_ALLOWED_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionNO_MODIFICATION_ALLOWED_ERR), (intptr_t)0, NoIntrinsic },
    { "INVALID_STATE_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionINVALID_STATE_ERR), (intptr_t)0, NoIntrinsic },
    { "SYNTAX_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionSYNTAX_ERR), (intptr_t)0, NoIntrinsic },
    { "INVALID_MODIFICATION_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionINVALID_MODIFICATION_ERR), (intptr_t)0, NoIntrinsic },
    { "QUOTA_EXCEEDED_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionQUOTA_EXCEEDED_ERR), (intptr_t)0, NoIntrinsic },
    { "TYPE_MISMATCH_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionTYPE_MISMATCH_ERR), (intptr_t)0, NoIntrinsic },
    { "PATH_EXISTS_ERR", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsFileExceptionPATH_EXISTS_ERR), (intptr_t)0, NoIntrinsic },
    { "toString", DontDelete | DontEnum | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsFileExceptionPrototypeFunctionToString), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSFileExceptionPrototypeTable = { 35, 31, JSFileExceptionPrototypeTableValues, 0 };
static const HashTable* getJSFileExceptionPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSFileExceptionPrototypeTable);
}

const ClassInfo JSFileExceptionPrototype::s_info = { "FileExceptionPrototype", &Base::s_info, 0, getJSFileExceptionPrototypeTable, CREATE_METHOD_TABLE(JSFileExceptionPrototype) };

JSObject* JSFileExceptionPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSFileException>(exec, globalObject);
}

bool JSFileExceptionPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSFileExceptionPrototype* thisObject = jsCast<JSFileExceptionPrototype*>(cell);
    return getStaticPropertySlot<JSFileExceptionPrototype, JSObject>(exec, getJSFileExceptionPrototypeTable(exec), thisObject, propertyName, slot);
}

bool JSFileExceptionPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSFileExceptionPrototype* thisObject = jsCast<JSFileExceptionPrototype*>(object);
    return getStaticPropertyDescriptor<JSFileExceptionPrototype, JSObject>(exec, getJSFileExceptionPrototypeTable(exec), thisObject, propertyName, descriptor);
}

static const HashTable* getJSFileExceptionTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSFileExceptionTable);
}

const ClassInfo JSFileException::s_info = { "FileException", &Base::s_info, 0, getJSFileExceptionTable , CREATE_METHOD_TABLE(JSFileException) };

JSFileException::JSFileException(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<FileException> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSFileException::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSFileException::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSFileExceptionPrototype::create(exec->globalData(), globalObject, JSFileExceptionPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->errorPrototype()));
}

void JSFileException::destroy(JSC::JSCell* cell)
{
    JSFileException* thisObject = static_cast<JSFileException*>(cell);
    thisObject->JSFileException::~JSFileException();
}

JSFileException::~JSFileException()
{
    releaseImplIfNotNull();
}

bool JSFileException::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSFileException* thisObject = jsCast<JSFileException*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSFileException, Base>(exec, getJSFileExceptionTable(exec), thisObject, propertyName, slot);
}

bool JSFileException::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSFileException* thisObject = jsCast<JSFileException*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSFileException, Base>(exec, getJSFileExceptionTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsFileExceptionCode(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileException* castedThis = jsCast<JSFileException*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileException* impl = static_cast<FileException*>(castedThis->impl());
    JSValue result = jsNumber(impl->code());
    return result;
}


JSValue jsFileExceptionName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileException* castedThis = jsCast<JSFileException*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileException* impl = static_cast<FileException*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->name());
    return result;
}


JSValue jsFileExceptionMessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileException* castedThis = jsCast<JSFileException*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    FileException* impl = static_cast<FileException*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->message());
    return result;
}


JSValue jsFileExceptionConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSFileException* domObject = jsCast<JSFileException*>(asObject(slotBase));
    return JSFileException::getConstructor(exec, domObject->globalObject());
}

JSValue JSFileException::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSFileExceptionConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsFileExceptionPrototypeFunctionToString(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSFileException::s_info))
        return throwVMTypeError(exec);
    JSFileException* castedThis = jsCast<JSFileException*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSFileException::s_info);
    FileException* impl = static_cast<FileException*>(castedThis->impl());

    JSC::JSValue result = jsStringWithCache(exec, impl->toString());
    return JSValue::encode(result);
}

// Constant getters

JSValue jsFileExceptionNOT_FOUND_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsFileExceptionSECURITY_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsFileExceptionABORT_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsFileExceptionNOT_READABLE_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}

JSValue jsFileExceptionENCODING_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(5));
}

JSValue jsFileExceptionNO_MODIFICATION_ALLOWED_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(6));
}

JSValue jsFileExceptionINVALID_STATE_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(7));
}

JSValue jsFileExceptionSYNTAX_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(8));
}

JSValue jsFileExceptionINVALID_MODIFICATION_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(9));
}

JSValue jsFileExceptionQUOTA_EXCEEDED_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(10));
}

JSValue jsFileExceptionTYPE_MISMATCH_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(11));
}

JSValue jsFileExceptionPATH_EXISTS_ERR(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(12));
}

static inline bool isObservable(JSFileException* jsFileException)
{
    if (jsFileException->hasCustomProperties())
        return true;
    return false;
}

bool JSFileExceptionOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSFileException* jsFileException = jsCast<JSFileException*>(handle.get().asCell());
    if (!isObservable(jsFileException))
        return false;
    UNUSED_PARAM(visitor);
    return false;
}

void JSFileExceptionOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSFileException* jsFileException = jsCast<JSFileException*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsFileException->impl(), jsFileException);
    jsFileException->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, FileException* impl)
{
    return wrap<JSFileException>(exec, globalObject, impl);
}

FileException* toFileException(JSC::JSValue value)
{
    return value.inherits(&JSFileException::s_info) ? jsCast<JSFileException*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(BLOB) || ENABLE(FILE_SYSTEM)
