/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SHARED_WORKERS)

#include "JSSharedWorkerContext.h"

#include "EventListener.h"
#include "JSEventListener.h"
#include "KURL.h"
#include "SharedWorkerContext.h"
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSSharedWorkerContextTableValues[] =
{
    { "name", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSharedWorkerContextName), (intptr_t)0, NoIntrinsic },
    { "onconnect", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSharedWorkerContextOnconnect), (intptr_t)setJSSharedWorkerContextOnconnect, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSharedWorkerContextTable = { 4, 3, JSSharedWorkerContextTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSSharedWorkerContextPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSSharedWorkerContextPrototypeTable = { 1, 0, JSSharedWorkerContextPrototypeTableValues, 0 };
static const HashTable* getJSSharedWorkerContextPrototypeTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSSharedWorkerContextPrototypeTable);
}

const ClassInfo JSSharedWorkerContextPrototype::s_info = { "SharedWorkerContextPrototype", &Base::s_info, 0, getJSSharedWorkerContextPrototypeTable, CREATE_METHOD_TABLE(JSSharedWorkerContextPrototype) };

static const HashTable* getJSSharedWorkerContextTable(ExecState* exec)
{
    return getHashTableForGlobalData(exec->globalData(), &JSSharedWorkerContextTable);
}

const ClassInfo JSSharedWorkerContext::s_info = { "SharedWorkerContext", &Base::s_info, 0, getJSSharedWorkerContextTable , CREATE_METHOD_TABLE(JSSharedWorkerContext) };

JSSharedWorkerContext::JSSharedWorkerContext(JSGlobalData& globalData, Structure* structure, PassRefPtr<SharedWorkerContext> impl)
    : JSWorkerContext(globalData, structure, impl)
{
}

bool JSSharedWorkerContext::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSSharedWorkerContext* thisObject = jsCast<JSSharedWorkerContext*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSSharedWorkerContext, Base>(exec, getJSSharedWorkerContextTable(exec), thisObject, propertyName, slot);
}

bool JSSharedWorkerContext::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSSharedWorkerContext* thisObject = jsCast<JSSharedWorkerContext*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSSharedWorkerContext, Base>(exec, getJSSharedWorkerContextTable(exec), thisObject, propertyName, descriptor);
}

JSValue jsSharedWorkerContextName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSharedWorkerContext* castedThis = jsCast<JSSharedWorkerContext*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SharedWorkerContext* impl = static_cast<SharedWorkerContext*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->name());
    return result;
}


JSValue jsSharedWorkerContextOnconnect(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSSharedWorkerContext* castedThis = jsCast<JSSharedWorkerContext*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SharedWorkerContext* impl = static_cast<SharedWorkerContext*>(castedThis->impl());
    if (EventListener* listener = impl->onconnect()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl))
                return jsFunction;
        }
    }
    return jsNull();
}


void JSSharedWorkerContext::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSSharedWorkerContext* thisObject = jsCast<JSSharedWorkerContext*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSSharedWorkerContext, Base>(exec, propertyName, value, getJSSharedWorkerContextTable(exec), thisObject, slot);
}

void setJSSharedWorkerContextOnconnect(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSSharedWorkerContext* castedThis = jsCast<JSSharedWorkerContext*>(thisObject);
    SharedWorkerContext* impl = static_cast<SharedWorkerContext*>(castedThis->impl());
    impl->setOnconnect(createJSAttributeEventListener(exec, value, thisObject));
}


SharedWorkerContext* toSharedWorkerContext(JSC::JSValue value)
{
    return value.inherits(&JSSharedWorkerContext::s_info) ? jsCast<JSSharedWorkerContext*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(SHARED_WORKERS)
