/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSOESElementIndexUint.h"

#include "OESElementIndexUint.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table for prototype */

static const HashTableValue JSOESElementIndexUintPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSOESElementIndexUintPrototypeTable = { 1, 0, JSOESElementIndexUintPrototypeTableValues, 0 };
const ClassInfo JSOESElementIndexUintPrototype::s_info = { "OESElementIndexUintPrototype", &Base::s_info, &JSOESElementIndexUintPrototypeTable, 0, CREATE_METHOD_TABLE(JSOESElementIndexUintPrototype) };

JSObject* JSOESElementIndexUintPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSOESElementIndexUint>(exec, globalObject);
}

const ClassInfo JSOESElementIndexUint::s_info = { "OESElementIndexUint", &Base::s_info, 0, 0 , CREATE_METHOD_TABLE(JSOESElementIndexUint) };

JSOESElementIndexUint::JSOESElementIndexUint(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<OESElementIndexUint> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSOESElementIndexUint::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSOESElementIndexUint::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSOESElementIndexUintPrototype::create(exec->globalData(), globalObject, JSOESElementIndexUintPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSOESElementIndexUint::destroy(JSC::JSCell* cell)
{
    JSOESElementIndexUint* thisObject = static_cast<JSOESElementIndexUint*>(cell);
    thisObject->JSOESElementIndexUint::~JSOESElementIndexUint();
}

JSOESElementIndexUint::~JSOESElementIndexUint()
{
    releaseImplIfNotNull();
}

static inline bool isObservable(JSOESElementIndexUint* jsOESElementIndexUint)
{
    if (jsOESElementIndexUint->hasCustomProperties())
        return true;
    return false;
}

bool JSOESElementIndexUintOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSOESElementIndexUint* jsOESElementIndexUint = jsCast<JSOESElementIndexUint*>(handle.get().asCell());
    if (!isObservable(jsOESElementIndexUint))
        return false;
    WebGLRenderingContext* root = jsOESElementIndexUint->impl()->context();
    return visitor.containsOpaqueRoot(root);
}

void JSOESElementIndexUintOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSOESElementIndexUint* jsOESElementIndexUint = jsCast<JSOESElementIndexUint*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsOESElementIndexUint->impl(), jsOESElementIndexUint);
    jsOESElementIndexUint->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, OESElementIndexUint* impl)
{
    return wrap<JSOESElementIndexUint>(exec, globalObject, impl);
}

OESElementIndexUint* toOESElementIndexUint(JSC::JSValue value)
{
    return value.inherits(&JSOESElementIndexUint::s_info) ? jsCast<JSOESElementIndexUint*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(WEBGL)
