/* bzflag
 * Copyright (c) 1993-2025 Tim Riker
 *
 * This package is free software;  you can redistribute it and/or
 * modify it under the terms of the license found in the file
 * named COPYING that should have accompanied this file.
 *
 * THIS PACKAGE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#ifndef __CUSTOM_SPHERE_H__
#define __CUSTOM_SPHERE_H__

/* interface header */
#include "WorldFileObstacle.h"

/* common interface headers */
#include "BzMaterial.h"

/* local interface headers */
#include "WorldInfo.h"


class CustomSphere : public WorldFileObstacle
{
public:
    CustomSphere();
    ~CustomSphere();
    bool read(const char *cmd, std::istream& input) override;
    void writeToGroupDef(GroupDefinition*) override;

private:
    enum
    {
        Edge,
        Bottom,
        MaterialCount
    };
    static const char* sideNames[MaterialCount];

    int divisions;
    float texsize[2];
    bool hemisphere;
    int phydrv;
    bool useNormals;
    bool smoothBounce;
    BzMaterial materials[MaterialCount];
};


#endif  /* __CUSTOM_SPHERE_H__ */

// Local variables: ***
// mode: C++ ***
// tab-width: 4***
// c-basic-offset: 4 ***
// indent-tabs-mode: nil ***
// End: ***
// ex: shiftwidth=4 tabstop=4
