from __future__ import absolute_import, division, print_function
import os, sys
import time
#import libtbx.load_env

from mmtbx import monomer_library
import mmtbx.monomer_library.server
from cctbx.array_family import flex
import mmtbx.model
import mmtbx.monomer_library.pdb_interpretation
from six.moves import cStringIO as StringIO
#from mmtbx import utils
#from libtbx.utils import format_cpu_times

from mmtbx import conformation_dependent_library as cdl
from mmtbx.conformation_dependent_library import cdl_utils, cdl_setup
from mmtbx.conformation_dependent_library.cdl_database import cdl_database
from six.moves import range

filenames = {
  "cdl_test_1.pdb" : [
    [
      "IleVal_nonxpro",
      "NonPGIV_nonxpro",
      "Gly_nonxpro",
      ],
    [
      (-100, 110),
      ( -70, 150),
      ( -80, 160),
      ],
    [
      ["B",  30, 122.93],
      ["B", 177, 120.94],
      ["B",  16, 120.64],
      ],
    ],
  "cdl_test_2.pdb" : [
    [
      "NonPGIV_nonxpro",
      "NonPGIV_nonxpro",
      "NonPGIV_nonxpro",
      "NonPGIV_nonxpro",
      ],
    [
      ( 170, -40),
      (-110, 160),
      ( 170, -40),
      (-110, 160),
      ],
    [
      ["I", 10921, 121.54],
      ["B",    85, 122.92],
      ["I", 10921, 121.54],
      ["B",    85, 122.92],
      ],
    ],
  "cdl_test_3.pdb" : [
    [
      "NonPGIV_nonxpro",
      "NonPGIV_xpro",
      "Pro_nonxpro",
      "Gly_nonxpro",
      ],
    [
      (-130,  20),
      (-120,  90),
      ( -50, 130),
      (  90,   0),
      ],
    [
      ["B",    24, 122.14],
      ["B",     7, 123.30],
      ["B",    21, 119.93],
      ["B",    79, 122.05],
      ],
    ],
  "cdl_test_4.pdb" : [
    [
      "IleVal_xpro",
      "Pro_nonxpro",
      "IleVal_xpro",
      "Pro_nonxpro",
      ],
    [
      (-150, 150),
      ( -70, 140),
      (-150, 150),
      ( -70, 140),
      ],
    [
      ["I",    81, 122.13],
      ["B",    44, 119.76],
      ["I",    81, 122.13],
      ["B",    44, 119.76],
      ],
    ],
  "cdl_test_5.pdb" : [
    [
      "Gly_xpro",
      "Pro_xpro",
      "Pro_nonxpro",
      "Gly_nonxpro",
      ],
    [
      ( 170,  70),
      ( -30, 160),
      ( -30, 160),
      (-180,-160),
      ],
    [
      ["I",    44, 121.87],
      ["I",    12, 120.38],
      ["I",   639, 119.84],
      ["B",     7, 120.51],
      ],
    ],
  "cdl_test_7.pdb" : [
    [
      "NonPGIV_nonxpro", # A
      "NonPGIV_nonxpro",
      "NonPGIV_nonxpro",
      "NonPGIV_nonxpro", # B
      "NonPGIV_nonxpro",
      "NonPGIV_nonxpro",
      ],
    [
      (-110, 100),
      ( -60, -30),
      ( -60, -30),
      (-110, 100),
      ( -50, -40),
      ( -70, -20),
      ],
    [
      ["B",    46, 123.14],
      ["B",   718, 120.28],
      ["B",   718, 120.28],
      ["B",    46, 123.14],
      ["B",   254, 120.38],
      ["B",   436, 120.72],
      ],
    [
     (27, 28, 29),
     (29, 28, 27),
     (28, 29),
     (11, 27, 28),
     (28, 27, 11),
     (11, 27),
     (27, 28),
     ],
    ],
  "cdl_test_8.pdb" : [
    [
      "NonPGIV_xpro",
      ],
    [
      ( -70, 130),
      ],
    [
      ['B', 15, 120.67],
      ],
    [
      True,
      ],
    ],
  "cdl_test_9.pdb" : [
    [
      'IleVal_nonxpro',
      ],
    [
      None,
      ],
    [
      None,
      ],
    ]
  }

output_filenames = {
  "cdl_test_1.pdb" : """CRYST1   78.400   78.400   36.970  90.00  90.00  90.00 P 43 21 2     8
ORIGX1      1.000000  0.000000  0.000000        0.00000
ORIGX2      0.000000  1.000000  0.000000        0.00000
ORIGX3      0.000000  0.000000  1.000000        0.00000
SCALE1      0.012755  0.000000  0.000000        0.00000
SCALE2      0.000000  0.012755  0.000000        0.00000
SCALE3      0.000000  0.000000  0.027049        0.00000
ATOM      1  N   LYS A   1       2.978  10.061   9.810  1.00 18.67           N
ATOM      2  CA  LYS A   1       2.042  10.475   8.681  1.00 18.31           C
ATOM      3  C   LYS A   1       2.170  11.990   8.529  1.00 19.54           C
ATOM      4  O   LYS A   1       2.174  12.724   9.562  1.00 18.93           O
ATOM      5  CB  LYS A   1       0.614  10.079   9.071  1.00 18.68           C
ATOM      6  CG  LYS A   1      -0.468  10.538   8.055  1.00 20.33           C
ATOM      7  CD  LYS A   1      -1.793   9.976   8.472  1.00 23.73           C
ATOM      8  CE  LYS A   1      -2.857  10.739   7.745  1.00 27.82           C
ATOM      9  NZ  LYS A   1      -4.139   9.932   7.827  1.00 35.12           N
ATOM     10  N   VAL A   2       2.301  12.446   7.281  1.00 20.08           N
ATOM     11  CA  VAL A   2       2.189  13.827   6.988  1.00 19.50           C
ATOM     12  C   VAL A   2       0.780  14.077   6.459  1.00 20.53           C
ATOM     13  O   VAL A   2       0.455  13.617   5.317  1.00 21.79           O
ATOM     14  CB  VAL A   2       3.230  14.266   5.965  1.00 19.74           C
ATOM     15  CG1 VAL A   2       3.079  15.706   5.710  1.00 19.95           C
ATOM     16  CG2 VAL A   2       4.675  13.969   6.492  1.00 20.88           C
ATOM     17  N   PHE A   3      -0.025  14.816   7.224  1.00 19.86           N
ATOM     18  CA  PHE A   3      -1.383  15.190   6.817  1.00 19.37           C
ATOM     19  C   PHE A   3      -1.385  16.251   5.760  1.00 19.48           C
ATOM     20  O   PHE A   3      -0.541  17.116   5.732  1.00 19.87           O
ATOM     21  CB  PHE A   3      -2.184  15.760   7.983  1.00 17.99           C
ATOM     22  CG  PHE A   3      -2.764  14.735   8.851  1.00 19.05           C
ATOM     23  CD1 PHE A   3      -1.965  14.098   9.821  1.00 17.66           C
ATOM     24  CD2 PHE A   3      -4.096  14.381   8.763  1.00 17.74           C
ATOM     25  CE1 PHE A   3      -2.519  13.100  10.640  1.00 19.73           C
ATOM     26  CE2 PHE A   3      -4.613  13.367   9.590  1.00 16.68           C
ATOM     27  CZ  PHE A   3      -3.842  12.762  10.524  1.00 20.53           C
ATOM     28  N   GLY A   4      -2.390  16.210   4.856  1.00 21.93           N
ATOM     29  CA  GLY A   4      -2.669  17.427   4.119  1.00 20.88           C
ATOM     30  C   GLY A   4      -3.440  18.425   4.971  1.00 20.46           C
ATOM     31  O   GLY A   4      -4.063  18.017   5.942  1.00 20.59           O
ATOM     32  N   ARG A   5      -3.452  19.702   4.585  1.00 20.64           N
ATOM     33  CA  ARG A   5      -4.145  20.738   5.384  1.00 22.42           C
ATOM     34  C   ARG A   5      -5.629  20.426   5.653  1.00 23.55           C
ATOM     35  O   ARG A   5      -6.065  20.496   6.804  1.00 22.39           O
ATOM     36  CB  ARG A   5      -4.019  22.075   4.644  1.00 23.43           C
ATOM     37  CG  ARG A   5      -4.695  23.187   5.211  1.00 21.72           C
ATOM     38  CD  ARG A   5      -4.439  24.429   4.291  1.00 23.07           C
ATOM     39  NE  ARG A   5      -4.978  24.334   2.924  1.00 26.36           N
ATOM     40  CZ  ARG A   5      -6.256  24.606   2.606  1.00 29.93           C
ATOM     41  NH1 ARG A   5      -7.155  25.021   3.533  1.00 29.05           N
ATOM     42  NH2 ARG A   5      -6.634  24.532   1.335  1.00 30.26           N
END
""",
  "cdl_test_2.pdb" : """CRYST1   59.140   59.140  186.740  90.00  90.00 120.00 P 32 2 1      6
ORIGX1      1.000000  0.000000  0.000000        0.00000
ORIGX2      0.000000  1.000000  0.000000        0.00000
ORIGX3      0.000000  0.000000  1.000000        0.00000
SCALE1      0.016909  0.009762  0.000000        0.00000
SCALE2      0.000000  0.019525  0.000000        0.00000
SCALE3      0.000000  0.000000  0.005355        0.00000
ATOM   3708  N   ARG A 238      -3.155   2.964   9.280  1.00 26.44           N
ANISOU 3708  N   ARG A 238     2310   4436   3302   1501    -44   -636       N
ATOM   3709  CA  ARG A 238      -2.158   2.016   9.755  1.00 38.30           C
ANISOU 3709  CA  ARG A 238     2311   6253   5989   1912     86   1184       C
ATOM   3710  C   ARG A 238      -2.826   0.771  10.333  1.00 40.52           C
ANISOU 3710  C   ARG A 238     4415   4937   6042   2589   1562    468       C
ATOM   3711  O   ARG A 238      -2.916   0.609  11.567  1.00 70.06           O
ANISOU 3711  O   ARG A 238    13435   7190   5995   -711  -2846   3279       O
ATOM   3712  CB  ARG A 238      -1.347   2.771  10.834  1.00 46.30           C
ANISOU 3712  CB  ARG A 238     2187   7787   7618   1791  -1530   1440       C
ATOM   3713  CG  ARG A 238      -0.562   3.934  10.206  1.00 63.42           C
ANISOU 3713  CG  ARG A 238     4955   7689  11453     30    524    -36       C
ATOM   3714  CD  ARG A 238      -0.570   5.141  11.137  1.00 65.76           C
ANISOU 3714  CD  ARG A 238     3404   7864  13718   1672   3308  -1029       C
ATOM   3715  NE  ARG A 238      -1.611   6.058  10.682  1.00 74.79           N
ANISOU 3715  NE  ARG A 238     6336   7837  14243   1136    504    931       N
ATOM   3716  CZ  ARG A 238      -1.593   7.373  10.605  1.00 75.60           C
ANISOU 3716  CZ  ARG A 238     6297   7919  14508    415    192   1432       C
ATOM   3717  NH1 ARG A 238      -0.527   8.069  10.982  1.00 80.12           N
ANISOU 3717  NH1 ARG A 238     5536  10778  14127  -2180   3841   2359       N
ATOM   3718  NH2 ARG A 238      -2.657   8.042  10.161  1.00 77.75           N
ANISOU 3718  NH2 ARG A 238     5602   8669  15269   2476   3438   1117       N
ATOM   3719  H   ARG A 238      -3.639   3.361   9.870  1.00 31.73           H
ATOM   3720  HA  ARG A 238      -1.567   1.761   9.016  1.00 45.96           H
ATOM   3721  HB2 ARG A 238      -1.950   3.114  11.511  1.00 55.56           H
ATOM   3722  HB3 ARG A 238      -0.729   2.158  11.263  1.00 55.56           H
ATOM   3723  HG2 ARG A 238       0.353   3.657  10.039  1.00 76.11           H
ATOM   3724  HG3 ARG A 238      -0.964   4.176   9.357  1.00 76.11           H
ATOM   3725  HD2 ARG A 238      -0.750   4.858  12.048  1.00 78.91           H
ATOM   3726  HD3 ARG A 238       0.294   5.582  11.119  1.00 78.91           H
ATOM   3727  HE  ARG A 238      -2.343   5.685  10.427  1.00 89.75           H
ATOM   3728 HH11 ARG A 238       0.168   7.661  11.282  1.00 96.14           H
ATOM   3729 HH12 ARG A 238      -0.531   8.927  10.925  1.00 96.14           H
ATOM   3730 HH21 ARG A 238      -3.364   7.615   9.921  1.00 93.29           H
ATOM   3731 HH22 ARG A 238      -2.637   8.901  10.114  1.00 93.29           H
ATOM   3732  N   GLU A 239      -3.259  -0.180   9.507  1.00 61.01           N
ANISOU 3732  N   GLU A 239     8805   7109   7268   -465   1338   -107       N
ATOM   3733  CA  GLU A 239      -3.997  -1.358   9.938  1.00 54.21           C
ANISOU 3733  CA  GLU A 239     8081   6237   6280    626   1613   -200       C
ATOM   3734  C   GLU A 239      -4.598  -2.077   8.722  1.00 55.11           C
ANISOU 3734  C   GLU A 239     9152   5609   6177    510   1378     67       C
ATOM   3735  O   GLU A 239      -4.560  -3.307   8.677  1.00 57.38           O
ANISOU 3735  O   GLU A 239     9787   5373   6643  -1615   1558   1275       O
ATOM   3736  CB AGLU A 239      -5.113  -0.987  10.921  0.39 51.07           C
ANISOU 3736  CB AGLU A 239     7126   6478   5800   1665    682    270       C
ATOM   3737  CB BGLU A 239      -5.114  -0.984  10.899  0.61 51.10           C
ANISOU 3737  CB BGLU A 239     7361   6372   5685   1709    761    428       C
ATOM   3738  CG AGLU A 239      -5.565  -2.004  11.946  0.39 43.33           C
ANISOU 3738  CG AGLU A 239     5570   5396   5499   3079    821    -50       C
ATOM   3739  CG BGLU A 239      -4.827  -1.259  12.366  0.61 48.99           C
ANISOU 3739  CG BGLU A 239     6855   6082   5677   2131    459   -122       C
ATOM   3740  CD AGLU A 239      -6.502  -1.466  13.020  0.39 45.82           C
ANISOU 3740  CD AGLU A 239     6276   5460   5674   2634    906   -931       C
ATOM   3741  CD BGLU A 239      -5.877  -0.539  13.204  0.61 49.31           C
ANISOU 3741  CD BGLU A 239     7487   5254   5994   1837    445   -878       C
ATOM   3742  OE1AGLU A 239      -6.171  -0.475  13.703  0.39 42.67           O
ANISOU 3742  OE1AGLU A 239     5740   4028   6446   3819   -363   -267       O
ATOM   3743  OE1BGLU A 239      -6.510   0.403  12.702  0.61 49.13           O
ANISOU 3743  OE1BGLU A 239     6944   5966   5758   2026    402   -741       O
ATOM   3744  OE2AGLU A 239      -7.604  -2.032  13.226  0.39 42.34           O
ANISOU 3744  OE2AGLU A 239     5022   6899   4165   3057    -24  -1587       O
ATOM   3745  OE2BGLU A 239      -6.056  -0.967  14.344  0.61 45.41           O
ANISOU 3745  OE2BGLU A 239     9181   2709   5363   1565    407  -2132       O
ATOM   3746  H   GLU A 239      -3.092  -0.093   8.668  1.00 73.21           H
ATOM   3747  HA AGLU A 239      -3.376  -1.969  10.387  1.00 65.05           H
ATOM   3748  HB2AGLU A 239      -4.825  -0.196  11.402  0.39 61.28           H
ATOM   3749  HB2BGLU A 239      -5.304  -0.038  10.795  0.61 61.32           H
ATOM   3750  HB3AGLU A 239      -5.890  -0.734  10.398  0.39 61.28           H
ATOM   3751  HB3BGLU A 239      -5.913  -1.472  10.645  0.61 61.32           H
ATOM   3752  HG2AGLU A 239      -6.013  -2.730  11.483  0.39 52.00           H
ATOM   3753  HG2BGLU A 239      -4.861  -2.213  12.538  0.61 58.79           H
ATOM   3754  HG3AGLU A 239      -4.781  -2.375  12.379  0.39 52.00           H
ATOM   3755  HG3BGLU A 239      -3.941  -0.938  12.597  0.61 58.79           H
ATOM   3756  N   GLN A 240      -5.123  -1.256   7.820  1.00 51.78           N
ANISOU 3756  N   GLN A 240     7881   5786   6005   1303   1976   -299       N
ATOM   3757  CA  GLN A 240      -5.815  -1.651   6.579  1.00 48.42           C
ANISOU 3757  CA  GLN A 240     7439   5291   5667   1037   2360      0       C
ATOM   3758  C   GLN A 240      -4.914  -1.631   5.369  1.00 50.22           C
ANISOU 3758  C   GLN A 240     6823   6557   5702    323   2152    622       C
ATOM   3759  O   GLN A 240      -4.600  -0.753   4.598  1.00 48.60           O
ANISOU 3759  O   GLN A 240     3660   8042   6764   1632    953   2651       O
ATOM   3760  CB  GLN A 240      -7.093  -0.780   6.473  1.00 49.78           C
ANISOU 3760  CB  GLN A 240     7780   4950   6185   1171   1880   -549       C
ATOM   3761  CG  GLN A 240      -8.174  -1.308   7.405  1.00 42.82           C
ANISOU 3761  CG  GLN A 240     6648   3396   6227   2273    855   1000       C
ATOM   3762  CD  GLN A 240      -9.333  -0.374   7.653  1.00 41.20           C
ANISOU 3762  CD  GLN A 240     7296   3924   4435   2729    687    401       C
ATOM   3763  OE1 GLN A 240      -9.512   0.675   7.010  1.00 34.35           O
ANISOU 3763  OE1 GLN A 240     6339   2251   4461   1271  -2237  -1012       O
ATOM   3764  NE2 GLN A 240     -10.148  -0.767   8.636  1.00 55.98           N
ANISOU 3764  NE2 GLN A 240     6092   7850   7330   1793   1349   1644       N
ATOM   3765  H   GLN A 240      -5.053  -0.413   7.975  1.00 62.13           H
ATOM   3766  HA  GLN A 240      -6.110  -2.578   6.699  1.00 58.10           H
ATOM   3767  HB2 GLN A 240      -6.882   0.138   6.707  1.00 59.74           H
ATOM   3768  HB3 GLN A 240      -7.419  -0.790   5.559  1.00 59.74           H
ATOM   3769  HG2 GLN A 240      -8.521  -2.135   7.034  1.00 51.39           H
ATOM   3770  HG3 GLN A 240      -7.765  -1.521   8.258  1.00 51.39           H
ATOM   3771 HE21 GLN A 240     -10.830  -0.288   8.847  1.00 67.18           H
ATOM   3772 HE22 GLN A 240      -9.990  -1.500   9.057  1.00 67.18           H
ATOM   3773  N   MET A 248      -4.937   2.701   4.182  1.00 37.29           N
ANISOU 3773  N   MET A 248     5297   3715   5155   2607  -2235  -1151       N
ATOM   3774  CA  MET A 248      -6.312   3.045   3.834  1.00 29.73           C
ANISOU 3774  CA  MET A 248     4299   3326   3672   1807   -547   -895       C
ATOM   3775  C   MET A 248      -6.646   4.429   4.362  1.00 22.08           C
ANISOU 3775  C   MET A 248     2714   3083   2591    972      4   -548       C
ATOM   3776  O   MET A 248      -6.681   4.689   5.562  1.00 23.02           O
ANISOU 3776  O   MET A 248     2580   3509   2656    793   -164   -592       O
ATOM   3777  CB  MET A 248      -7.221   1.978   4.379  1.00 38.11           C
ANISOU 3777  CB  MET A 248     6459   2679   5343   1548    339   -712       C
ATOM   3778  CG  MET A 248      -8.639   2.239   3.852  1.00 37.85           C
ANISOU 3778  CG  MET A 248     5001   2965   6417   1094   1857   -137       C
ATOM   3779  SD  MET A 248      -9.147   0.888   2.822  1.00 67.88           S
ANISOU 3779  SD  MET A 248     6928   8620  10245   2450  -1345  -4912       S
ATOM   3780  CE  MET A 248     -10.423   1.544   1.799  1.00 43.00           C
ANISOU 3780  CE  MET A 248     2904   3094  10341    226   1769  -2687       C
ATOM   3781  H   MET A 248      -4.854   2.669   5.067  1.00 55.93           H
ATOM   3782  HA  MET A 248      -6.394   3.055   2.858  1.00 35.68           H
ATOM   3783  HB2 MET A 248      -6.916   1.103   4.093  1.00 45.73           H
ATOM   3784  HB3 MET A 248      -7.217   2.002   5.349  1.00 45.73           H
ATOM   3785  HG2 MET A 248      -9.254   2.333   4.597  1.00 45.43           H
ATOM   3786  HG3 MET A 248      -8.653   3.064   3.342  1.00 45.43           H
ATOM   3787  HE1 MET A 248     -10.778   0.847   1.243  1.00 64.50           H
ATOM   3788  HE2 MET A 248     -10.063   2.241   1.246  1.00 64.50           H
ATOM   3789  HE3 MET A 248     -11.123   1.902   2.350  1.00 64.50           H
ATOM   3790  N   TYR A 249      -6.873   5.325   3.430  1.00 23.25           N
ANISOU 3790  N   TYR A 249     3069   3108   2656    966    246   -485       N
ATOM   3791  CA  TYR A 249      -7.274   6.698   3.737  1.00 18.90           C
ANISOU 3791  CA  TYR A 249     2230   2821   2129    457    210   -277       C
ATOM   3792  C   TYR A 249      -8.737   6.893   3.412  1.00 17.18           C
ANISOU 3792  C   TYR A 249     2093   2781   1655    300    595   -381       C
ATOM   3793  O   TYR A 249      -9.313   6.090   2.683  1.00 18.40           O
ANISOU 3793  O   TYR A 249     2539   2576   1875    710    -34   -404       O
ATOM   3794  CB  TYR A 249      -6.416   7.700   3.006  1.00 21.83           C
ANISOU 3794  CB  TYR A 249     2065   3491   2738    254    552   -213       C
ATOM   3795  CG  TYR A 249      -4.945   7.586   3.391  1.00 25.15           C
ANISOU 3795  CG  TYR A 249     2122   3868   3564    414    384    -59       C
ATOM   3796  CD1 TYR A 249      -4.512   8.033   4.635  1.00 26.16           C
ANISOU 3796  CD1 TYR A 249     2080   3879   3980     77      0   -249       C
ATOM   3797  CD2 TYR A 249      -4.004   7.042   2.531  1.00 29.90           C
ANISOU 3797  CD2 TYR A 249     2219   5321   3821    827    539    -47       C
ATOM   3798  CE1 TYR A 249      -3.183   7.961   5.050  1.00 32.64           C
ANISOU 3798  CE1 TYR A 249     2177   5761   4465    273   -135    238       C
ATOM   3799  CE2 TYR A 249      -2.692   6.979   2.957  1.00 34.37           C
ANISOU 3799  CE2 TYR A 249     2181   6039   4837    861    452    149       C
ATOM   3800  CZ  TYR A 249      -2.256   7.417   4.181  1.00 33.76           C
ANISOU 3800  CZ  TYR A 249     1872   6491   4465    115    348    890       C
ATOM   3801  OH  TYR A 249      -0.922   7.324   4.553  1.00 40.76           O
ANISOU 3801  OH  TYR A 249     2151   7364   5972    698   -186    837       O
ATOM   3802  H   TYR A 249      -6.782   5.095   2.606  1.00 27.90           H
ATOM   3803  HA  TYR A 249      -7.156   6.841   4.699  1.00 22.68           H
ATOM   3804  HB2 TYR A 249      -6.506   7.560   2.050  1.00 26.19           H
ATOM   3805  HB3 TYR A 249      -6.730   8.595   3.207  1.00 26.19           H
ATOM   3806  HD1 TYR A 249      -5.139   8.397   5.217  1.00 31.39           H
ATOM   3807  HD2 TYR A 249      -4.250   6.728   1.690  1.00 35.88           H
ATOM   3808  HE1 TYR A 249      -2.927   8.272   5.888  1.00 39.17           H
ATOM   3809  HE2 TYR A 249      -2.064   6.616   2.375  1.00 41.24           H
ATOM   3810  N   VAL A 250      -9.305   7.956   3.940  1.00 16.60           N
ANISOU 3810  N   VAL A 250     2001   2588   1717    329    174   -331       N
ATOM   3811  CA  VAL A 250     -10.743   8.196   3.704  1.00 15.87           C
ANISOU 3811  CA  VAL A 250     1947   2389   1694    136    378   -319       C
ATOM   3812  C   VAL A 250     -11.034   8.242   2.203  1.00 15.66           C
ANISOU 3812  C   VAL A 250     1868   2293   1788    198    160   -398       C
ATOM   3813  O   VAL A 250     -12.137   7.787   1.818  1.00 16.36           O
ANISOU 3813  O   VAL A 250     1879   2196   2141    111    228   -521       O
ATOM   3814  CB  VAL A 250     -11.175   9.432   4.486  1.00 15.79           C
ANISOU 3814  CB  VAL A 250     1847   2325   1827     26    310   -356       C
ATOM   3815  CG1 VAL A 250     -10.724  10.733   3.874  1.00 16.17           C
ANISOU 3815  CG1 VAL A 250     1843   2333   1968    167    382   -264       C
ATOM   3816  CG2 VAL A 250     -12.687   9.349   4.713  1.00 22.92           C
ANISOU 3816  CG2 VAL A 250     2179   2341   4190     35   1319   -560       C
ATOM   3817  H   VAL A 250      -8.844   8.505   4.417  1.00 19.91           H
ATOM   3818  HA  VAL A 250     -11.231   7.430   4.074  1.00 19.05           H
ATOM   3819  HB  VAL A 250     -10.752   9.372   5.368  1.00 18.95           H
ATOM   3820 HG11 VAL A 250      -9.773  10.712   3.742  1.00 24.25           H
ATOM   3821 HG12 VAL A 250     -10.949  11.459   4.461  1.00 24.25           H
ATOM   3822 HG13 VAL A 250     -11.162  10.858   3.029  1.00 24.25           H
ATOM   3823 HG21 VAL A 250     -12.906   8.496   5.097  1.00 34.39           H
ATOM   3824 HG22 VAL A 250     -13.143   9.448   3.874  1.00 34.39           H
ATOM   3825 HG23 VAL A 250     -12.960  10.048   5.311  1.00 34.39           H
END

""",
  "cdl_test_3.pdb" : """CRYST1   78.400   78.400   36.970  90.00  90.00  90.00 P 43 21 2     8
ORIGX1      1.000000  0.000000  0.000000        0.00000
ORIGX2      0.000000  1.000000  0.000000        0.00000
ORIGX3      0.000000  0.000000  1.000000        0.00000
SCALE1      0.012755  0.000000  0.000000        0.00000
SCALE2      0.000000  0.012755  0.000000        0.00000
SCALE3      0.000000  0.000000  0.027049        0.00000
ATOM    546  N   GLY A  67      11.101   9.366  29.637  1.00 17.94           N
ATOM    547  CA  GLY A  67      12.163   8.693  30.425  1.00 18.26           C
ATOM    548  C   GLY A  67      13.507   9.365  30.392  1.00 19.97           C
ATOM    549  O   GLY A  67      14.488   8.801  30.951  1.00 20.09           O
ATOM    550  N   ARG A  68      13.628  10.523  29.748  1.00 17.72           N
ATOM    551  CA  ARG A  68      14.872  11.244  29.716  1.00 18.14           C
ATOM    552  C   ARG A  68      14.750  12.732  29.989  1.00 19.27           C
ATOM    553  O   ARG A  68      15.634  13.524  29.582  1.00 22.09           O
ATOM    554  CB  ARG A  68      15.628  10.987  28.386  1.00 18.05           C
ATOM    555  CG  ARG A  68      14.914  11.505  27.179  1.00 18.41           C
ATOM    556  CD  ARG A  68      15.883  11.529  26.010  1.00 19.08           C
ATOM    557  NE  ARG A  68      15.421  12.521  25.048  1.00 20.73           N
ATOM    558  CZ  ARG A  68      15.821  12.542  23.764  1.00 19.88           C
ATOM    559  NH1 ARG A  68      16.664  11.596  23.351  1.00 20.06           N
ATOM    560  NH2 ARG A  68      15.366  13.499  22.857  1.00 13.89           N
ATOM    561  N   THR A  69      13.695  13.162  30.686  1.00 17.50           N
ATOM    562  CA  THR A  69      13.549  14.569  30.983  1.00 17.41           C
ATOM    563  C   THR A  69      13.478  14.721  32.518  1.00 18.58           C
ATOM    564  O   THR A  69      12.424  14.701  33.115  1.00 18.15           O
ATOM    565  CB  THR A  69      12.285  15.177  30.327  1.00 17.98           C
ATOM    566  OG1 THR A  69      12.307  14.794  28.923  1.00 18.45           O
ATOM    567  CG2 THR A  69      12.311  16.761  30.405  1.00 16.00           C
ATOM    568  N   PRO A  70      14.637  14.873  33.132  1.00 20.91           N
ATOM    569  CA  PRO A  70      14.653  14.921  34.608  1.00 23.45           C
ATOM    570  C   PRO A  70      13.712  15.941  35.188  1.00 25.34           C
ATOM    571  O   PRO A  70      13.679  17.131  34.760  1.00 26.21           O
ATOM    572  CB  PRO A  70      16.109  15.285  34.922  1.00 24.93           C
ATOM    573  CG  PRO A  70      16.878  14.476  33.781  1.00 23.80           C
ATOM    574  CD  PRO A  70      15.990  14.884  32.557  1.00 22.05           C
ATOM    575  N   GLY A  71      12.919  15.489  36.148  1.00 25.17           N
ATOM    576  CA  GLY A  71      12.229  16.459  36.975  1.00 27.28           C
ATOM    577  C   GLY A  71      10.881  16.750  36.364  1.00 28.56           C
ATOM    578  O   GLY A  71      10.095  17.549  36.877  1.00 31.19           O
ATOM    579  N   SER A  72      10.591  16.091  35.253  1.00 28.46           N
ATOM    580  CA  SER A  72       9.414  16.396  34.499  1.00 28.52           C
ATOM    581  C   SER A  72       8.164  15.668  35.014  1.00 28.41           C
ATOM    582  O   SER A  72       8.207  14.680  35.763  1.00 26.59           O
ATOM    583  CB  SER A  72       9.671  16.096  33.019  1.00 27.53           C
ATOM    584  OG  SER A  72       9.706  14.690  32.833  1.00 26.85           O
END

""",
  "cdl_test_4.pdb" : """CRYST1   78.400   78.400   36.970  90.00  90.00  90.00 P 43 21 2     8
ORIGX1      1.000000  0.000000  0.000000        0.00000
ORIGX2      0.000000  1.000000  0.000000        0.00000
ORIGX3      0.000000  0.000000  1.000000        0.00000
SCALE1      0.012755  0.000000  0.000000        0.00000
SCALE2      0.000000  0.012755  0.000000        0.00000
SCALE3      0.000000  0.000000  0.027049        0.00000
ATOM    618  N   ASN A  77      -0.512  11.604  31.096  1.00 20.93           N
ATOM    619  C   ASN A  77      -0.196   9.268  30.198  1.00 21.38           C
ATOM    620  O   ASN A  77      -0.881   8.283  30.000  1.00 21.80           O
ATOM    621  CA AASN A  77      -0.387  10.160  31.412  0.50 20.46           C
ATOM    622  CB AASN A  77      -1.589   9.725  32.281  0.50 21.87           C
ATOM    623  CG AASN A  77      -1.756  10.639  33.481  0.50 20.45           C
ATOM    624  OD1AASN A  77      -0.876  10.720  34.313  0.50 25.10           O
ATOM    625  ND2AASN A  77      -2.869  11.346  33.553  0.50 23.32           N
ATOM    626  CA BASN A  77      -0.453  10.150  31.410  0.50 21.90           C
ATOM    627  CB BASN A  77      -1.758   9.718  32.170  0.50 23.71           C
ATOM    628  CG BASN A  77      -2.305   8.359  31.743  0.50 29.20           C
ATOM    629  OD1BASN A  77      -2.088   7.354  32.431  0.50 37.16           O
ATOM    630  ND2BASN A  77      -3.077   8.325  30.635  0.50 33.49           N
ATOM    631  N   ILE A  78       0.793   9.619  29.363  1.00 19.09           N
ATOM    632  CA  ILE A  78       1.050   8.859  28.168  1.00 19.18           C
ATOM    633  C   ILE A  78       2.555   8.868  27.903  1.00 18.54           C
ATOM    634  O   ILE A  78       3.248   9.866  28.220  1.00 17.60           O
ATOM    635  CB  ILE A  78       0.445   9.543  26.881  1.00 19.36           C
ATOM    636  CG1 ILE A  78       0.729  11.033  26.935  1.00 18.45           C
ATOM    637  CG2 ILE A  78      -0.972   9.182  26.719  1.00 24.11           C
ATOM    638  CD1 ILE A  78       0.487  11.784  25.606  1.00 24.47           C
ATOM    639  N   PRO A  79       3.060   7.785  27.288  1.00 18.41           N
ATOM    640  CA  PRO A  79       4.443   7.862  26.738  1.00 17.69           C
ATOM    641  C   PRO A  79       4.479   8.877  25.603  1.00 15.10           C
ATOM    642  O   PRO A  79       3.525   8.971  24.804  1.00 15.70           O
ATOM    643  CB  PRO A  79       4.692   6.482  26.182  1.00 17.34           C
ATOM    644  CG  PRO A  79       3.386   5.843  25.977  1.00 21.80           C
ATOM    645  CD  PRO A  79       2.344   6.567  26.831  1.00 19.64           C
ATOM    646  N   CYS A  80       5.548   9.649  25.518  1.00 15.91           N
ATOM    647  CA  CYS A  80       5.607  10.641  24.479  1.00 13.93           C
ATOM    648  C   CYS A  80       5.499   9.982  23.089  1.00 14.20           C
ATOM    649  O   CYS A  80       5.019  10.606  22.155  1.00 14.20           O
ATOM    650  CB  CYS A  80       6.936  11.394  24.588  1.00 13.89           C
ATOM    651  SG  CYS A  80       7.072  12.387  26.105  1.00 13.81           S
END

""",
  "cdl_test_5.pdb" : """CRYST1   78.400   78.400   36.970  90.00  90.00  90.00 P 43 21 2     8
ORIGX1      1.000000  0.000000  0.000000        0.00000
ORIGX2      0.000000  1.000000  0.000000        0.00000
ORIGX3      0.000000  0.000000  1.000000        0.00000
SCALE1      0.012755  0.000000  0.000000        0.00000
SCALE2      0.000000  0.012755  0.000000        0.00000
SCALE3      0.000000  0.000000  0.027049        0.00000
HETATM    1  N   ALA A   1      -5.418  -5.235  -2.694  1.00 20.00      A    N
HETATM    2  H   ALA A   1      -5.559  -6.106  -2.484  1.00 20.00      A    H
HETATM    3  HN3 ALA A   1      -5.929  -5.009  -3.421  1.00 20.00      A    H
HETATM    4  CA  ALA A   1      -5.784  -4.397  -1.564  1.00 20.00      A    C
HETATM    5  HA  ALA A   1      -6.172  -3.588  -1.967  1.00 20.00      A    H
HETATM    6  CB  ALA A   1      -6.892  -4.972  -0.715  1.00 20.00      A    C
HETATM    7  HB1 ALA A   1      -6.754  -5.931  -0.607  1.00 20.00      A    H
HETATM    8  HB2 ALA A   1      -7.755  -4.812  -1.151  1.00 20.00      A    H
HETATM    9  HB3 ALA A   1      -6.887  -4.539   0.166  1.00 20.00      A    H
HETATM   10  C   ALA A   1      -4.606  -3.903  -0.772  1.00 20.00      A    C
HETATM   11  O   ALA A   1      -4.275  -4.481   0.265  1.00 20.00      A    O
HETATM   12  N   GLY A   2      -3.867  -2.761  -1.226  1.00 20.00      A    N
HETATM   13  H   GLY A   2      -4.075  -2.373  -2.018  1.00 20.00      A    H
HETATM   14  CA  GLY A   2      -2.829  -2.202  -0.405  1.00 20.00      A    C
HETATM   15  HA  GLY A   2      -3.258  -1.801   0.387  1.00 20.00      A    H
HETATM   16  HB3 GLY A   2      -2.271  -2.927  -0.103  1.00 20.00      A    H
HETATM   17  C   GLY A   2      -1.899  -1.119  -1.037  1.00 20.00      A    C
HETATM   18  O   GLY A   2      -0.710  -1.366  -1.232  1.00 20.00      A    O
HETATM   19  N   PRO A   3      -2.416   0.186  -1.325  1.00 20.00      A    N
HETATM   20  CA  PRO A   3      -1.669   1.290  -1.839  1.00 20.00      A    C
HETATM   21  HA  PRO A   3      -1.800   1.035  -2.770  1.00 20.00      A    H
HETATM   22  CB  PRO A   3      -2.365   2.519  -1.353  1.00 20.00      A    C
HETATM   23  HB2 PRO A   3      -2.454   3.164  -2.086  1.00 20.00      A    H
HETATM   24  HB3 PRO A   3      -1.867   2.909  -0.614  1.00 20.00      A    H
HETATM   25  CG  PRO A   3      -3.710   2.073  -0.886  1.00 20.00      A    C
HETATM   26  HG2 PRO A   3      -3.810   2.252   0.068  1.00 20.00      A    H
HETATM   27  HG3 PRO A   3      -4.401   2.526  -1.380  1.00 20.00      A    H
HETATM   28  CD  PRO A   3      -3.772   0.612  -1.149  1.00 20.00      A    C
HETATM   29  HD2 PRO A   3      -4.172   0.149  -0.396  1.00 20.00      A    H
HETATM   30  HD3 PRO A   3      -4.283   0.444  -1.955  1.00 20.00      A    H
HETATM   31  C   PRO A   3      -0.259   1.253  -1.277  1.00 20.00      A    C
HETATM   32  O   PRO A   3       0.004   0.517  -0.341  1.00 20.00      A    O
HETATM   33  N   PRO A   4       0.814   2.066  -1.908  1.00 20.00      A    N
HETATM   34  CA  PRO A   4       2.197   2.085  -1.522  1.00 20.00      A    C
HETATM   35  HA  PRO A   4       2.824   1.474  -1.952  1.00 20.00      A    H
HETATM   36  CB  PRO A   4       2.709   3.438  -1.892  1.00 20.00      A    C
HETATM   37  HB2 PRO A   4       3.574   3.366  -2.305  1.00 20.00      A    H
HETATM   38  HB3 PRO A   4       2.762   3.997  -1.110  1.00 20.00      A    H
HETATM   39  CG  PRO A   4       1.724   4.001  -2.857  1.00 20.00      A    C
HETATM   40  HG2 PRO A   4       2.154   4.166  -3.710  1.00 20.00      A    H
HETATM   41  HG3 PRO A   4       1.348   4.828  -2.503  1.00 20.00      A    H
HETATM   42  CD  PRO A   4       0.649   2.963  -3.004  1.00 20.00      A    C
HETATM   43  HD2 PRO A   4       0.751   2.481  -3.845  1.00 20.00      A    H
HETATM   44  HD3 PRO A   4      -0.231   3.381  -2.960  1.00 20.00      A    H
HETATM   45  C   PRO A   4       2.306   1.897  -0.025  1.00 20.00      A    C
HETATM   46  O   PRO A   4       1.359   2.199   0.702  1.00 20.00      A    O
HETATM   47  N   GLY A   5       3.573   1.428   0.572  1.00 20.00      A    N
HETATM   48  H   GLY A   5       4.256   1.155   0.038  1.00 20.00      A    H
HETATM   49  CA  GLY A   5       3.710   1.365   2.030  1.00 20.00      A    C
HETATM   50  HA  GLY A   5       3.594   2.257   2.371  1.00 20.00      A    H
HETATM   51  HB3 GLY A   5       2.987   0.824   2.368  1.00 20.00      A    H
HETATM   52  C   GLY A   5       5.001   0.817   2.608  1.00 20.00      A    C
HETATM   53  O   GLY A   5       6.063   0.961   1.994  1.00 20.00      A    O
HETATM   54  N   ALA A   6       5.011   0.259   3.975  1.00 20.00      A    N
HETATM   55  H   ALA A   6       4.237   0.198   4.445  1.00 20.00      A    H
HETATM   56  CA  ALA A   6       6.225  -0.222   4.540  1.00 20.00      A    C
HETATM   57  HA  ALA A   6       6.839  -0.292   3.788  1.00 20.00      A    H
HETATM   58  CB  ALA A   6       6.126  -1.610   5.086  1.00 20.00      A    C
HETATM   59  HB1 ALA A   6       5.470  -1.627   5.822  1.00 20.00      A    H
HETATM   60  HB2 ALA A   6       5.839  -2.218   4.380  1.00 20.00      A    H
HETATM   61  HB3 ALA A   6       6.995  -1.888   5.420  1.00 20.00      A    H
HETATM   62  C   ALA A   6       6.883   0.752   5.486  1.00 20.00      A    C
HETATM   63  HC1 ALA A   6       7.560   1.373   5.156  1.00 20.00      A    H
HETATM   64  O   ALA A   6       6.608   0.723   6.689  1.00 20.00      A    O
END

""",
  "cdl_test_7.pdb" : """CRYST1   63.800   30.630   34.420  90.00 105.80  90.00 P 1 21 1      2
ORIGX1      1.000000  0.000000  0.000000        0.00000
ORIGX2      0.000000  1.000000  0.000000        0.00000
ORIGX3      0.000000  0.000000  1.000000        0.00000
SCALE1      0.015674  0.000000  0.004435        0.00000
SCALE2      0.000000  0.032648  0.000000        0.00000
SCALE3      0.000000  0.000000  0.030194        0.00000
ATOM    357  N   LYS A  42      18.395  26.865  -5.091  1.00 15.63           N
ANISOU  357  N   LYS A  42     1174   2885   1878    -53   -141    932       N
ATOM    358  CA  LYS A  42      17.614  27.899  -4.447  1.00 15.69           C
ANISOU  358  CA  LYS A  42     1179   2887   1896     93   -160   1130       C
ATOM    359  C   LYS A  42      18.410  28.797  -3.504  1.00 15.56           C
ANISOU  359  C   LYS A  42     1130   2638   2145    245    -71    964       C
ATOM    360  O   LYS A  42      17.910  29.831  -3.034  1.00 17.53           O
ANISOU  360  O   LYS A  42     1248   2412   2999    315   -138   1003       O
ATOM    361  CB  LYS A  42      16.407  27.296  -3.693  1.00 17.00           C
ANISOU  361  CB  LYS A  42     1291   2893   2277     -3      5   1082       C
ATOM    362  CG  LYS A  42      15.344  26.658  -4.544  1.00 18.44           C
ANISOU  362  CG  LYS A  42     1165   3253   2588     -3    -31    920       C
ATOM    363  CD  LYS A  42      14.532  27.707  -5.300  1.00 21.35           C
ANISOU  363  CD  LYS A  42     1425   3532   3157   -298   -502   1293       C
ATOM    364  CE  LYS A  42      13.510  27.042  -6.206  1.00 22.84           C
ANISOU  364  CE  LYS A  42     1794   3767   3117    -83   -619    845       C
ATOM    365  NZ  LYS A  42      12.571  28.017  -6.821  1.00 23.31           N
ANISOU  365  NZ  LYS A  42     1834   4551   2470    -20   -515   1255       N
ATOM    366  N   PHE A  43      19.628  28.411  -3.168  1.00 13.55           N
ANISOU  366  N   PHE A  43     1111   2289   1750    176    -19    692       N
ATOM    367  CA  PHE A  43      20.491  29.155  -2.266  1.00 12.82           C
ANISOU  367  CA  PHE A  43     1228   2079   1563    378    136    395       C
ATOM    368  C   PHE A  43      21.588  29.873  -3.018  1.00 13.05           C
ANISOU  368  C   PHE A  43     1271   1872   1817    207    -52    489       C
ATOM    369  O   PHE A  43      22.623  29.246  -3.287  1.00 12.13           O
ANISOU  369  O   PHE A  43     1072   1840   1695    -36    -99    400       O
ATOM    370  CB APHE A  43      21.138  28.326  -1.148  0.54 13.33           C
ANISOU  370  CB APHE A  43     1095   2283   1688    229      6    504       C
ATOM    371  CB BPHE A  43      21.107  28.204  -1.235  0.46 12.43           C
ANISOU  371  CB BPHE A  43     1285   1918   1520    308     29    285       C
ATOM    372  CG APHE A  43      20.164  27.778  -0.102  0.54 11.73           C
ANISOU  372  CG APHE A  43      932   2235   1291    262   -176    359       C
ATOM    373  CG BPHE A  43      20.126  27.442  -0.348  0.46 10.59           C
ANISOU  373  CG BPHE A  43     1177   1391   1456    379    -31     65       C
ATOM    374  CD1APHE A  43      19.528  26.591  -0.346  0.54 12.33           C
ANISOU  374  CD1APHE A  43     1096   2169   1419    270    268    116       C
ATOM    375  CD1BPHE A  43      19.524  26.263  -0.766  0.46 10.91           C
ANISOU  375  CD1BPHE A  43     1269   1490   1385    435     21   -132       C
ATOM    376  CD2APHE A  43      19.963  28.454   1.063  0.54 13.16           C
ANISOU  376  CD2APHE A  43     1322   2021   1658    260    -39    163       C
ATOM    377  CD2BPHE A  43      19.884  27.949   0.902  0.46 11.05           C
ANISOU  377  CD2BPHE A  43     1067   1744   1386   -211   -145    -95       C
ATOM    378  CE1APHE A  43      18.682  26.025   0.592  0.54 12.53           C
ANISOU  378  CE1APHE A  43     1037   2084   1639    456    489     94       C
ATOM    379  CE1BPHE A  43      18.684  25.566   0.121  0.46 13.29           C
ANISOU  379  CE1BPHE A  43     1461   1859   1731     -7     -7    -36       C
ATOM    380  CE2APHE A  43      19.094  27.900   2.007  0.54 13.14           C
ANISOU  380  CE2APHE A  43     1211   2508   1274    314   -144     87       C
ATOM    381  CE2BPHE A  43      19.044  27.272   1.787  0.46 10.84           C
ANISOU  381  CE2BPHE A  43      897   1694   1530     93    -84    168       C
ATOM    382  CZ APHE A  43      18.455  26.706   1.748  0.54 12.26           C
ANISOU  382  CZ APHE A  43      714   2323   1622    485    393    113       C
ATOM    383  CZ BPHE A  43      18.461  26.093   1.368  0.46 11.15           C
ANISOU  383  CZ BPHE A  43     1072   1528   1635     94    148    168       C
ATOM    384  N   ASP A  44      21.437  31.147  -3.318  1.00 15.77           N
ANISOU  384  N   ASP A  44     1567   2043   2384    322     75    783       N
ATOM    385  CA  ASP A  44      22.544  31.869  -3.932  1.00 16.47           C
ANISOU  385  CA  ASP A  44     1672   1969   2616    180    163    714       C
ATOM    386  C  AASP A  44      23.758  31.742  -3.013  0.62 18.30           C
ANISOU  386  C  AASP A  44     1864   2132   2956   -265    -85    975       C
ATOM    387  C  BASP A  44      23.871  31.755  -3.195  0.38 18.75           C
ANISOU  387  C  BASP A  44     2012   1899   3212   -390   -423    792       C
ATOM    388  O  AASP A  44      24.926  31.718  -3.371  0.62 21.31           O
ANISOU  388  O  AASP A  44     1788   2706   3601   -153    -12   1547       O
ATOM    389  O  BASP A  44      24.888  31.692  -3.888  0.38 17.70           O
ANISOU  389  O  BASP A  44     1658   2205   2862   -512   -760   1253       O
ATOM    390  CB  ASP A  44      22.143  33.330  -4.128  1.00 22.20           C
ANISOU  390  CB  ASP A  44     2754   1991   3691    126   -200   1068       C
ATOM    391  CG  ASP A  44      21.166  33.573  -5.248  1.00 27.77           C
ANISOU  391  CG  ASP A  44     3558   2501   4490    214   -877   1628       C
ATOM    392  OD1 ASP A  44      20.889  32.667  -6.057  1.00 28.61           O
ANISOU  392  OD1 ASP A  44     3727   3698   3446    899   -782   1151       O
ATOM    393  OD2 ASP A  44      20.767  34.754  -5.305  1.00 35.69           O
ANISOU  393  OD2 ASP A  44     4278   2879   6403    845  -1295   1598       O
ATOM    394  N  AARG A  45      23.412  31.660  -1.733  0.62 16.64           N
ANISOU  394  N  AARG A  45     2103   1404   2815     37   -219    380       N
ATOM    395  N  BARG A  45      23.874  31.742  -1.873  0.38 16.77           N
ANISOU  395  N  BARG A  45     1635   1512   3224    -71   -469    -81       N
ATOM    396  CA AARG A  45      24.341  31.598  -0.631  0.62 15.97           C
ANISOU  396  CA AARG A  45     1881   1308   2880   -541   -157    244       C
ATOM    397  CA BARG A  45      25.113  31.653  -1.116  0.38 17.04           C
ANISOU  397  CA BARG A  45     1579   1508   3388   -550   -546    -59       C
ATOM    398  C  AARG A  45      25.232  30.357  -0.688  0.62 15.73           C
ANISOU  398  C  AARG A  45     1583   1486   2906   -501   -473    431       C
ATOM    399  C  BARG A  45      25.789  30.293  -1.141  0.38 14.13           C
ANISOU  399  C  BARG A  45     1024   1600   2744   -595    -60    600       C
ATOM    400  O  AARG A  45      26.356  30.433  -0.147  0.62 17.06           O
ANISOU  400  O  AARG A  45     1646   2177   2660   -660   -440    558       O
ATOM    401  O  BARG A  45      26.976  30.147  -0.823  0.38 17.78           O
ANISOU  401  O  BARG A  45     1530   1736   3489   -694  -1102    550       O
ATOM    402  CB AARG A  45      23.578  31.610   0.690  0.62 18.40           C
ANISOU  402  CB AARG A  45     2253   1956   2783   -460    -76    261       C
ATOM    403  CB BARG A  45      24.855  31.998   0.354  0.38 18.43           C
ANISOU  403  CB BARG A  45     1840   1880   3281    -53   -630     81       C
ATOM    404  CG AARG A  45      24.339  31.969   1.925  0.62 17.49           C
ANISOU  404  CG AARG A  45     1380   2348   2917   -485     87    304       C
ATOM    405  CG BARG A  45      23.918  31.058   1.078  0.38 16.97           C
ANISOU  405  CG BARG A  45     1362   1968   3116    114   -792    174       C
ATOM    406  CD AARG A  45      23.391  32.292   3.091  0.62 16.95           C
ANISOU  406  CD AARG A  45     1802   1676   2962    129    -81    -41       C
ATOM    407  CD BARG A  45      23.612  31.615   2.472  0.38 19.89           C
ANISOU  407  CD BARG A  45     1973   2278   3308    313   -483    101       C
ATOM    408  NE AARG A  45      24.080  32.172   4.360  0.62 17.21           N
ANISOU  408  NE AARG A  45     1245   2257   3039    344    -54   -142       N
ATOM    409  NE BARG A  45      23.115  32.990   2.347  0.38 23.31           N
ANISOU  409  NE BARG A  45     2655   2715   3485   1121   -370    116       N
ATOM    410  CZ AARG A  45      23.462  32.261   5.544  0.62 19.15           C
ANISOU  410  CZ AARG A  45     1182   3107   2988    252   -140   -373       C
ATOM    411  CZ BARG A  45      23.529  34.017   3.069  0.38 26.09           C
ANISOU  411  CZ BARG A  45     3599   1963   4352    767   -806    637       C
ATOM    412  NH1AARG A  45      22.177  32.489   5.690  0.62 25.59           N
ANISOU  412  NH1AARG A  45     1495   4972   3256   1158    104   -193       N
ATOM    413  NH1BARG A  45      24.459  33.809   3.991  0.38 24.55           N
ANISOU  413  NH1BARG A  45     2276   2187   4867    571   -586    -56       N
ATOM    414  NH2AARG A  45      24.195  32.127   6.654  0.62 27.38           N
ANISOU  414  NH2AARG A  45     1130   6242   3030     99   -103    -53       N
ATOM    415  NH2BARG A  45      23.040  35.233   2.906  0.38 29.85           N
ANISOU  415  NH2BARG A  45     3533   2527   5281   1687    125    374       N
ATOM    416  N  APHE A  46      24.811  29.238  -1.314  0.62 14.05           N
ANISOU  416  N  APHE A  46     1534   1362   2443   -293   -128    408       N
ATOM    417  N  BPHE A  46      24.958  29.283  -1.457  0.38 13.32           N
ANISOU  417  N  BPHE A  46     1291   1374   2398   -322   -678    323       N
ATOM    418  CA  PHE A  46      25.500  27.952  -1.293  1.00 13.73           C
ANISOU  418  CA  PHE A  46     1094   1576   2548   -154    -60    502       C
ATOM    419  C   PHE A  46      25.742  27.338  -2.662  1.00 14.20           C
ANISOU  419  C   PHE A  46     1113   1648   2634    -60   -134    398       C
ATOM    420  O   PHE A  46      26.415  26.282  -2.756  1.00 15.60           O
ANISOU  420  O   PHE A  46     1145   1685   3097    -18    137    487       O
ATOM    421  CB  PHE A  46      24.719  26.983  -0.408  1.00 14.08           C
ANISOU  421  CB  PHE A  46     1094   1436   2820    -80   -100    584       C
ATOM    422  CG  PHE A  46      24.523  27.495   1.008  1.00 15.24           C
ANISOU  422  CG  PHE A  46     1140   2109   2540    -88   -166    918       C
ATOM    423  CD1 PHE A  46      25.610  27.940   1.750  1.00 14.61           C
ANISOU  423  CD1 PHE A  46     1167   1520   2865   -128     55    309       C
ATOM    424  CD2 PHE A  46      23.285  27.487   1.615  1.00 17.37           C
ANISOU  424  CD2 PHE A  46     1106   3182   2313    -41   -169   1247       C
ATOM    425  CE1 PHE A  46      25.451  28.424   3.026  1.00 15.97           C
ANISOU  425  CE1 PHE A  46     1588   1860   2620   -134    155    560       C
ATOM    426  CE2 PHE A  46      23.164  27.975   2.897  1.00 18.23           C
ANISOU  426  CE2 PHE A  46     1622   3096   2208   -177     -1   1381       C
ATOM    427  CZ  PHE A  46      24.207  28.434   3.646  1.00 16.95           C
ANISOU  427  CZ  PHE A  46     1580   2503   2357    121     92    996       C
END

""",
  "cdl_test_8.pdb" : """CRYST1   29.475   29.475   29.480  90.00  90.00  90.00 P 41 21 2    16
ORIGX1      1.000000  0.000000  0.000000        0.00000
ORIGX2      0.000000  1.000000  0.000000        0.00000
ORIGX3      0.000000  0.000000  1.000000        0.00000
SCALE1      0.033927  0.000000  0.000000        0.00000
SCALE2      0.000000  0.033927  0.000000        0.00000
SCALE3      0.000000  0.000000  0.033921        0.00000
ATOM     25  N   CYS A   4      -1.017  11.791   3.510  1.00  5.40           N
ATOM     26  CA  CYS A   4      -1.211  11.782   2.064  1.00  5.20           C
ATOM     27  C   CYS A   4      -2.703  11.983   1.729  1.00  5.50           C
ATOM     28  O   CYS A   4      -3.156  11.557   0.671  1.00  5.81           O
ATOM     29  CB  CYS A   4      -0.708  10.530   1.426  1.00  6.10           C
ATOM     30  SG  CYS A   4      -1.749   9.057   1.832  1.00  5.73           S
ATOM     31  N   TYR A   5      -3.441  12.684   2.609  1.00  5.06           N
ATOM     32  CA  TYR A   5      -4.882  12.770   2.375  1.00  5.21           C
ATOM     33  C   TYR A   5      -5.158  13.567   1.094  1.00  5.25           C
ATOM     34  O   TYR A   5      -4.616  14.713   0.914  1.00  5.88           O
ATOM     35  CB  TYR A   5      -5.568  13.494   3.574  1.00  5.48           C
ATOM     36  CG  TYR A   5      -7.029  13.724   3.329  1.00  5.59           C
ATOM     37  CD1 TYR A   5      -7.488  14.961   2.861  1.00  6.24           C
ATOM     38  CD2 TYR A   5      -7.947  12.712   3.571  1.00  6.54           C
ATOM     39  CE1 TYR A   5      -8.844  15.156   2.644  1.00  7.21           C
ATOM     40  CE2 TYR A   5      -9.290  12.938   3.330  1.00  7.81           C
ATOM     41  CZ  TYR A   5      -9.711  14.144   2.862  1.00  8.31           C
ATOM     42  OH  TYR A   5     -11.070  14.386   2.640  1.00 12.07           O
ATOM     43  N   PRO A   6      -6.046  13.065   0.236  1.00  5.32           N
ATOM     44  CD  PRO A   6      -6.525  13.878  -0.938  1.00  6.62           C
ATOM     45  CG  PRO A   6      -7.611  13.053  -1.435  1.00 12.66           C
ATOM     46  CB  PRO A   6      -7.933  11.914  -0.642  1.00  7.02           C
ATOM     47  CA  PRO A   6      -6.759  11.758   0.397  1.00  5.50           C
ATOM     48  C   PRO A   6      -5.935  10.619   0.104  1.00  5.60           C
ATOM     49  OXT PRO A   6      -5.268  10.568  -1.166  1.00  6.37           O
""",
  # added for test_omega,py
  "cdl_test_9.pdb" : """CRYST1   74.560  104.040   69.150  90.00  90.00  90.00 C 2 2 21
SCALE1      0.013412  0.000000  0.000000        0.00000
SCALE2      0.000000  0.009612  0.000000        0.00000
SCALE3      0.000000  0.000000  0.014461        0.00000
ATOM   3586  N   LEU A 265      12.362  20.789  -0.224  1.00 39.28           N
ATOM   3587  CA  LEU A 265      10.958  21.100  -0.450  1.00 25.81           C
ATOM   3588  C   LEU A 265      10.613  21.342  -1.914  1.00 29.00           C
ATOM   3589  O   LEU A 265       9.427  21.349  -2.256  1.00 24.23           O
ATOM   3590  CB  LEU A 265      10.562  22.339   0.362  1.00 29.70           C
ATOM   3591  CG  LEU A 265      10.712  22.246   1.881  1.00 42.25           C
ATOM   3592  CD1 LEU A 265      10.529  23.620   2.508  0.84 29.47           C
ATOM   3593  CD2 LEU A 265       9.719  21.250   2.465  0.86 30.85           C
ATOM   3594  H   LEU A 265      12.873  21.481  -0.221  1.00 47.14           H
ATOM   3595  HA  LEU A 265      10.420  20.356  -0.137  1.00 30.97           H
ATOM   3596  HB2 LEU A 265      11.109  23.083   0.065  1.00 35.64           H
ATOM   3597  HB3 LEU A 265       9.630  22.535   0.178  1.00 35.64           H
ATOM   3598  HG  LEU A 265      11.607  21.937   2.092  1.00 50.69           H
ATOM   3599 HD11 LEU A 265      10.627  23.544   3.470  0.46 35.36           H
ATOM   3600 HD12 LEU A 265      11.202  24.222   2.153  0.63 35.36           H
ATOM   3601 HD13 LEU A 265       9.643  23.950   2.291  0.53 35.36           H
ATOM   3602 HD21 LEU A 265       9.838  21.213   3.427  0.54 37.02           H
ATOM   3603 HD22 LEU A 265       8.818  21.543   2.254  0.45 37.02           H
ATOM   3604 HD23 LEU A 265       9.883  20.377   2.077  0.60 37.02           H
ATOM   3605  N   ILE A 266      11.598  21.541  -2.783  1.00 25.15           N
ATOM   3606  CA  ILE A 266      11.300  21.894  -4.165  1.00 17.45           C
ATOM   3607  C   ILE A 266      11.066  20.627  -4.979  1.00 26.65           C
ATOM   3608  O   ILE A 266      10.493  20.675  -6.067  1.00 44.84           O
ATOM   3609  CB  ILE A 266      12.416  22.771  -4.786  1.00 21.23           C
ATOM   3610  CG1 ILE A 266      13.593  21.922  -5.287  1.00 25.40           C
ATOM   3611  CG2 ILE A 266      12.898  23.814  -3.770  1.00 25.56           C
ATOM   3612  CD1 ILE A 266      14.606  22.711  -6.073  1.00 38.72           C
ATOM   3613  H   ILE A 266      12.437  21.479  -2.601  1.00 30.18           H
ATOM   3614  HA  ILE A 266      10.478  22.410  -4.182  1.00 20.94           H
ATOM   3615  HB  ILE A 266      12.041  23.242  -5.546  1.00 25.48           H
ATOM   3616 HG12 ILE A 266      14.047  21.532  -4.524  1.00 30.47           H
ATOM   3617 HG13 ILE A 266      13.251  21.220  -5.862  1.00 30.47           H
ATOM   3618 HG21 ILE A 266      13.596  24.351  -4.177  1.00 30.67           H
ATOM   3619 HG22 ILE A 266      12.150  24.377  -3.518  1.00 30.67           H
ATOM   3620 HG23 ILE A 266      13.246  23.356  -2.989  1.00 30.67           H
ATOM   3621 HD11 ILE A 266      15.318  22.117  -6.357  1.00 46.46           H
ATOM   3622 HD12 ILE A 266      14.171  23.101  -6.847  1.00 46.46           H
ATOM   3623 HD13 ILE A 266      14.967  23.413  -5.508  1.00 46.46           H
ATOM   3624  N   SER A 267      11.505  19.495  -4.440  1.00 41.57           N
""",
  }

def test_res_type(hierarchy,
                  filename,
                  restraints_manager,
                  ):
  for i, threes in enumerate(cdl.generate_protein_threes(
    hierarchy,
    #restraints_manager=restraints_manager
    geometry=restraints_manager.geometry,
    cdl_class=True,
    )
                             ):
    print(threes.show(), end=' ')
    res_type_group = cdl_utils.get_res_type_group(
      threes[1].resname,
      threes[2].resname,
      )
    assert res_type_group
    print(i, res_type_group, filenames[filename][0][i])
    assert res_type_group == filenames[filename][0][i]

def test_phi_psi_key(hierarchy,
                     filename,
                     restraints_manager,
                     ):
  for i, threes in enumerate(cdl.generate_protein_threes(
    hierarchy,
    #restraints_manager=restraints_manager
    geometry=restraints_manager.geometry,
    cdl_class=True,
    )
                             ):
    key = threes.get_cdl_key()
    print(i,key,filenames[filename][1])
    assert key == filenames[filename][1][i]

def test_cdl_lookup(hierarchy,
                    filename,
                    restraints_manager,
                    ):
  for i, threes in enumerate(cdl.generate_protein_threes(
    hierarchy,
    #restraints_manager=restraints_manager
    geometry=restraints_manager.geometry,
    cdl_class=True,
    )
                             ):
    res_type_group = cdl_utils.get_res_type_group(
      threes[1].resname,
      threes[2].resname,
      )
    key = threes.get_cdl_key()
    print('key',key)
    if key is None:
      assert filenames[filename][2][i] is None
      continue
    restraint_values = cdl_database[res_type_group][key]
    print(restraint_values[:4])
    assert restraint_values[:3] == filenames[filename][2][i]

def test_cis_trans_peptide(hierarchy,
                           filename,
                           restraints_manager,
                           ):
  for i, threes in enumerate(cdl.generate_protein_threes(
    hierarchy,
    geometry=restraints_manager.geometry,
    cdl_class=True,
    )
                             ):
    cis_peptide_bond = threes.cis_group()
    if cis_peptide_bond:
      print(cis_peptide_bond)
      assert cis_peptide_bond == filenames[filename][3][i]

def test_average(hierarchy,
                 filename,
                 restraints_manager,
                 ):
  for i, threes in enumerate(cdl.generate_protein_threes(
    hierarchy,
    geometry=restraints_manager.geometry,
    cdl_class=True,
    )
                             ):
    if threes.registry.n:
      for key in threes.registry.n.keys():
        assert key in filenames[filename][3]

def get_managers(filename, testing=False, verbose=False):
  mon_lib_srv = monomer_library.server.server()
  ener_lib = monomer_library.server.ener_lib()
  processed_pdb_file = monomer_library.pdb_interpretation.process(
                                       mon_lib_srv               = mon_lib_srv,
                                       ener_lib                  = ener_lib,
                                       file_name                 = filename,
                                       raw_records               = None,
                                       force_symmetry            = True,
                                       )
################
  geometry = processed_pdb_file.geometry_restraints_manager(
                                                    show_energies      = False,
                                                    plain_pairs_radius = 5.0)
  restraints_manager = mmtbx.restraints.manager(geometry      = geometry,
                                                normalization = False)
  xray_structure = processed_pdb_file.xray_structure()
  selection = flex.bool(xray_structure.scatterers().size(), True)
  # Not used anywhere, incorrect creation.
  # mol = mmtbx.model.manager(
  #   restraints_manager = restraints_manager,
  #   xray_structure = xray_structure,
  #   pdb_hierarchy = processed_pdb_file.all_chain_proxies.pdb_hierarchy)
  return processed_pdb_file, restraints_manager

def run_apply(filename, testing=False, verbose=False):
  processed_pdb_file, restraints_manager = get_managers(filename)
  if testing:
    test_res_type(processed_pdb_file.all_chain_proxies.pdb_hierarchy,
                  filename,
                  restraints_manager,
                  )
    test_phi_psi_key(processed_pdb_file.all_chain_proxies.pdb_hierarchy,
                     filename,
                     restraints_manager,
                     )
    test_cdl_lookup(processed_pdb_file.all_chain_proxies.pdb_hierarchy,
                    filename,
                    restraints_manager,
                    )
    test_cis_trans_peptide(processed_pdb_file.all_chain_proxies.pdb_hierarchy,
                           filename,
                           restraints_manager,
                           )
    print("OK")

  sites_cart = processed_pdb_file.all_chain_proxies.sites_cart_exact()
  if True:
    lines = StringIO()
    restraints_manager.geometry.show_sorted(sites_cart=sites_cart,
                                                  f=lines)
    f=open("%s_pre.geo" % os.path.basename(filename)[:-4], "w")
    f.write(lines.getvalue())
    f.close()

  t0=time.time()
  cdl_proxies = cdl_setup.setup_restraints(restraints_manager.geometry,
                                           verbose=verbose,
                                         )
  cdl.update_restraints(processed_pdb_file.all_chain_proxies.pdb_hierarchy,
                        geometry=restraints_manager.geometry,
                        cdl_proxies=cdl_proxies,
                        verbose=verbose,
                        )
  if testing:
    test_average(processed_pdb_file.all_chain_proxies.pdb_hierarchy,
                 filename,
                 restraints_manager,
                 )
    print('OK')

  print('Time to update restraints %0.5fs' % (time.time()-t0))
  if True:
    lines = StringIO()
    restraints_manager.geometry.show_sorted(sites_cart=sites_cart,
                                                  f=lines)
    f=open("%s_post.geo" % os.path.basename(filename)[:-4], "w")
    f.write(lines.getvalue())
    f.close()

def convert_dict_to_excel(keys_number=4,
                          column_number=6,
                          ):
  key = sorted(cdl_database.keys())[keys_number]
  outl = " "
  phi_range = (0, 370, 10)
  psi_range = (0, 370, 10)
  phi_range = (180, -190, -10)
  psi_range = (-180, 190, 10)
  for i, psi in enumerate(range(*psi_range)):
    outl += ", %d" % psi
  outl += "\n"
  for i, phi in enumerate(range(*phi_range)):
    outl += "%3d" % phi
    if phi>=180: phi-=360
    for j, psi in enumerate(range(*psi_range)):
      if psi>=180: psi-=360
      print(phi, psi, cdl_database[key][(phi, psi)][column_number])
      outl += ", %0.2f" %  cdl_database[key][(phi, psi)][column_number]
    outl += "\n"
  outl += "\n"
  print(outl)
  return outl

def convert_dict_to_gnuplot(keys_number=4,
                            column_number=6,
                            dales_format=False,
                            ):
  key = sorted(cdl_database.keys())[keys_number]
  outl = " "
  if dales_format:
    header = """set terminal png size 1850,2000 linewidth 1
set output '%s.png'
set border 4095 front linetype -1 linewidth 1.000

set title "CDL for (!Gly,!Pro,!Ile,!Val)-!Pro"
set xlabel "phi"
set ylabel "psi"
#unset key
#unset colorbar
#set tic scale 0

set palette rgbformulae 33,13,10   # rainbow
set cbrange [%s:%s]

set ticslevel 60
set xtic 60
set xrange [-180:180]
set ytic 60
set yrange [-180:180]

set view map
set samples 36, 36
set isosamples 36, 36
splot '-' matrix using (10*$2-180):(10*$1-180):3 with image
"""
    outl = ""
    phi_range = (-180, 190, 10)
    psi_range = (-180, 190, 10)
    data = []
    for i, phi in enumerate(range(*phi_range)):
      if phi>=180: kphi=phi-360
      else: kphi=phi
      for j, psi in enumerate(range(*psi_range)):
        if psi>=180: kpsi=psi-360
        else: kpsi=psi
        outl += " %7.3f" % (cdl_database[key][(kphi, kpsi)][column_number])
        data.append(cdl_database[key][(kphi, kpsi)][column_number])
      outl += "\n"
    outl = header % (key, min(data), max(data)) + outl
  else:
    phi_range = (0, 370, 10)
    psi_range = (0, 370, 10)
    for i, phi in enumerate(range(*phi_range)):
      if phi>=180: kphi=phi-360
      else: kphi=phi
      for j, psi in enumerate(range(*psi_range)):
        if psi>=180: kpsi=psi-360
        else: kpsi=psi
        outl += " %12.5f %12.5f %12.5f\n" % (phi, psi, cdl_database[key][(kphi, kpsi)][column_number])
  return outl

def convert_dict_to_scilab(keys_number=4,
                           column_number=6,
                           ):
  key = sorted(cdl_database.keys())[keys_number]
  phi_range = (0, 370, 10)
  psi_range = (0, 370, 10)
  #phi_range = (-180, 190, 10)
  #psi_range = (-180, 190, 10)
  outl = ''
  outl += "X = [\n"
  for i, phi in enumerate(range(*phi_range)):
    outl += " %12.5f" % phi
  outl += "];\n"
  outl += "Y = [\n"
  for i, psi in enumerate(range(*psi_range)):
    outl += " %12.5f" % psi
  outl += "];\n"
  outl += "Z = ["
  for i, phi in enumerate(range(*phi_range)):
    if phi>=180: kphi=phi-360
    else: kphi=phi
    for j, psi in enumerate(range(*psi_range)):
      if psi>=180: kpsi=psi-360
      else: kpsi=psi
      outl += " %12.5f" % (cdl_database[key][(kphi, kpsi)][column_number]-110)
    outl += "\n"
  outl += "];\n"
  outl += """
  surf(X,Y,Z);
  """
  #scf(10)
  #axfig10=gca();
  #surf(axfig10,Z,'zdat',[100:119],'marker','d','markerfac','green','markeredg','yel') // draw onto the axe of figure 10

  print(outl)
  return outl

def convert_dict_to_kin2Dcont(keys_number=4,
                           column_number=6,
                           ):
  key = sorted(cdl_database.keys())[keys_number]
  outl = "PHI/PSI %s %s" % (key, column_number)
  outl = """# Table name/description: "motif.loose_threeten"
  # Number of dimensions: 2
  # For each dimension, 1 to 2: lower_bound  upper_bound  number_of_bins  wrapping
  #   x1: -180.0 180.0 120 true
  #   x2: -180.0 180.0 120 true
  # List of table coordinates and values. (Value is last number on each line.)
  """
  phi_range = (0, 370, 10)
  psi_range = (0, 370, 10)
  #phi_range = (-180, 190, 10)
  #psi_range = (-180, 190, 10)
  for i, phi in enumerate(range(*phi_range)):
    if phi>=180: kphi=phi-360
    else: kphi=phi
    for j, psi in enumerate(range(*psi_range)):
      if psi>=180: kpsi=psi-360
      else: kpsi=psi
      outl += " %12.5f %12.5f %12.5f\n" % (phi, psi, cdl_database[key][(kphi, kpsi)][column_number])

  print(outl)
  return outl

def get_min_max_table():
  from mmtbx.conformation_dependent_library import columns
  def anglise(s):
    outl = ""
    for c in s:
      if c in ["m", "s"]: continue
      if c=="A":
        outl += "%s-" % "CA"
      elif c=="B":
        outl += "%s-" % "CB"
      else:
        outl += "%s-" % c
    return outl[:-1]
  svl_data = [None, None,
              121.7, 1.8,
              110.4, 1.5,
              111.2, 2.8,
              None, None,
              120.8, 1.7,
              116.2, 2.0,
              123.0, 1.6,
              ]
  ##
  min_values = [1e9]*26
  min_data = [None]*26
  max_values = [-1e9]*26
  max_data = [None]*26
  for i, (residue_class, resdiue_data) in enumerate(cdl_database.items()):
    if residue_class.startswith("Gly"): continue
    if residue_class.startswith("Pro"): continue
    print(residue_class)
    for j, (phi_psi, data) in enumerate(sorted(resdiue_data.items())):
      for k, d in enumerate(data):
        if k<2: continue
        if d<min_values[k]:
          min_values[k]=d
          min_data[k]=(residue_class, phi_psi)
        if d>max_values[k]:
          max_values[k]=d
          max_data[k]=(residue_class, phi_psi)
  print(min_values)
  print(max_values)
  print(min_data)
  print(max_data)
  outl = "Angle\tSVL\tmin(CDL)\tmax(CDL)\n"
  for i, c in enumerate(columns):
    if i<2: continue
    if i>15: continue
    if c.startswith("s"): continue
    print(i, c)
    outl += anglise(c)
    if svl_data[i] is None:
      outl += "\t-"
    else:
      outl += "\t%0.1f" % svl_data[i]
    outl += "\t%0.1f" % min_values[i]
    outl += "\t%0.1f" % max_values[i]
    #outl += "\t#%s %s" % min_data[i]
    #outl += "\t%s %s" % max_data[i]
    outl += "\n"
    print(outl)
  assert 0

def run(filename=None):
  if 0:
    print(get_min_max_table())
    assert 0
  if 0:
    for i, key in enumerate(sorted(cdl_database)):
      output = "n_ca_c_m_%s.dat" % key
      print(i+1,key,output)
      f=open(output, "w")
      f.write(convert_dict_to_gnuplot(keys_number=i, dales_format=True))
      f.close()
      cmd = "gnuplot %s" % output
      os.system(cmd)
    assert 0
    f=open("n_ca_c_e.dat", "w")
    f.write(convert_dict_to_gnuplot(column_number=7))
    f.close()
    f=open("n_ca_c_m.csv", "w")
    f.write(convert_dict_to_excel())
    f.close()
    f=open("n_ca_c_m.cse", "w")
    f.write(convert_dict_to_scilab())
    f.close()
    assert 0

  if filename:
    print('run CDL on',filename)
    run_apply(filename,
              #verbose=True,
              )
  else:
    print('Running tests')
    for filename in output_filenames:
      print(filename)
      f=open(filename, "w")
      f.write(output_filenames[filename])
      f.close()
    for filename in filenames:
      #if filename.find("_8")==-1: continue
      print(('%s ' % filename)*5)
      run_apply(filename, testing=True)

def test_threes_methods():
  import iotbx.pdb
  from mmtbx.conformation_dependent_library import generate_protein_threes
  tmp_hierarchy = iotbx.pdb.input(
      source_info=None,
      lines=flex.split_lines(output_filenames["cdl_test_8.pdb"])).\
    construct_hierarchy()
  for three in generate_protein_threes(
      hierarchy=tmp_hierarchy,
      geometry=None):
    # there should be only one!
    assert three.get_resnames() == ["CYS", "TYR", "PRO"], '%s!=%s' % (
      three.get_resnames(), ["CYS", "TYR", "PRO"])

if __name__=="__main__":
  args = sys.argv[1:]
  del sys.argv[1:]
  run(*tuple(args))
  test_threes_methods()
