# Ajuda FastAPI - Obter Ajuda

Você gosta do **FastAPI**?

Você gostaria de ajudar o FastAPI, outros usários, e o autor?

Ou você gostaria de obter ajuda relacionada ao **FastAPI**??

Existem métodos muito simples de ajudar (A maioria das ajudas podem ser feitas com um ou dois cliques).

E também existem vários modos de se conseguir ajuda.

## Inscreva-se na newsletter

Você pode se inscrever (pouco frequente) [**FastAPI e amigos** newsletter](newsletter.md){.internal-link target=_blank} para receber atualizações:

* Notícias sobre FastAPI e amigos 🚀
* Tutoriais 📝
* Recursos ✨
* Mudanças de última hora 🚨
* Truques e dicas ✅

## Siga o FastAPI no X (Twitter)

<a href="https://x.com/fastapi" class="external-link" target="_blank">Siga @fastapi no **X (Twitter)**</a> para receber as últimas notícias sobre o **FastAPI**. 🐦

## Favorite o **FastAPI** no GitHub

Você pode "favoritar" o FastAPI no GitHub (clicando na estrela no canto superior direito): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. ⭐️

Favoritando, outros usuários poderão encontrar mais facilmente e verão que já foi útil para muita gente.

## Acompanhe novos updates no repositorio do GitHub

Você pode "acompanhar" (watch) o FastAPI no GitHub (clicando no botão com um "olho" no canto superior direito): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. 👀

Podendo selecionar apenas "Novos Updates".

Fazendo isto, serão enviadas notificações (em seu email) sempre que tiver novos updates (uma nova versão) com correções de bugs e novos recursos no **FastAPI**

## Conect-se com o autor

Você pode se conectar <a href="https://tiangolo.com" class="external-link" target="_blank">comigo (Sebastián Ramírez / `tiangolo`)</a>, o autor.

Você pode:

* <a href="https://github.com/tiangolo" class="external-link" target="_blank">Me siga no **GitHub**</a>.
    * Ver também outros projetos Open Source criados por mim que podem te ajudar.
    * Me seguir para saber quando um novo projeto Open Source for criado.
* <a href="https://x.com/tiangolo" class="external-link" target="_blank">Me siga no **X (Twitter)**</a>.
    * Me dizer o motivo pelo o qual você está usando o FastAPI(Adoro ouvir esse tipo de comentário).
    * Saber quando eu soltar novos anúncios ou novas ferramentas.
    * Também é possivel <a href="https://x.com/fastapi" class="external-link" target="_blank">seguir o @fastapi no X (Twitter)</a> (uma conta aparte).
* <a href="https://www.linkedin.com/in/tiangolo/" class="external-link" target="_blank">Conect-se comigo no **Linkedin**</a>.
    * Saber quando eu fizer novos anúncios ou novas ferramentas (apesar de que uso o X (Twitter) com mais frequência 🤷‍♂).
* Ler meus artigos (ou me seguir) no <a href="https://dev.to/tiangolo" class="external-link" target="_blank">**Dev.to**</a> ou no <a href="https://medium.com/@tiangolo" class="external-link" target="_blank">**Medium**</a>.
    * Ficar por dentro de novas ideias, artigos, e ferramentas criadas por mim.
    * Me siga para saber quando eu publicar algo novo.

## Tweete sobre **FastAPI**

<a href="https://x.com/compose/tweet?text=I'm loving @fastapi because... https://github.com/fastapi/fastapi" class="external-link" target="_blank">Tweete sobre o **FastAPI**</a> e compartilhe comigo e com os outros o porque de gostar do FastAPI. 🎉

Adoro ouvir sobre como o **FastAPI** é usado, o que você gosta nele, em qual projeto/empresa está sendo usado, etc.

## Vote no FastAPI

* <a href="https://www.slant.co/options/34241/~fastapi-review" class="external-link" target="_blank">Vote no **FastAPI** no Slant</a>.
* <a href="https://alternativeto.net/software/fastapi/" class="external-link" target="_blank">Vote no **FastAPI** no AlternativeTo</a>.

## Responda perguntas no GitHub

Você pode acompanhar as <a href="https://github.com/fastapi/fastapi/issues" class="external-link" target="_blank">perguntas existentes</a> e tentar ajudar outros,            . 🤓

Ajudando a responder as questões de varias pessoas, você pode se tornar um [Expert em FastAPI](fastapi-people.md#especialistas){.internal-link target=_blank} oficial. 🎉

## Acompanhe o repositório do GitHub

Você pode "acompanhar" (watch) o FastAPI no GitHub (clicando no "olho" no canto superior direito): <a href="https://github.com/fastapi/fastapi" class="external-link" target="_blank">https://github.com/fastapi/fastapi</a>. 👀

Se você selecionar "Acompanhando" (Watching) em vez de "Apenas Lançamentos" (Releases only) você receberá notificações quando alguém tiver uma nova pergunta.

Assim podendo tentar ajudar a resolver essas questões.

## Faça perguntas

É possível <a href="https://github.com/fastapi/fastapi/issues/new/choose" class="external-link" target="_blank">criar uma nova pergunta</a> no repositório do GitHub, por exemplo:

* Faça uma **pergunta** ou pergunte sobre um **problema**.
* Sugira novos **recursos**.

**Nota**: Se você fizer uma pergunta, então eu gostaria de pedir que você também ajude os outros com suas respectivas perguntas. 😉

## Crie um Pull Request

É possível [contribuir](contributing.md){.internal-link target=_blank} no código fonte fazendo Pull Requests, por exemplo:

* Para corrigir um erro de digitação que você encontrou na documentação.
* Para compartilhar um artigo, video, ou podcast criados por você sobre o FastAPI <a href="https://github.com/fastapi/fastapi/edit/master/docs/en/data/external_links.yml" class="external-link" target="_blank">editando este arquivo</a>.
    * Não se esqueça de adicionar o link no começo da seção correspondente.
* Para ajudar [traduzir a documentação](contributing.md#traducoes){.internal-link target=_blank} para sua lingua.
    * Também é possivel revisar as traduções já existentes.
* Para propor novas seções na documentação.
* Para corrigir um bug/questão.
* Para adicionar um novo recurso.

## Entre no chat

Entre no 👥 <a href="https://discord.gg/VQjSZaeJmf" class="external-link" target="_blank">server de conversa do Discord</a> 👥 e conheça novas pessoas da comunidade
do FastAPI.

/// tip | Dica

Para perguntas, pergunte nas <a href="https://github.com/fastapi/fastapi/issues/new/choose" class="external-link" target="_blank">questões do GitHub</a>, lá tem um chance maior de você ser ajudado sobre o FastAPI [FastAPI Experts](fastapi-people.md#especialistas){.internal-link target=_blank}.

Use o chat apenas para outro tipo de assunto.

///

### Não faça perguntas no chat

Tenha em mente que os chats permitem uma "conversa mais livre", dessa forma é muito fácil fazer perguntas que são muito genéricas e dificeís de responder, assim você pode acabar não sendo respondido.

Nas questões do GitHub o template irá te guiar para que você faça a sua pergunta de um jeito mais correto, fazendo com que você receba respostas mais completas, e até mesmo que você mesmo resolva o problema antes de perguntar. E no GitHub eu garanto que sempre irei responder todas as perguntas, mesmo que leve um tempo. Eu pessoalmente não consigo fazer isso via chat. 😅

Conversas no chat não são tão fáceis de serem encontrados quanto no GitHub, então questões e respostas podem se perder dentro da conversa. E apenas as que estão nas questões do GitHub contam para você se tornar um [Expert em FastAPI](fastapi-people.md#especialistas){.internal-link target=_blank}, então você receberá mais atenção nas questões do GitHub.

Por outro lado, existem milhares de usuários no chat, então tem uma grande chance de você encontrar alguém para trocar uma idéia por lá em qualquer horário. 😄

## Patrocine o autor

Você também pode ajudar o autor financeiramente (eu) através do <a href="https://github.com/sponsors/tiangolo" class="external-link" target="_blank">GitHub sponsors</a>.

Lá você pode me pagar um cafézinho ☕️ como agradecimento. 😄

E você também pode se tornar um patrocinador Prata ou Ouro do FastAPI. 🏅🎉

## Patrocine as ferramente que potencializam o FastAPI

Como você viu na documentação, o FastAPI se apoia em nos gigantes, Starlette e Pydantic.

Patrocine também:

* <a href="https://github.com/sponsors/samuelcolvin" class="external-link" target="_blank">Samuel Colvin (Pydantic)</a>
* <a href="https://github.com/sponsors/encode" class="external-link" target="_blank">Encode (Starlette, Uvicorn)</a>

---

Muito Obrigado! 🚀
