//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armdesktopvirtualization

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strconv"
	"strings"
)

// ScalingPlanPersonalSchedulesClient contains the methods for the ScalingPlanPersonalSchedules group.
// Don't use this type directly, use NewScalingPlanPersonalSchedulesClient() instead.
type ScalingPlanPersonalSchedulesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewScalingPlanPersonalSchedulesClient creates a new instance of ScalingPlanPersonalSchedulesClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewScalingPlanPersonalSchedulesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*ScalingPlanPersonalSchedulesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &ScalingPlanPersonalSchedulesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// Create - Create or update a ScalingPlanPersonalSchedule.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-05
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - scalingPlanName - The name of the scaling plan.
//   - scalingPlanScheduleName - The name of the ScalingPlanSchedule
//   - scalingPlanSchedule - Object containing ScalingPlanPersonalSchedule definitions.
//   - options - ScalingPlanPersonalSchedulesClientCreateOptions contains the optional parameters for the ScalingPlanPersonalSchedulesClient.Create
//     method.
func (client *ScalingPlanPersonalSchedulesClient) Create(ctx context.Context, resourceGroupName string, scalingPlanName string, scalingPlanScheduleName string, scalingPlanSchedule ScalingPlanPersonalSchedule, options *ScalingPlanPersonalSchedulesClientCreateOptions) (ScalingPlanPersonalSchedulesClientCreateResponse, error) {
	var err error
	const operationName = "ScalingPlanPersonalSchedulesClient.Create"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, resourceGroupName, scalingPlanName, scalingPlanScheduleName, scalingPlanSchedule, options)
	if err != nil {
		return ScalingPlanPersonalSchedulesClientCreateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ScalingPlanPersonalSchedulesClientCreateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return ScalingPlanPersonalSchedulesClientCreateResponse{}, err
	}
	resp, err := client.createHandleResponse(httpResp)
	return resp, err
}

// createCreateRequest creates the Create request.
func (client *ScalingPlanPersonalSchedulesClient) createCreateRequest(ctx context.Context, resourceGroupName string, scalingPlanName string, scalingPlanScheduleName string, scalingPlanSchedule ScalingPlanPersonalSchedule, options *ScalingPlanPersonalSchedulesClientCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/scalingPlans/{scalingPlanName}/personalSchedules/{scalingPlanScheduleName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if scalingPlanName == "" {
		return nil, errors.New("parameter scalingPlanName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scalingPlanName}", url.PathEscape(scalingPlanName))
	if scalingPlanScheduleName == "" {
		return nil, errors.New("parameter scalingPlanScheduleName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scalingPlanScheduleName}", url.PathEscape(scalingPlanScheduleName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-05")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, scalingPlanSchedule); err != nil {
		return nil, err
	}
	return req, nil
}

// createHandleResponse handles the Create response.
func (client *ScalingPlanPersonalSchedulesClient) createHandleResponse(resp *http.Response) (ScalingPlanPersonalSchedulesClientCreateResponse, error) {
	result := ScalingPlanPersonalSchedulesClientCreateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ScalingPlanPersonalSchedule); err != nil {
		return ScalingPlanPersonalSchedulesClientCreateResponse{}, err
	}
	return result, nil
}

// Delete - Remove a ScalingPlanPersonalSchedule.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-05
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - scalingPlanName - The name of the scaling plan.
//   - scalingPlanScheduleName - The name of the ScalingPlanSchedule
//   - options - ScalingPlanPersonalSchedulesClientDeleteOptions contains the optional parameters for the ScalingPlanPersonalSchedulesClient.Delete
//     method.
func (client *ScalingPlanPersonalSchedulesClient) Delete(ctx context.Context, resourceGroupName string, scalingPlanName string, scalingPlanScheduleName string, options *ScalingPlanPersonalSchedulesClientDeleteOptions) (ScalingPlanPersonalSchedulesClientDeleteResponse, error) {
	var err error
	const operationName = "ScalingPlanPersonalSchedulesClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, scalingPlanName, scalingPlanScheduleName, options)
	if err != nil {
		return ScalingPlanPersonalSchedulesClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ScalingPlanPersonalSchedulesClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return ScalingPlanPersonalSchedulesClientDeleteResponse{}, err
	}
	return ScalingPlanPersonalSchedulesClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *ScalingPlanPersonalSchedulesClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, scalingPlanName string, scalingPlanScheduleName string, options *ScalingPlanPersonalSchedulesClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/scalingPlans/{scalingPlanName}/personalSchedules/{scalingPlanScheduleName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if scalingPlanName == "" {
		return nil, errors.New("parameter scalingPlanName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scalingPlanName}", url.PathEscape(scalingPlanName))
	if scalingPlanScheduleName == "" {
		return nil, errors.New("parameter scalingPlanScheduleName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scalingPlanScheduleName}", url.PathEscape(scalingPlanScheduleName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-05")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - Get a ScalingPlanPersonalSchedule.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-05
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - scalingPlanName - The name of the scaling plan.
//   - scalingPlanScheduleName - The name of the ScalingPlanSchedule
//   - options - ScalingPlanPersonalSchedulesClientGetOptions contains the optional parameters for the ScalingPlanPersonalSchedulesClient.Get
//     method.
func (client *ScalingPlanPersonalSchedulesClient) Get(ctx context.Context, resourceGroupName string, scalingPlanName string, scalingPlanScheduleName string, options *ScalingPlanPersonalSchedulesClientGetOptions) (ScalingPlanPersonalSchedulesClientGetResponse, error) {
	var err error
	const operationName = "ScalingPlanPersonalSchedulesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, scalingPlanName, scalingPlanScheduleName, options)
	if err != nil {
		return ScalingPlanPersonalSchedulesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ScalingPlanPersonalSchedulesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ScalingPlanPersonalSchedulesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *ScalingPlanPersonalSchedulesClient) getCreateRequest(ctx context.Context, resourceGroupName string, scalingPlanName string, scalingPlanScheduleName string, options *ScalingPlanPersonalSchedulesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/scalingPlans/{scalingPlanName}/personalSchedules/{scalingPlanScheduleName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if scalingPlanName == "" {
		return nil, errors.New("parameter scalingPlanName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scalingPlanName}", url.PathEscape(scalingPlanName))
	if scalingPlanScheduleName == "" {
		return nil, errors.New("parameter scalingPlanScheduleName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scalingPlanScheduleName}", url.PathEscape(scalingPlanScheduleName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-05")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *ScalingPlanPersonalSchedulesClient) getHandleResponse(resp *http.Response) (ScalingPlanPersonalSchedulesClientGetResponse, error) {
	result := ScalingPlanPersonalSchedulesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ScalingPlanPersonalSchedule); err != nil {
		return ScalingPlanPersonalSchedulesClientGetResponse{}, err
	}
	return result, nil
}

// NewListPager - List ScalingPlanPersonalSchedules.
//
// Generated from API version 2023-09-05
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - scalingPlanName - The name of the scaling plan.
//   - options - ScalingPlanPersonalSchedulesClientListOptions contains the optional parameters for the ScalingPlanPersonalSchedulesClient.NewListPager
//     method.
func (client *ScalingPlanPersonalSchedulesClient) NewListPager(resourceGroupName string, scalingPlanName string, options *ScalingPlanPersonalSchedulesClientListOptions) *runtime.Pager[ScalingPlanPersonalSchedulesClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[ScalingPlanPersonalSchedulesClientListResponse]{
		More: func(page ScalingPlanPersonalSchedulesClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *ScalingPlanPersonalSchedulesClientListResponse) (ScalingPlanPersonalSchedulesClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "ScalingPlanPersonalSchedulesClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, resourceGroupName, scalingPlanName, options)
			}, nil)
			if err != nil {
				return ScalingPlanPersonalSchedulesClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *ScalingPlanPersonalSchedulesClient) listCreateRequest(ctx context.Context, resourceGroupName string, scalingPlanName string, options *ScalingPlanPersonalSchedulesClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/scalingPlans/{scalingPlanName}/personalSchedules"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if scalingPlanName == "" {
		return nil, errors.New("parameter scalingPlanName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scalingPlanName}", url.PathEscape(scalingPlanName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-05")
	if options != nil && options.PageSize != nil {
		reqQP.Set("pageSize", strconv.FormatInt(int64(*options.PageSize), 10))
	}
	if options != nil && options.IsDescending != nil {
		reqQP.Set("isDescending", strconv.FormatBool(*options.IsDescending))
	}
	if options != nil && options.InitialSkip != nil {
		reqQP.Set("initialSkip", strconv.FormatInt(int64(*options.InitialSkip), 10))
	}
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *ScalingPlanPersonalSchedulesClient) listHandleResponse(resp *http.Response) (ScalingPlanPersonalSchedulesClientListResponse, error) {
	result := ScalingPlanPersonalSchedulesClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ScalingPlanPersonalScheduleList); err != nil {
		return ScalingPlanPersonalSchedulesClientListResponse{}, err
	}
	return result, nil
}

// Update - Update a ScalingPlanPersonalSchedule.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-09-05
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - scalingPlanName - The name of the scaling plan.
//   - scalingPlanScheduleName - The name of the ScalingPlanSchedule
//   - options - ScalingPlanPersonalSchedulesClientUpdateOptions contains the optional parameters for the ScalingPlanPersonalSchedulesClient.Update
//     method.
func (client *ScalingPlanPersonalSchedulesClient) Update(ctx context.Context, resourceGroupName string, scalingPlanName string, scalingPlanScheduleName string, options *ScalingPlanPersonalSchedulesClientUpdateOptions) (ScalingPlanPersonalSchedulesClientUpdateResponse, error) {
	var err error
	const operationName = "ScalingPlanPersonalSchedulesClient.Update"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, scalingPlanName, scalingPlanScheduleName, options)
	if err != nil {
		return ScalingPlanPersonalSchedulesClientUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return ScalingPlanPersonalSchedulesClientUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return ScalingPlanPersonalSchedulesClientUpdateResponse{}, err
	}
	resp, err := client.updateHandleResponse(httpResp)
	return resp, err
}

// updateCreateRequest creates the Update request.
func (client *ScalingPlanPersonalSchedulesClient) updateCreateRequest(ctx context.Context, resourceGroupName string, scalingPlanName string, scalingPlanScheduleName string, options *ScalingPlanPersonalSchedulesClientUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DesktopVirtualization/scalingPlans/{scalingPlanName}/personalSchedules/{scalingPlanScheduleName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if scalingPlanName == "" {
		return nil, errors.New("parameter scalingPlanName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scalingPlanName}", url.PathEscape(scalingPlanName))
	if scalingPlanScheduleName == "" {
		return nil, errors.New("parameter scalingPlanScheduleName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{scalingPlanScheduleName}", url.PathEscape(scalingPlanScheduleName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-09-05")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if options != nil && options.ScalingPlanSchedule != nil {
		if err := runtime.MarshalAsJSON(req, *options.ScalingPlanSchedule); err != nil {
			return nil, err
		}
		return req, nil
	}
	return req, nil
}

// updateHandleResponse handles the Update response.
func (client *ScalingPlanPersonalSchedulesClient) updateHandleResponse(resp *http.Response) (ScalingPlanPersonalSchedulesClientUpdateResponse, error) {
	result := ScalingPlanPersonalSchedulesClientUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ScalingPlanPersonalSchedule); err != nil {
		return ScalingPlanPersonalSchedulesClientUpdateResponse{}, err
	}
	return result, nil
}
