//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armnetwork_test

import (
	"context"
	"log"

	"github.com/Azure/azure-sdk-for-go/sdk/azidentity"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/network/armnetwork/v4"
)

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ExpressRoutePortsLocationList.json
func ExampleExpressRoutePortsLocationsClient_NewListPager() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	pager := clientFactory.NewExpressRoutePortsLocationsClient().NewListPager(nil)
	for pager.More() {
		page, err := pager.NextPage(ctx)
		if err != nil {
			log.Fatalf("failed to advance page: %v", err)
		}
		for _, v := range page.Value {
			// You could use page here. We use blank identifier for just demo purposes.
			_ = v
		}
		// If the HTTP response code is 200 as defined in example definition, your page structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
		// page.ExpressRoutePortsLocationListResult = armnetwork.ExpressRoutePortsLocationListResult{
		// 	Value: []*armnetwork.ExpressRoutePortsLocation{
		// 		{
		// 			Name: to.Ptr("locationName"),
		// 			Type: to.Ptr("Microsoft.Network/expressRoutePortsLocations"),
		// 			ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/expressRoutePortsLocations/locationName"),
		// 			Location: to.Ptr("westus"),
		// 			Properties: &armnetwork.ExpressRoutePortsLocationPropertiesFormat{
		// 				Address: to.Ptr("123 Main Street, City, State, Zip"),
		// 				AvailableBandwidths: []*armnetwork.ExpressRoutePortsLocationBandwidths{
		// 				},
		// 				Contact: to.Ptr("email@address.com"),
		// 				ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
		// 			},
		// 	}},
		// }
	}
}

// Generated from example definition: https://github.com/Azure/azure-rest-api-specs/blob/80c21c17b4a7aa57f637ee594f7cfd653255a7e0/specification/network/resource-manager/Microsoft.Network/stable/2023-05-01/examples/ExpressRoutePortsLocationGet.json
func ExampleExpressRoutePortsLocationsClient_Get() {
	cred, err := azidentity.NewDefaultAzureCredential(nil)
	if err != nil {
		log.Fatalf("failed to obtain a credential: %v", err)
	}
	ctx := context.Background()
	clientFactory, err := armnetwork.NewClientFactory("<subscription-id>", cred, nil)
	if err != nil {
		log.Fatalf("failed to create client: %v", err)
	}
	res, err := clientFactory.NewExpressRoutePortsLocationsClient().Get(ctx, "locationName", nil)
	if err != nil {
		log.Fatalf("failed to finish the request: %v", err)
	}
	// You could use response here. We use blank identifier for just demo purposes.
	_ = res
	// If the HTTP response code is 200 as defined in example definition, your response structure would look as follows. Please pay attention that all the values in the output are fake values for just demo purposes.
	// res.ExpressRoutePortsLocation = armnetwork.ExpressRoutePortsLocation{
	// 	Name: to.Ptr("locationName"),
	// 	Type: to.Ptr("Microsoft.Network/expressRoutePortsLocations"),
	// 	ID: to.Ptr("/subscriptions/subid/providers/Microsoft.Network/expressRoutePortsLocations/locationName"),
	// 	Location: to.Ptr("westus"),
	// 	Properties: &armnetwork.ExpressRoutePortsLocationPropertiesFormat{
	// 		Address: to.Ptr("123 Main Street, City, State, Zip"),
	// 		AvailableBandwidths: []*armnetwork.ExpressRoutePortsLocationBandwidths{
	// 			{
	// 				OfferName: to.Ptr("100 Gbps"),
	// 				ValueInGbps: to.Ptr[int32](100),
	// 		}},
	// 		Contact: to.Ptr("email@address.com"),
	// 		ProvisioningState: to.Ptr(armnetwork.ProvisioningStateSucceeded),
	// 	},
	// }
}
