//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armnetworkanalytics

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// DataProductsClient contains the methods for the DataProducts group.
// Don't use this type directly, use NewDataProductsClient() instead.
type DataProductsClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewDataProductsClient creates a new instance of DataProductsClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewDataProductsClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*DataProductsClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &DataProductsClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// AddUserRole - Assign role to the data product.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - dataProductName - The data product resource name
//   - body - The content of the action request
//   - options - DataProductsClientAddUserRoleOptions contains the optional parameters for the DataProductsClient.AddUserRole
//     method.
func (client *DataProductsClient) AddUserRole(ctx context.Context, resourceGroupName string, dataProductName string, body RoleAssignmentCommonProperties, options *DataProductsClientAddUserRoleOptions) (DataProductsClientAddUserRoleResponse, error) {
	var err error
	const operationName = "DataProductsClient.AddUserRole"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.addUserRoleCreateRequest(ctx, resourceGroupName, dataProductName, body, options)
	if err != nil {
		return DataProductsClientAddUserRoleResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DataProductsClientAddUserRoleResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DataProductsClientAddUserRoleResponse{}, err
	}
	resp, err := client.addUserRoleHandleResponse(httpResp)
	return resp, err
}

// addUserRoleCreateRequest creates the AddUserRole request.
func (client *DataProductsClient) addUserRoleCreateRequest(ctx context.Context, resourceGroupName string, dataProductName string, body RoleAssignmentCommonProperties, options *DataProductsClientAddUserRoleOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts/{dataProductName}/addUserRole"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dataProductName == "" {
		return nil, errors.New("parameter dataProductName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataProductName}", url.PathEscape(dataProductName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// addUserRoleHandleResponse handles the AddUserRole response.
func (client *DataProductsClient) addUserRoleHandleResponse(resp *http.Response) (DataProductsClientAddUserRoleResponse, error) {
	result := DataProductsClientAddUserRoleResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.RoleAssignmentDetail); err != nil {
		return DataProductsClientAddUserRoleResponse{}, err
	}
	return result, nil
}

// BeginCreate - Create data product resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - dataProductName - The data product resource name
//   - resource - Resource create parameters.
//   - options - DataProductsClientBeginCreateOptions contains the optional parameters for the DataProductsClient.BeginCreate
//     method.
func (client *DataProductsClient) BeginCreate(ctx context.Context, resourceGroupName string, dataProductName string, resource DataProduct, options *DataProductsClientBeginCreateOptions) (*runtime.Poller[DataProductsClientCreateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.create(ctx, resourceGroupName, dataProductName, resource, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DataProductsClientCreateResponse]{
			FinalStateVia: runtime.FinalStateViaAzureAsyncOp,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DataProductsClientCreateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Create - Create data product resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
func (client *DataProductsClient) create(ctx context.Context, resourceGroupName string, dataProductName string, resource DataProduct, options *DataProductsClientBeginCreateOptions) (*http.Response, error) {
	var err error
	const operationName = "DataProductsClient.BeginCreate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createCreateRequest(ctx, resourceGroupName, dataProductName, resource, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// createCreateRequest creates the Create request.
func (client *DataProductsClient) createCreateRequest(ctx context.Context, resourceGroupName string, dataProductName string, resource DataProduct, options *DataProductsClientBeginCreateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts/{dataProductName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dataProductName == "" {
		return nil, errors.New("parameter dataProductName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataProductName}", url.PathEscape(dataProductName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, resource); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginDelete - Delete data product resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - dataProductName - The data product resource name
//   - options - DataProductsClientBeginDeleteOptions contains the optional parameters for the DataProductsClient.BeginDelete
//     method.
func (client *DataProductsClient) BeginDelete(ctx context.Context, resourceGroupName string, dataProductName string, options *DataProductsClientBeginDeleteOptions) (*runtime.Poller[DataProductsClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, dataProductName, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DataProductsClientDeleteResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DataProductsClientDeleteResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Delete - Delete data product resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
func (client *DataProductsClient) deleteOperation(ctx context.Context, resourceGroupName string, dataProductName string, options *DataProductsClientBeginDeleteOptions) (*http.Response, error) {
	var err error
	const operationName = "DataProductsClient.BeginDelete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, dataProductName, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusAccepted, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *DataProductsClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, dataProductName string, options *DataProductsClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts/{dataProductName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dataProductName == "" {
		return nil, errors.New("parameter dataProductName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataProductName}", url.PathEscape(dataProductName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// GenerateStorageAccountSasToken - Generate sas token for storage account.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - dataProductName - The data product resource name
//   - body - The content of the action request
//   - options - DataProductsClientGenerateStorageAccountSasTokenOptions contains the optional parameters for the DataProductsClient.GenerateStorageAccountSasToken
//     method.
func (client *DataProductsClient) GenerateStorageAccountSasToken(ctx context.Context, resourceGroupName string, dataProductName string, body AccountSas, options *DataProductsClientGenerateStorageAccountSasTokenOptions) (DataProductsClientGenerateStorageAccountSasTokenResponse, error) {
	var err error
	const operationName = "DataProductsClient.GenerateStorageAccountSasToken"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.generateStorageAccountSasTokenCreateRequest(ctx, resourceGroupName, dataProductName, body, options)
	if err != nil {
		return DataProductsClientGenerateStorageAccountSasTokenResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DataProductsClientGenerateStorageAccountSasTokenResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DataProductsClientGenerateStorageAccountSasTokenResponse{}, err
	}
	resp, err := client.generateStorageAccountSasTokenHandleResponse(httpResp)
	return resp, err
}

// generateStorageAccountSasTokenCreateRequest creates the GenerateStorageAccountSasToken request.
func (client *DataProductsClient) generateStorageAccountSasTokenCreateRequest(ctx context.Context, resourceGroupName string, dataProductName string, body AccountSas, options *DataProductsClientGenerateStorageAccountSasTokenOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts/{dataProductName}/generateStorageAccountSasToken"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dataProductName == "" {
		return nil, errors.New("parameter dataProductName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataProductName}", url.PathEscape(dataProductName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// generateStorageAccountSasTokenHandleResponse handles the GenerateStorageAccountSasToken response.
func (client *DataProductsClient) generateStorageAccountSasTokenHandleResponse(resp *http.Response) (DataProductsClientGenerateStorageAccountSasTokenResponse, error) {
	result := DataProductsClientGenerateStorageAccountSasTokenResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.AccountSasToken); err != nil {
		return DataProductsClientGenerateStorageAccountSasTokenResponse{}, err
	}
	return result, nil
}

// Get - Retrieve data product resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - dataProductName - The data product resource name
//   - options - DataProductsClientGetOptions contains the optional parameters for the DataProductsClient.Get method.
func (client *DataProductsClient) Get(ctx context.Context, resourceGroupName string, dataProductName string, options *DataProductsClientGetOptions) (DataProductsClientGetResponse, error) {
	var err error
	const operationName = "DataProductsClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, resourceGroupName, dataProductName, options)
	if err != nil {
		return DataProductsClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DataProductsClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DataProductsClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *DataProductsClient) getCreateRequest(ctx context.Context, resourceGroupName string, dataProductName string, options *DataProductsClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts/{dataProductName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dataProductName == "" {
		return nil, errors.New("parameter dataProductName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataProductName}", url.PathEscape(dataProductName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *DataProductsClient) getHandleResponse(resp *http.Response) (DataProductsClientGetResponse, error) {
	result := DataProductsClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DataProduct); err != nil {
		return DataProductsClientGetResponse{}, err
	}
	return result, nil
}

// NewListByResourceGroupPager - List data products by resource group.
//
// Generated from API version 2023-11-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - options - DataProductsClientListByResourceGroupOptions contains the optional parameters for the DataProductsClient.NewListByResourceGroupPager
//     method.
func (client *DataProductsClient) NewListByResourceGroupPager(resourceGroupName string, options *DataProductsClientListByResourceGroupOptions) *runtime.Pager[DataProductsClientListByResourceGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[DataProductsClientListByResourceGroupResponse]{
		More: func(page DataProductsClientListByResourceGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DataProductsClientListByResourceGroupResponse) (DataProductsClientListByResourceGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DataProductsClient.NewListByResourceGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listByResourceGroupCreateRequest(ctx, resourceGroupName, options)
			}, nil)
			if err != nil {
				return DataProductsClientListByResourceGroupResponse{}, err
			}
			return client.listByResourceGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listByResourceGroupCreateRequest creates the ListByResourceGroup request.
func (client *DataProductsClient) listByResourceGroupCreateRequest(ctx context.Context, resourceGroupName string, options *DataProductsClientListByResourceGroupOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByResourceGroupHandleResponse handles the ListByResourceGroup response.
func (client *DataProductsClient) listByResourceGroupHandleResponse(resp *http.Response) (DataProductsClientListByResourceGroupResponse, error) {
	result := DataProductsClientListByResourceGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DataProductListResult); err != nil {
		return DataProductsClientListByResourceGroupResponse{}, err
	}
	return result, nil
}

// NewListBySubscriptionPager - List data products by subscription.
//
// Generated from API version 2023-11-15
//   - options - DataProductsClientListBySubscriptionOptions contains the optional parameters for the DataProductsClient.NewListBySubscriptionPager
//     method.
func (client *DataProductsClient) NewListBySubscriptionPager(options *DataProductsClientListBySubscriptionOptions) *runtime.Pager[DataProductsClientListBySubscriptionResponse] {
	return runtime.NewPager(runtime.PagingHandler[DataProductsClientListBySubscriptionResponse]{
		More: func(page DataProductsClientListBySubscriptionResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *DataProductsClientListBySubscriptionResponse) (DataProductsClientListBySubscriptionResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "DataProductsClient.NewListBySubscriptionPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listBySubscriptionCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return DataProductsClientListBySubscriptionResponse{}, err
			}
			return client.listBySubscriptionHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listBySubscriptionCreateRequest creates the ListBySubscription request.
func (client *DataProductsClient) listBySubscriptionCreateRequest(ctx context.Context, options *DataProductsClientListBySubscriptionOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.NetworkAnalytics/dataProducts"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listBySubscriptionHandleResponse handles the ListBySubscription response.
func (client *DataProductsClient) listBySubscriptionHandleResponse(resp *http.Response) (DataProductsClientListBySubscriptionResponse, error) {
	result := DataProductsClientListBySubscriptionResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.DataProductListResult); err != nil {
		return DataProductsClientListBySubscriptionResponse{}, err
	}
	return result, nil
}

// ListRolesAssignments - List user roles associated with the data product.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - dataProductName - The data product resource name
//   - body - The content of the action request
//   - options - DataProductsClientListRolesAssignmentsOptions contains the optional parameters for the DataProductsClient.ListRolesAssignments
//     method.
func (client *DataProductsClient) ListRolesAssignments(ctx context.Context, resourceGroupName string, dataProductName string, body any, options *DataProductsClientListRolesAssignmentsOptions) (DataProductsClientListRolesAssignmentsResponse, error) {
	var err error
	const operationName = "DataProductsClient.ListRolesAssignments"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.listRolesAssignmentsCreateRequest(ctx, resourceGroupName, dataProductName, body, options)
	if err != nil {
		return DataProductsClientListRolesAssignmentsResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DataProductsClientListRolesAssignmentsResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return DataProductsClientListRolesAssignmentsResponse{}, err
	}
	resp, err := client.listRolesAssignmentsHandleResponse(httpResp)
	return resp, err
}

// listRolesAssignmentsCreateRequest creates the ListRolesAssignments request.
func (client *DataProductsClient) listRolesAssignmentsCreateRequest(ctx context.Context, resourceGroupName string, dataProductName string, body any, options *DataProductsClientListRolesAssignmentsOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts/{dataProductName}/listRolesAssignments"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dataProductName == "" {
		return nil, errors.New("parameter dataProductName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataProductName}", url.PathEscape(dataProductName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// listRolesAssignmentsHandleResponse handles the ListRolesAssignments response.
func (client *DataProductsClient) listRolesAssignmentsHandleResponse(resp *http.Response) (DataProductsClientListRolesAssignmentsResponse, error) {
	result := DataProductsClientListRolesAssignmentsResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.ListRoleAssignments); err != nil {
		return DataProductsClientListRolesAssignmentsResponse{}, err
	}
	return result, nil
}

// RemoveUserRole - Remove role from the data product.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - dataProductName - The data product resource name
//   - body - The content of the action request
//   - options - DataProductsClientRemoveUserRoleOptions contains the optional parameters for the DataProductsClient.RemoveUserRole
//     method.
func (client *DataProductsClient) RemoveUserRole(ctx context.Context, resourceGroupName string, dataProductName string, body RoleAssignmentDetail, options *DataProductsClientRemoveUserRoleOptions) (DataProductsClientRemoveUserRoleResponse, error) {
	var err error
	const operationName = "DataProductsClient.RemoveUserRole"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.removeUserRoleCreateRequest(ctx, resourceGroupName, dataProductName, body, options)
	if err != nil {
		return DataProductsClientRemoveUserRoleResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DataProductsClientRemoveUserRoleResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return DataProductsClientRemoveUserRoleResponse{}, err
	}
	return DataProductsClientRemoveUserRoleResponse{}, nil
}

// removeUserRoleCreateRequest creates the RemoveUserRole request.
func (client *DataProductsClient) removeUserRoleCreateRequest(ctx context.Context, resourceGroupName string, dataProductName string, body RoleAssignmentDetail, options *DataProductsClientRemoveUserRoleOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts/{dataProductName}/removeUserRole"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dataProductName == "" {
		return nil, errors.New("parameter dataProductName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataProductName}", url.PathEscape(dataProductName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// RotateKey - Initiate key rotation on Data Product.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - dataProductName - The data product resource name
//   - body - The content of the action request
//   - options - DataProductsClientRotateKeyOptions contains the optional parameters for the DataProductsClient.RotateKey method.
func (client *DataProductsClient) RotateKey(ctx context.Context, resourceGroupName string, dataProductName string, body KeyVaultInfo, options *DataProductsClientRotateKeyOptions) (DataProductsClientRotateKeyResponse, error) {
	var err error
	const operationName = "DataProductsClient.RotateKey"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.rotateKeyCreateRequest(ctx, resourceGroupName, dataProductName, body, options)
	if err != nil {
		return DataProductsClientRotateKeyResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return DataProductsClientRotateKeyResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return DataProductsClientRotateKeyResponse{}, err
	}
	return DataProductsClientRotateKeyResponse{}, nil
}

// rotateKeyCreateRequest creates the RotateKey request.
func (client *DataProductsClient) rotateKeyCreateRequest(ctx context.Context, resourceGroupName string, dataProductName string, body KeyVaultInfo, options *DataProductsClientRotateKeyOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts/{dataProductName}/rotateKey"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dataProductName == "" {
		return nil, errors.New("parameter dataProductName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataProductName}", url.PathEscape(dataProductName))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, body); err != nil {
		return nil, err
	}
	return req, nil
}

// BeginUpdate - Update data product resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
//   - resourceGroupName - The name of the resource group. The name is case insensitive.
//   - dataProductName - The data product resource name
//   - properties - The resource properties to be updated.
//   - options - DataProductsClientBeginUpdateOptions contains the optional parameters for the DataProductsClient.BeginUpdate
//     method.
func (client *DataProductsClient) BeginUpdate(ctx context.Context, resourceGroupName string, dataProductName string, properties DataProductUpdate, options *DataProductsClientBeginUpdateOptions) (*runtime.Poller[DataProductsClientUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.update(ctx, resourceGroupName, dataProductName, properties, options)
		if err != nil {
			return nil, err
		}
		poller, err := runtime.NewPoller(resp, client.internal.Pipeline(), &runtime.NewPollerOptions[DataProductsClientUpdateResponse]{
			FinalStateVia: runtime.FinalStateViaLocation,
			Tracer:        client.internal.Tracer(),
		})
		return poller, err
	} else {
		return runtime.NewPollerFromResumeToken(options.ResumeToken, client.internal.Pipeline(), &runtime.NewPollerFromResumeTokenOptions[DataProductsClientUpdateResponse]{
			Tracer: client.internal.Tracer(),
		})
	}
}

// Update - Update data product resource.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2023-11-15
func (client *DataProductsClient) update(ctx context.Context, resourceGroupName string, dataProductName string, properties DataProductUpdate, options *DataProductsClientBeginUpdateOptions) (*http.Response, error) {
	var err error
	const operationName = "DataProductsClient.BeginUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.updateCreateRequest(ctx, resourceGroupName, dataProductName, properties, options)
	if err != nil {
		return nil, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusAccepted) {
		err = runtime.NewResponseError(httpResp)
		return nil, err
	}
	return httpResp, nil
}

// updateCreateRequest creates the Update request.
func (client *DataProductsClient) updateCreateRequest(ctx context.Context, resourceGroupName string, dataProductName string, properties DataProductUpdate, options *DataProductsClientBeginUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NetworkAnalytics/dataProducts/{dataProductName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if dataProductName == "" {
		return nil, errors.New("parameter dataProductName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{dataProductName}", url.PathEscape(dataProductName))
	req, err := runtime.NewRequest(ctx, http.MethodPatch, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2023-11-15")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, properties); err != nil {
		return nil, err
	}
	return req, nil
}
