//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armpolicy

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// VariablesClient contains the methods for the Variables group.
// Don't use this type directly, use NewVariablesClient() instead.
type VariablesClient struct {
	internal       *arm.Client
	subscriptionID string
}

// NewVariablesClient creates a new instance of VariablesClient with the specified values.
//   - subscriptionID - The ID of the target subscription.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewVariablesClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*VariablesClient, error) {
	cl, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	client := &VariablesClient{
		subscriptionID: subscriptionID,
		internal:       cl,
	}
	return client, nil
}

// CreateOrUpdate - This operation creates or updates a variable with the given subscription and name. Policy variables can
// only be used by a policy definition at the scope they are created or below.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - variableName - The name of the variable to operate on.
//   - parameters - Parameters for the variable.
//   - options - VariablesClientCreateOrUpdateOptions contains the optional parameters for the VariablesClient.CreateOrUpdate
//     method.
func (client *VariablesClient) CreateOrUpdate(ctx context.Context, variableName string, parameters Variable, options *VariablesClientCreateOrUpdateOptions) (VariablesClientCreateOrUpdateResponse, error) {
	var err error
	const operationName = "VariablesClient.CreateOrUpdate"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateCreateRequest(ctx, variableName, parameters, options)
	if err != nil {
		return VariablesClientCreateOrUpdateResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VariablesClientCreateOrUpdateResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return VariablesClientCreateOrUpdateResponse{}, err
	}
	resp, err := client.createOrUpdateHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *VariablesClient) createOrUpdateCreateRequest(ctx context.Context, variableName string, parameters Variable, options *VariablesClientCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/variables/{variableName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if variableName == "" {
		return nil, errors.New("parameter variableName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{variableName}", url.PathEscape(variableName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateHandleResponse handles the CreateOrUpdate response.
func (client *VariablesClient) createOrUpdateHandleResponse(resp *http.Response) (VariablesClientCreateOrUpdateResponse, error) {
	result := VariablesClientCreateOrUpdateResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Variable); err != nil {
		return VariablesClientCreateOrUpdateResponse{}, err
	}
	return result, nil
}

// CreateOrUpdateAtManagementGroup - This operation creates or updates a variable with the given management group and name.
// Policy variables can only be used by a policy definition at the scope they are created or below.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - managementGroupID - The ID of the management group.
//   - variableName - The name of the variable to operate on.
//   - parameters - Parameters for the variable.
//   - options - VariablesClientCreateOrUpdateAtManagementGroupOptions contains the optional parameters for the VariablesClient.CreateOrUpdateAtManagementGroup
//     method.
func (client *VariablesClient) CreateOrUpdateAtManagementGroup(ctx context.Context, managementGroupID string, variableName string, parameters Variable, options *VariablesClientCreateOrUpdateAtManagementGroupOptions) (VariablesClientCreateOrUpdateAtManagementGroupResponse, error) {
	var err error
	const operationName = "VariablesClient.CreateOrUpdateAtManagementGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.createOrUpdateAtManagementGroupCreateRequest(ctx, managementGroupID, variableName, parameters, options)
	if err != nil {
		return VariablesClientCreateOrUpdateAtManagementGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VariablesClientCreateOrUpdateAtManagementGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusCreated) {
		err = runtime.NewResponseError(httpResp)
		return VariablesClientCreateOrUpdateAtManagementGroupResponse{}, err
	}
	resp, err := client.createOrUpdateAtManagementGroupHandleResponse(httpResp)
	return resp, err
}

// createOrUpdateAtManagementGroupCreateRequest creates the CreateOrUpdateAtManagementGroup request.
func (client *VariablesClient) createOrUpdateAtManagementGroupCreateRequest(ctx context.Context, managementGroupID string, variableName string, parameters Variable, options *VariablesClientCreateOrUpdateAtManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/variables/{variableName}"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if variableName == "" {
		return nil, errors.New("parameter variableName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{variableName}", url.PathEscape(variableName))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	if err := runtime.MarshalAsJSON(req, parameters); err != nil {
		return nil, err
	}
	return req, nil
}

// createOrUpdateAtManagementGroupHandleResponse handles the CreateOrUpdateAtManagementGroup response.
func (client *VariablesClient) createOrUpdateAtManagementGroupHandleResponse(resp *http.Response) (VariablesClientCreateOrUpdateAtManagementGroupResponse, error) {
	result := VariablesClientCreateOrUpdateAtManagementGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Variable); err != nil {
		return VariablesClientCreateOrUpdateAtManagementGroupResponse{}, err
	}
	return result, nil
}

// Delete - This operation deletes a variable, given its name and the subscription it was created in. The scope of a variable
// is the part of its ID preceding
// '/providers/Microsoft.Authorization/variables/{variableName}'.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - variableName - The name of the variable to operate on.
//   - options - VariablesClientDeleteOptions contains the optional parameters for the VariablesClient.Delete method.
func (client *VariablesClient) Delete(ctx context.Context, variableName string, options *VariablesClientDeleteOptions) (VariablesClientDeleteResponse, error) {
	var err error
	const operationName = "VariablesClient.Delete"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteCreateRequest(ctx, variableName, options)
	if err != nil {
		return VariablesClientDeleteResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VariablesClientDeleteResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return VariablesClientDeleteResponse{}, err
	}
	return VariablesClientDeleteResponse{}, nil
}

// deleteCreateRequest creates the Delete request.
func (client *VariablesClient) deleteCreateRequest(ctx context.Context, variableName string, options *VariablesClientDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/variables/{variableName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if variableName == "" {
		return nil, errors.New("parameter variableName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{variableName}", url.PathEscape(variableName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// DeleteAtManagementGroup - This operation deletes a variable, given its name and the management group it was created in.
// The scope of a variable is the part of its ID preceding
// '/providers/Microsoft.Authorization/variables/{variableName}'.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - managementGroupID - The ID of the management group.
//   - variableName - The name of the variable to operate on.
//   - options - VariablesClientDeleteAtManagementGroupOptions contains the optional parameters for the VariablesClient.DeleteAtManagementGroup
//     method.
func (client *VariablesClient) DeleteAtManagementGroup(ctx context.Context, managementGroupID string, variableName string, options *VariablesClientDeleteAtManagementGroupOptions) (VariablesClientDeleteAtManagementGroupResponse, error) {
	var err error
	const operationName = "VariablesClient.DeleteAtManagementGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.deleteAtManagementGroupCreateRequest(ctx, managementGroupID, variableName, options)
	if err != nil {
		return VariablesClientDeleteAtManagementGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VariablesClientDeleteAtManagementGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK, http.StatusNoContent) {
		err = runtime.NewResponseError(httpResp)
		return VariablesClientDeleteAtManagementGroupResponse{}, err
	}
	return VariablesClientDeleteAtManagementGroupResponse{}, nil
}

// deleteAtManagementGroupCreateRequest creates the DeleteAtManagementGroup request.
func (client *VariablesClient) deleteAtManagementGroupCreateRequest(ctx context.Context, managementGroupID string, variableName string, options *VariablesClientDeleteAtManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/variables/{variableName}"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if variableName == "" {
		return nil, errors.New("parameter variableName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{variableName}", url.PathEscape(variableName))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// Get - This operation retrieves a single variable, given its name and the subscription it was created at.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - variableName - The name of the variable to operate on.
//   - options - VariablesClientGetOptions contains the optional parameters for the VariablesClient.Get method.
func (client *VariablesClient) Get(ctx context.Context, variableName string, options *VariablesClientGetOptions) (VariablesClientGetResponse, error) {
	var err error
	const operationName = "VariablesClient.Get"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getCreateRequest(ctx, variableName, options)
	if err != nil {
		return VariablesClientGetResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VariablesClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return VariablesClientGetResponse{}, err
	}
	resp, err := client.getHandleResponse(httpResp)
	return resp, err
}

// getCreateRequest creates the Get request.
func (client *VariablesClient) getCreateRequest(ctx context.Context, variableName string, options *VariablesClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/variables/{variableName}"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	if variableName == "" {
		return nil, errors.New("parameter variableName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{variableName}", url.PathEscape(variableName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *VariablesClient) getHandleResponse(resp *http.Response) (VariablesClientGetResponse, error) {
	result := VariablesClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Variable); err != nil {
		return VariablesClientGetResponse{}, err
	}
	return result, nil
}

// GetAtManagementGroup - This operation retrieves a single variable, given its name and the management group it was created
// at.
// If the operation fails it returns an *azcore.ResponseError type.
//
// Generated from API version 2022-08-01-preview
//   - managementGroupID - The ID of the management group.
//   - variableName - The name of the variable to operate on.
//   - options - VariablesClientGetAtManagementGroupOptions contains the optional parameters for the VariablesClient.GetAtManagementGroup
//     method.
func (client *VariablesClient) GetAtManagementGroup(ctx context.Context, managementGroupID string, variableName string, options *VariablesClientGetAtManagementGroupOptions) (VariablesClientGetAtManagementGroupResponse, error) {
	var err error
	const operationName = "VariablesClient.GetAtManagementGroup"
	ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, operationName)
	ctx, endSpan := runtime.StartSpan(ctx, operationName, client.internal.Tracer(), nil)
	defer func() { endSpan(err) }()
	req, err := client.getAtManagementGroupCreateRequest(ctx, managementGroupID, variableName, options)
	if err != nil {
		return VariablesClientGetAtManagementGroupResponse{}, err
	}
	httpResp, err := client.internal.Pipeline().Do(req)
	if err != nil {
		return VariablesClientGetAtManagementGroupResponse{}, err
	}
	if !runtime.HasStatusCode(httpResp, http.StatusOK) {
		err = runtime.NewResponseError(httpResp)
		return VariablesClientGetAtManagementGroupResponse{}, err
	}
	resp, err := client.getAtManagementGroupHandleResponse(httpResp)
	return resp, err
}

// getAtManagementGroupCreateRequest creates the GetAtManagementGroup request.
func (client *VariablesClient) getAtManagementGroupCreateRequest(ctx context.Context, managementGroupID string, variableName string, options *VariablesClientGetAtManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/variables/{variableName}"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	if variableName == "" {
		return nil, errors.New("parameter variableName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{variableName}", url.PathEscape(variableName))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getAtManagementGroupHandleResponse handles the GetAtManagementGroup response.
func (client *VariablesClient) getAtManagementGroupHandleResponse(resp *http.Response) (VariablesClientGetAtManagementGroupResponse, error) {
	result := VariablesClientGetAtManagementGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.Variable); err != nil {
		return VariablesClientGetAtManagementGroupResponse{}, err
	}
	return result, nil
}

// NewListPager - This operation retrieves the list of all variables associated with the given subscription.
//
// Generated from API version 2022-08-01-preview
//   - options - VariablesClientListOptions contains the optional parameters for the VariablesClient.NewListPager method.
func (client *VariablesClient) NewListPager(options *VariablesClientListOptions) *runtime.Pager[VariablesClientListResponse] {
	return runtime.NewPager(runtime.PagingHandler[VariablesClientListResponse]{
		More: func(page VariablesClientListResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *VariablesClientListResponse) (VariablesClientListResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "VariablesClient.NewListPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listCreateRequest(ctx, options)
			}, nil)
			if err != nil {
				return VariablesClientListResponse{}, err
			}
			return client.listHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listCreateRequest creates the List request.
func (client *VariablesClient) listCreateRequest(ctx context.Context, options *VariablesClientListOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/variables"
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listHandleResponse handles the List response.
func (client *VariablesClient) listHandleResponse(resp *http.Response) (VariablesClientListResponse, error) {
	result := VariablesClientListResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VariableListResult); err != nil {
		return VariablesClientListResponse{}, err
	}
	return result, nil
}

// NewListForManagementGroupPager - This operation retrieves the list of all variables applicable to the management group.
//
// Generated from API version 2022-08-01-preview
//   - managementGroupID - The ID of the management group.
//   - options - VariablesClientListForManagementGroupOptions contains the optional parameters for the VariablesClient.NewListForManagementGroupPager
//     method.
func (client *VariablesClient) NewListForManagementGroupPager(managementGroupID string, options *VariablesClientListForManagementGroupOptions) *runtime.Pager[VariablesClientListForManagementGroupResponse] {
	return runtime.NewPager(runtime.PagingHandler[VariablesClientListForManagementGroupResponse]{
		More: func(page VariablesClientListForManagementGroupResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *VariablesClientListForManagementGroupResponse) (VariablesClientListForManagementGroupResponse, error) {
			ctx = context.WithValue(ctx, runtime.CtxAPINameKey{}, "VariablesClient.NewListForManagementGroupPager")
			nextLink := ""
			if page != nil {
				nextLink = *page.NextLink
			}
			resp, err := runtime.FetcherForNextLink(ctx, client.internal.Pipeline(), nextLink, func(ctx context.Context) (*policy.Request, error) {
				return client.listForManagementGroupCreateRequest(ctx, managementGroupID, options)
			}, nil)
			if err != nil {
				return VariablesClientListForManagementGroupResponse{}, err
			}
			return client.listForManagementGroupHandleResponse(resp)
		},
		Tracer: client.internal.Tracer(),
	})
}

// listForManagementGroupCreateRequest creates the ListForManagementGroup request.
func (client *VariablesClient) listForManagementGroupCreateRequest(ctx context.Context, managementGroupID string, options *VariablesClientListForManagementGroupOptions) (*policy.Request, error) {
	urlPath := "/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/variables"
	if managementGroupID == "" {
		return nil, errors.New("parameter managementGroupID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{managementGroupId}", url.PathEscape(managementGroupID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.internal.Endpoint(), urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2022-08-01-preview")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listForManagementGroupHandleResponse handles the ListForManagementGroup response.
func (client *VariablesClient) listForManagementGroupHandleResponse(resp *http.Response) (VariablesClientListForManagementGroupResponse, error) {
	result := VariablesClientListForManagementGroupResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.VariableListResult); err != nil {
		return VariablesClientListForManagementGroupResponse{}, err
	}
	return result, nil
}
