//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// AlertsServer is a fake server for instances of the armsecurity.AlertsClient type.
type AlertsServer struct {
	// GetResourceGroupLevel is the fake for method AlertsClient.GetResourceGroupLevel
	// HTTP status codes to indicate success: http.StatusOK
	GetResourceGroupLevel func(ctx context.Context, resourceGroupName string, ascLocation string, alertName string, options *armsecurity.AlertsClientGetResourceGroupLevelOptions) (resp azfake.Responder[armsecurity.AlertsClientGetResourceGroupLevelResponse], errResp azfake.ErrorResponder)

	// GetSubscriptionLevel is the fake for method AlertsClient.GetSubscriptionLevel
	// HTTP status codes to indicate success: http.StatusOK
	GetSubscriptionLevel func(ctx context.Context, ascLocation string, alertName string, options *armsecurity.AlertsClientGetSubscriptionLevelOptions) (resp azfake.Responder[armsecurity.AlertsClientGetSubscriptionLevelResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method AlertsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armsecurity.AlertsClientListOptions) (resp azfake.PagerResponder[armsecurity.AlertsClientListResponse])

	// NewListByResourceGroupPager is the fake for method AlertsClient.NewListByResourceGroupPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByResourceGroupPager func(resourceGroupName string, options *armsecurity.AlertsClientListByResourceGroupOptions) (resp azfake.PagerResponder[armsecurity.AlertsClientListByResourceGroupResponse])

	// NewListResourceGroupLevelByRegionPager is the fake for method AlertsClient.NewListResourceGroupLevelByRegionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListResourceGroupLevelByRegionPager func(ascLocation string, resourceGroupName string, options *armsecurity.AlertsClientListResourceGroupLevelByRegionOptions) (resp azfake.PagerResponder[armsecurity.AlertsClientListResourceGroupLevelByRegionResponse])

	// NewListSubscriptionLevelByRegionPager is the fake for method AlertsClient.NewListSubscriptionLevelByRegionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListSubscriptionLevelByRegionPager func(ascLocation string, options *armsecurity.AlertsClientListSubscriptionLevelByRegionOptions) (resp azfake.PagerResponder[armsecurity.AlertsClientListSubscriptionLevelByRegionResponse])

	// BeginSimulate is the fake for method AlertsClient.BeginSimulate
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginSimulate func(ctx context.Context, ascLocation string, alertSimulatorRequestBody armsecurity.AlertSimulatorRequestBody, options *armsecurity.AlertsClientBeginSimulateOptions) (resp azfake.PollerResponder[armsecurity.AlertsClientSimulateResponse], errResp azfake.ErrorResponder)

	// UpdateResourceGroupLevelStateToActivate is the fake for method AlertsClient.UpdateResourceGroupLevelStateToActivate
	// HTTP status codes to indicate success: http.StatusNoContent
	UpdateResourceGroupLevelStateToActivate func(ctx context.Context, resourceGroupName string, ascLocation string, alertName string, options *armsecurity.AlertsClientUpdateResourceGroupLevelStateToActivateOptions) (resp azfake.Responder[armsecurity.AlertsClientUpdateResourceGroupLevelStateToActivateResponse], errResp azfake.ErrorResponder)

	// UpdateResourceGroupLevelStateToDismiss is the fake for method AlertsClient.UpdateResourceGroupLevelStateToDismiss
	// HTTP status codes to indicate success: http.StatusNoContent
	UpdateResourceGroupLevelStateToDismiss func(ctx context.Context, resourceGroupName string, ascLocation string, alertName string, options *armsecurity.AlertsClientUpdateResourceGroupLevelStateToDismissOptions) (resp azfake.Responder[armsecurity.AlertsClientUpdateResourceGroupLevelStateToDismissResponse], errResp azfake.ErrorResponder)

	// UpdateResourceGroupLevelStateToInProgress is the fake for method AlertsClient.UpdateResourceGroupLevelStateToInProgress
	// HTTP status codes to indicate success: http.StatusNoContent
	UpdateResourceGroupLevelStateToInProgress func(ctx context.Context, resourceGroupName string, ascLocation string, alertName string, options *armsecurity.AlertsClientUpdateResourceGroupLevelStateToInProgressOptions) (resp azfake.Responder[armsecurity.AlertsClientUpdateResourceGroupLevelStateToInProgressResponse], errResp azfake.ErrorResponder)

	// UpdateResourceGroupLevelStateToResolve is the fake for method AlertsClient.UpdateResourceGroupLevelStateToResolve
	// HTTP status codes to indicate success: http.StatusNoContent
	UpdateResourceGroupLevelStateToResolve func(ctx context.Context, resourceGroupName string, ascLocation string, alertName string, options *armsecurity.AlertsClientUpdateResourceGroupLevelStateToResolveOptions) (resp azfake.Responder[armsecurity.AlertsClientUpdateResourceGroupLevelStateToResolveResponse], errResp azfake.ErrorResponder)

	// UpdateSubscriptionLevelStateToActivate is the fake for method AlertsClient.UpdateSubscriptionLevelStateToActivate
	// HTTP status codes to indicate success: http.StatusNoContent
	UpdateSubscriptionLevelStateToActivate func(ctx context.Context, ascLocation string, alertName string, options *armsecurity.AlertsClientUpdateSubscriptionLevelStateToActivateOptions) (resp azfake.Responder[armsecurity.AlertsClientUpdateSubscriptionLevelStateToActivateResponse], errResp azfake.ErrorResponder)

	// UpdateSubscriptionLevelStateToDismiss is the fake for method AlertsClient.UpdateSubscriptionLevelStateToDismiss
	// HTTP status codes to indicate success: http.StatusNoContent
	UpdateSubscriptionLevelStateToDismiss func(ctx context.Context, ascLocation string, alertName string, options *armsecurity.AlertsClientUpdateSubscriptionLevelStateToDismissOptions) (resp azfake.Responder[armsecurity.AlertsClientUpdateSubscriptionLevelStateToDismissResponse], errResp azfake.ErrorResponder)

	// UpdateSubscriptionLevelStateToInProgress is the fake for method AlertsClient.UpdateSubscriptionLevelStateToInProgress
	// HTTP status codes to indicate success: http.StatusNoContent
	UpdateSubscriptionLevelStateToInProgress func(ctx context.Context, ascLocation string, alertName string, options *armsecurity.AlertsClientUpdateSubscriptionLevelStateToInProgressOptions) (resp azfake.Responder[armsecurity.AlertsClientUpdateSubscriptionLevelStateToInProgressResponse], errResp azfake.ErrorResponder)

	// UpdateSubscriptionLevelStateToResolve is the fake for method AlertsClient.UpdateSubscriptionLevelStateToResolve
	// HTTP status codes to indicate success: http.StatusNoContent
	UpdateSubscriptionLevelStateToResolve func(ctx context.Context, ascLocation string, alertName string, options *armsecurity.AlertsClientUpdateSubscriptionLevelStateToResolveOptions) (resp azfake.Responder[armsecurity.AlertsClientUpdateSubscriptionLevelStateToResolveResponse], errResp azfake.ErrorResponder)
}

// NewAlertsServerTransport creates a new instance of AlertsServerTransport with the provided implementation.
// The returned AlertsServerTransport instance is connected to an instance of armsecurity.AlertsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewAlertsServerTransport(srv *AlertsServer) *AlertsServerTransport {
	return &AlertsServerTransport{
		srv:                                    srv,
		newListPager:                           newTracker[azfake.PagerResponder[armsecurity.AlertsClientListResponse]](),
		newListByResourceGroupPager:            newTracker[azfake.PagerResponder[armsecurity.AlertsClientListByResourceGroupResponse]](),
		newListResourceGroupLevelByRegionPager: newTracker[azfake.PagerResponder[armsecurity.AlertsClientListResourceGroupLevelByRegionResponse]](),
		newListSubscriptionLevelByRegionPager:  newTracker[azfake.PagerResponder[armsecurity.AlertsClientListSubscriptionLevelByRegionResponse]](),
		beginSimulate:                          newTracker[azfake.PollerResponder[armsecurity.AlertsClientSimulateResponse]](),
	}
}

// AlertsServerTransport connects instances of armsecurity.AlertsClient to instances of AlertsServer.
// Don't use this type directly, use NewAlertsServerTransport instead.
type AlertsServerTransport struct {
	srv                                    *AlertsServer
	newListPager                           *tracker[azfake.PagerResponder[armsecurity.AlertsClientListResponse]]
	newListByResourceGroupPager            *tracker[azfake.PagerResponder[armsecurity.AlertsClientListByResourceGroupResponse]]
	newListResourceGroupLevelByRegionPager *tracker[azfake.PagerResponder[armsecurity.AlertsClientListResourceGroupLevelByRegionResponse]]
	newListSubscriptionLevelByRegionPager  *tracker[azfake.PagerResponder[armsecurity.AlertsClientListSubscriptionLevelByRegionResponse]]
	beginSimulate                          *tracker[azfake.PollerResponder[armsecurity.AlertsClientSimulateResponse]]
}

// Do implements the policy.Transporter interface for AlertsServerTransport.
func (a *AlertsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "AlertsClient.GetResourceGroupLevel":
		resp, err = a.dispatchGetResourceGroupLevel(req)
	case "AlertsClient.GetSubscriptionLevel":
		resp, err = a.dispatchGetSubscriptionLevel(req)
	case "AlertsClient.NewListPager":
		resp, err = a.dispatchNewListPager(req)
	case "AlertsClient.NewListByResourceGroupPager":
		resp, err = a.dispatchNewListByResourceGroupPager(req)
	case "AlertsClient.NewListResourceGroupLevelByRegionPager":
		resp, err = a.dispatchNewListResourceGroupLevelByRegionPager(req)
	case "AlertsClient.NewListSubscriptionLevelByRegionPager":
		resp, err = a.dispatchNewListSubscriptionLevelByRegionPager(req)
	case "AlertsClient.BeginSimulate":
		resp, err = a.dispatchBeginSimulate(req)
	case "AlertsClient.UpdateResourceGroupLevelStateToActivate":
		resp, err = a.dispatchUpdateResourceGroupLevelStateToActivate(req)
	case "AlertsClient.UpdateResourceGroupLevelStateToDismiss":
		resp, err = a.dispatchUpdateResourceGroupLevelStateToDismiss(req)
	case "AlertsClient.UpdateResourceGroupLevelStateToInProgress":
		resp, err = a.dispatchUpdateResourceGroupLevelStateToInProgress(req)
	case "AlertsClient.UpdateResourceGroupLevelStateToResolve":
		resp, err = a.dispatchUpdateResourceGroupLevelStateToResolve(req)
	case "AlertsClient.UpdateSubscriptionLevelStateToActivate":
		resp, err = a.dispatchUpdateSubscriptionLevelStateToActivate(req)
	case "AlertsClient.UpdateSubscriptionLevelStateToDismiss":
		resp, err = a.dispatchUpdateSubscriptionLevelStateToDismiss(req)
	case "AlertsClient.UpdateSubscriptionLevelStateToInProgress":
		resp, err = a.dispatchUpdateSubscriptionLevelStateToInProgress(req)
	case "AlertsClient.UpdateSubscriptionLevelStateToResolve":
		resp, err = a.dispatchUpdateSubscriptionLevelStateToResolve(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (a *AlertsServerTransport) dispatchGetResourceGroupLevel(req *http.Request) (*http.Response, error) {
	if a.srv.GetResourceGroupLevel == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetResourceGroupLevel not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/alerts/(?P<alertName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	alertNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.GetResourceGroupLevel(req.Context(), resourceGroupNameParam, ascLocationParam, alertNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Alert, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AlertsServerTransport) dispatchGetSubscriptionLevel(req *http.Request) (*http.Response, error) {
	if a.srv.GetSubscriptionLevel == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetSubscriptionLevel not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/alerts/(?P<alertName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	alertNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.GetSubscriptionLevel(req.Context(), ascLocationParam, alertNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Alert, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AlertsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := a.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/alerts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := a.srv.NewListPager(nil)
		newListPager = &resp
		a.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsecurity.AlertsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		a.newListPager.remove(req)
	}
	return resp, nil
}

func (a *AlertsServerTransport) dispatchNewListByResourceGroupPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListByResourceGroupPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByResourceGroupPager not implemented")}
	}
	newListByResourceGroupPager := a.newListByResourceGroupPager.get(req)
	if newListByResourceGroupPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/alerts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListByResourceGroupPager(resourceGroupNameParam, nil)
		newListByResourceGroupPager = &resp
		a.newListByResourceGroupPager.add(req, newListByResourceGroupPager)
		server.PagerResponderInjectNextLinks(newListByResourceGroupPager, req, func(page *armsecurity.AlertsClientListByResourceGroupResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByResourceGroupPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListByResourceGroupPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByResourceGroupPager) {
		a.newListByResourceGroupPager.remove(req)
	}
	return resp, nil
}

func (a *AlertsServerTransport) dispatchNewListResourceGroupLevelByRegionPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListResourceGroupLevelByRegionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListResourceGroupLevelByRegionPager not implemented")}
	}
	newListResourceGroupLevelByRegionPager := a.newListResourceGroupLevelByRegionPager.get(req)
	if newListResourceGroupLevelByRegionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/alerts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListResourceGroupLevelByRegionPager(ascLocationParam, resourceGroupNameParam, nil)
		newListResourceGroupLevelByRegionPager = &resp
		a.newListResourceGroupLevelByRegionPager.add(req, newListResourceGroupLevelByRegionPager)
		server.PagerResponderInjectNextLinks(newListResourceGroupLevelByRegionPager, req, func(page *armsecurity.AlertsClientListResourceGroupLevelByRegionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListResourceGroupLevelByRegionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListResourceGroupLevelByRegionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListResourceGroupLevelByRegionPager) {
		a.newListResourceGroupLevelByRegionPager.remove(req)
	}
	return resp, nil
}

func (a *AlertsServerTransport) dispatchNewListSubscriptionLevelByRegionPager(req *http.Request) (*http.Response, error) {
	if a.srv.NewListSubscriptionLevelByRegionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListSubscriptionLevelByRegionPager not implemented")}
	}
	newListSubscriptionLevelByRegionPager := a.newListSubscriptionLevelByRegionPager.get(req)
	if newListSubscriptionLevelByRegionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/alerts`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
		if err != nil {
			return nil, err
		}
		resp := a.srv.NewListSubscriptionLevelByRegionPager(ascLocationParam, nil)
		newListSubscriptionLevelByRegionPager = &resp
		a.newListSubscriptionLevelByRegionPager.add(req, newListSubscriptionLevelByRegionPager)
		server.PagerResponderInjectNextLinks(newListSubscriptionLevelByRegionPager, req, func(page *armsecurity.AlertsClientListSubscriptionLevelByRegionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListSubscriptionLevelByRegionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		a.newListSubscriptionLevelByRegionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListSubscriptionLevelByRegionPager) {
		a.newListSubscriptionLevelByRegionPager.remove(req)
	}
	return resp, nil
}

func (a *AlertsServerTransport) dispatchBeginSimulate(req *http.Request) (*http.Response, error) {
	if a.srv.BeginSimulate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginSimulate not implemented")}
	}
	beginSimulate := a.beginSimulate.get(req)
	if beginSimulate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/alerts/default/simulate`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armsecurity.AlertSimulatorRequestBody](req)
		if err != nil {
			return nil, err
		}
		ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := a.srv.BeginSimulate(req.Context(), ascLocationParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginSimulate = &respr
		a.beginSimulate.add(req, beginSimulate)
	}

	resp, err := server.PollerResponderNext(beginSimulate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		a.beginSimulate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginSimulate) {
		a.beginSimulate.remove(req)
	}

	return resp, nil
}

func (a *AlertsServerTransport) dispatchUpdateResourceGroupLevelStateToActivate(req *http.Request) (*http.Response, error) {
	if a.srv.UpdateResourceGroupLevelStateToActivate == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateResourceGroupLevelStateToActivate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/alerts/(?P<alertName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/activate`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	alertNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.UpdateResourceGroupLevelStateToActivate(req.Context(), resourceGroupNameParam, ascLocationParam, alertNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AlertsServerTransport) dispatchUpdateResourceGroupLevelStateToDismiss(req *http.Request) (*http.Response, error) {
	if a.srv.UpdateResourceGroupLevelStateToDismiss == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateResourceGroupLevelStateToDismiss not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/alerts/(?P<alertName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dismiss`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	alertNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.UpdateResourceGroupLevelStateToDismiss(req.Context(), resourceGroupNameParam, ascLocationParam, alertNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AlertsServerTransport) dispatchUpdateResourceGroupLevelStateToInProgress(req *http.Request) (*http.Response, error) {
	if a.srv.UpdateResourceGroupLevelStateToInProgress == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateResourceGroupLevelStateToInProgress not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/alerts/(?P<alertName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inProgress`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	alertNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.UpdateResourceGroupLevelStateToInProgress(req.Context(), resourceGroupNameParam, ascLocationParam, alertNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AlertsServerTransport) dispatchUpdateResourceGroupLevelStateToResolve(req *http.Request) (*http.Response, error) {
	if a.srv.UpdateResourceGroupLevelStateToResolve == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateResourceGroupLevelStateToResolve not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/alerts/(?P<alertName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resolve`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	alertNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.UpdateResourceGroupLevelStateToResolve(req.Context(), resourceGroupNameParam, ascLocationParam, alertNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AlertsServerTransport) dispatchUpdateSubscriptionLevelStateToActivate(req *http.Request) (*http.Response, error) {
	if a.srv.UpdateSubscriptionLevelStateToActivate == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateSubscriptionLevelStateToActivate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/alerts/(?P<alertName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/activate`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	alertNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.UpdateSubscriptionLevelStateToActivate(req.Context(), ascLocationParam, alertNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AlertsServerTransport) dispatchUpdateSubscriptionLevelStateToDismiss(req *http.Request) (*http.Response, error) {
	if a.srv.UpdateSubscriptionLevelStateToDismiss == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateSubscriptionLevelStateToDismiss not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/alerts/(?P<alertName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/dismiss`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	alertNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.UpdateSubscriptionLevelStateToDismiss(req.Context(), ascLocationParam, alertNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AlertsServerTransport) dispatchUpdateSubscriptionLevelStateToInProgress(req *http.Request) (*http.Response, error) {
	if a.srv.UpdateSubscriptionLevelStateToInProgress == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateSubscriptionLevelStateToInProgress not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/alerts/(?P<alertName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/inProgress`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	alertNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.UpdateSubscriptionLevelStateToInProgress(req.Context(), ascLocationParam, alertNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (a *AlertsServerTransport) dispatchUpdateSubscriptionLevelStateToResolve(req *http.Request) (*http.Response, error) {
	if a.srv.UpdateSubscriptionLevelStateToResolve == nil {
		return nil, &nonRetriableError{errors.New("fake for method UpdateSubscriptionLevelStateToResolve not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/locations/(?P<ascLocation>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/alerts/(?P<alertName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resolve`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	ascLocationParam, err := url.PathUnescape(matches[regex.SubexpIndex("ascLocation")])
	if err != nil {
		return nil, err
	}
	alertNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("alertName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := a.srv.UpdateSubscriptionLevelStateToResolve(req.Context(), ascLocationParam, alertNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusNoContent}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusNoContent", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
