//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"net/url"
	"regexp"
)

// ServerVulnerabilityAssessmentServer is a fake server for instances of the armsecurity.ServerVulnerabilityAssessmentClient type.
type ServerVulnerabilityAssessmentServer struct {
	// CreateOrUpdate is the fake for method ServerVulnerabilityAssessmentClient.CreateOrUpdate
	// HTTP status codes to indicate success: http.StatusAccepted
	CreateOrUpdate func(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, options *armsecurity.ServerVulnerabilityAssessmentClientCreateOrUpdateOptions) (resp azfake.Responder[armsecurity.ServerVulnerabilityAssessmentClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ServerVulnerabilityAssessmentClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusOK, http.StatusAccepted, http.StatusNoContent
	BeginDelete func(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, options *armsecurity.ServerVulnerabilityAssessmentClientBeginDeleteOptions) (resp azfake.PollerResponder[armsecurity.ServerVulnerabilityAssessmentClientDeleteResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ServerVulnerabilityAssessmentClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, options *armsecurity.ServerVulnerabilityAssessmentClientGetOptions) (resp azfake.Responder[armsecurity.ServerVulnerabilityAssessmentClientGetResponse], errResp azfake.ErrorResponder)

	// ListByExtendedResource is the fake for method ServerVulnerabilityAssessmentClient.ListByExtendedResource
	// HTTP status codes to indicate success: http.StatusOK
	ListByExtendedResource func(ctx context.Context, resourceGroupName string, resourceNamespace string, resourceType string, resourceName string, options *armsecurity.ServerVulnerabilityAssessmentClientListByExtendedResourceOptions) (resp azfake.Responder[armsecurity.ServerVulnerabilityAssessmentClientListByExtendedResourceResponse], errResp azfake.ErrorResponder)
}

// NewServerVulnerabilityAssessmentServerTransport creates a new instance of ServerVulnerabilityAssessmentServerTransport with the provided implementation.
// The returned ServerVulnerabilityAssessmentServerTransport instance is connected to an instance of armsecurity.ServerVulnerabilityAssessmentClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewServerVulnerabilityAssessmentServerTransport(srv *ServerVulnerabilityAssessmentServer) *ServerVulnerabilityAssessmentServerTransport {
	return &ServerVulnerabilityAssessmentServerTransport{
		srv:         srv,
		beginDelete: newTracker[azfake.PollerResponder[armsecurity.ServerVulnerabilityAssessmentClientDeleteResponse]](),
	}
}

// ServerVulnerabilityAssessmentServerTransport connects instances of armsecurity.ServerVulnerabilityAssessmentClient to instances of ServerVulnerabilityAssessmentServer.
// Don't use this type directly, use NewServerVulnerabilityAssessmentServerTransport instead.
type ServerVulnerabilityAssessmentServerTransport struct {
	srv         *ServerVulnerabilityAssessmentServer
	beginDelete *tracker[azfake.PollerResponder[armsecurity.ServerVulnerabilityAssessmentClientDeleteResponse]]
}

// Do implements the policy.Transporter interface for ServerVulnerabilityAssessmentServerTransport.
func (s *ServerVulnerabilityAssessmentServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ServerVulnerabilityAssessmentClient.CreateOrUpdate":
		resp, err = s.dispatchCreateOrUpdate(req)
	case "ServerVulnerabilityAssessmentClient.BeginDelete":
		resp, err = s.dispatchBeginDelete(req)
	case "ServerVulnerabilityAssessmentClient.Get":
		resp, err = s.dispatchGet(req)
	case "ServerVulnerabilityAssessmentClient.ListByExtendedResource":
		resp, err = s.dispatchListByExtendedResource(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *ServerVulnerabilityAssessmentServerTransport) dispatchCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.CreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method CreateOrUpdate not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<resourceNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/serverVulnerabilityAssessments/(?P<serverVulnerabilityAssessment>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceNamespace")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.CreateOrUpdate(req.Context(), resourceGroupNameParam, resourceNamespaceParam, resourceTypeParam, resourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusAccepted}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ServerVulnerabilityAssessment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerVulnerabilityAssessmentServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if s.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := s.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<resourceNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/serverVulnerabilityAssessments/(?P<serverVulnerabilityAssessment>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 5 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		resourceNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceNamespace")])
		if err != nil {
			return nil, err
		}
		resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
		if err != nil {
			return nil, err
		}
		resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := s.srv.BeginDelete(req.Context(), resourceGroupNameParam, resourceNamespaceParam, resourceTypeParam, resourceNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		s.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusAccepted, http.StatusNoContent}, resp.StatusCode) {
		s.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusAccepted, http.StatusNoContent", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		s.beginDelete.remove(req)
	}

	return resp, nil
}

func (s *ServerVulnerabilityAssessmentServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if s.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<resourceNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/serverVulnerabilityAssessments/(?P<serverVulnerabilityAssessment>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceNamespace")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Get(req.Context(), resourceGroupNameParam, resourceNamespaceParam, resourceTypeParam, resourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ServerVulnerabilityAssessment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (s *ServerVulnerabilityAssessmentServerTransport) dispatchListByExtendedResource(req *http.Request) (*http.Response, error) {
	if s.srv.ListByExtendedResource == nil {
		return nil, &nonRetriableError{errors.New("fake for method ListByExtendedResource not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/(?P<resourceNamespace>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceType>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/(?P<resourceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/serverVulnerabilityAssessments`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 5 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	resourceNamespaceParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceNamespace")])
	if err != nil {
		return nil, err
	}
	resourceTypeParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceType")])
	if err != nil {
		return nil, err
	}
	resourceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.ListByExtendedResource(req.Context(), resourceGroupNameParam, resourceNamespaceParam, resourceTypeParam, resourceNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ServerVulnerabilityAssessmentsList, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
