//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/synapse/armsynapse"
	"net/http"
	"net/url"
	"regexp"
)

// SQLPoolRecommendedSensitivityLabelsServer is a fake server for instances of the armsynapse.SQLPoolRecommendedSensitivityLabelsClient type.
type SQLPoolRecommendedSensitivityLabelsServer struct {
	// Update is the fake for method SQLPoolRecommendedSensitivityLabelsClient.Update
	// HTTP status codes to indicate success: http.StatusOK
	Update func(ctx context.Context, resourceGroupName string, workspaceName string, sqlPoolName string, parameters armsynapse.RecommendedSensitivityLabelUpdateList, options *armsynapse.SQLPoolRecommendedSensitivityLabelsClientUpdateOptions) (resp azfake.Responder[armsynapse.SQLPoolRecommendedSensitivityLabelsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewSQLPoolRecommendedSensitivityLabelsServerTransport creates a new instance of SQLPoolRecommendedSensitivityLabelsServerTransport with the provided implementation.
// The returned SQLPoolRecommendedSensitivityLabelsServerTransport instance is connected to an instance of armsynapse.SQLPoolRecommendedSensitivityLabelsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSQLPoolRecommendedSensitivityLabelsServerTransport(srv *SQLPoolRecommendedSensitivityLabelsServer) *SQLPoolRecommendedSensitivityLabelsServerTransport {
	return &SQLPoolRecommendedSensitivityLabelsServerTransport{srv: srv}
}

// SQLPoolRecommendedSensitivityLabelsServerTransport connects instances of armsynapse.SQLPoolRecommendedSensitivityLabelsClient to instances of SQLPoolRecommendedSensitivityLabelsServer.
// Don't use this type directly, use NewSQLPoolRecommendedSensitivityLabelsServerTransport instead.
type SQLPoolRecommendedSensitivityLabelsServerTransport struct {
	srv *SQLPoolRecommendedSensitivityLabelsServer
}

// Do implements the policy.Transporter interface for SQLPoolRecommendedSensitivityLabelsServerTransport.
func (s *SQLPoolRecommendedSensitivityLabelsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SQLPoolRecommendedSensitivityLabelsClient.Update":
		resp, err = s.dispatchUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SQLPoolRecommendedSensitivityLabelsServerTransport) dispatchUpdate(req *http.Request) (*http.Response, error) {
	if s.srv.Update == nil {
		return nil, &nonRetriableError{errors.New("fake for method Update not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Synapse/workspaces/(?P<workspaceName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/sqlPools/(?P<sqlPoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/recommendedSensitivityLabels`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	body, err := server.UnmarshalRequestAsJSON[armsynapse.RecommendedSensitivityLabelUpdateList](req)
	if err != nil {
		return nil, err
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	workspaceNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("workspaceName")])
	if err != nil {
		return nil, err
	}
	sqlPoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("sqlPoolName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := s.srv.Update(req.Context(), resourceGroupNameParam, workspaceNameParam, sqlPoolNameParam, body, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.NewResponse(respContent, req, nil)
	if err != nil {
		return nil, err
	}
	return resp, nil
}
