/* $Id: Org_ref.hpp 607104 2020-04-30 12:36:14Z grichenk $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the ASN data definition file
 *   'seqfeat.asn'.
 */

#ifndef OBJECTS_SEQFEAT_ORG_REF_HPP
#define OBJECTS_SEQFEAT_ORG_REF_HPP


// generated includes
#include <objects/seqfeat/Org_ref_.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

class NCBI_SEQFEAT_EXPORT COrg_ref : public COrg_ref_Base
{
    typedef COrg_ref_Base Tparent;
public:
    enum EOrgref_part {
        eOrgref_nothing    = 0,
        eOrgref_taxname    = 0x0010, // org-ref.taxname
        eOrgref_common     = 0x0040, // org-ref.common
        eOrgref_mod        = 0x0800, // org-ref.mod

        eOrgref_db         = 0x2000, // org-ref.db
        eOrgref_db_taxid   = 0x0001, // org-ref.db[@dbtag='taxon']
        eOrgref_db_all     = (eOrgref_db | eOrgref_db_taxid),

        eOrgref_syn        = 0x4000, // org-ref.syn

        eOrgref_orgname    = 0x0008, // org-ref.orgname
        eOrgref_on_name    = 0x0080, // org-ref.orgname.name
          eOrgref_on_attr       = 0x1000, // org-ref.orgname.attrib
          eOrgref_on_attr_spec  = 0x00010000, // org-ref.orgname.attrib[.='specified']
          eOrgref_on_attr_nofwd = 0x00040000, // org-ref.orgname.attrib[.='nomodforward']
          eOrgref_on_attr_uncult= 0x00080000, // org-ref.orgname.attrib[.='uncultured']
          eOrgref_on_attr_all   = (eOrgref_on_attr | eOrgref_on_attr_spec | eOrgref_on_attr_nofwd | eOrgref_on_attr_uncult),
        eOrgref_on_mod     = 0x0200, // org-ref.orgname.mod
          eOrgref_on_mod_nom    = 0x00020000, // org-ref.orgname.mod[subtype=nomenclature]
          eOrgref_on_mod_oldname= 0x00100000, // org-ref.orgname.mod[subtype=old-name]
          eOrgref_on_mod_tm     = 0x00200000, // org-ref.orgname.mod[subtype=type-material]
	  eOrgref_on_mod_all    = (eOrgref_on_mod | eOrgref_on_mod_nom | eOrgref_on_mod_oldname | eOrgref_on_mod_tm),
        eOrgref_on_lin     = 0x0020, // org-ref.orgname.lineage
        eOrgref_on_gc      = 0x0002, // org-ref.orgname.gcode
        eOrgref_on_mgc     = 0x0004, // org-ref.orgname.mgcode
        eOrgref_on_pgc     = 0x0400, // org-ref.orgname.pgcode
        eOrgref_on_div     = 0x0100, // org-ref.orgname.div
        eOrgref_on_all     = (eOrgref_orgname | eOrgref_on_name | eOrgref_on_attr_all | eOrgref_on_mod_all |
                              eOrgref_on_lin | eOrgref_on_gc | eOrgref_on_mgc | eOrgref_on_pgc | eOrgref_on_div),

        eOrgref_all        = (eOrgref_taxname | eOrgref_common | eOrgref_mod | eOrgref_db_all | eOrgref_syn |
                              eOrgref_on_all),

        eOrgref_all_but_syn  = (eOrgref_all ^ eOrgref_syn), // all but synonyms
        eOrgref_all_but_spec = (eOrgref_all ^ eOrgref_on_attr_spec), // all but orgname's 'specified' attribute

        eOrgref_default    = eOrgref_all
    };
    typedef unsigned int fOrgref_parts;

    // constructor
    COrg_ref(void);
    // destructor
    ~COrg_ref(void);
    
    // Appends a label to "label" based on content
    void GetLabel(string* label) const;

    // Returns NCBI Taxonomy database id (AKA tax id)
    // if the latter is found in Org_ref; otherwise returns 0
    TTaxId GetTaxId() const;
    // Sets tax id into Org_ref contents.
    // Returns old value of tax id or 0 if it was not found
    TTaxId SetTaxId( TTaxId tax_id );

    // shortcut access to selected OrgName methods
    bool IsSetLineage(void) const;
    const string& GetLineage(void) const;
    
    bool IsSetGcode(void) const;
    int GetGcode(void) const;
    
    bool IsSetMgcode(void) const;
    int GetMgcode(void) const;
    
    bool IsSetPgcode(void) const;
    int GetPgcode(void) const;
    
    bool IsSetDivision(void) const;
    const string& GetDivision(void) const;
    
    bool IsSetOrgMod(void) const;

    bool IsVarietyValid(const string& variety) const;
    bool HasValidVariety() const;
    bool IsSubspeciesValid(const string& subspecies) const;

    CRef<COrg_ref> MakeCommon(const COrg_ref& other) const;
    
    static CConstRef<COrg_ref> TableLookup(const string& taxname);
    static const vector<string>& GetTaxnameList();
    bool UpdateFromTable();

    void CleanForGenBank();

    void FilterOutParts( fOrgref_parts to_remain );
private:
    // Prohibit copy constructor and assignment operator
    COrg_ref(const COrg_ref& value);
    COrg_ref& operator=(const COrg_ref& value);

    string x_GetTaxnameAfterFirstTwoWords() const;
};



/////////////////// COrg_ref inline methods

// constructor
inline
COrg_ref::COrg_ref(void)
{
}


/////////////////// end of COrg_ref inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE


#endif // OBJECTS_SEQFEAT_ORG_REF_HPP
/* Original file checksum: lines: 90, chars: 2371, CRC32: 49735a91 */
