# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.workloadorchestration import WorkloadOrchestrationMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestWorkloadOrchestrationMgmtSolutionVersionsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(WorkloadOrchestrationMgmtClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_solution_versions_get(self, resource_group):
        response = self.client.solution_versions.get(
            resource_group_name=resource_group.name,
            target_name="str",
            solution_name="str",
            solution_version_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_solution_versions_begin_create_or_update(self, resource_group):
        response = self.client.solution_versions.begin_create_or_update(
            resource_group_name=resource_group.name,
            target_name="str",
            solution_name="str",
            solution_version_name="str",
            resource={
                "eTag": "str",
                "extendedLocation": {"name": "str", "type": "str"},
                "id": "str",
                "name": "str",
                "properties": {
                    "specification": {"str": {}},
                    "actionType": "str",
                    "configuration": "str",
                    "errorDetails": {
                        "additionalInfo": [{"info": {}, "type": "str"}],
                        "code": "str",
                        "details": [...],
                        "message": "str",
                        "target": "str",
                    },
                    "externalValidationId": "str",
                    "latestActionTrackingUri": "str",
                    "provisioningState": "str",
                    "reviewId": "str",
                    "revision": 0,
                    "solutionDependencies": [
                        {
                            "solutionTemplateVersionId": "str",
                            "solutionVersionId": "str",
                            "targetId": "str",
                            "dependencies": [...],
                            "solutionInstanceName": "str",
                        }
                    ],
                    "solutionInstanceName": "str",
                    "solutionTemplateVersionId": "str",
                    "state": "str",
                    "targetDisplayName": "str",
                    "targetLevelConfiguration": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_solution_versions_begin_update(self, resource_group):
        response = self.client.solution_versions.begin_update(
            resource_group_name=resource_group.name,
            target_name="str",
            solution_name="str",
            solution_version_name="str",
            properties={
                "eTag": "str",
                "extendedLocation": {"name": "str", "type": "str"},
                "id": "str",
                "name": "str",
                "properties": {
                    "specification": {"str": {}},
                    "actionType": "str",
                    "configuration": "str",
                    "errorDetails": {
                        "additionalInfo": [{"info": {}, "type": "str"}],
                        "code": "str",
                        "details": [...],
                        "message": "str",
                        "target": "str",
                    },
                    "externalValidationId": "str",
                    "latestActionTrackingUri": "str",
                    "provisioningState": "str",
                    "reviewId": "str",
                    "revision": 0,
                    "solutionDependencies": [
                        {
                            "solutionTemplateVersionId": "str",
                            "solutionVersionId": "str",
                            "targetId": "str",
                            "dependencies": [...],
                            "solutionInstanceName": "str",
                        }
                    ],
                    "solutionInstanceName": "str",
                    "solutionTemplateVersionId": "str",
                    "state": "str",
                    "targetDisplayName": "str",
                    "targetLevelConfiguration": "str",
                },
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_solution_versions_begin_delete(self, resource_group):
        response = self.client.solution_versions.begin_delete(
            resource_group_name=resource_group.name,
            target_name="str",
            solution_name="str",
            solution_version_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_solution_versions_list_by_solution(self, resource_group):
        response = self.client.solution_versions.list_by_solution(
            resource_group_name=resource_group.name,
            target_name="str",
            solution_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
