% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbs.R
\name{verb-HEAD}
\alias{verb-HEAD}
\title{HTTP verb info: HEAD}
\description{
The HEAD method asks for a response identical to that of a GET request,
but without the response body.
}
\section{The HEAD method}{

The HEAD method is identical to GET except that the
server MUST NOT send a message body in the response (i.e., the
response terminates at the end of the header section).  The server
SHOULD send the same header fields in response to a HEAD request as
it would have sent if the request had been a GET, except that the
payload header fields MAY be omitted.  This method can
be used for obtaining metadata about the selected representation
without transferring the representation data and is often used for
testing hypertext links for validity, accessibility, and recent
modification.
}

\examples{
\dontrun{
x <- HttpClient$new(url = "https://hb.opencpu.org")
x$head()
}

}
\references{
\url{https://datatracker.ietf.org/doc/html/rfc7231#section-4.3.2}
}
\seealso{
\link{crul-package}

Other verbs: 
\code{\link{verb-DELETE}},
\code{\link{verb-GET}},
\code{\link{verb-PATCH}},
\code{\link{verb-POST}},
\code{\link{verb-PUT}}
}
\concept{verbs}
