% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Punits.r
\name{Punits}
\alias{Punits}
\title{Prepare units for Printing and Plotting}
\usage{
Punits(u, lower = TRUE, adds = TRUE, upfirst = FALSE, default = "")
}
\arguments{
\item{u}{a single string containing units of measurement}

\item{lower}{if \code{TRUE} set string to all lower case}

\item{adds}{if \code{TRUE} add trailing \code{"s"}}

\item{upfirst}{if \code{TRUE} set first character to upper case}

\item{default}{default units if \code{u} is empty}
}
\value{
a single character string
}
\description{
Takes a character variable containing units of measurement for a variable.
If it has zero length, a \code{""} string is return.  Otherwise, any trailing \code{"s"} is
removed if the string is longer than one character, and depending on the arguments,
the string is changed to lower case, \code{"s"} is added, and the first character is
changed to upper case.
}
\examples{
\dontrun{
Punits('Years')
}
}
\seealso{
\code{\link[Hmisc:units]{Hmisc::units()}}
}
