#### This error code is internal to the compiler and will not be emitted with normal Rust code.

The internal `rustc_allowed_through_unstable_modules` attribute must be used
on an item with a `stable` attribute.

Erroneous code example:

```compile_fail,E0789
// NOTE: both of these attributes are perma-unstable and should *never* be
//       used outside of the compiler and standard library.
#![feature(rustc_attrs)]
#![feature(staged_api)]
#![allow(internal_features)]

#![unstable(feature = "foo_module", reason = "...", issue = "123")]

#[rustc_allowed_through_unstable_modules = "deprecation message"]
// #[stable(feature = "foo", since = "1.0")]
struct Foo;
// ^^^ error: `rustc_allowed_through_unstable_modules` attribute must be
//            paired with a `stable` attribute
```

Typically when an item is marked with a `stable` attribute, the modules that
enclose the item must also be marked with `stable` attributes, otherwise the
item becomes *de facto* unstable. `#[rustc_allowed_through_unstable_modules]`
is a workaround which allows an item to "escape" its unstable parent modules.
This error occurs when an item is marked with
`#[rustc_allowed_through_unstable_modules]` but no supplementary `stable`
attribute exists. See [#99288](https://github.com/rust-lang/rust/pull/99288)
for an example of `#[rustc_allowed_through_unstable_modules]` in use.
