/* bug-221100.c

   If test_index is char, loses high bit when indexes table
   workaround is to use [(unsigned int) test_index]
 */
#include <testfwk.h>

#define ARRAY_SIZE  130

#if defined(__SDCC_pic16) || defined(__SDCC_pdk14) || defined(__SDCC_pdk15)
/* not enough pic16 / pdk14 data space, so put the array into the code memory */
const static unsigned int
testArray[ARRAY_SIZE] = {
    0,   1,   2,   3,   4,   5,   6,   7,   8,   9,
   10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
   20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
   30,  31,  32,  33,  34,  35,  36,  37,  38,  39,
   40,  41,  42,  43,  44,  45,  46,  47,  48,  49,
   50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
   60,  61,  62,  63,  64,  65,  66,  67,  68,  69,
   70,  71,  72,  73,  74,  75,  76,  77,  78,  79,
   80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
   90,  91,  92,  93,  94,  95,  96,  97,  98,  99,
  100, 101, 102, 103, 104, 105, 106, 107, 108, 109,
  110, 111, 112, 113, 114, 115, 116, 117, 118, 119,
  120, 121, 122, 123, 124, 125, 126, 127, 128, 129,
};
#else
__xdata static unsigned int
testArray[ARRAY_SIZE];
#endif


static unsigned int test_int;
static unsigned char test_index;

static void
fetch (void)
{
  test_int = testArray [test_index];
}

static void
testUnsignedCharIndex (void)
{
#if !defined(__SDCC_pic16) && !defined(__SDCC_pdk14) && !defined(__SDCC_pdk15)
  int i;
  for (i = 0; i < 130; i++) {
    testArray[i] = i;
  }
#endif

  test_index = 5;
  fetch ();
  ASSERT (test_int == 5);

  test_index = 129;
  fetch ();
  ASSERT (test_int == 129);
}
