/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/

#ifndef KRD_H
#define KRD_H

#include <QtCore/QObject>
#include <QtCore/QByteArray>
#include <QtCore/QList>
#include <QtCore/QMap>
#include <QtCore/QString>
#include <QtCore/QStringList>
#include <QtCore/QVariant>
#include <QtDBus/QtDBus>

typedef QList<QVariantMap> ClientInfo;
Q_DECLARE_METATYPE(ClientInfo)

/*
 * Proxy class for interface com.kylin.RemoteDesktop
 */
class ComKylinRemoteDesktopInterface: public QDBusAbstractInterface
{
    Q_OBJECT
public:
    static inline const char *staticInterfaceName()
    { return "com.kylin.RemoteDesktop"; }

public:
    ComKylinRemoteDesktopInterface(const QString &service, const QString &path, const QDBusConnection &connection, QObject *parent = nullptr);

    ~ComKylinRemoteDesktopInterface();

    Q_PROPERTY(uint AllowedMaxClient READ allowedMaxClient WRITE setAllowedMaxClient)
    inline uint allowedMaxClient() const
    { return qvariant_cast< uint >(property("AllowedMaxClient")); }
    inline void setAllowedMaxClient(uint value)
    { setProperty("AllowedMaxClient", QVariant::fromValue(value)); }

    Q_PROPERTY(uchar AuthMethod READ authMethod WRITE setAuthMethod)
    inline uchar authMethod() const
    { return qvariant_cast< uchar >(property("AuthMethod")); }
    inline void setAuthMethod(uchar value)
    { setProperty("AuthMethod", QVariant::fromValue(value)); }

    Q_PROPERTY(ClientInfo ClientsInfo READ clientsInfo)
    inline ClientInfo clientsInfo() const
    { return qvariant_cast< ClientInfo >(property("ClientsInfo")); }

    Q_PROPERTY(bool ClipBoard READ clipBoard WRITE setClipBoard)
    inline bool clipBoard() const
    { return qvariant_cast< bool >(property("ClipBoard")); }
    inline void setClipBoard(bool value)
    { setProperty("ClipBoard", QVariant::fromValue(value)); }

    Q_PROPERTY(QString CurrrentOutput READ currrentOutput)
    inline QString currrentOutput() const
    { return qvariant_cast< QString >(property("CurrrentOutput")); }

    Q_PROPERTY(uint SupportedInputDevice READ supportedInputDevice WRITE setSupportedInputDevice)
    inline uint supportedInputDevice() const
    { return qvariant_cast< uint >(property("SupportedInputDevice")); }
    inline void setSupportedInputDevice(uint value)
    { setProperty("SupportedInputDevice", QVariant::fromValue(value)); }

    Q_PROPERTY(QStringList SupportedOutputDevice READ supportedOutputDevice)
    inline QStringList supportedOutputDevice() const
    { return qvariant_cast< QStringList >(property("SupportedOutputDevice")); }

    Q_PROPERTY(int WheelSpeed READ wheelSpeed WRITE setWheelSpeed)
    inline int wheelSpeed() const
    { return qvariant_cast< int >(property("WheelSpeed")); }
    inline void setWheelSpeed(int value)
    { setProperty("WheelSpeed", QVariant::fromValue(value)); }

public Q_SLOTS: // METHODS
    inline QDBusPendingReply<> CloseClient(int id)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(id);
        return asyncCallWithArgumentList(QStringLiteral("CloseClient"), argumentList);
    }

    inline QDBusPendingReply<> Exit()
    {
        QList<QVariant> argumentList;
        return asyncCallWithArgumentList(QStringLiteral("Exit"), argumentList);
    }

    inline QDBusPendingReply<int> SetPassword(const QString &passwd)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(passwd);
        return asyncCallWithArgumentList(QStringLiteral("SetPassword"), argumentList);
    }

    inline QDBusPendingReply<> SetViewOnly(int id, bool viewOnly)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(id) << QVariant::fromValue(viewOnly);
        return asyncCallWithArgumentList(QStringLiteral("SetViewOnly"), argumentList);
    }

    inline QDBusPendingReply<int> Start(const QString &output)
    {
        QList<QVariant> argumentList;
        argumentList << QVariant::fromValue(output);
        return asyncCallWithArgumentList(QStringLiteral("Start"), argumentList);
    }

Q_SIGNALS: // SIGNALS
    void Changed(int type);
};

#endif
