/*
 * Decompiled with CFR 0.152.
 */
package rene.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import rene.gui.BasicIcon;
import rene.gui.CloseFrame;
import rene.gui.ColorIcon;
import rene.gui.Global;
import rene.gui.IconBarElement;
import rene.gui.IconBarListener;
import rene.gui.IconBarPanel;
import rene.gui.IconGroup;
import rene.gui.IconWithGif;
import rene.gui.MultipleIcon;
import rene.gui.MultipleStringIcon;
import rene.gui.MultipleToggleIcon;
import rene.gui.MyLabel;
import rene.gui.OnOffIcon;
import rene.gui.OverflowButton;
import rene.gui.Panel3D;
import rene.gui.PopupIcon;
import rene.gui.Separator;
import rene.gui.StateDisplay;
import rene.gui.ToggleIcon;

public class IconBar
extends Panel
implements KeyListener,
FocusListener,
IconBarListener {
    Vector Left = new Vector();
    Vector Right = new Vector();
    int W;
    Frame F;
    public final int Offset = 2;
    public String Resource = "/";
    int Focus = 0;
    public boolean TraverseFocus = true;
    public boolean UseSize = true;
    public boolean Vertical = false;
    boolean Overflow = false;
    boolean Shifted = false;
    OverflowButton OB;
    int OverflowX;
    IconBarListener L = null;
    boolean Shift;
    boolean Control;
    Window WHelp = null;

    public IconBar(Frame frame, boolean bl) {
        this.F = frame;
        this.TraverseFocus = bl;
        if (Global.ControlBackground != null) {
            this.setBackground(Global.ControlBackground);
        } else {
            this.setBackground(SystemColor.menu);
        }
        this.Resource = Global.getParameter("iconpath", "");
        BasicIcon.Size = Global.getParameter("iconsize", 20);
        this.setLayout(null);
        this.W = 4;
        this.addKeyListener(this);
        if (this.TraverseFocus) {
            this.addFocusListener(this);
        }
    }

    public IconBar(Frame frame) {
        this(frame, true);
    }

    public void forceRepaint() {
        BasicIcon basicIcon;
        super.repaint();
        Enumeration enumeration = this.Left.elements();
        while (enumeration.hasMoreElements()) {
            basicIcon = (BasicIcon)enumeration.nextElement();
            basicIcon.repaint();
        }
        enumeration = this.Right.elements();
        while (enumeration.hasMoreElements()) {
            basicIcon = (BasicIcon)enumeration.nextElement();
            basicIcon.repaint();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 39: {
                this.setFocus(this.Focus, false);
                ++this.Focus;
                if (this.Focus >= this.Left.size() + this.Right.size()) {
                    this.Focus = 0;
                }
                while (!(this.getIcon(this.Focus) instanceof BasicIcon)) {
                    ++this.Focus;
                    if (this.Focus < this.Left.size() + this.Right.size()) continue;
                    this.Focus = 0;
                    break;
                }
                this.setFocus(this.Focus, true);
                break;
            }
            case 37: {
                this.setFocus(this.Focus, false);
                --this.Focus;
                if (this.Focus < 0) {
                    this.Focus = this.Left.size() + this.Right.size() - 1;
                }
                while (!(this.getIcon(this.Focus) instanceof BasicIcon)) {
                    --this.Focus;
                    if (this.Focus >= 0) continue;
                    this.Focus = this.Left.size() + this.Right.size() - 1;
                    break;
                }
                this.setFocus(this.Focus, true);
                break;
            }
            case 32: {
                try {
                    BasicIcon basicIcon = (BasicIcon)this.getIcon(this.Focus);
                    basicIcon.mouseReleased(new MouseEvent(this, 502, 0L, 0, 0, 0, 1, false));
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public Object getIcon(int n) {
        if (n < this.Left.size()) {
            return this.Left.elementAt(n);
        }
        return this.Right.elementAt(this.Right.size() - 1 - (n - this.Left.size()));
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.TraverseFocus) {
            this.setFocus(this.Focus, true);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.TraverseFocus) {
            this.setFocus(this.Focus, false);
        }
    }

    public void setFocus(int n, boolean bl) {
        if (!this.TraverseFocus) {
            return;
        }
        try {
            if (n < this.Left.size()) {
                BasicIcon basicIcon = (BasicIcon)this.Left.elementAt(n);
                basicIcon.setFocus(bl);
            } else {
                BasicIcon basicIcon = (BasicIcon)this.Right.elementAt(this.Right.size() - 1 - (n - this.Left.size()));
                basicIcon.setFocus(bl);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addLeft(String string) {
        this.addLeft(new IconWithGif(this, string));
    }

    public void addLeft(BasicIcon basicIcon) {
        this.Left.addElement(basicIcon);
        this.add(basicIcon);
        this.W += basicIcon.width() + 2;
    }

    public void addRight(String string) {
        this.addRight(new IconWithGif(this, string));
    }

    public void addRight(BasicIcon basicIcon) {
        this.Right.addElement(basicIcon);
        this.add(basicIcon);
        this.W += basicIcon.width() + 2;
    }

    public void addToggleLeft(String string) {
        this.addLeft(new ToggleIcon(this, string));
    }

    public void addToggleRight(String string) {
        this.addRight(new ToggleIcon(this, string));
    }

    public void addOnOffLeft(String string) {
        this.addLeft(new OnOffIcon(this, string));
    }

    public void addOnOffRight(String string) {
        this.addRight(new OnOffIcon(this, string));
    }

    public void addToggleGroupLeft(String[] stringArray, String[] stringArray2) {
        IconGroup iconGroup = new IconGroup(this, stringArray, stringArray2);
        iconGroup.addLeft();
    }

    public void addToggleGroupRight(String[] stringArray, String[] stringArray2) {
        IconGroup iconGroup = new IconGroup(this, stringArray, stringArray2);
        iconGroup.addRight();
    }

    public void addToggleGroupLeft(String[] stringArray) {
        this.addToggleGroupLeft(stringArray, stringArray);
    }

    public void addToggleGroupRight(String[] stringArray) {
        this.addToggleGroupRight(stringArray, stringArray);
    }

    public void addToggleGroupLeft(String string, int n) {
        IconGroup iconGroup = new IconGroup(this, string, n);
        iconGroup.addLeft();
    }

    public void addToggleGroupRight(String string, int n) {
        IconGroup iconGroup = new IconGroup(this, string, n);
        iconGroup.addRight();
    }

    public void addToggleGroupLeft(String string, Color[] colorArray) {
        IconGroup iconGroup = new IconGroup(this, string, colorArray);
        iconGroup.addLeft();
    }

    public void addToggleGroupRight(String string, Color[] colorArray) {
        IconGroup iconGroup = new IconGroup(this, string, colorArray);
        iconGroup.addRight();
    }

    public void addSeparatorLeft() {
        if (this.Left.size() == 0) {
            return;
        }
        if (this.Left.lastElement() instanceof Separator) {
            return;
        }
        Separator separator = new Separator(this);
        this.Left.addElement(separator);
        this.add(separator);
        this.W += separator.width() + 2;
    }

    public void addSeparatorRight() {
        if (this.Right.size() == 0) {
            return;
        }
        if (this.Right.lastElement() instanceof Separator) {
            return;
        }
        Separator separator = new Separator(this);
        this.Right.addElement(separator);
        this.add(separator);
        this.W += separator.width() + 2;
    }

    public void addMultipleIconLeft(String string, int n) {
        this.addLeft(new MultipleIcon(this, string, n));
    }

    public void addMultipleIconRight(String string, int n) {
        this.addRight(new MultipleIcon(this, string, n));
    }

    public void addMultipleStringIconLeft(String string, String[] stringArray) {
        this.addLeft(new MultipleStringIcon(this, string, stringArray));
    }

    public void addMultipleStringIconRight(String string, String[] stringArray) {
        this.addRight(new MultipleStringIcon(this, string, stringArray));
    }

    public void addMultipleToggleIconLeft(String string, int n) {
        this.addLeft(new MultipleToggleIcon(this, string, n));
    }

    public void addMultipleToggleIconRight(String string, int n) {
        this.addRight(new MultipleToggleIcon(this, string, n));
    }

    public void addColorIconLeft(String string, Color[] colorArray) {
        this.addLeft(new ColorIcon(this, string, colorArray));
    }

    public void addColorIconRight(String string, Color[] colorArray) {
        this.addRight(new ColorIcon(this, string, colorArray));
    }

    public void addStateLeft(String string) {
        this.addLeft(new StateDisplay(this, string));
    }

    public void addStateRight(String string) {
        this.addRight(new StateDisplay(this, string));
    }

    public void doLayout() {
        if (this.OB != null) {
            this.remove(this.OB);
            this.OB = null;
        }
        if (this.Vertical) {
            int n;
            int n2 = this.getSize().height;
            for (n = 0; n < this.Right.size(); ++n) {
                IconBarElement iconBarElement = (IconBarElement)this.Right.elementAt(n);
                iconBarElement.setPosition(2, n2 -= iconBarElement.width());
                n2 -= 2;
            }
            n = n2;
            n2 = 0;
            for (int i = 0; i < this.Left.size(); ++i) {
                IconBarElement iconBarElement = (IconBarElement)this.Left.elementAt(i);
                iconBarElement.setPosition(2, n2);
                n2 += iconBarElement.width();
                if ((n2 += 2) + IconWithGif.Size <= n) continue;
                n2 = -1000;
            }
        } else {
            int n;
            int n3 = this.getSize().width;
            for (n = 0; n < this.Right.size(); ++n) {
                IconBarElement iconBarElement = (IconBarElement)this.Right.elementAt(n);
                iconBarElement.setPosition(n3 -= iconBarElement.width(), 2);
                n3 -= 2;
            }
            n = n3;
            n3 = 0;
            for (int i = 0; i < this.Left.size(); ++i) {
                IconBarElement iconBarElement = (IconBarElement)this.Left.elementAt(i);
                iconBarElement.setPosition(n3, 2);
                n3 += iconBarElement.width();
                if ((n3 += 2) + IconWithGif.Size <= n - 10 || i >= this.Left.size() - 1) continue;
                this.Overflow = true;
                this.OverflowX = n3;
                this.OB = new OverflowButton(this, this.Shifted);
                this.add(this.OB);
                this.OB.setSize(10, BasicIcon.Size);
                this.OB.setLocation(n - 10 - 2, 2);
                if (!this.Shifted) {
                    n3 = -1000;
                    continue;
                }
                n3 = n - 10 - 4;
                for (int j = this.Left.size() - 1; j >= 0; --j) {
                    iconBarElement = (IconBarElement)this.Left.elementAt(j);
                    iconBarElement.setPosition(n3 -= iconBarElement.width(), 2);
                    if ((n3 -= 2) - IconWithGif.Size >= 0) continue;
                    n3 -= 1000;
                }
                break;
            }
        }
    }

    public void setShifted(boolean bl) {
        this.Shifted = bl;
        this.doLayout();
    }

    public Dimension getPreferredSize() {
        if (this.Vertical) {
            if (!this.UseSize) {
                return new Dimension(IconWithGif.Size + 4, 10);
            }
            return new Dimension(IconWithGif.Size + 4, this.W + 10);
        }
        if (!this.UseSize) {
            return new Dimension(10, IconWithGif.Size + 4);
        }
        return new Dimension(this.W + 10, IconWithGif.Size + 4);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setIconBarListener(IconBarListener iconBarListener) {
        this.L = iconBarListener;
    }

    public void removeIconBarListener(IconBarListener iconBarListener) {
        this.L = null;
    }

    public void iconPressed(String string, boolean bl, boolean bl2) {
        this.Shift = bl;
        this.Control = bl2;
        this.removeHelp();
        if (this.L != null) {
            this.L.iconPressed(string);
        }
    }

    public boolean isShiftPressed() {
        return this.Shift;
    }

    public boolean isControlPressed() {
        return this.Control;
    }

    public void clearShiftControl() {
        this.Control = false;
        this.Shift = false;
    }

    public synchronized void displayHelp(IconBarElement iconBarElement, String string) {
        if (this.F == null || this.WHelp != null) {
            return;
        }
        Point point = iconBarElement.getPosition();
        this.WHelp = new Window(this.F);
        Panel panel = new Panel();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
        panel.setLayout(new GridLayout(0, 1));
        while (stringTokenizer.hasMoreTokens()) {
            panel.add(new MyLabel(stringTokenizer.nextToken()));
        }
        this.WHelp.add("Center", panel);
        this.WHelp.pack();
        Dimension dimension = this.WHelp.getSize();
        Dimension dimension2 = this.getToolkit().getScreenSize();
        int n = point.x;
        int n2 = point.y + iconBarElement.width() + 10;
        if (n + dimension.width > dimension2.width) {
            n = dimension2.width - dimension.width;
        }
        if (n2 + dimension.height > dimension2.height) {
            n2 = point.y - iconBarElement.width() - dimension.height;
        }
        this.WHelp.setLocation(n, n2);
        this.WHelp.setBackground(new Color(255, 255, 220));
        this.WHelp.setForeground(Color.black);
        this.WHelp.setVisible(true);
    }

    public synchronized void removeHelp() {
        if (this.WHelp == null) {
            return;
        }
        this.WHelp.setVisible(false);
        this.WHelp.dispose();
        this.WHelp = null;
    }

    private BasicIcon find(String string) {
        BasicIcon basicIcon;
        int n;
        for (n = 0; n < this.Left.size(); ++n) {
            try {
                basicIcon = (BasicIcon)this.Left.elementAt(n);
                if (!basicIcon.getName().equals(string)) continue;
                return basicIcon;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (n = 0; n < this.Right.size(); ++n) {
            try {
                basicIcon = (BasicIcon)this.Right.elementAt(n);
                if (!basicIcon.getName().equals(string)) continue;
                return basicIcon;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public void setEnabled(String string, boolean bl) {
        BasicIcon basicIcon = this.find(string);
        if (basicIcon == null) {
            return;
        }
        basicIcon.setEnabled(bl);
    }

    public void toggle(String string) {
        BasicIcon basicIcon = this.find(string);
        if (basicIcon == null || !(basicIcon instanceof ToggleIcon)) {
            return;
        }
        ((ToggleIcon)basicIcon).setState(true);
    }

    public boolean have(String string) {
        return this.find(string) != null;
    }

    public void unselect(String string) {
        BasicIcon basicIcon = this.find(string);
        if (basicIcon == null || !(basicIcon instanceof ToggleIcon)) {
            return;
        }
        ((ToggleIcon)basicIcon).unselect();
    }

    public void toggle(String string, int n) {
        this.toggle(string + n);
    }

    public void setState(String string, boolean bl) {
        BasicIcon basicIcon = this.find(string);
        if (basicIcon != null && basicIcon instanceof ToggleIcon) {
            ((ToggleIcon)basicIcon).setState(bl);
        }
        if (basicIcon != null && basicIcon instanceof MultipleToggleIcon) {
            ((MultipleToggleIcon)basicIcon).setState(bl);
        }
    }

    public boolean getState(String string) {
        BasicIcon basicIcon = this.find(string);
        if (basicIcon == null || !(basicIcon instanceof ToggleIcon)) {
            return false;
        }
        return ((ToggleIcon)basicIcon).getState();
    }

    public int getToggleState(String string) {
        BasicIcon basicIcon = this.find(string + 0);
        if (basicIcon == null || !(basicIcon instanceof ToggleIcon)) {
            return -1;
        }
        int n = ((ToggleIcon)basicIcon).countPeers();
        for (int i = 0; i < n; ++i) {
            if (!this.getState(string + i)) continue;
            return i;
        }
        return -1;
    }

    public int getMultipleState(String string) {
        IconBarElement iconBarElement;
        int n;
        for (n = 0; n < this.Left.size(); ++n) {
            iconBarElement = (IconBarElement)this.Left.elementAt(n);
            if (!iconBarElement.getName().equals(string) || !(iconBarElement instanceof MultipleIcon)) continue;
            return ((MultipleIcon)iconBarElement).getSelected();
        }
        for (n = 0; n < this.Right.size(); ++n) {
            iconBarElement = (IconBarElement)this.Right.elementAt(n);
            if (!iconBarElement.getName().equals(string) || !(iconBarElement instanceof MultipleIcon)) continue;
            return ((MultipleIcon)iconBarElement).getSelected();
        }
        return -1;
    }

    public void setMultipleState(String string, int n) {
        IconBarElement iconBarElement;
        int n2;
        for (n2 = 0; n2 < this.Left.size(); ++n2) {
            iconBarElement = (IconBarElement)this.Left.elementAt(n2);
            if (!iconBarElement.getName().equals(string) || !(iconBarElement instanceof MultipleIcon)) continue;
            ((MultipleIcon)iconBarElement).setSelected(n);
        }
        for (n2 = 0; n2 < this.Right.size(); ++n2) {
            iconBarElement = (IconBarElement)this.Right.elementAt(n2);
            if (!iconBarElement.getName().equals(string) || !(iconBarElement instanceof MultipleIcon)) continue;
            ((MultipleIcon)iconBarElement).setSelected(n);
        }
    }

    public boolean isSet(String string) {
        BasicIcon basicIcon = this.find(string);
        if (basicIcon == null) {
            return false;
        }
        return basicIcon.isSet();
    }

    public void unset(String string) {
        BasicIcon basicIcon = this.find(string);
        if (basicIcon != null) {
            basicIcon.unset();
        }
    }

    public void getKey(KeyEvent keyEvent) {
        this.processKeyEvent(keyEvent);
    }

    public void setSize(int n) {
        BasicIcon.Size = n;
    }

    public void removeAll() {
        Enumeration enumeration = this.Left.elements();
        while (enumeration.hasMoreElements()) {
            this.remove((BasicIcon)enumeration.nextElement());
        }
        enumeration = this.Right.elements();
        while (enumeration.hasMoreElements()) {
            this.remove((BasicIcon)enumeration.nextElement());
        }
        this.Left.removeAllElements();
        this.Right.removeAllElements();
    }

    public String getHelp(String string) {
        return "";
    }

    public static void main(String[] stringArray) {
        CloseFrame closeFrame = new CloseFrame("Test");
        IconBar iconBar = new IconBar(closeFrame);
        iconBar.Vertical = true;
        iconBar.setSize(30);
        iconBar.Resource = "/icons/";
        iconBar.addLeft("back");
        iconBar.addLeft("undo");
        iconBar.addSeparatorLeft();
        iconBar.addOnOffLeft("grid");
        iconBar.addSeparatorLeft();
        iconBar.addToggleLeft("delete");
        iconBar.addSeparatorLeft();
        String[] stringArray2 = new String[]{"zoom", "draw", "", "rename", "edit"};
        iconBar.addToggleGroupLeft(stringArray2);
        iconBar.addSeparatorLeft();
        iconBar.addMultipleToggleIconLeft("macro", 3);
        iconBar.addSeparatorLeft();
        String[] stringArray3 = new String[]{"zoom", "draw", "rename", "edit"};
        iconBar.addLeft(new PopupIcon(iconBar, stringArray3));
        iconBar.addSeparatorLeft();
        String[] stringArray4 = new String[]{"A", "B", "C", "D"};
        iconBar.addMultipleStringIconLeft("strings", stringArray4);
        Color[] colorArray = new Color[]{Color.BLACK, Color.RED, Color.GREEN};
        iconBar.addStateLeft("needsave");
        iconBar.addColorIconLeft("color", colorArray);
        closeFrame.add("Center", new IconBarPanel(new Panel3D(iconBar), new Panel3D(new Panel())));
        closeFrame.pack();
        closeFrame.center();
        iconBar.setIconBarListener(iconBar);
        closeFrame.setVisible(true);
    }

    public void iconPressed(String string) {
        System.out.println(string);
    }
}

