/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.objects;

import java.awt.Checkbox;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.FocusEvent;
import rene.gui.Global;
import rene.gui.IconBar;
import rene.gui.MyLabel;
import rene.gui.TextFieldAction;
import rene.zirkel.Zirkel;
import rene.zirkel.dialogs.ObjectEditDialog;
import rene.zirkel.objects.PlumbObject;
import rene.zirkel.objects.PrimitiveLineObject;
import rene.zirkel.objects.SegmentObject;

class LineEditDialog
extends ObjectEditDialog {
    TextField Length;
    Checkbox Fixed;
    Checkbox Restricted;
    IconBar IC;

    public LineEditDialog(Frame frame, PrimitiveLineObject primitiveLineObject) {
        super(frame, Zirkel.name("edit.line.title"), primitiveLineObject);
    }

    public void addFirst(Panel panel) {
        PrimitiveLineObject primitiveLineObject = (PrimitiveLineObject)this.O;
        if (primitiveLineObject instanceof SegmentObject) {
            this.Length = new TextFieldAction(this, "Length", ((SegmentObject)primitiveLineObject).getStringLength(), 30);
            if (((SegmentObject)primitiveLineObject).canFix()) {
                this.Fixed = new Checkbox("");
                this.Fixed.setState(((SegmentObject)primitiveLineObject).fixed());
            } else {
                this.Length.setEditable(false);
            }
        }
        if (primitiveLineObject instanceof PlumbObject && ((PlumbObject)primitiveLineObject).canRestrict()) {
            this.Restricted = new Checkbox("");
            this.Restricted.setState(((PlumbObject)primitiveLineObject).isRestricted());
        }
        if (this.Length != null) {
            panel.add(new MyLabel(Zirkel.name("edit.segment.length")));
            panel.add(this.Length);
        }
        if (this.Fixed != null) {
            panel.add(new MyLabel(Zirkel.name("edit.fixed")));
            panel.add(this.Fixed);
        }
        if (this.Restricted != null) {
            panel.add(new MyLabel(Zirkel.name("edit.plumb.restricted")));
            panel.add(this.Restricted);
        }
    }

    public void addSecond(Panel panel) {
        PrimitiveLineObject primitiveLineObject = (PrimitiveLineObject)this.O;
        this.IC = new IconBar(this.F);
        this.IC.setIconBarListener(this);
        if (!(primitiveLineObject instanceof SegmentObject)) {
            this.IC.addToggleLeft("plines");
            this.IC.setState("plines", primitiveLineObject.isPartial());
        }
        if (primitiveLineObject instanceof SegmentObject) {
            this.IC.addToggleLeft("arrow");
            this.IC.setState("arrow", ((SegmentObject)primitiveLineObject).isArrow());
        }
        panel.add(new MyLabel(""));
        panel.add(this.IC);
    }

    public boolean showsValue() {
        return this.Length != null;
    }

    public void doAction(String string) {
        if (string.equals("Length") && this.Fixed != null) {
            this.Fixed.setState(true);
            super.doAction("OK");
        } else {
            super.doAction(string);
        }
    }

    public void setAction() {
        if (this.Fixed != null) {
            try {
                ((SegmentObject)this.O).setFixed(this.Fixed.getState(), this.Length.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.Restricted != null) {
            ((PlumbObject)this.O).setRestricted(this.Restricted.getState());
        }
        if (!(this.O instanceof SegmentObject)) {
            ((PrimitiveLineObject)this.O).setPartial(this.IC.getState("plines"));
        } else if (this.O instanceof SegmentObject) {
            ((SegmentObject)this.O).setArrow(this.IC.getState("arrow"));
            Global.setParameter("unit.length", this.Unit.getText());
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (this.Fixed != null && this.Fixed.getState()) {
            this.Length.requestFocus();
        } else {
            super.focusGained(focusEvent);
        }
    }
}

