/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;

public class SmilesMolecule {
    private SmilesAtom[] atoms = new SmilesAtom[16];
    private int atomsCount = 0;
    private SmilesBond[] bonds = new SmilesBond[16];
    private int bondsCount = 0;
    private static final int INITIAL_ATOMS = 16;
    private static final int INITIAL_BONDS = 16;

    public SmilesAtom createAtom() {
        SmilesAtom[] smilesAtomArray;
        if (this.atomsCount >= this.atoms.length) {
            smilesAtomArray = new SmilesAtom[this.atoms.length * 2];
            System.arraycopy(this.atoms, 0, smilesAtomArray, 0, this.atoms.length);
            this.atoms = smilesAtomArray;
        }
        this.atoms[this.atomsCount] = smilesAtomArray = new SmilesAtom(this.atomsCount);
        ++this.atomsCount;
        return smilesAtomArray;
    }

    public int getAtomsCount() {
        return this.atomsCount;
    }

    public SmilesAtom getAtom(int n) {
        if (n >= 0 && n < this.atomsCount) {
            return this.atoms[n];
        }
        return null;
    }

    public SmilesBond createBond(SmilesAtom smilesAtom, SmilesAtom smilesAtom2, int n) {
        Object object;
        if (this.bondsCount >= this.bonds.length) {
            object = new SmilesBond[this.bonds.length * 2];
            System.arraycopy(this.bonds, 0, object, 0, this.bonds.length);
            this.bonds = object;
        }
        this.bonds[this.bondsCount] = object = new SmilesBond(smilesAtom, smilesAtom2, n);
        ++this.bondsCount;
        if (smilesAtom != null) {
            smilesAtom.addBond((SmilesBond)object);
        }
        if (smilesAtom2 != null) {
            smilesAtom2.addBond((SmilesBond)object);
        }
        return object;
    }

    public int getBondsCount() {
        return this.bondsCount;
    }

    public SmilesBond getBond(int n) {
        if (n >= 0 && n < this.bondsCount) {
            return this.bonds[n];
        }
        return null;
    }
}

