/************************************************************************
 *
 *  ListOption.java
 *
 *  Copyright: 2002-2023 by Henrik Just
 *
 *  This file is part of Writer2LaTeX.
 *  
 *  Writer2LaTeX is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  Writer2LaTeX is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License
 *  along with Writer2LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 * 
 *  Version 2.0 (2023-06-29)
 *
 */
package writer2latex.base;

import java.util.Collections;
import java.util.List;

// Must override the setString method to set the value member
public abstract class ListOption extends Option {
	protected List<String> value; 
	
	public List<String> getValue() { return Collections.unmodifiableList(value); }

	public ListOption(String sName, String sDefaultValue) {
		super(sName,sDefaultValue);
	}	

}
