/*
 * Copyright (C) 2010 Tommi Maekitalo
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * As a special exception, you may use this file as part of a free
 * software library without restriction. Specifically, if other files
 * instantiate templates or use macros or inline functions from this
 * file, or you compile this file and link it with other files to
 * produce an executable, this file does not by itself cause the
 * resulting executable to be covered by the GNU General Public
 * License. This exception does not however invalidate any other
 * reasons why the executable file might be covered by the GNU Library
 * General Public License.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include <iostream>
#include <cxxtools/mutex.h>
#include <cxxtools/threadpool.h>
#include <cxxtools/arg.h>

cxxtools::Mutex mutex;
unsigned count = 0;

void funct()
{
  for (unsigned n = 0; n < 10; ++n)
  {
    {
      cxxtools::MutexLock lock(mutex);
      std::cout << "Hello " << ++count << std::endl;
    }

    cxxtools::Thread::sleep(100);
  }
}

int main(int argc, char* argv[])
{
  try
  {
    cxxtools::Arg<unsigned> threads(argc, argv, 't', 5);
    cxxtools::Arg<unsigned> tasks(argc, argv, 'n', 20);
    cxxtools::Arg<bool> docancel(argc, argv, 'c');

    cxxtools::ThreadPool p(threads);

    for (unsigned n = 0; n < tasks; ++n)
        p.schedule(cxxtools::callable(funct));

    if (docancel)
      p.stop(docancel);
  }
  catch (const std::exception& e)
  {
    std::cerr << e.what() << std::endl;
  }
}

