// SPDX-FileCopyrightText: 2020 - 2022 UnionTech Software Technology Co., Ltd.
//
// SPDX-License-Identifier: GPL-3.0-or-later

#include <QComboBox>
#include <gtest/gtest.h>

#include "dfilestatisticsjob.h"
#include "stub.h"
#include <dlistview.h>

#define private public
#define protected public
#include "views/dfilemanagerwindow.h"
#include "dialogs/connecttoserverdialog.h"

namespace  {
    class TestConnectToServerDialog : public testing::Test
    {
    public:
        void SetUp() override
        {
            void(*stu_start)(const DUrlList &) = [](const DUrlList &){};
            Stub stu;
            stu.set((void(DFileStatisticsJob::*)(const DUrlList &))ADDR(DFileStatisticsJob, start), stu_start);

            bool(*stu_openNewTab)(DUrl fileUrl) = [](DUrl fileUrl)->bool{
                Q_UNUSED(fileUrl);
                return true;
            };
            Stub stu2;
            stu2.set(ADDR(DFileManagerWindow, openNewTab), stu_openNewTab);

            void(*stu_initTitleBar)() = [](){};
            Stub stu3;
            stu3.set(ADDR(DFileManagerWindow, initTitleBar), stu_initTitleBar);

            m_pMainwindow = new DFileManagerWindow();
            m_pTester = new ConnectToServerDialog(m_pMainwindow);

            int count = m_pTester->m_collectionServerView->model()->rowCount();
            for(int i=0;i<count;i++){
                QModelIndex index = m_pTester->m_collectionServerView->model()->index(i,0);
                if(index.isValid()){
                    QString compare = m_pTester->m_collectionServerView->model()->index(i,0).data().toString();
                    if(compare == "127.0.0.1")
                        m_pTester->m_collectionServerView->removeItem(i);
                }
            }
            std::cout << "start TestConnectToServerDialog";
        }
        void TearDown() override
        {
            if(m_pTester)
                delete m_pTester;
            m_pTester = nullptr;
            if(m_pMainwindow)
                delete m_pMainwindow;
            m_pMainwindow = nullptr;
            std::cout << "end TestConnectToServerDialog";
        }
    public:
        ConnectToServerDialog *m_pTester = nullptr;
        DFileManagerWindow* m_pMainwindow = nullptr;
    };
}
#ifndef __arm__
TEST_F(TestConnectToServerDialog, testInit)
{
    EXPECT_NE(nullptr, m_pTester);
}

TEST_F(TestConnectToServerDialog, testInitUI)
{
    bool(*stub_isWayLand)() = []()->bool{
        return true;
    };
    Stub stu;
    stu.set(ADDR(DFMGlobal, isWayLand), stub_isWayLand);

    ConnectToServerDialog dlg;
    QString str = dlg.windowTitle();
    EXPECT_TRUE(str == "Connect to Server");
}

TEST_F(TestConnectToServerDialog, testOnButtonClicked)
{
    int index = 1;
    m_pTester->onButtonClicked(index);
    QString str = m_pTester->m_serverComboBox->currentText();
    EXPECT_TRUE(str == "");
}

TEST_F(TestConnectToServerDialog, testOnButtonClicked2)
{
    QString(*stub_currentText)() = []()->QString{
        return "GTest";
    };
    Stub stu;
    stu.set(ADDR(QComboBox, currentText), stub_currentText);

    bool(*stu_cd)() = []()->bool{
            return false;
    };
    Stub stu2;
    stu2.set(ADDR(DFileManagerWindow, cd), stu_cd);

    int index = 1;
    m_pTester->onButtonClicked(index);
    QString str = m_pTester->m_serverComboBox->currentText();
    EXPECT_TRUE(str == "GTest");
}

TEST_F(TestConnectToServerDialog, testOnAddButtonClicked)
{
    m_pTester->m_schemeComboBox->setCurrentIndex(0);
    m_pTester->m_serverComboBox->setEditText("127.0.0.1");
    m_pTester->onAddButtonClicked();
    QString str = m_pTester->m_serverComboBox->currentText();
    EXPECT_TRUE(str == "127.0.0.1");
}

TEST_F(TestConnectToServerDialog, testOnAddButtonClicked2)
{
    bool(*stub_addItem)(const QVariant&) = [](const QVariant&)->bool{
        return false;
    };

    Stub stu;
    stu.set(ADDR(DListView, addItem), stub_addItem);
    m_pTester->m_schemeComboBox->setCurrentIndex(0);
    m_pTester->m_serverComboBox->setEditText("127.0.0.1");
    m_pTester->onAddButtonClicked();
    QString str = m_pTester->m_serverComboBox->currentText();
    EXPECT_TRUE(str == "127.0.0.1");
}

TEST_F(TestConnectToServerDialog, testOnAddButtonClicked3)
{
    m_pTester->m_serverComboBox->setEditText("127.0.0.1");
    m_pTester->onAddButtonClicked();
    QString str = m_pTester->m_serverComboBox->currentText();
    EXPECT_TRUE(str == "127.0.0.1");
}

TEST_F(TestConnectToServerDialog, testOnDelButtonClicked)
{
    m_pTester->m_schemeComboBox->setCurrentIndex(0);
    m_pTester->m_serverComboBox->setEditText("127.0.0.1");
    m_pTester->setFocus(Qt::MouseFocusReason);
    int countBefore = m_pTester->m_collectionServerView->model()->rowCount();
    m_pTester->onDelButtonClicked();
    int countAfter = m_pTester->m_collectionServerView->model()->rowCount();
    QString str = m_pTester->m_serverComboBox->currentText();
    EXPECT_TRUE(countAfter == (countBefore - 1));
    EXPECT_TRUE(str == "127.0.0.1");
}

TEST_F(TestConnectToServerDialog, testOnDelButtonClicked2)
{
    bool(*stub_removeItem)(int) = [](int)->bool{
        return false;
    };

    Stub stu;
    stu.set(ADDR(DListView, removeItem), stub_removeItem);

    m_pTester->m_serverComboBox->setEditText("127.0.0.1");
    m_pTester->onDelButtonClicked();
    QString str = m_pTester->m_serverComboBox->currentText();
    EXPECT_TRUE(str == "127.0.0.1");
}
#endif
