##########################################################################
#
# __init__.py:  defines this directory as the 'tests' package.
#
#  Debian Partial Mirror is a tool to make complete and partial Debian mirrors.
#  See http://projetos.ossystems.com.br/debpartial-mirror/ for more information.
#
# ====================================================================
# Copyright (c) 2002-2005 O.S. Systems.  All rights reserved.
#
# This software is licensed as described in the file COPYING, which
# you should have received as part of this distribution.
#
#########################################################################
# Author: Otavio Salvador <otavio@ossystems.com.br>

from os.path  import abspath, join, dirname

import os
import shutil
import sys
import tempfile
import unittest

class TestBase(unittest.TestCase):
	use_relative_paths = os.environ.has_key("USE_RELATIVE_PATHS")
	TEST_DIR = "tests"

	def setUp(self):
		self._tempDirs = []
		self._tempFiles = []

	def tearDown(self):
		for tempDir in self._tempDirs:
			shutil.rmtree(tempDir)

		for tempFile in self._tempFiles:
			if os.path.exists(tempFile):
				os.remove(tempFile)

	def aux_rel_path(self):
		if "aux" in os.listdir("."):
			return "aux"
		return "%s/aux" % self.TEST_DIR

	def aux_file(self, filename):
		return abspath(os.path.join(self.aux_rel_path(), filename))
		current_dir = abspath(dirname(sys.argv[0]))

		if not current_dir.endswith(self.TEST_DIR):
			current_dir += "/" + self.TEST_DIR

		return join(current_dir, 'aux', filename)

	def createTempDirectory(self):
		if self.use_relative_paths:
			tempDir = tempfile.mkdtemp(prefix="dpmtest", dir=".")
		else:
			tempDir = tempfile.mkdtemp(prefix="dpmtest")
		self._tempDirs.append(tempDir)
		return tempDir

	def createTempFile(self):
		if self.use_relative_paths:
			tempFile = tempfile.mktemp(prefix="dpmtest", dir=".")
		else:
			tempFile = tempfile.mktemp(prefix="dpmtest")
		self._tempFiles.append(tempFile)
		return tempFile
