#!/bin/bash
# set -x 

if test -e "/boot/vmlinuz-4.19.0-amd64-desktop"; then
	BACKUP_UUID=$(cat /etc/deepin/ab-recovery.json | sed -r "s/.*\"Backup\"[: ]*\"([^\"]*)\".*/\1/g")
	if [ -z "$BACKUP_UUID" ]; then
		exit 0
	fi
	MOUNT_DIR=$(mktemp -d)
	mount --uuid "$BACKUP_UUID" "$MOUNT_DIR"
	if [ $? != 0 ]
	then
		rm -rf "$MOUNT_DIR"
		exit 0
	fi
	BACKUP_VERSION=$(cat "$MOUNT_DIR"/etc/os-version  | grep ^MinorVersion= | awk -F= '{print $2}')
	if [ -n "$BACKUP_VERSION" ] && [ "$BACKUP_VERSION" -ge "1030" ]
	then
		echo "new version >=1030"
		CURRENT_VERSION=$(cat /etc/os-version  | grep ^MinorVersion= | awk -F= '{print $2}')
		if [ -n "$CURRENT_VERSION" ] && [ "$CURRENT_VERSION" -le "1022" ]
		then
			echo "rollback version <= 1022, new version >= 1030, need remove 4.19.0 kernel"
			mv /boot/vmlinuz-4.19.0-amd64-desktop /boot/zvmlinuz-4.19.0-amd64-desktop
			update-grub
		fi
	fi
	umount "$MOUNT_DIR"
	rm -rf "$MOUNT_DIR"
fi
