#!/bin/sh
# SPDX-FileCopyrightText: 2022 UnionTech Software Technology Co., Ltd.
#
# SPDX-License-Identifier: GPL-3.0-or-later
set -ex
proj_dir=$(git rev-parse --show-toplevel)
dir=$(dirname $0)
. $dir/config.sh || exit 1

cd $proj_dir
debuild -us -uc
make fs-break

deb_dir='~/deepin-initramfs-enhance-deb'
version=$(dpkg-parsechangelog -S Version)
ssh $VM_MACHINE "mkdir -p $deb_dir; cd $deb_dir && rm -rf *";
scp fs-break/fs-break $VM_MACHINE:/tmp
scp "../deepin-initramfs-enhance_${version}_all.deb" $VM_MACHINE:$deb_dir

ssh $VM_MACHINE "cd $deb_dir; echo $VM_PASSWORD | sudo -k -S sh -x -c '
	cp /tmp/fs-break /sbin/fs-break
	chmod +x /sbin/fs-break
	dpkg -i *.deb;
	ls -lh /boot/initrd.img-*
	' "

if [ "$1" = "-r" ]; then
	# do reboot
	ssh $VM_MACHINE "echo $VM_PASSWORD | sudo -k -S sh -x -c 'reboot' "
fi

