package storage

import (
	"encoding/json"
	"net/http"

	"github.com/pkg/errors"
)

// 获取云服务商和用户前缀等基本信息
func Backend(token TokenSource) (*BackendResp, error) {
	req, err := http.NewRequest("GET", SyncServerAPI()+"/backend", nil)
	if err != nil {
		return nil, errors.Wrap(err, "New request")
	}

	req.Header.Set(AuthToken, token.Token())

	resp, err := http.DefaultClient.Do(req)
	if err != nil {
		return nil, errors.Wrap(err, "Http do")
	}
	defer resp.Body.Close()
	var result BackendResp
	err = json.NewDecoder(resp.Body).Decode(&result)
	if err != nil {
		return nil, errors.Wrap(err, "Decode response")
	}
	if result.Error != nil {
		return nil, errors.Errorf("Backend: %s(%d)", result.Error.Msg, result.Error.Code)
	}
	return &result, nil
}

type BackendResp struct {
	Service    string     `json:"service"`
	Bucket     string     `json:"bucket"`
	PathPrefix string     `json:"pathPrefix"`
	Error      *RespError `json:"error,omitempty"`
}
