package screenedge

import (
	"reflect"

	"pkg.deepin.io/daemon/sync/infrastructure/utils"
	. "pkg.deepin.io/daemon/sync/modules/model"
)

type Data struct {
	Version     string `json:"version"`
	LeftBottom  string `json:"left_bottom"`
	LeftTop     string `json:"left_top"`
	RightBottom string `json:"right_bottom"`
	RightTop    string `json:"right_top"`
}

const (
	Name = "screen_edge"
)

func (core *Data) Name() string {
	return Name
}

func (core *Data) Model() interface{} {
	return &Data{}
}

func (core *Data) ToIFC(v interface{}) DataIFC {
	return v.(*Data)
}

func (core *Data) Equal(target DataIFC) bool {
	info := target.(*Data)
	return reflect.DeepEqual(core, info)
}

func (core *Data) GenCache(DataIFC) DataIFC {
	return core
}

func (core *Data) Merge(current, cache DataIFC) {
	curInfo := current.(*Data)
	cacheInfo := cache.(*Data)
	utils.MergeString(&core.LeftBottom, curInfo.LeftBottom,
		cacheInfo.LeftBottom)
	utils.MergeString(&core.LeftTop, curInfo.LeftTop,
		cacheInfo.LeftTop)
	utils.MergeString(&core.RightBottom, curInfo.RightBottom,
		cacheInfo.RightBottom)
	utils.MergeString(&core.RightTop, curInfo.RightTop,
		cacheInfo.RightTop)
}
